/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetAuthErrorWorker;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorker;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpProcessor;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAuthError;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAuthErrorDao;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDevice;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.dhcp.connection.InetDhcpConnectionEntry;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.model.Idable;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.AverageCounter;

abstract class AbstractInetDhcpProcessor2
extends DhcpProcessor<InetDhcpDevice>
implements ExtendedLifecycle {
    private static final Logger logger = LogManager.getLogger();
    public static final DhcpPacket.DhcpPacketOption<Object> AGENT_REMOTE_ID = new DhcpPacket.DhcpPacketOption("agentRemoteId");
    public static final DhcpPacket.DhcpPacketOption<Object> AGENT_CIRCUIT_ID = new DhcpPacket.DhcpPacketOption("agentCircuitId");
    public static final DhcpPacket.DhcpPacketOption<Object> VLAN_ID = new DhcpPacket.DhcpPacketOption("vlanId");
    public static final DhcpPacket.DhcpPacketOption<Object> INTERFACE_ID = new DhcpPacket.DhcpPacketOption("interfaceId");
    public static final DhcpPacket.DhcpPacketOption<Object> AGENT_SVLAN = new DhcpPacket.DhcpPacketOption("agentSvlan");
    public static final DhcpPacket.DhcpPacketOption<Object> LOGIN = new DhcpPacket.DhcpPacketOption("login");
    public static final DhcpPacket.DhcpPacketOption<Object> CIRCUIT_ID = new DhcpPacket.DhcpPacketOption("circuitId");
    public static final DhcpPacket.DhcpPacketOption<Object> CALLED_STATION_ID = new DhcpPacket.DhcpPacketOption("calledStationId");
    protected boolean processRenew = false;
    protected boolean useXid = true;
    protected boolean skipUnknownDevices = false;
    protected boolean findDeviceBySocketAddress = true;
    protected int overrideRelayDeviceId;
    protected final Access access;
    protected InetDhcpDeviceMap deviceMap;
    protected final AverageCounter discoverSecondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter discoverMinuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    protected final AverageCounter requestSecondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter requestMinuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    protected final AverageCounter otherSecondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter otherMinuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    protected final AverageCounter offerSecondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter offerMinuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    protected final AverageCounter ackSecondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter ackMinuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    protected final AverageCounter nakSecondCounter = new AverageCounter(60L, TimeUnit.SECONDS);
    protected final AverageCounter nakMinuteCounter = new AverageCounter(60L, TimeUnit.MINUTES);
    private final byte[] ZERO_ADDR = new byte[]{0, 0, 0, 0};

    protected InetConnectionRuntime getConnection(InetDhcpConnectionEntry entry, String callingStationId) {
        List<InetConnectionRuntime> connectionRuntimeList = this.access.connectionManager.getByServId(entry.servId);
        if (connectionRuntimeList != null) {
            int size = connectionRuntimeList.size();
            for (int i = 0; i < size; ++i) {
                InetConnectionRuntime connectionRuntime = connectionRuntimeList.get(i);
                InetConnection connection = connectionRuntime.connection;
                if (connection.getId() != entry.connectionId || !Utils.isEmptyString((String)callingStationId) && !callingStationId.equalsIgnoreCase(connection.getCallingStationId())) continue;
                return connectionRuntime;
            }
        }
        return null;
    }

    public AbstractInetDhcpProcessor2(Setup setup, Access access) throws BGException {
        super(setup, "inet", SetupParam.getModuleId((ParameterMap)setup));
        this.access = access;
    }

    public void init() throws Exception {
        this.deviceMap = new InetDhcpDeviceMap(this.access);
        InetDeviceRuntime rootDeviceRuntime = this.access.deviceMap.get(this.access.rootDeviceId);
        if (rootDeviceRuntime != null) {
            this.useXid = rootDeviceRuntime.config.getInt("dhcp.xid", 0) > 0;
            this.processRenew = rootDeviceRuntime.config.getInt("dhcp.renew", 0) > 0;
            this.skipUnknownDevices = rootDeviceRuntime.config.getInt("dhcp.skipUnknownDevices", 0) > 0;
            this.findDeviceBySocketAddress = rootDeviceRuntime.config.getInt("dhcp.findDeviceBySocketAddress", 1) > 0;
            this.overrideRelayDeviceId = rootDeviceRuntime.config.getInt("dhcp.overrideRelayDeviceId", 0);
        } else {
            this.useXid = ((Setup)this.setup).getModuleSetup(Integer.valueOf(this.access.moduleId)).getInt("dhcp.xid", 0) > 0;
            this.processRenew = this.access.setup.getModuleSetup(Integer.valueOf(this.access.moduleId)).getInt("dhcp.renew", 0) > 0;
            this.skipUnknownDevices = this.access.setup.getModuleSetup(Integer.valueOf(this.access.moduleId)).getInt("dhcp.skipUnknownDevices", 0) > 0;
            this.findDeviceBySocketAddress = this.access.setup.getModuleSetup(Integer.valueOf(this.access.moduleId)).getInt("dhcp.findDeviceBySocketAddress", 1) > 0;
            this.overrideRelayDeviceId = this.access.setup.getModuleSetup(Integer.valueOf(this.access.moduleId)).getInt("dhcp.overrideRelayDeviceId", 0);
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public InetDhcpDevice getDevice(InetSocketAddress clientAddress, DhcpListenerWorker<InetDhcpDevice> req, DhcpPacket request) throws UnknownHostException {
        if (this.overrideRelayDeviceId > 0) {
            return this.deviceMap.get(this.overrideRelayDeviceId);
        }
        return this.deviceMap.getDevice((SocketAddress)clientAddress, request, this.findDeviceBySocketAddress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, DhcpPacket request) throws UnknownHostException, BGException {
        DhcpPacket response;
        if (logger.isInfoEnabled()) {
            logger.info("REQUEST:\n" + String.valueOf(request));
        }
        if (request.op != 1) {
            return;
        }
        logger.debug("OP_BOOT_REQUEST");
        byte messageType = request.messageType;
        this.updatePacketTypeCounters(messageType);
        InetDhcpDevice device = this.getDevice((InetSocketAddress)clientAddress, req, request);
        if (device != null && request.haveSubOptions()) {
            if (messageType != 3 && messageType != 1) {
                logger.debug("Unsupported message type: " + messageType);
                return;
            }
            response = this.processOption82Request(device, req, clientAddress, request);
        } else {
            if (this.skipUnknownDevices && device == null && !DhcpPacket.isNil((byte[])request.giaddr)) {
                logger.info("DHCP-device not found for giaddr, ignoring DHCP request.");
                return;
            }
            if (DhcpPacket.isRenewRequest((DhcpPacket)request)) {
                if (!this.processRenew) {
                    logger.warn("Renew request processing is disabled.");
                    return;
                }
                logger.debug("Renew request");
                response = this.processRenewRequest(req, clientAddress, request);
                if (response == null) {
                    return;
                }
            } else {
                if (device == null) {
                    logger.warn("DHCP-device not found for address: " + IpAddress.toString((byte[])((InetSocketAddress)clientAddress).getAddress().getAddress()) + ", ignoring DHCP request.");
                    return;
                }
                if (device.isOption82Required()) {
                    logger.warn("DHCP request without Options.82!");
                    return;
                }
                if (messageType != 3 && messageType != 1) {
                    logger.debug("Unsupported message type: " + messageType);
                    return;
                }
                response = this.processOption82Request(device, req, clientAddress, request);
            }
        }
        device = (InetDhcpDevice)req.getDevice();
        if (response != null && response.messageType == 0) {
            response = null;
        }
        if (response != null && device != null) {
            if (device.alwaysBroadcast) {
                response.flags = (short)(response.flags | DhcpPacket.FLAG_BROADCAST);
            }
            if (device.deviceRuntime.protocolHandler != null) {
                try {
                    logger.info("RESPONSE_BEFORE_POSTPROCESS:\n" + String.valueOf(response));
                    device.deviceRuntime.protocolHandler.postprocessDhcpRequest(request, response);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (response != null) {
            if (logger.isInfoEnabled()) {
                logger.info("RESPONSE:\n" + String.valueOf(response));
            }
            this.updateResponseCounters(response);
        }
        req.setResponse(response);
    }

    private void updatePacketTypeCounters(byte messageType) {
        long nowMillis = System.currentTimeMillis();
        if (messageType == 1) {
            this.discoverMinuteCounter.add(nowMillis, 1L);
            this.discoverSecondCounter.add(nowMillis, 1L);
        } else if (messageType == 3) {
            this.requestMinuteCounter.add(nowMillis, 1L);
            this.requestSecondCounter.add(nowMillis, 1L);
        } else {
            this.otherMinuteCounter.add(nowMillis, 1L);
            this.otherSecondCounter.add(nowMillis, 1L);
        }
    }

    private void updateResponseCounters(DhcpPacket response) {
        long nowMillis = System.currentTimeMillis();
        switch (response.messageType) {
            case 5: {
                this.ackMinuteCounter.add(nowMillis, 1L);
                this.ackSecondCounter.add(nowMillis, 1L);
                break;
            }
            case 2: {
                this.offerMinuteCounter.add(nowMillis, 1L);
                this.offerSecondCounter.add(nowMillis, 1L);
                break;
            }
            default: {
                this.nakMinuteCounter.add(nowMillis, 1L);
                this.nakSecondCounter.add(nowMillis, 1L);
            }
        }
    }

    protected DhcpPacket processOption82Request(InetDhcpDevice device, DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, DhcpPacket request) throws BGException, UnknownHostException {
        req.relayDeviceId = device.getId();
        if (device.deviceSearchMode == 0 && device.deviceRuntime.protocolHandler != null) {
            try {
                device.deviceRuntime.protocolHandler.preprocessDhcpRequest(request, null);
                if (logger.isInfoEnabled()) {
                    logger.info("REQUEST_AFTER_PREPROCESS:\n" + String.valueOf(request));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        InetDhcpDevice agentDevice = device;
        if (device.deviceSearchMode != 2) {
            agentDevice = this.getAgentDevice(device, req, request, agentDevice);
        }
        if (agentDevice.deviceSearchMode != 0) {
            req.relayDeviceId = agentDevice.getId();
        }
        req.agentDeviceId = agentDevice.getId();
        req.setDevice((Idable)agentDevice);
        if ((req.relayDeviceId != req.agentDeviceId || agentDevice.deviceSearchMode != 0) && agentDevice.deviceRuntime.protocolHandler != null) {
            try {
                agentDevice.deviceRuntime.protocolHandler.preprocessDhcpRequest(request, null);
                if (logger.isInfoEnabled()) {
                    logger.info("REQUEST_AFTER_PREPROCESS:\n" + String.valueOf(request));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.processOption82RequestImpl(req, clientAddress, device, agentDevice, request, DhcpPacket.isRenewRequest((DhcpPacket)request));
    }

    private InetDhcpDevice getAgentDevice(InetDhcpDevice device, DhcpListenerWorker<InetDhcpDevice> req, DhcpPacket request, InetDhcpDevice agentDevice) {
        InetDeviceRuntime currentDevice = device.deviceRuntime;
        Object agentRemoteId = currentDevice.getOption82AgentRemoteId(request);
        if (agentRemoteId != null && !"".equals(agentRemoteId)) {
            InetDeviceRuntime subDeviceRuntime = this.access.deviceMap.getByIdentifier(currentDevice, agentRemoteId);
            if (subDeviceRuntime != null) {
                req.agentDeviceId = subDeviceRuntime.inetDeviceId;
                logger.debug("Found subDevice by identifier id=" + subDeviceRuntime.inetDeviceId);
                InetDhcpDevice dhcpDevice = this.deviceMap.get(subDeviceRuntime.inetDeviceId);
                if (dhcpDevice != null) {
                    agentDevice = dhcpDevice;
                } else {
                    logger.warn("Found subDevice by identifier id=" + subDeviceRuntime.inetDeviceId + " but it's type not in dhcp.relay.deviceTypeIds");
                }
                currentDevice = subDeviceRuntime;
            } else if (agentRemoteId instanceof byte[]) {
                logger.info("Agent device not found by agentRemoteId=" + Utils.bytesToString((byte[])((byte[])agentRemoteId), (boolean)false, null));
            } else if (agentRemoteId instanceof String) {
                logger.info("Agent device not found by agentRemoteId=" + String.valueOf(agentRemoteId));
            } else {
                logger.info("Agent device not found by agentRemoteId");
            }
        } else {
            logger.info("agentRemoteId is empty");
        }
        int agentSvlan = currentDevice.getOption82AgentSvlanId(request);
        if (agentSvlan >= 0) {
            InetDeviceRuntime subDeviceRuntime = this.access.deviceMap.getBySvlan(currentDevice, agentSvlan);
            if (subDeviceRuntime != null) {
                req.agentDeviceId = subDeviceRuntime.inetDeviceId;
                logger.debug("Found subDevice by SVLAN id=" + subDeviceRuntime.inetDeviceId);
                InetDhcpDevice dhcpDevice = this.deviceMap.get(subDeviceRuntime.inetDeviceId);
                if (dhcpDevice != null) {
                    agentDevice = dhcpDevice;
                } else {
                    logger.warn("Found subDevice by SVLAN id=" + subDeviceRuntime.inetDeviceId + " but it's type not in dhcp.relay.deviceTypeIds");
                }
                currentDevice = subDeviceRuntime;
            } else {
                logger.info("Agent device not found by SVLAN=" + agentSvlan);
            }
        }
        return agentDevice;
    }

    protected abstract DhcpPacket processOption82RequestImpl(DhcpListenerWorker<InetDhcpDevice> var1, SocketAddress var2, InetDhcpDevice var3, InetDhcpDevice var4, DhcpPacket var5, boolean var6) throws BGException;

    protected DhcpPacket buildResponse(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice device, DhcpPacket request, DhcpPacket response, InetDhcpConnectionEntry entry, Set<Integer> inetOptionIds, boolean renew) throws BGException {
        req.connectionId = entry.connectionId;
        int address = entry.address;
        response.yiaddr = Utils.convertIntToBytes((int)address);
        if (request.messageType == 1) {
            logger.debug("DHCP_DISCOVER");
            response.messageType = (byte)2;
            device.setOptions(this.access.ipResourceManager, entry.ipResourceId, response, Utils.unsignedIntToLong((int)address), inetOptionIds, renew);
            return response;
        }
        if (request.messageType == 3) {
            logger.debug("DHCP_REQUEST");
            response.messageType = (byte)5;
            device.setOptions(this.access.ipResourceManager, entry.ipResourceId, response, Utils.unsignedIntToLong((int)address), inetOptionIds, renew);
            return response;
        }
        return null;
    }

    protected void setOptions(InetDhcpDevice device, byte[] address, int ipResourceId, DhcpPacket response, Set<Integer> inetOptionIds, boolean renew) throws BGException {
        response.yiaddr = address;
        device.setOptions(this.access.ipResourceManager, ipResourceId, response, Utils.unsignedIntToLong((int)Utils.convertBytesToInt((byte[])address)), inetOptionIds, renew);
    }

    protected List<InetConnectionRuntime> getDhcpConnectionList(int parentServId) {
        ArrayList<InetConnectionRuntime> connectionList;
        List<InetServRuntime> children = this.access.inetServRuntimeMap.listChildren(parentServId);
        List<InetConnectionRuntime> allConnectionList = this.access.connectionManager.getByServId(parentServId);
        if (allConnectionList == null) {
            if (children == null || children.size() == 0) {
                return Collections.emptyList();
            }
            connectionList = new ArrayList(5);
        } else {
            connectionList = new ArrayList<InetConnectionRuntime>(allConnectionList.size() + 2);
            this.filterConnectionList(allConnectionList, connectionList);
        }
        if (children != null && children.size() > 0) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                InetServRuntime child = children.get(i);
                allConnectionList = this.access.connectionManager.getByServId(child.inetServId);
                if (allConnectionList == null) continue;
                this.filterConnectionList(allConnectionList, connectionList);
            }
        }
        return connectionList;
    }

    private void filterConnectionList(List<InetConnectionRuntime> allConnectionList, List<InetConnectionRuntime> connectionList) {
        int size = allConnectionList.size();
        for (int i = 0; i < size; ++i) {
            InetConnectionRuntime existConnectionRuntime = allConnectionList.get(i);
            InetConnection existConnection = existConnectionRuntime.connection;
            if (!InetUtils.checkAliveAndType(existConnection, false, 1024)) continue;
            connectionList.add(existConnectionRuntime);
        }
    }

    protected boolean isInfoReq(DhcpPacket request) {
        DhcpOption reqParams;
        boolean infoReq;
        boolean bl = infoReq = request.messageType == 1 && request.ciaddr != null && !Arrays.equals(this.ZERO_ADDR, request.ciaddr);
        if (infoReq && (reqParams = request.getOption((byte)55)) != null && reqParams.value != null) {
            for (int i = 0; i < reqParams.value.length; ++i) {
                if (reqParams.value[i] != 1) continue;
                infoReq = false;
                break;
            }
        }
        return infoReq;
    }

    protected void writeAuthError(InetDhcpDevice device, InetServ serv, int accessCode) throws InterruptedException, BGException {
        InetAuthError error = new InetAuthError();
        error.setDeviceId(device.deviceRuntime.inetDevice.getId());
        error.setDeviceTitle(device.deviceRuntime.inetDevice.getTitle());
        error.setContractId(serv.getContractId());
        error.setServId(serv.getId());
        error.setServTitle(serv.getTitle());
        error.setErrorCode(accessCode);
        error.setContractTitle("");
        InetAuthErrorWorker authErrorWorker = this.access.authErrorWorker;
        if (authErrorWorker != null) {
            if (!authErrorWorker.offer(error)) {
                logger.warn("Auth error not writed to DB. Queue is full.");
            }
        } else {
            try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
                 InetAuthErrorDao authErrorDao = new InetAuthErrorDao(connectionSet, this.moduleId, new Date());){
                authErrorDao.addError(error);
            }
        }
    }

    protected abstract DhcpPacket processRenewRequest(DhcpListenerWorker<InetDhcpDevice> var1, SocketAddress var2, DhcpPacket var3) throws BGException, UnknownHostException;

    @MBeanAttribute
    public long getDiscoverLastMinuteCount() {
        return this.discoverSecondCounter.getSum(System.currentTimeMillis(), 60, TimeUnit.SECONDS);
    }

    @MBeanAttribute
    public double getDiscoverLastTenMinutesAverage() {
        return this.discoverMinuteCounter.getAverage(System.currentTimeMillis(), 10, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public double getDiscoverLastHourAverage() {
        return this.discoverMinuteCounter.getAverage(System.currentTimeMillis(), 60, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public long getRequestLastMinuteCount() {
        return this.requestSecondCounter.getSum(System.currentTimeMillis(), 60, TimeUnit.SECONDS);
    }

    @MBeanAttribute
    public double getRequestLastTenMinutesAverage() {
        return this.requestMinuteCounter.getAverage(System.currentTimeMillis(), 10, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public double getRequestLastHourAverage() {
        return this.requestMinuteCounter.getAverage(System.currentTimeMillis(), 60, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public long getOtherLastMinuteCount() {
        return this.otherSecondCounter.getSum(System.currentTimeMillis(), 60, TimeUnit.SECONDS);
    }

    @MBeanAttribute
    public double getOtherLastTenMinutesAverage() {
        return this.otherMinuteCounter.getAverage(System.currentTimeMillis(), 10, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public double getOtherLastHourAverage() {
        return this.otherMinuteCounter.getAverage(System.currentTimeMillis(), 60, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public long getOfferLastMinuteCount() {
        return this.offerSecondCounter.getSum(System.currentTimeMillis(), 60, TimeUnit.SECONDS);
    }

    @MBeanAttribute
    public double getOfferLastTenMinutesAverage() {
        return this.offerMinuteCounter.getAverage(System.currentTimeMillis(), 10, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public double getOfferLastHourAverage() {
        return this.offerMinuteCounter.getAverage(System.currentTimeMillis(), 60, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public long getAckLastMinuteCount() {
        return this.ackSecondCounter.getSum(System.currentTimeMillis(), 60, TimeUnit.SECONDS);
    }

    @MBeanAttribute
    public double getAckLastTenMinutesAverage() {
        return this.ackMinuteCounter.getAverage(System.currentTimeMillis(), 10, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public double getAckLastHourAverage() {
        return this.ackMinuteCounter.getAverage(System.currentTimeMillis(), 60, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public long getNakLastMinuteCount() {
        return this.nakSecondCounter.getSum(System.currentTimeMillis(), 60, TimeUnit.SECONDS);
    }

    @MBeanAttribute
    public double getNakLastTenMinutesAverage() {
        return this.nakMinuteCounter.getAverage(System.currentTimeMillis(), 10, TimeUnit.MINUTES);
    }

    @MBeanAttribute
    public double getNakLastHourAverage() {
        return this.nakMinuteCounter.getAverage(System.currentTimeMillis(), 60, TimeUnit.MINUTES);
    }

    protected InetConnectionRuntime findConnection(int servId, int deviceId, long connectionId, String macString) {
        InetConnectionRuntime connectionRuntime = null;
        InetConnectionRuntime _connectionRuntime = null;
        List<InetConnectionRuntime> connectionList = this.access.connectionManager.getByCallingStationId(macString);
        if (connectionList == null) {
            return null;
        }
        int size = connectionList.size();
        for (int i = 0; i < size; ++i) {
            InetConnectionRuntime existConnectionRuntime = connectionList.get(i);
            InetConnection existConnection = existConnectionRuntime.connection;
            if (!InetUtils.checkAliveAndType(existConnection, false, 1024) || connectionId != -1L && connectionId != existConnection.getId() || servId != existConnection.getServId() || deviceId != existConnection.getDeviceId() || !macString.equals(existConnection.getCallingStationId())) continue;
            if ((existConnection.getType() & 0x400) != 0 || Utils.isEmptyString((String)existConnection.getUsername())) {
                connectionRuntime = existConnectionRuntime;
                break;
            }
            _connectionRuntime = existConnectionRuntime;
        }
        if (connectionRuntime == null) {
            connectionRuntime = _connectionRuntime;
        } else {
            _connectionRuntime = null;
        }
        return connectionRuntime;
    }

    protected InetConnectionRuntime findConnection(List<InetConnectionRuntime> dhcpConnectionList, int servId, long connectionId, String macString, int deviceId) {
        InetConnectionRuntime connectionRuntime = null;
        InetConnectionRuntime _connectionRuntime = null;
        int size = dhcpConnectionList.size();
        for (int i = 0; i < size; ++i) {
            InetConnectionRuntime existConnectionRuntime = dhcpConnectionList.get(i);
            InetConnection existConnection = existConnectionRuntime.connection;
            if (existConnection.getServId() != servId || deviceId != existConnection.getDeviceId() || connectionId != -1L && connectionId != existConnection.getId() || !macString.equals(existConnection.getCallingStationId())) continue;
            if ((existConnection.getType() & 0x400) != 0 || Utils.isEmptyString((String)existConnection.getUsername())) {
                connectionRuntime = existConnectionRuntime;
                break;
            }
            _connectionRuntime = existConnectionRuntime;
        }
        if (connectionRuntime == null) {
            connectionRuntime = _connectionRuntime;
        } else {
            _connectionRuntime = null;
        }
        return connectionRuntime;
    }

    public void writeLog(DhcpListenerWorker<InetDhcpDevice> req, int[] requestPositions, int[] responsePositions, long now) throws BGException {
        if (!req.isConnectionModified() || req.connectionId == 0L) {
            return;
        }
        ConnectionLogEntry entry = new ConnectionLogEntry();
        entry.setApplicationId(this.applicationId);
        entry.setDeviceId(((InetDhcpDevice)req.getDevice()).getId());
        entry.setDevicePort(req.interfaceId);
        entry.setTime(new Date(now));
        entry.setAcctSessId(Integer.toHexString(req.getRequest().xid));
        entry.setConnectionId(req.connectionId);
        entry.setLogType(5);
        entry.setRequestDataLogId(requestPositions[0]);
        entry.setRequestChunkId(requestPositions[1]);
        entry.setRequestPosition(requestPositions[2]);
        entry.setResponseDataLogId(responsePositions[0]);
        entry.setResponseChunkId(responsePositions[1]);
        entry.setResponsePosition(responsePositions[2]);
        InetAuthErrorWorker authErrorWorker = this.access.authErrorWorker;
        if (authErrorWorker != null) {
            try {
                authErrorWorker.offer(entry);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)Setup.getSetup(), (boolean)true);
                 ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(connectionSet, this.moduleId);){
                dataLogEntryDao.update(entry);
            }
        }
    }
}

