/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.table;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.kernel.tariff.server.enums.TrafficRangeMode;
import ru.bitel.bgbilling.kernel.tariff.server.enums.TrafficRangeType;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.InetTrafficRangeDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TableTrafficRange
extends BGTableInfoBase {
    public TableTrafficRange() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextCenter((String)"TreeNodeId", (String)"treeNodeId").setMaxWidth(300), BGUTableColumn.buildColumnTextCenter((String)"\u041a\u043b\u044e\u0447", (String)"rangeKey").setMaxWidth(-1), BGUTableColumn.buildColumnTextRight((String)"\u0421\u0447\u0435\u0442\u0447\u0438\u043a", (String)"counter").setWidth(150), BGUTableColumn.buildColumnTextRight((String)"\u041e\u0431\u044a\u0435\u043c", (String)"amount").setMaxWidth(150), BGUTableColumn.buildColumnTextRight((String)"\u041c\u0430\u043a\u0441. \u043e\u0431\u044a\u0435\u043c", (String)"maxAmount").setMaxWidth(150)};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        Connection con = serverContext.getConnection();
        try (InetTrafficRangeDao inetTrafficRangeDao = new InetTrafficRangeDao(con, moduleId);){
            List<BGUTableRowData> list = inetTrafficRangeDao.contractTrafficRangeList(tableParams.getContractId(), tableParams.optParamValue("period").map(a -> LocalDate.parse(a)).orElse(LocalDate.now())).stream().map(a -> new BGUTableRowData().addValue("treeNodeId", String.valueOf(a.getTreeNodeId())).addValue("rangeKey", this.rangeKeyToString(a.getRangeKey())).addValue("counter", String.valueOf(a.getCounter())).addValue("amount", Utils.formatLong((long)a.getAmount())).addValue("maxAmount", String.valueOf(a.getMaxAmount()))).toList();
            return list;
        }
    }

    private String rangeKeyToString(long rangeKey) {
        return rangeKey + " [mode = " + TrafficRangeMode.getTrafficRangeModeByCode((int)TrafficRangeKey.getMode((long)rangeKey)) + "; type = " + TrafficRangeType.getTrafficRangeTypeByCode((int)TrafficRangeKey.getType((long)rangeKey)) + "; id = " + TrafficRangeKey.getId((long)rangeKey) + Optional.ofNullable(TrafficRangeKey.getTime((long)rangeKey, (Calendar)new GregorianCalendar())).map(a -> "; time = " + TimeUtils.format((Calendar)a, (String)"dd.MM.yyyy HH:mm")).orElse("") + "]";
    }
}

