/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import java.math.BigDecimal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneCostMapItem;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.ZoneCostMapCache;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceServiceCost;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;
import ru.bitel.common.ParameterMap;

public class ZoneCostMapTariffTreeNode
extends TariffTreeNode<VoiceTariffRequest, VoiceTariffContext, TreeContext, VoiceTariffWorkerContext> {
    private static final Logger logger = LogManager.getLogger();
    private int zoneCostMapId = -1;

    public ZoneCostMapTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.zoneCostMapId = parameterMap.getInt("zoneCostMapId", -1);
        if (logger.isTraceEnabled()) {
            logger.trace("zoneCostMapId = {}", (Object)this.zoneCostMapId);
        }
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, VoiceTariffRequest voiceTariffRequest, VoiceTariffContext voiceTariffContext, TreeContext treeContext, VoiceTariffWorkerContext workerContext) {
        ZoneCostMapCache cache;
        VoiceZoneCostMapItem item;
        int zoneId = voiceTariffRequest.getZoneId();
        if (logger.isTraceEnabled()) {
            logger.trace("zoneCostMapId = {}; zoneId = {}", (Object)this.zoneCostMapId, (Object)zoneId);
        }
        if (zoneId > 0 && (item = (cache = voiceTariffContext.getZoneCostMapCache()).findZoneCost(this.zoneCostMapId, zoneId)) != null) {
            VoiceServiceCost serviceCost = (VoiceServiceCost)voiceTariffRequest.serviceCost;
            if (logger.isTraceEnabled()) {
                logger.trace("VoiceZoneCostMapItem: cost = {}; costSecond = {}", (Object)item.getCost(), (Object)item.getCostSecond());
            }
            serviceCost.setCost(item.getCost());
            serviceCost.divisor = new BigDecimal(item.getCostSecond());
            serviceCost.costSource = 5;
            serviceCost.acceptLevel = -1;
            serviceCost.acceptDefault = false;
            serviceCost.secondCost = item.getCost().divide(serviceCost.divisor);
            return 1;
        }
        return 0;
    }
}

