/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.upload.mfisoft.MfiSoftPaymentType;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadLogsTable;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class PaymentsToUpload {
    private static final Logger logger = LogManager.getLogger();
    private final ServerContext serverContext;
    private final Connection connection;
    private final boolean isFullUpload;
    private final int moduleId;
    private final Preferences config;
    private final int sormProjectId;

    public PaymentsToUpload(ServerContext serverContext, boolean isFullUpload, SormProject sormProject, int moduleId) {
        this.serverContext = serverContext;
        this.connection = serverContext.getConnection();
        this.moduleId = moduleId;
        this.isFullUpload = isFullUpload;
        this.config = sormProject.getLoadedConfig();
        this.sormProjectId = sormProject.getId();
    }

    public List<PaymentType> getPaymentTypesToUpload() throws BGException {
        List selectedTypes = Utils.toIntegerList((String)this.config.get("sorm.upload.paytype"));
        if (Utils.notEmptyCollection((Collection)selectedTypes)) {
            return ((PaymentService)this.serverContext.getService(PaymentService.class, -1)).paymentTypeList(null, null).stream().filter(type -> selectedTypes.contains(type.getId())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Payment> getPaymentsToUpload(boolean onlyWithSelectedTypes) throws Exception {
        List typeIds;
        int lastPaymentId = this.isFullUpload ? -1 : this.getLastPaymentId();
        Calendar threeYearsOld = Calendar.getInstance();
        threeYearsOld.add(1, -3);
        ArrayList<Payment> result = new ArrayList<Payment>();
        String query = "SELECT cp.id, cp.pt, cp.dt, cp.lm, cp.comment, cp.cid, cp.summa FROM contract_payment AS cp LEFT JOIN contract_module AS cmod ON cp.cid=cmod.cid  WHERE cmod.mid=" + this.moduleId;
        if (!this.isFullUpload && lastPaymentId > 0) {
            query = query + " AND cp.id > " + lastPaymentId;
        }
        if (onlyWithSelectedTypes && Utils.notEmptyCollection(typeIds = this.getPaymentTypesToUpload().stream().mapToInt(Id::getId).boxed().collect(Collectors.toList()))) {
            query = query + " AND cp.pt IN (" + Utils.toString(typeIds) + ") ";
        }
        if (this.isFullUpload) {
            query = query + " AND cp.dt>? ORDER BY cp.dt";
        }
        try (PreparedStatement ps = this.serverContext.getConnection().prepareStatement(query);){
            if (this.isFullUpload) {
                ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)threeYearsOld));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(Payment.builder().setId(rs.getInt("cp.id")).setContractId(rs.getInt("cp.cid")).setSum(rs.getBigDecimal("cp.summa")).setComment(rs.getString("cp.comment")).setTypeId(rs.getInt("cp.pt")).setTimeChange(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("cp.lm"))).setDate((Date)rs.getDate("cp.dt")).build());
                }
            }
        }
        return result;
    }

    public String getPaymentTypeCode(int paymentTypeId) {
        Map<Integer, List<Integer>> typesRatio = SormUtils.getPairsMidsListIds(this.config, "sorm.upload.paytype.ratio");
        List<Integer> types = typesRatio.get(paymentTypeId);
        if (Utils.isEmptyCollection(types)) {
            return MfiSoftPaymentType.UNDEFINED_PAYMENT.getCodeStr();
        }
        MfiSoftPaymentType type = MfiSoftPaymentType.getType((int)types.get(0));
        if (type != null) {
            return type.getCodeStr();
        }
        return MfiSoftPaymentType.UNDEFINED_PAYMENT.getCodeStr();
    }

    public int getLastPaymentId() throws SQLException {
        int lastPaymentId = -1;
        String sormPaymentsLogTable = SormUploadLogsTable.getPaymentsLogTable(this.moduleId);
        ServerUtils.checkTable((Connection)this.connection, (String)sormPaymentsLogTable, (String)SormUploadLogsTable.getPaymentsLogTableCreateQuery(this.moduleId));
        try (Statement st = this.connection.createStatement();
             ResultSet rs = st.executeQuery("SELECT paymentId FROM " + sormPaymentsLogTable + " WHERE sormProjectId=" + this.sormProjectId + " ORDER BY id DESC LIMIT 1");){
            if (rs.next()) {
                lastPaymentId = rs.getInt("paymentId");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439: " + lastPaymentId);
        }
        return lastPaymentId;
    }

    public void updatePaymentsLogTable(int lastPaymentId) throws SQLException {
        String paymentsLogTable = SormUploadLogsTable.getPaymentsLogTable(this.moduleId);
        ServerUtils.checkTable((Connection)this.connection, (String)paymentsLogTable, (String)SormUploadLogsTable.getPaymentsLogTableCreateQuery(this.moduleId));
        try (PreparedStatement ps = this.connection.prepareStatement("INSERT INTO " + paymentsLogTable + " (paymentId, sormProjectId, dt) values (?,?, NOW())");){
            ps.setInt(1, lastPaymentId);
            ps.setInt(2, this.sormProjectId);
            ps.executeUpdate();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0421\u041e\u0420\u041c: " + this.sormProjectId + " ID \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + lastPaymentId);
        }
    }
}

