/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payture.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.payture.common.bean.Transaction;
import ru.bitel.bgbilling.modules.payture.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.payture.common.service.PaytureService;
import ru.bitel.bgbilling.modules.payture.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.payture.common.service.PaytureService")
public class PaytureServiceImpl
extends AbstractService
implements PaytureService {
    private TransactionManager transactionManager;

    @PostConstruct
    private void init() {
        this.transactionManager = new TransactionManager(this.getConnection(), this.moduleId);
    }

    public int getOrderId(int contractId, BigDecimal amount) throws BGException {
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setTransactionDate(new Date())).setStatus(TransactionStatus.NEW.getCode())).setSum(amount)).build();
        this.transactionManager.update(transaction);
        return transaction.getId();
    }

    public SearchResult<Transaction> searchTransactionList(int contractId, String contractTitle, String status, PeriodWithTime period, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(period, page);
        this.transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, contractId, contractTitle, status);
        return searchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refund(int paymentId) throws BGException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
        }
        Transaction transaction = this.transactionManager.get(paymentId);
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        Object serverUrl = moduleSetup.get("payture.url.gate", "https://sandbox.payture.com/");
        serverUrl = ((String)serverUrl).lastIndexOf("/") == ((String)serverUrl).length() - 1 ? serverUrl : (String)serverUrl + "/";
        StringBuilder urlString = new StringBuilder((String)serverUrl + "apim/Refund?Key=" + moduleSetup.get("payture.key") + "&");
        urlString.append("Password=" + moduleSetup.get("payture.password") + "&");
        urlString.append("OrderId=" + (String)(moduleSetup.getBoolean("payture.add.contract.id", false) ? transaction.getContractId() + "_" : "") + transaction.getId() + "&");
        urlString.append("Amount=" + Utils.formatBigDecimal((BigDecimal)transaction.getSum().multiply(new BigDecimal(100)), (int)0));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0421\u0442\u0440\u043e\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0435\u0440\u0432\u0438\u0441\u0443 Payture.com: " + urlString.toString());
        }
        try {
            String success;
            Document xmlDocument;
            Element refundElement;
            URL url = new URL(urlString.toString());
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.connect();
            StringBuilder resultXml = new StringBuilder();
            try (BufferedReader br = null;){
                br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                if (br.ready()) {
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        resultXml.append(line);
                    }
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 Payture.com: " + resultXml);
            }
            if ((refundElement = XMLUtils.getElement((Document)(xmlDocument = XMLUtils.parseDocument((String)resultXml.toString())), (String)"Refund")) != null && !(success = XMLUtils.getAttribute((Element)refundElement, (String)"Success")).equalsIgnoreCase("true")) {
                String errCode = XMLUtils.getAttribute((Element)refundElement, (String)"ErrCode");
                this.getLogger().error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: " + errCode);
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u0435\u0440\u043d\u0443\u0442\u044c \u043f\u043b\u0430\u0442\u0435\u0436!");
            }
        }
        catch (IOException e) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0438\u0441\u0443 Payture. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438: " + e.getMessage(), (Throwable)e);
        }
    }
}

