/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.ip.dynamic;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.concurrent.FutureResult;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpAddressRangeSet2;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Node;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.Matcher;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceModifiedEvent;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceSubscribeEvent;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceSubscriptionEvent;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceUnsubscribeEvent;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpCategoryDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceDynSubscriptionDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceSubscriptionDao;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpCategoryRuntime;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceReserveManager;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntime;

public class IpResourceRuntimeManager
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private final Setup setup;
    private final int mid;
    private final ConcurrentMap<Integer, IpCategoryRuntime> categoryMap = new ConcurrentHashMap<Integer, IpCategoryRuntime>();
    private final ConcurrentMap<Integer, Future<IpResourceRuntime>> resourceMap = new ConcurrentHashMap<Integer, Future<IpResourceRuntime>>();
    private final PoolEventPublisher<IpResourceSubscriptionEvent> subscriptionEP;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private volatile IpAddressRangeSet2<IpResourceRange> rangeSet;
    private volatile Map<Integer, IpCategory> ipCategoryMap;
    private final Map<List<Integer>, IpResourceReserveManager> reserveManagerMap = new HashMap<List<Integer>, IpResourceReserveManager>();

    public IpResourceRuntimeManager(boolean realtime, Setup setup, int moduleId) throws BGException {
        this.setup = setup;
        this.mid = moduleId;
        EventProcessor ep = EventProcessor.getInstance();
        this.subscriptionEP = ep.newPoolEventPublisher(IpResourceSubscriptionEvent.class, moduleId, 500, 2000L);
        if (realtime) {
            ep.addListener(this, IpResourceSubscriptionEvent.class, moduleId, null);
            ep.addListener(this, IpResourceSubscribeEvent.class, moduleId, null);
            ep.addListener(this, IpResourceUnsubscribeEvent.class, moduleId, null);
            ep.addListener(this, IpResourceModifiedEvent.class, moduleId, null);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean contains(byte[] address, Matcher<IpResourceRange> matcher) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IpResourceRuntime getResource(Integer id) throws BGException {
        return this.getResource(null, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IpResourceRuntime getResource(ConnectionSet connectionSetExternal, Integer id) throws BGException {
        FutureResult result;
        this.readLock.lock();
        try {
            result = (FutureResult)this.resourceMap.get(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            this.readLock.unlock();
        }
        if (result != null) {
            try {
                return (IpResourceRuntime)result.get(3L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        FutureResult newResult = new FutureResult();
        this.writeLock.lock();
        try {
            result = this.resourceMap.putIfAbsent(id, (Future<IpResourceRuntime>)newResult);
            if (result == null) {
                result = newResult;
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            this.writeLock.unlock();
        }
        if (result != newResult) {
            try {
                return (IpResourceRuntime)result.get(3L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        this.readLock.lock();
        try {
            ConnectionSet connectionSet = connectionSetExternal != null ? connectionSetExternal : ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
            try {
                IpResourceRuntime newRuntime = null;
                Connection con = connectionSet.getConnection();
                try (IpResourceDao ipResourceDao = new IpResourceDao(con, this.mid);
                     IpResourceSubscriptionDao ipResourceSubscriptionDao = new IpResourceSubscriptionDao(con, this.mid);){
                    IpResource resource = (IpResource)ipResourceDao.get(id);
                    if (resource != null) {
                        newRuntime = new IpResourceRuntime(resource, new IpResourceDynSubscriptionDao(con, this.mid).listRuntime(id), ipResourceSubscriptionDao.listRuntime(id, new Date(), null));
                    } else {
                        logger.error("IpResource not found with id=" + id);
                    }
                }
                finally {
                    newResult.set(newRuntime);
                }
            }
            finally {
                if (connectionSet != connectionSetExternal) {
                    connectionSet.recycle();
                }
            }
            IpResourceRuntime ipResourceRuntime = (IpResourceRuntime)result.get();
            return ipResourceRuntime;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private IpCategoryRuntime getCategory(Integer id) throws BGException {
        IpCategoryRuntime result = (IpCategoryRuntime)this.categoryMap.get(id);
        if (logger.isDebugEnabled()) {
            logger.debug("IpCategoryRuntime (from categoryMap): " + result + "; id => " + id);
        }
        if (result == null) {
            try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
                IpCategoryRuntime newResult = this.loadCategory(connectionSet, id);
                if (logger.isDebugEnabled()) {
                    logger.debug("IpCategoryRuntime (from database): " + result + "; id => " + id);
                }
                if (newResult == null) {
                    IpCategoryRuntime ipCategoryRuntime = null;
                    return ipCategoryRuntime;
                }
                result = this.categoryMap.putIfAbsent(id, newResult);
                if (result == null) {
                    result = newResult;
                }
                connectionSet.commit();
            }
        }
        return result;
    }

    private IpCategoryRuntime getCategory(ConnectionSet connectionSet, Integer id) throws BGException {
        IpCategoryRuntime result = (IpCategoryRuntime)this.categoryMap.get(id);
        if (result == null) {
            IpCategoryRuntime newResult = this.loadCategory(connectionSet, id);
            if (newResult == null) {
                return null;
            }
            result = this.categoryMap.putIfAbsent(id, newResult);
            if (result == null) {
                result = newResult;
            }
            connectionSet.commit();
        }
        return result;
    }

    private Map<Integer, IpCategory> getIpCategoryRoot() throws BGException {
        Map result = this.ipCategoryMap;
        if (result != null) {
            return result;
        }
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
             IpCategoryDao ipCategoryDao = new IpCategoryDao(connectionSet.getConnection(), this.mid);){
            List<IpCategory> ipCategoryList = ipCategoryDao.list();
            IpCategory root = new IpCategory();
            root.setId(0);
            root.setTitle("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 IP \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
            TreeUtils.tree(ipCategoryList, (Node)root);
            result = Id.newMap(ipCategoryList);
        }
        this.ipCategoryMap = result;
        return result;
    }

    private IpCategoryRuntime loadCategory(ConnectionSet connectionSet, int id) throws BGException {
        IpCategory category = this.getIpCategoryRoot().get(id);
        if (logger.isDebugEnabled()) {
            logger.debug("loadCategory(...): category = " + category);
        }
        if (category == null) {
            return null;
        }
        ArrayList<IpCategoryRuntime> children = new ArrayList<IpCategoryRuntime>();
        if (category.getChildren() != null) {
            for (IpCategory child : category.getChildren()) {
                IpCategoryRuntime childCategory = this.getCategory(connectionSet, child.getId());
                if (childCategory == null) continue;
                children.add(childCategory);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadCategory(...): children = " + children + "; size = " + children.size());
        }
        List<IpResource> resourceList = null;
        try (IpResourceDao ipResourceDao = new IpResourceDao(connectionSet.getConnection(), this.mid);){
            resourceList = ipResourceDao.list(id);
        }
        ArrayList<IpResourceRuntime> resources = new ArrayList<IpResourceRuntime>();
        for (IpResource res : resourceList) {
            IpResourceRuntime resource = this.getResource(connectionSet, res.getId());
            if (resource == null) continue;
            resources.add(resource);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadCategory(...): resources = " + resources + "; size = " + resources.size());
        }
        return new IpCategoryRuntime(id, children.toArray(new IpCategoryRuntime[children.size()]), resources.toArray(new IpResourceRuntime[resources.size()]));
    }

    public int reserve(List<IpResourceReserve> list, Set<Integer> categories, long millis, long timeout, int max) throws BGException {
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null || (max = category.reserve(list, millis, timeout, max)) > 0) continue;
            return max;
        }
        return max;
    }

    public IpResourceReserve reserve(Set<Integer> categories, long timeout) throws BGException {
        for (Integer id : categories) {
            IpResourceReserve result;
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null || (result = category.reserve(timeout)) == null) continue;
            return result;
        }
        return null;
    }

    public int getIpResourceId(Set<Integer> categoryIds, byte[] address, long millis) throws BGException {
        for (Integer id : categoryIds) {
            int result;
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null || (result = category.getIpResourceId(address, millis)) <= 0) continue;
            return result;
        }
        return -1;
    }

    public void subscribe(Connection con, int contractId, String contractTitle, int ipResourceId, byte[] address, Date timeFrom, long connectionId) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug("Subscribing " + IpAddress.toString((byte[])address) + " to contractId=" + contractId);
        }
        long subscriptionId = new IpResourceDynSubscriptionDao(con, this.mid).occupie(ipResourceId, connectionId, address, timeFrom, -1, contractId, contractTitle);
        this.subscriptionEP.publishAfterCommit(new IpResourceSubscriptionEvent(1, this.mid, -1, contractId, contractTitle, ipResourceId, subscriptionId, address, null, timeFrom, null, true));
    }

    public void unsubscribe(Connection con, int contractId, int ipResourceId, byte[] address, Date timeTo, long connectionId) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug("Unsubscribing " + IpAddress.toString((byte[])address) + " from contractId=" + contractId);
        }
        long subscriptionId = new IpResourceDynSubscriptionDao(con, this.mid).free(ipResourceId, connectionId, address, timeTo, -1, contractId);
        this.subscriptionEP.publishAfterCommit(new IpResourceSubscriptionEvent(2, this.mid, -1, contractId, null, ipResourceId, subscriptionId, address, null, null, timeTo, true));
    }

    @Override
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        if (e instanceof IpResourceSubscribeEvent) {
            IpResourceSubscribeEvent ev = (IpResourceSubscribeEvent)e;
            byte[] address = ev.getAddress();
            int ipResourceId = this.getIpResourceId(ev.getCategorieIds(), address, ev.getTimeFrom().getTime());
            if (ipResourceId > 0) {
                long subscriptionId = new IpResourceDynSubscriptionDao(ctx.getConnection(), this.mid).occupie(ipResourceId, ev.getConnectionId(), address, ev.getTimeFrom(), ev.getSubscriberType(), ev.getContractId(), ev.getSubscriberTitle());
                this.subscriptionEP.publish(new IpResourceSubscriptionEvent(1, this.mid, ev.getSubscriberType(), ev.getContractId(), ev.getSubscriberTitle(), ipResourceId, subscriptionId, address, null, ev.getTimeFrom(), null, true));
            } else {
                logger.error("IpResource not found with categories=" + ev.getCategorieIds() + " and ip=" + new IpAddress(address));
            }
        } else if (e instanceof IpResourceUnsubscribeEvent) {
            IpResourceUnsubscribeEvent ev = (IpResourceUnsubscribeEvent)e;
            byte[] address = ev.getAddress();
            long subscriptionId = new IpResourceDynSubscriptionDao(ctx.getConnection(), this.mid).free(ev.getIpResourceId(), ev.getConnectionId(), address, ev.getTimeTo(), ev.getSubscriberType(), ev.getContractId());
            this.subscriptionEP.publish(new IpResourceSubscriptionEvent(2, this.mid, ev.getSubscriberType(), ev.getContractId(), null, ev.getIpResourceId(), subscriptionId, address, null, null, ev.getTimeTo(), true));
        } else if (e instanceof IpResourceSubscriptionEvent) {
            IpResourceSubscriptionEvent ev = (IpResourceSubscriptionEvent)e;
            switch (ev.getType()) {
                case 1: {
                    this.readLock.lock();
                    try {
                        IpResourceRuntime resource;
                        ConcurrentMap<Integer, Future<IpResourceRuntime>> resourceMap = this.resourceMap;
                        Future future = (Future)resourceMap.get(ev.getIpResourceId());
                        if (future != null && (resource = (IpResourceRuntime)future.get()) != null) {
                            resource.occipie(ev.getSubscriptionId(), ev.getAddressFrom(), ev.getAddressTo(), ev.isDynamic());
                        }
                        break;
                    }
                    catch (Exception ex) {
                        throw new BGException((Throwable)ex);
                    }
                    finally {
                        this.readLock.unlock();
                    }
                }
                case 2: {
                    this.readLock.lock();
                    try {
                        IpResourceRuntime resource;
                        ConcurrentMap<Integer, Future<IpResourceRuntime>> resourceMap = this.resourceMap;
                        Future future = (Future)resourceMap.get(ev.getIpResourceId());
                        if (future != null && (resource = (IpResourceRuntime)future.get()) != null) {
                            resource.free(ev.getSubscriptionId(), ev.getAddressFrom(), ev.getAddressTo(), ev.isDynamic());
                        }
                        break;
                    }
                    catch (Exception ex) {
                        throw new BGException((Throwable)ex);
                    }
                    finally {
                        this.readLock.unlock();
                    }
                }
            }
        } else if (e instanceof IpResourceModifiedEvent) {
            this.reload(((IpResourceModifiedEvent)e).getIpResourceCategoryId(), ((IpResourceModifiedEvent)e).getIpResourceId());
        }
    }

    private void reload(int categoryId, int ipResourceId) {
        this.writeLock.lock();
        try {
            this.categoryMap.remove(categoryId);
            this.resourceMap.remove(ipResourceId);
            this.rangeSet = null;
            this.ipCategoryMap = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reloadResource(int ipResourceId) {
        Future future = (Future)this.resourceMap.get(ipResourceId);
        if (future != null && future.isDone()) {
            try {
                IpResourceRuntime resource = (IpResourceRuntime)future.get();
                if (resource != null) {
                    this.reload(resource.categoryId, ipResourceId);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void reload(final LinkedHashSet<Integer> ipResourceCategoryIds) {
        new Thread("ip-resource-reload"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = IpResourceRuntimeManager.this.resourceMap.values().stream().filter(a -> a.isDone()).map(a -> {
                    try {
                        return (IpResourceRuntime)a.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                }).filter(a -> ipResourceCategoryIds.contains(a.categoryId)).collect(Collectors.toSet());
                IpResourceRuntimeManager.this.writeLock.lock();
                try {
                    for (IpResourceRuntime r : set) {
                        IpResourceRuntimeManager.this.reload(r.categoryId, r.id);
                    }
                }
                finally {
                    IpResourceRuntimeManager.this.writeLock.unlock();
                }
            }
        }.start();
    }

    protected IpResourceReserveManager newReserveManager(LinkedHashSet<Integer> categories) {
        return new IpResourceReserveManager(this.setup, this.mid, categories, this);
    }

    public IpResourceReserveManager getReserveManager(LinkedHashSet<Integer> categories, String name) {
        return this.getReserveManager(categories, name, new IpResourceReserveManager.IpResourceReserveManagerConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpResourceReserveManager getReserveManager(LinkedHashSet<Integer> categories, String name, IpResourceReserveManager.IpResourceReserveManagerConfig config) {
        this.readLock.lock();
        try {
            ArrayList<Integer> list = new ArrayList<Integer>(categories);
            IpResourceReserveManager result = this.reserveManagerMap.get(list);
            if (result == null) {
                result = this.newReserveManager(categories);
                this.reserveManagerMap.put(list, result);
            }
            result.names.add(name);
            result.setConfig(config);
            IpResourceReserveManager ipResourceReserveManager = result;
            return ipResourceReserveManager;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getSize(Set<Integer> categories) throws BGException {
        long result = 0L;
        if (logger.isDebugEnabled()) {
            logger.debug("getSize(...): categories => " + categories);
        }
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (logger.isDebugEnabled()) {
                logger.debug("getSize(...): category => " + category);
            }
            if (category == null) continue;
            long size = category.getSize();
            if (logger.isDebugEnabled()) {
                logger.debug("getSize(...): category.getSize() => " + size);
            }
            if (size != Long.MIN_VALUE) {
                result += size;
                continue;
            }
            return Long.MIN_VALUE;
        }
        return result;
    }

    public long getOccupiedCount(Set<Integer> categories) throws BGException {
        long result = 0L;
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null) continue;
            result += category.getOccupiedCount();
        }
        return result;
    }

    public long getReservedCount(Set<Integer> categories) throws BGException {
        long result = 0L;
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null) continue;
            result += category.getReservedCount();
        }
        return result;
    }

    public long getOccupiedAndReservedCount(Set<Integer> categories) throws BGException {
        long result = 0L;
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null) continue;
            result += category.getOccupiedCount() + category.getReservedCount();
        }
        return result;
    }

    public void initPools(ParameterMap config) {
        ArrayList<IpResourceReserveManager> list;
        this.writeLock.lock();
        try {
            list = new ArrayList<IpResourceReserveManager>(this.reserveManagerMap.values());
        }
        finally {
            this.writeLock.unlock();
        }
        for (IpResourceReserveManager reserveManager : list) {
            reserveManager.pauseBatchReserve();
        }
    }

    public String status() {
        ArrayList<IpResourceReserveManager> list;
        StringBuilder sb = new StringBuilder();
        this.writeLock.lock();
        try {
            list = new ArrayList<IpResourceReserveManager>(this.reserveManagerMap.values());
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            int i = 0;
            for (IpResourceReserveManager reserveManager : list) {
                if (i++ > 50) {
                    sb.append("Skip next pools: " + (list.size() - 50) + "\n");
                    break;
                }
                sb.append("IP pool [" + Utils.toString(reserveManager.names) + "] ").append("ipCategoryIds: " + reserveManager.getIpResourceCategoryIds() + ", ").append("size: " + reserveManager.getSize() + ", ").append("occupied: " + reserveManager.getOccupiedCount() + ", ").append("reserved: " + reserveManager.getReservedCount() + ", ").append("localReserved: " + reserveManager.getLocalReservedCount() + ", ").append("fetchSize: " + reserveManager.getFetchSize()).append('\n');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return sb.toString();
    }

    ConcurrentMap<Integer, IpCategoryRuntime> getLoadedCategoryMap() {
        return this.categoryMap;
    }

    private static /* synthetic */ IpResourceRange lambda$contains$0(Calendar utilCalendar, IpResource a) {
        return new IpResourceRange(a, utilCalendar);
    }

    public static final class IpResourceRange
    extends IpRange {
        public final long dateFrom;
        public final long dateTo;

        public IpResourceRange(IpResource resource, Calendar utilCalendar) {
            super(resource.getAddressFrom(), resource.getAddressTo());
            this.dateFrom = InetUtils.dateFrom((Date)resource.getDateFrom(), (Calendar)utilCalendar);
            this.dateTo = InetUtils.dateTo((Date)resource.getDateTo(), (Calendar)utilCalendar);
        }
    }
}

