/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ParamValueManager;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ParamManager {
    private Connection con;
    private static final String TABLE_NAME = "object_param";

    public ParamManager(Connection con) {
        this.con = con;
    }

    public List<ObjectParam> getParamList() throws BGException {
        ArrayList<ObjectParam> result = new ArrayList<ObjectParam>();
        String query = "SELECT * FROM object_param ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getParamFromRs(rs));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<ObjectParam> getParamList(int typeId) throws BGException {
        ArrayList<ObjectParam> result = new ArrayList<ObjectParam>();
        String query = "SELECT * FROM object_param WHERE type=? ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, typeId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getParamFromRs(rs));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Map<Integer, ObjectParam> getParamMap() throws BGException {
        HashMap<Integer, ObjectParam> result = new HashMap<Integer, ObjectParam>();
        String query = "SELECT * FROM object_param";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                ObjectParam param = this.getParamFromRs(rs);
                result.put(param.getId(), param);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateParam(ObjectParam value) {
        boolean update = value.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + "object_param SET title=?, type=?, comment=?, flags=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            boolean flags = value.isHistory();
            ps.setString(1, value.getTitle());
            ps.setInt(2, value.getTypeId());
            ps.setString(3, value.getComment());
            ps.setByte(4, (byte)(flags ? 1 : 0));
            if (update) {
                ps.setInt(5, value.getId());
            }
            ps.executeUpdate();
            if (!update) {
                value.setId(ServerUtils.lastInsertId(ps));
            }
            ParamValueManager.resetParametersHistoryMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteParam(int id) throws BGException {
        String query = "DELETE FROM object_param WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public ObjectParam getParameter(int parameterId) throws BGException {
        ObjectParam result = null;
        String query = "SELECT * FROM object_param WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, parameterId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getParamFromRs(rs);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private ObjectParam getParamFromRs(ResultSet rs) throws SQLException {
        byte flags = rs.getByte("flags");
        ObjectParam result = new ObjectParam();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setTypeId(rs.getInt("type"));
        result.setComment(rs.getString("comment"));
        result.setHistory((flags & 1) > 0);
        return result;
    }
}

