/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ChargeDao
extends AbstractIdDao<Charge> {
    public ChargeDao(Connection con) {
        super(con, -1, "contract_charge");
        this.fields = new HashMap();
        this.fields.put("date", "dt");
    }

    public SearchResult<Charge> getChargeList(int contractId, int chargeTypeId, Period period, int members) throws BGException {
        return this.getList(contractId, chargeTypeId, period, members, false);
    }

    public SearchResult<Charge> getPaybackList(int contractId, int paybackTypeId, Period period, int members) throws BGException {
        return this.getList(contractId, paybackTypeId, period, members, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SearchResult<Charge> getList(int contractId, int type, Period period, int members, Boolean isPayback) throws BGException {
        SearchResult searchResult = new SearchResult();
        List result = searchResult.getList();
        Date dateFrom = null;
        Date dateTo = null;
        if (period != null) {
            dateFrom = period.getDateFrom();
            dateTo = period.getDateTo();
        }
        try (PreparedStatement ps = this.getPS(contractId, dateFrom, dateTo, type, members, isPayback, true);){
            if (ps == null) {
                searchResult.setSum(BigDecimal.ZERO);
                SearchResult searchResult2 = searchResult;
                return searchResult2;
            }
            BigDecimal totalSum = BigDecimal.ZERO;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    totalSum = totalSum.add(rs.getBigDecimal("summa"));
                    result.add(this.getFromRS(rs));
                }
                searchResult.setSum(totalSum);
                return searchResult;
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public SearchResult<Charge> getChargeList(List<Integer> contractIds, Period period) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPeriod(period);
        this.searchChargeList((SearchResult<Charge>)searchResult, contractIds);
        return searchResult;
    }

    public void searchChargeList(SearchResult<Charge> searchResult, List<Integer> contractIds) throws BGException {
        String[] stringArray;
        if (searchResult == null || contractIds == null || contractIds.isEmpty()) {
            return;
        }
        int index = 1;
        Period period = searchResult.getPeriod();
        if (searchResult.getSort() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "date";
        } else {
            stringArray = searchResult.getSort();
        }
        String[] sort = stringArray;
        List result = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT * FROM " + this.tableName + " WHERE cid IN (" + Utils.toString(contractIds) + ")");
        if (period != null) {
            if (period.getDateFrom() != null) {
                query.append(" AND dt>=?");
            }
            if (period.getDateTo() != null) {
                query.append(" AND dt<=?");
            }
        }
        query.append(this.getSQLOrder(sort, this.fields));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (period != null && period.getDateFrom() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            }
            if (period != null && period.getDateTo() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            }
            ResultSet rs = ps.executeQuery();
            BigDecimal sumL = BigDecimal.ZERO;
            while (rs.next()) {
                sumL = sumL.add(rs.getBigDecimal("summa"));
                result.add(this.getFromRS(rs));
            }
            searchResult.setSum(sumL);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void searchLastChargeList(SearchResult<Charge> searchResult, List<Integer> contractIds, int lastCharges) throws BGException {
        if (searchResult == null || contractIds == null || contractIds.isEmpty()) {
            return;
        }
        List result = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT id, cid, comment, dt, pt, summa, uid, lm, payback FROM " + this.tableName + " WHERE cid IN (" + Utils.toString(contractIds) + ") ORDER BY dt DESC");
        if (lastCharges > 0) {
            query.append(" LIMIT ").append(lastCharges);
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ResultSet rs = ps.executeQuery();
            BigDecimal sumL = BigDecimal.ZERO;
            while (rs.next()) {
                sumL = sumL.add(rs.getBigDecimal("summa"));
                result.add(this.getFromRS(rs));
            }
            searchResult.setSum(sumL);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public int deleteCharges(int contractId) throws BGException {
        return this.delete("cid=?", new Object[]{contractId});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getSum(int contractId, Date dateFrom, Date dateTo, int typeId, int members, Boolean isPayback) throws BGException {
        BigDecimal result = BigDecimal.ZERO;
        try (PreparedStatement ps = this.getPS(contractId, dateFrom, dateTo, typeId, members, isPayback, false);){
            if (ps == null) {
                BigDecimal bigDecimal = result;
                return bigDecimal;
            }
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return result;
            result = rs.getBigDecimal("sum");
            return result;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    private PreparedStatement getPS(int contractId, Date dateFrom, Date dateTo, int typeId, int members, Boolean isPayback, boolean isList) throws Exception {
        String cids = ContractUtils.getCidsStringForQuery(contractId, members, this.con);
        if (cids == null) {
            return null;
        }
        StringBuilder query = new StringBuilder("SELECT " + (isList ? "*" : "IF( SUM(summa) IS NOT NULL, SUM(summa), 0 ) as sum") + " FROM " + this.tableName + " c WHERE c.cid IN(" + cids + ")");
        if (typeId > 0) {
            query.append(" AND c.pt=?");
        }
        if (dateFrom != null) {
            query.append(" AND c.dt >= ?");
        }
        if (dateTo != null) {
            query.append(" AND c.dt <= ?");
        }
        if (isPayback != null) {
            query.append(" AND payback = ?");
        }
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        int index = 1;
        if (typeId > 0) {
            ps.setInt(index++, typeId);
        }
        if (dateFrom != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
        }
        if (dateTo != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateTo));
        }
        if (isPayback != null) {
            ps.setBoolean(index, isPayback);
        }
        return ps;
    }

    protected void updateImpl(Charge charge) throws BGException, SQLException {
        if (charge == null) {
            throw new BGException("Charge is null!");
        }
        int index = 1;
        PreparedStatement ps = null;
        ps = charge.getId() <= 0 ? this.con.prepareStatement("INSERT INTO contract_charge SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=?, payback=?", 1) : this.con.prepareStatement("UPDATE contract_charge SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=? WHERE id=?");
        ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)charge.getDate()));
        ps.setInt(index++, charge.getContractId());
        ps.setInt(index++, charge.getTypeId());
        ps.setInt(index++, charge.getUserId());
        ps.setBigDecimal(index++, charge.getSum());
        ps.setString(index++, charge.getComment());
        if (charge.getId() > 0) {
            ps.setInt(index++, charge.getId());
        } else {
            ps.setBoolean(index, charge.isPayback());
        }
        ps.executeUpdate();
        if (charge.getId() <= 0) {
            charge.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    protected Charge getFromRS(ResultSet rs) throws SQLException, BGException {
        Charge result = new Charge();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setComment(rs.getString("comment"));
        result.setDate(rs.getDate("dt"));
        result.setTypeId(rs.getInt("pt"));
        result.setSum(rs.getBigDecimal("summa"));
        result.setUserId(rs.getInt("uid"));
        result.setTimeChange(rs.getTimestamp("lm"));
        result.setPayback(rs.getBoolean("payback"));
        return result;
    }
}

