/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action.base;

import bitel.billing.server.ActionConType;
import bitel.billing.server.call.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

@ActionConType(value=2)
public abstract class ActionGetLogAndError
extends ActionBase {
    private static final String[] errorMessages = new String[]{"", "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0438\u043d-\u043a\u043e\u0434 \u043a\u0430\u0440\u0442\u044b", "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c \u043b\u043e\u0433\u0438\u043d\u0430", "\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0441\u0435\u0441\u0441\u0438\u0439", "NAS \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043a\u043e\u0434 \u0443\u0441\u043b\u0443\u0433\u0438", "\u041a\u0430\u0440\u0442\u0430 \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u0430", "\u041a\u0430\u0440\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430", "\u041a\u0430\u0440\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u043d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441", "\u0426\u0435\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f", "\u0422\u0438\u043f \u0437\u0432\u043e\u043d\u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d", "\u041b\u043e\u0433\u0438\u043d \u0438 \u043a\u0430\u0440\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b", "\u041d\u0435\u0442 \u0434\u0435\u043d\u0435\u0433 \u043d\u0430 \u0437\u0432\u043e\u043d\u043e\u043a", "\u0417\u0432\u043e\u043d\u043e\u043a \u043d\u0435 \u0442\u0430\u0440\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u0435\u0442\u0441\u044f", "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0443 \u043d\u0430 \u044d\u0442\u043e\u043c NAS\u0435", "REALM \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d", "\u0423\u0441\u043b\u0443\u0433\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430", "", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0441\u0435\u0441\u0441\u0438\u0439", "\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u0432\u0445\u043e\u0434 \u043d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d", "\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u0432\u0445\u043e\u0434 \u0432 \u044d\u0442\u043e \u0432\u0440\u0435\u043c\u044f", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0443\u0441\u043b\u0443\u0433\u0438", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438", "\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d", "\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u0432\u0445\u043e\u0434 \u0441 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430", "", "", "", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430", "\u041f\u0440\u0435\u0444\u0438\u043a\u0441 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0435\u043d", "NAS \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d", "\u0418\u0441\u0442\u0435\u043a \u0441\u0440\u043e\u043a \u0436\u0438\u0437\u043d\u0438 \u043a\u0430\u0440\u0442\u043e\u0447\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "\u0417\u0430\u043f\u0440\u0435\u0442 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438", "", "", "", "\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e"};
    protected String units = "b";

    @Override
    public void doAction() throws SQLException, BGException {
        PreparedStatement ps;
        Object sql;
        Page page = this.getPage();
        String contractTitle = "???";
        int lid = this.getIntParameter("lid", -1);
        int cid = this.getIntParameter("cid", -1);
        int mid = this.getIntParameter("mid", -1);
        int from = this.getIntParameter("from", 1);
        int to = this.getIntParameter("to", 1);
        String mode = this.getParameter("mode");
        this.units = this.getParameter("units", "b");
        Date paramDate = this.getDateParameter("date", "dd.MM.yyyy HH:mm", null);
        boolean onlyLogin = this.getIntParameter("only_login", 0) == 1;
        String numberA = this.getParameter("numberA", null);
        String numberB = this.getParameter("numberB", null);
        if (mode == null || mid < 0) {
            return;
        }
        for (int i = 0; i < errorMessages.length; ++i) {
            try {
                ActionGetLogAndError.errorMessages[i] = this.moduleSetup.get("error.message.code." + i, errorMessages[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HashMap<Integer, String> errorMessageMap = new HashMap<Integer, String>();
        for (Map.Entry e : this.moduleSetup.subIndexed("error.message.code.").entrySet()) {
            errorMessageMap.put((Integer)e.getKey(), ((ParameterMap)e.getValue()).get("", ""));
        }
        Element contract = this.createElement(this.rootNode, "contract");
        if (cid > 0) {
            sql = "SELECT title, comment, closesumma, mode FROM contract WHERE id=?";
            ps = this.conSlave.prepareStatement((String)sql);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                contractTitle = rs.getString(1);
                contract.setAttribute("title", contractTitle);
                contract.setAttribute("comment", rs.getString(2));
                contract.setAttribute("limit", rs.getString(3));
                contract.setAttribute("mode", rs.getString(4));
            }
            rs.close();
            ps.close();
            sql = "SELECT summa1 + summa2 - summa3 - summa4 FROM contract_balance WHERE cid=? ORDER BY yy DESC, mm DESC LIMIT 1";
            ps = this.conSlave.prepareStatement((String)sql);
            ps.setInt(1, cid);
            rs = ps.executeQuery();
            while (rs.next()) {
                contract.setAttribute("balance", String.valueOf(rs.getFloat(1)));
            }
            rs.close();
            ps.close();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        GregorianCalendar date = new GregorianCalendar();
        Timestamp timestampFrom = null;
        Calendar dateFrom = (Calendar)((Calendar)date).clone();
        if (from > 0 && paramDate != null) {
            dateFrom.setTime(paramDate);
        } else {
            dateFrom.add(11, from);
        }
        timestampFrom = new Timestamp(dateFrom.getTime().getTime());
        Timestamp timestampTo = null;
        Calendar dateTo = (Calendar)((Calendar)date).clone();
        if (to > 0 && paramDate != null) {
            dateTo.setTime(paramDate);
            dateTo.add(5, 1);
        } else {
            dateTo.add(11, to);
        }
        timestampTo = new Timestamp(dateTo.getTime().getTime());
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        String dateStr = format.format(dateFrom.getTime());
        int index = 1;
        Object nasFilter = "";
        String nas = this.getParameter("nas", "");
        if (nas.length() > 0) {
            nasFilter = " AND nas_id IN ( " + nas + " ) ";
        }
        Object numberFilter = "";
        if (Utils.notBlankString((String)numberA) && !"0".equals(numberA)) {
            numberFilter = (String)numberFilter + " AND from_number REGEXP '" + numberA + "' ";
        }
        if (Utils.notBlankString((String)numberB) && !"0".equals(numberB)) {
            numberFilter = (String)numberFilter + " AND to_number REGEXP '" + numberB + "' ";
        }
        String table_name = null;
        String nasTableName = "nas_" + mid;
        if ("error".equals(mode)) {
            table_name = "log_error_" + mid + "_" + dateStr;
            if (ServerUtils.tableExists(this.con, table_name)) {
                StringBuilder query = new StringBuilder(300);
                query.append("SELECT SQL_CALC_FOUND_ROWS t1.*, t2.title, t2.comment, nas.identifier FROM ");
                query.append(table_name);
                query.append(" AS t1 LEFT JOIN contract AS t2 ON t1.cid=t2.id ");
                query.append(" LEFT JOIN ");
                query.append(nasTableName);
                query.append(" AS nas ON t1.nas_id=nas.id ");
                query.append(" WHERE dt>? AND dt<? ");
                query.append((String)nasFilter);
                if (lid > 0) {
                    query.append(" AND (lid=? OR lid=0) ");
                }
                if (onlyLogin) {
                    query.append(" AND lid!=0");
                }
                query.append(" ORDER BY dt desc").append(page.sqlLimit());
                ps = this.conSlave.prepareStatement(query.toString(), 1);
                index = 1;
                ps.setTimestamp(index++, timestampFrom);
                ps.setTimestamp(index++, timestampTo);
                if (lid > 0) {
                    ps.setInt(index++, lid);
                }
                ResultSet rs = ps.executeQuery();
                page.setRecordCount(ServerUtils.foundRows(this.con));
                while (rs.next()) {
                    Element element = this.createElement(data, "row");
                    element.setAttribute("f0", rs.getString("log_rec_id"));
                    element.setAttribute("f1", rs.getString("cid"));
                    Timestamp timestamp = rs.getTimestamp("dt");
                    element.setAttribute("f2", TimeUtils.formatFullDate((Date)timestamp));
                    String title = rs.getInt("cid") == 0 ? "-" : (cid > 0 ? contractTitle : rs.getString("t2.title"));
                    element.setAttribute("f3", title);
                    element.setAttribute("f4", rs.getString("t2.comment"));
                    element.setAttribute("f5", rs.getString("login"));
                    element.setAttribute("f6", rs.getString("nas.identifier"));
                    Integer errorCode = rs.getInt("error_code");
                    StringBuffer buf = new StringBuffer();
                    buf.append('[');
                    if (errorCode < 10) {
                        buf.append('0');
                    }
                    buf.append(errorCode);
                    buf.append("] ");
                    if (errorCode < errorMessages.length) {
                        buf.append(errorMessages[errorCode]);
                    } else {
                        buf.append((String)errorMessageMap.get(errorCode));
                    }
                    element.setAttribute("f7", buf.toString());
                }
                ps.close();
            }
        } else if ("logs".equals(mode)) {
            table_name = "log_session_" + mid + "_" + dateStr;
            if (ServerUtils.tableExists(this.con, table_name)) {
                boolean noZeroCost = this.getIntParameter("no_zero_cost", -1) > 0;
                boolean noZeroTime = this.getIntParameter("no_zero_time", -1) > 0;
                Object timeCostFilter = "";
                if (noZeroCost) {
                    timeCostFilter = (String)timeCostFilter + " AND session_cost!=0 ";
                }
                if (noZeroTime) {
                    timeCostFilter = (String)timeCostFilter + " AND session_time!=0 ";
                }
                index = 1;
                sql = lid > 0 ? "SELECT SQL_CALC_FOUND_ROWS * FROM " + table_name + " AS t1, contract AS t2, user_login_" + mid + " AS t3 WHERE lid=? AND session_start>? AND session_start<? AND t1.lid=t3.id AND t3.cid=t2.id " + (String)nasFilter + (String)timeCostFilter + (String)numberFilter + "ORDER BY session_start LIMIT ? OFFSET ?" : "SELECT SQL_CALC_FOUND_ROWS * FROM " + table_name + " AS t1, contract AS t2, user_login_" + mid + " AS t3 WHERE  session_start>? AND session_start<? AND t1.lid=t3.id AND t3.cid=t2.id " + (String)nasFilter + (String)timeCostFilter + (String)numberFilter + "ORDER BY session_start" + page.sqlLimit();
                ps = this.conSlave.prepareStatement((String)sql);
                if (lid > 0) {
                    ps.setInt(index++, lid);
                }
                ps.setTimestamp(index++, timestampFrom);
                ps.setTimestamp(index++, timestampTo);
                try (ResultSet rs = ps.executeQuery();){
                    page.setRecordCount(ServerUtils.foundRows(this.con));
                    this.addData(rs, data);
                }
                ps.close();
            }
        } else if ("active".equals(mode) && ServerUtils.tableExists(this.con, table_name = "log_session_" + mid + "_" + dateStr)) {
            index = 1;
            sql = lid > 0 ? "SELECT SQL_CALC_FOUND_ROWS * FROM " + table_name + " as t1, contract as t2, user_login_" + mid + " as t3 WHERE  lid=? and t1.lid=t3.id and t3.cid=t2.id " + (String)nasFilter + (String)numberFilter + "AND t1.status=0 ORDER BY session_start LIMIT ? OFFSET ?" : "SELECT SQL_CALC_FOUND_ROWS * FROM " + table_name + " as t1, contract as t2, user_login_" + mid + " as t3 WHERE  t1.lid=t3.id and t3.cid=t2.id and t1.status=0 " + (String)nasFilter + (String)numberFilter + "ORDER BY session_start" + page.sqlLimit();
            ps = this.conSlave.prepareStatement((String)sql);
            if (lid > 0) {
                ps.setInt(index++, lid);
            }
            try (ResultSet rs = ps.executeQuery();){
                page.setRecordCount(ServerUtils.foundRows(this.con));
                this.addData(rs, data);
            }
            ps.close();
        }
        this.setPageAttribute(table, page);
        if (this.getIntParameter("nasList", -1) == 1) {
            this.addNASList(this.rootNode, mid);
        }
        ServerUtils.prepareElementToSerialize(this.rootNode);
    }

    protected abstract void addData(ResultSet var1, Element var2) throws SQLException;
}

