/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.event.AbstractConsumer;
import ru.bitel.bgbilling.kernel.event.AbstractExecutorEventWorker;
import ru.bitel.bgbilling.kernel.event.Consumer;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerThreadContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;

public abstract class ExecutorEventWorker
extends AbstractExecutorEventWorker
implements EventListener<Event>,
MessageListener,
Lifecycle {
    protected final ContractExecutorEventWorker executor;

    public ExecutorEventWorker(ContractExecutorEventWorker executor, EventProcessor ep, Class<? extends Event> clazz, int moduleId, int pluginId, String query) throws BGException {
        super(ep, clazz, moduleId, pluginId, query);
        this.executor = executor;
        this.executor.eventWorkers.add(this);
    }

    public ExecutorEventWorker(ContractExecutorEventWorker executor, EventProcessor ep, String destination, int moduleId, int pluginId, String query, Class<?> ... clazz) throws BGException {
        super(ep, destination, moduleId, pluginId, query, clazz);
        this.executor = executor;
        this.executor.eventWorkers.add(this);
    }

    public void onMessage(Message message) {
        this.executor.onMessage(message, this.consumer);
    }

    public static class ContractExecutorEventWorker
    implements Lifecycle {
        protected final ExecutorService[] executors;
        protected final List<AbstractExecutorEventWorker> eventWorkers = new ArrayList<AbstractExecutorEventWorker>();

        public ContractExecutorEventWorker(EventProcessor ep, String name, int threadCount, int queueSize) {
            this.executors = new ExecutorService[threadCount];
            for (int i = 0; i < threadCount; ++i) {
                this.executors[i] = EventListenerThreadContext.newExecutorService(ep, name, 1, queueSize);
            }
        }

        public void onMessage(Message message, AbstractConsumer consumer) {
            int contractId = 0;
            try {
                contractId = message.getIntProperty("cid");
                if (contractId < 0) {
                    contractId = 0;
                }
            }
            catch (JMSException e) {
                LogManager.getLogger().error(e.getMessage(), (Throwable)e);
            }
            this.executors[contractId % this.executors.length].execute(new Consumer.EventListenerRunnable(message, consumer));
        }

        @Override
        public void start() throws BGException {
            for (AbstractExecutorEventWorker w : this.eventWorkers) {
                w.start();
            }
        }

        @Override
        public void stop() throws BGException {
            for (AbstractExecutorEventWorker w : this.eventWorkers) {
                w.stop();
            }
        }
    }
}

