/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountTypeDao;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.oss.kernel.entity.common.bean.Entity;

public class LoaderImportVoiceServUtil
extends LoaderBase {
    @Override
    public String execute(String data, String config) throws Exception {
        JSONObject configJsonObject = new JSONObject(config);
        int moduleId = configJsonObject.getInt("moduleId");
        int voiceAccountTypeId = configJsonObject.getInt("voiceAccountTypeId");
        StringBuffer result = new StringBuffer();
        try (ContractDao contractDao = new ContractDao(this.con, 0);
             VoiceAccountDao voiceAccountDao = new VoiceAccountDao(this.con, moduleId);
             VoiceAccountTypeDao voiceAccountTypeDao = new VoiceAccountTypeDao(this.con, moduleId);){
            VoiceAccountType voiceAccountType = (VoiceAccountType)voiceAccountTypeDao.get(voiceAccountTypeId);
            int deviceId = new Preferences(voiceAccountType.getConfig(), "\n").getInt("const.device.id", 0);
            if (deviceId == 0) {
                throw new BGMessageException("\u0414\u043b\u044f \u0442\u0438\u043f\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u0441 ID#" + voiceAccountTypeId + " \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0442\u0438\u043f\u0430 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 const.device.id= (ID \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430)");
            }
            DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
            int count = 0;
            for (String line : data.split("\n")) {
                VoiceAccountData voiceAccountData = new VoiceAccountData();
                voiceAccountData.deviceId = deviceId;
                AtomicReference<Integer> index = new AtomicReference<Integer>(2);
                String[] lineData = line.split("\t");
                if (this.setConract(line, lineData, voiceAccountData, contractDao, result) || this.setDateFrom(line, lineData, voiceAccountData, timeFormatter, result) || voiceAccountType.isNeedPhone() && this.setPhone(line, lineData, voiceAccountData, result, index) || voiceAccountType.isNeedLines() && this.setLines(line, lineData, voiceAccountData, result, index) || voiceAccountType.isNeedLogin() && this.setLoginPassword(line, lineData, voiceAccountData, result, index)) continue;
                List voiceAccounts = voiceAccountDao.list(voiceAccountData.contractId);
                if (voiceAccounts == null || voiceAccounts.isEmpty()) {
                    this.addVoiceAccount(voiceAccountData, voiceAccountTypeId, voiceAccountDao);
                } else {
                    boolean add = true;
                    for (VoiceAccount voiceAccount : voiceAccounts) {
                        if (voiceAccount.getTypeId() != voiceAccountTypeId || voiceAccount.getNumber() != voiceAccountData.phoneNumber) continue;
                        add = false;
                        break;
                    }
                    if (!add) {
                        result.append("\u041f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c => " + line + " => \u043f\u043e\u0432\u0442\u043e\u0440\n");
                        continue;
                    }
                    this.addVoiceAccount(voiceAccountData, voiceAccountTypeId, voiceAccountDao);
                }
                ++count;
            }
            result.insert(0, "\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 -> " + count + "\n\n");
        }
        return result.toString();
    }

    private void addVoiceAccount(VoiceAccountData voiceAccountData, int voiceAccountTypeId, VoiceAccountDao voiceAccountDao) throws Exception {
        VoiceAccount voiceAccount = VoiceAccount.builder().setContractId(voiceAccountData.contractId).setTypeId(voiceAccountTypeId).setDeviceId(voiceAccountData.deviceId).setDateFrom(TimeUtils.convertLocalDateToDate(voiceAccountData.dateFrom)).setLineCount(voiceAccountData.lineCount).setLogin(voiceAccountData.login).setPassword(voiceAccountData.password).build();
        voiceAccountDao.update((Entity)voiceAccount);
    }

    private boolean setConract(String line, String[] lineData, VoiceAccountData voiceAccountData, ContractDao contractDao, StringBuffer result) throws BGException {
        if (lineData.length > 0) {
            Contract contract = contractDao.getByTitle(lineData[0]);
            if (contract == null) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \"" + lineData[0] + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\n");
                return true;
            }
            voiceAccountData.contractId = contract.getId();
            return false;
        }
        result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
        return true;
    }

    private boolean setDateFrom(String line, String[] lineData, VoiceAccountData voiceAccountData, DateTimeFormatter timeFormatter, StringBuffer result) throws BGException {
        if (lineData.length > 1) {
            try {
                voiceAccountData.dateFrom = LocalDate.parse(lineData[1], timeFormatter);
                return false;
            }
            catch (Exception ex) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u0434\u0430\u0442\u044b \"" + lineData[1] + "\"\n");
                return true;
            }
        }
        result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
        return true;
    }

    private boolean setLoginPassword(String line, String[] lineData, VoiceAccountData voiceAccountData, StringBuffer result, AtomicReference<Integer> index) throws BGException {
        if (lineData.length > index.get() + 1) {
            try {
                voiceAccountData.login = lineData[index.get()];
                index.set(index.get() + 1);
                voiceAccountData.password = lineData[index.get()];
                index.set(index.get() + 1);
                return false;
            }
            catch (Exception ex) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043b\u043e\u0433\u0438\u043d\u0430/\u043f\u0430\u0440\u043e\u043b\u044f \"" + lineData[index.get()] + "\"\n");
                return true;
            }
        }
        result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
        return true;
    }

    private boolean setPhone(String line, String[] lineData, VoiceAccountData voiceAccountData, StringBuffer result, AtomicReference<Integer> index) throws BGException {
        if (lineData.length > index.get() + 1) {
            if (!lineData[index.get()].matches("^\\d{11}$")) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043d\u043e\u043c\u0435\u0440\u0430 \"" + lineData[index.get()] + "\"\n");
                return true;
            }
            voiceAccountData.phoneNumber = Long.parseLong(lineData[index.get()]);
            index.set(index.get() + 1);
            return false;
        }
        result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
        return true;
    }

    private boolean setLines(String line, String[] lineData, VoiceAccountData voiceAccountData, StringBuffer result, AtomicReference<Integer> index) throws BGException {
        if (lineData.length > index.get() + 1) {
            try {
                voiceAccountData.lineCount = Integer.parseInt(lineData[index.get()]);
                index.set(index.get() + 1);
                return false;
            }
            catch (Exception ex) {
                result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 => " + line + " => \u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043b\u0438\u043d\u0438\u0439 \"" + lineData[index.get()] + "\"\n");
                return true;
            }
        }
        result.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 => " + line + "\n");
        return true;
    }

    class VoiceAccountData {
        int contractId;
        LocalDate dateFrom;
        int deviceId;
        long phoneNumber;
        int lineCount;
        String login;
        String password;

        VoiceAccountData() {
        }
    }
}

