/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.config.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.config.common.bean.ContractModuleConfig;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstarctDaoConstant;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public abstract class AbstractContractConfig
extends AbstarctDaoConstant
implements AutoCloseable {
    protected static final String TABLE_CONTRACT_MODULE_CONFIG = "contract_module_config";
    protected static final String TABLE_CONTRACT_PLUGIN_CONFIG = "contract_plugin_config";
    private String table = null;
    private Connection con = null;
    private int configId = 0;
    private PreparedStatement psSelect = null;
    private PreparedStatement psKeySelect = null;
    private PreparedStatement psUpdate = null;
    private PreparedStatement psDelete = null;

    protected AbstractContractConfig(String table, Connection con, int configId) {
        this.table = table;
        this.con = con;
        this.configId = configId;
        this.fields = new HashMap();
        this.fields.put("key", "key");
        this.fields.put("value", "value");
    }

    public String get(int contractId, String key) throws BGException {
        return this.get(contractId, key, null);
    }

    public String get(int contractId, String key, String defaultValue) throws BGException {
        return this.get(contractId, this.configId, key, defaultValue);
    }

    private String get(int contractId, int configId, String key, String defaultValue) throws BGException {
        String value = defaultValue;
        if (contractId > 0 && key != null) {
            try {
                if (this.psSelect == null) {
                    String query = "SELECT " + "value" + " FROM " + this.table + " WHERE " + "contract_id=? AND " + (this.table.equals(TABLE_CONTRACT_MODULE_CONFIG) ? "module" : "plugin") + "_id=? AND `key`=?";
                    this.psSelect = this.con.prepareStatement(query);
                }
                int index = 1;
                this.psSelect.setInt(index++, contractId);
                this.psSelect.setInt(index++, configId);
                this.psSelect.setString(index++, key);
                ResultSet resultSet = this.psSelect.executeQuery();
                while (resultSet.next()) {
                    value = resultSet.getString(1);
                }
                resultSet.close();
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
        return value;
    }

    public void update(int contractId, String key, String value) throws BGException {
        this.update(contractId, this.configId, key, value);
    }

    private void update(int contractId, int configId, String key, String value) throws BGException {
        if (contractId > 0 && key != null && value != null) {
            try {
                if (this.psUpdate == null) {
                    String query = "INSERT INTO " + this.table + "(`contract_id`, `" + (this.table.equals(TABLE_CONTRACT_MODULE_CONFIG) ? "module" : "plugin") + "_id`, `key`, `value` )" + " VALUES " + "( ?, ?, ?, ? )" + " ON DUPLICATE KEY UPDATE " + "`value`=?";
                    this.psUpdate = this.con.prepareStatement(query);
                }
                int index = 1;
                this.psUpdate.setInt(index++, contractId);
                this.psUpdate.setInt(index++, configId);
                this.psUpdate.setString(index++, key);
                this.psUpdate.setString(index++, value);
                this.psUpdate.setString(index++, value);
                this.psUpdate.executeUpdate();
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
    }

    public void delete(int contractId, String key) throws BGException {
        this.delete(contractId, this.configId, key);
    }

    private void delete(int contractId, int configId, String key) throws BGException {
        if (contractId > 0 && key != null) {
            try {
                if (this.psDelete == null) {
                    String query = "DELETE " + " FROM " + this.table + " WHERE " + "`contract_id`=? AND " + (this.table.equals(TABLE_CONTRACT_MODULE_CONFIG) ? "`module" : "`plugin") + "_id`=? AND `key`=?";
                    this.psDelete = this.con.prepareStatement(query);
                }
                int index = 1;
                this.psDelete.setInt(index++, contractId);
                this.psDelete.setInt(index++, configId);
                this.psDelete.setString(index++, key);
                this.psDelete.executeUpdate();
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
    }

    public void deleteForContract(int contractId) throws BGException {
        try {
            String query = "DELETE " + this.table + " WHERE " + "contract_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public void searchContractModuleConfig(SearchResult<ContractModuleConfig> searchResult, String contractTitle, String[] keys) throws BGException {
        try {
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            List<ContractModuleConfig> list = searchResult.getList();
            StringBuilder keysWhere = new StringBuilder();
            if (keys != null && keys.length > 0) {
                keysWhere.append(" AND `key` IN ( ");
                for (int i = 0; i < keys.length; ++i) {
                    if (i > 0) {
                        keysWhere.append(", ");
                    }
                    keysWhere.append("?");
                }
                keysWhere.append(" )");
            }
            StringBuilder contractTitleWhere = new StringBuilder();
            if (Utils.notBlankString(contractTitle)) {
                contractTitleWhere.append(" AND c.title LIKE ?");
            }
            String query = "SELECT " + "SQL_CALC_FOUND_ROWS " + " `contract_id`, `key`, `value`, c.title AS contractTitle" + " FROM " + this.table + " AS v" + " LEFT JOIN contract AS c ON c.id=v.contract_id" + " WHERE " + (this.table.equals(TABLE_CONTRACT_MODULE_CONFIG) ? "module" : "plugin") + "_id=?" + keysWhere.toString() + contractTitleWhere.toString() + this.getSQLOrder(sort, this.fields) + page.sqlLimit();
            int index = 1;
            PreparedStatement psDataSelect = this.con.prepareStatement(query);
            psDataSelect.setInt(index++, this.configId);
            if (keys != null && keys.length > 0) {
                for (int i = 0; i < keys.length; ++i) {
                    psDataSelect.setString(index++, keys[i]);
                }
            }
            if (Utils.notBlankString(contractTitle)) {
                psDataSelect.setString(index++, "%" + contractTitle + "%");
            }
            ResultSet resultSet = psDataSelect.executeQuery();
            while (resultSet.next()) {
                ContractModuleConfig contractModuleConfig = new ContractModuleConfig();
                contractModuleConfig.setContractId(resultSet.getInt("contract_id"));
                contractModuleConfig.setContractTitle(resultSet.getString("contractTitle"));
                contractModuleConfig.setKey(resultSet.getString("key"));
                contractModuleConfig.setValue(resultSet.getString("value"));
                list.add(contractModuleConfig);
            }
            resultSet.close();
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public List<String> getKeyList() throws BGException {
        ArrayList<String> keyList = new ArrayList<String>();
        try {
            if (this.psKeySelect == null) {
                String query = "SELECT " + "DISTINCT " + "`key`" + " FROM " + this.table + " WHERE " + (this.table.equals(TABLE_CONTRACT_MODULE_CONFIG) ? "module" : "plugin") + "_id=?" + " ORDER BY " + "`key`";
                this.psKeySelect = this.con.prepareStatement(query);
            }
            int index = 1;
            this.psKeySelect.setInt(index++, this.configId);
            ResultSet resultSet = this.psKeySelect.executeQuery();
            while (resultSet.next()) {
                keyList.add(resultSet.getString(1));
            }
            resultSet.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return keyList;
    }

    @Override
    public void close() {
        try {
            if (this.psSelect != null) {
                this.psSelect.close();
                this.psSelect = null;
            }
            if (this.psKeySelect != null) {
                this.psKeySelect.close();
                this.psKeySelect = null;
            }
            if (this.psUpdate != null) {
                this.psUpdate.close();
                this.psUpdate = null;
            }
            if (this.psDelete != null) {
                this.psDelete.close();
                this.psDelete = null;
            }
        }
        catch (SQLException ex) {
            this.getLogger().error("error close dao", (Throwable)ex);
        }
    }
}

