/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterMultiListItem;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractParameterMultiListItemDao
extends AbstractIdDao<ContractParameterMultiListItem>
implements Directory<ContractParameterMultiListItem> {
    private int parameterTypeId;

    public ContractParameterMultiListItemDao(Connection con, int parameterTypeId) {
        super(con, 0, "contract_parameter_type_multilist_values");
        this.parameterTypeId = parameterTypeId;
    }

    @Override
    protected ContractParameterMultiListItem getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractParameterMultiListItem result = new ContractParameterMultiListItem();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setInUse(rs.getBoolean("inUse"));
        return result;
    }

    @Override
    protected void updateImpl(ContractParameterMultiListItem contractParameterMultiListItem) throws BGException, SQLException {
        boolean update = contractParameterMultiListItem.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, pid=?, inUse=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, contractParameterMultiListItem.getTitle());
            ps.setInt(index++, contractParameterMultiListItem.getParameterId());
            ps.setBoolean(index++, contractParameterMultiListItem.isInUse());
            if (update) {
                ps.setInt(index++, contractParameterMultiListItem.getId());
            }
            ps.executeUpdate();
            if (!update) {
                contractParameterMultiListItem.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    @Override
    protected int deleteImpl(int id) throws BGException, SQLException {
        boolean isUsed = false;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT cid FROM contract_parameter_type_multilist_item WHERE pid=? LIMIT 1");){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                isUsed = rs.next();
            }
        }
        if (isUsed) {
            throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435, \u0442.\u043a. \u043e\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.", "list.value.deleteError.isUsed");
        }
        return super.deleteImpl(id);
    }

    @Override
    public void recycle() throws BGException {
        super.recycle();
    }

    @Override
    public ContractParameterMultiListItem get(String title) throws BGException {
        return (ContractParameterMultiListItem)((Object)super.get("title=?", title));
    }

    @Override
    public List<ContractParameterMultiListItem> list() throws BGException {
        if (this.parameterTypeId > 0) {
            return super.list("pid=?", "title", this.parameterTypeId);
        }
        return super.list(null, "title", new Object[0]);
    }
}

