/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionExpressionData;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class ActionExpressionDataDao
extends AbstractIdDao<ActionExpressionData> {
    public ActionExpressionDataDao(Connection con) {
        super(con, 0, "bgs_user_action_expression");
    }

    public List<ActionExpressionData> list() throws BGException {
        return this.list(null, "title", new Object[0]);
    }

    public List<ActionExpressionData> list(String componentId, List<Integer> actionsIds) throws BGException {
        return this.list("component_id=?" + (String)(actionsIds == null || actionsIds.isEmpty() ? "" : " AND service_id IN ( " + Utils.toString(actionsIds) + " )"), "title", componentId);
    }

    @Override
    protected ActionExpressionData getFromRS(ResultSet rs) throws SQLException, BGException {
        return ActionExpressionData.builder().setId(rs.getInt("id")).setComponentId(rs.getString("component_id")).setTitle(rs.getString("title")).setServiceId(rs.getInt("service_id")).setServiceName(rs.getString("service_name")).setServiceOperation(rs.getString("service_operation")).setServiceExpression(rs.getString("service_expression")).build();
    }

    @Override
    protected void updateImpl(ActionExpressionData expressionData) throws BGException, SQLException {
        boolean update = expressionData.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET component_id=?, title=?, service_id=?, service_name=?, service_operation=?, service_expression=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, expressionData.getComponentId());
            ps.setString(index++, expressionData.getTitle());
            ps.setInt(index++, expressionData.getServiceId());
            ps.setString(index++, expressionData.getServiceName());
            ps.setString(index++, expressionData.getServiceOperation());
            ps.setString(index++, expressionData.getServiceExpression());
            if (update) {
                ps.setInt(index++, expressionData.getId());
            }
            ps.executeUpdate();
            if (!update) {
                expressionData.setId(index);
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }
}

