/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address.sync;

import bitel.billing.module.common.BGControlPanelButtonGroup;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.common.table.BGTableColumn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class AddressSynchronizer
extends JFrame {
    private Preferences setup;
    private GenericObjectPool<Object> mainConnectionPool;
    private GenericObjectPool<Object> secondaryConnectionPool;
    private final String CONFIG_KEY_DATE = "d.date.";
    private final String CONFIG_KEY_BOX_INDEX = "s.box.index";
    private final String CONFIG_KEY_FLAT_AMOUNT = ".i.flat.amount";
    private final String CONFIG_KEY_POD_RANGE = ".s.pod.range";
    private final String TABLE_COUNTRY = "address_country";
    private final String TABLE_CITY = "address_city";
    private final String TABLE_STREET = "address_street";
    private final String TABLE_AREA = "address_area";
    private final String TABLE_QUARTER = "address_quarter";
    private final String TABLE_HOUSE = "address_house";
    private final String TABLE_CONFIG = "address_config";
    private BGTable primaryTable = new BGTable();
    private BGTable secondaryTable = new BGTable();
    private BGButton commit = new BGButton("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u043e\u0432\u0430\u0442\u044c");
    private BGControlPanelButtonGroup addressTable = new BGControlPanelButtonGroup();
    private BGControlPanelButtonGroup mode = new BGControlPanelButtonGroup();
    private JCheckBox showOnlyAsyncCB = new JCheckBox("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0435\u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0435");
    private JLabel primaryRecordLabel = new JLabel("0");
    private JLabel secondaryRecordLabel = new JLabel("0");

    public AddressSynchronizer() {
        try {
            this.init();
            this.initTables();
            this.initButtons();
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setLocation(0, 0);
        this.setSize(screenSize.width, screenSize.height - 30);
        if (this.getToolkit().isFrameStateSupported(6)) {
            this.setExtendedState(6);
        }
        this.setVisible(true);
        this.setData(this.addressTable.getSelectedCommand());
    }

    private void initButtons() {
        this.mode.addButton("A => B", "AtoB", true);
        this.mode.addButton("A <= B", "BtoA");
        this.mode.addButton("A <=> B", "AB");
        this.addressTable.addButton("\u0421\u0442\u0440\u0430\u043d\u044b", "country", true);
        this.addressTable.addButton("\u0413\u043e\u0440\u043e\u0434\u0430", "city");
        this.addressTable.addButton("\u0420\u0430\u0439\u043e\u043d\u044b", "area");
        this.addressTable.addButton("\u0423\u043b\u0438\u0446\u044b", "street");
        this.addressTable.addButton("\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u044b", "quarter");
        this.addressTable.addButton("\u0414\u043e\u043c\u0430", "house");
        this.addressTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressSynchronizer.this.setData(e.getActionCommand());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String command) {
        Connection maincon = null;
        Connection seccon = null;
        try {
            Vector<String> rowData;
            if (Utils.notBlankString(command)) {
                maincon = this.getDBConnectionFromMainPool();
                seccon = this.getDBConnectionFromSecondaryPool();
                this.primaryTable.removeRows();
                this.secondaryTable.removeRows();
            }
            StringBuilder query = new StringBuilder();
            if ("house".equals(command)) {
                query.append("SELECT house.id, concat(if(ISNULL(city.title),'',city.title), ', ', if(ISNULL(area.title),'',area.title), ', ', if(ISNULL(quar.title),'',quar.title), ', ', if(ISNULL(str.title),'',str.title), ', ', CAST(house.house as CHAR), if(ISNULL(house.frac),'',house.frac)),");
                query.append(" concat(if(ISNULL(city.title),'',city.title), ', ', if(ISNULL(area.title),'',area.title), ', ', if(ISNULL(quar.title),'',quar.title), ', ', if(ISNULL(str.title),'',str.title), ', ', CAST(house.house as CHAR), if(ISNULL(house.frac),'',house.frac)), '' FROM ");
                query.append("address_house");
                query.append(" AS house LEFT JOIN address_street AS str ON house.streetid=str.id");
                query.append(" LEFT JOIN address_city AS city ON str.cityid=city.id");
                query.append(" LEFT JOIN address_quarter AS quar ON house.quarterid=quar.id");
                query.append(" LEFT JOIN address_area AS area ON house.areaid=area.id");
                query.append(" ORDER BY city.title, str.title, house.house, house.frac");
            } else if ("city".equals(command)) {
                query.append("SELECT t.id, concat( t.title, ' (', c.title, ')' ), t.title, ''  FROM ");
                query.append("address_city");
                query.append(" AS t LEFT JOIN address_country AS c ON t.country_id=c.id ORDER BY t.title");
            } else if ("country".equals(command)) {
                query.append("SELECT id, title, title, '' FROM ");
                query.append("address_country");
                query.append(" ORDER BY title");
            } else {
                String tableName = "address_" + command;
                query.append("SELECT t.id, concat( c.title, ', ', t.title ) AS title, t.title, t.cityid FROM ");
                query.append(tableName);
                query.append(" AS t LEFT JOIN address_city AS c ON t.cityid=c.id ORDER BY title");
            }
            PreparedStatement ps = maincon.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                rowData = new Vector<String>();
                rowData.add(rs.getString(1));
                rowData.add(rs.getString(2));
                rowData.add(rs.getString(3));
                rowData.add(rs.getString(4));
                this.primaryTable.addRow(rowData);
            }
            rs.close();
            ps.close();
            query = new StringBuilder();
            if ("house".equals(command)) {
                query.append("SELECT house.id, concat(if(ISNULL(city.title),'',city.title), ', ', if(ISNULL(area.title),'',area.title), ', ', if(ISNULL(quar.title),'',quar.title), ', ', if(ISNULL(str.title),'',str.title), ', ', CAST(house.house as CHAR), if(ISNULL(house.frac),'',house.frac)),");
                query.append(" concat(if(ISNULL(city.title),'',city.title), ', ', if(ISNULL(area.title),'',area.title), ', ', if(ISNULL(quar.title),'',quar.title), ', ', if(ISNULL(str.title),'',str.title), ', ', CAST(house.house as CHAR), if(ISNULL(house.frac),'',house.frac))");
                query.append(" , '' FROM address_house as house");
                query.append(" LEFT JOIN address_street as str ON house.streetid=str.id");
                query.append(" LEFT JOIN address_city as city ON str.cityid=city.id");
                query.append(" LEFT JOIN address_quarter as quar ON house.quarterid=quar.id");
                query.append(" LEFT JOIN address_area as area ON house.areaid=area.id");
                query.append(" ORDER BY city.title, str.title, house.house, house.frac");
            } else if ("city".equals(command)) {
                query.append("SELECT t.id, concat( t.title, ' (', c.title, ')' ), t.title, ''  FROM ");
                query.append("address_city");
                query.append(" AS t LEFT JOIN address_country AS c ON t.country_id=c.id ORDER BY t.title");
            } else if ("country".equals(command)) {
                query.append("SELECT id, title, title, '' FROM ");
                query.append("address_country");
                query.append(" ORDER BY title");
            } else {
                String tableName = "address_" + command;
                query.append("SELECT t.id, concat( t.title, ' (', c.title, ')' ), t.title, t.cityid FROM ");
                query.append(tableName);
                query.append(" AS t LEFT JOIN address_city AS c ON t.cityid=c.id ORDER BY t.title");
            }
            ps = seccon.prepareStatement(query.toString());
            rs = ps.executeQuery();
            boolean notAdd = false;
            while (rs.next()) {
                notAdd = false;
                rowData = new Vector();
                String id = rs.getString(1);
                String title = rs.getString(2);
                String data = rs.getString(3);
                String cityId = rs.getString(4);
                if (this.showOnlyAsyncCB.isSelected()) {
                    for (int i = 0; i < this.primaryTable.getRowCount(); ++i) {
                        if (!this.primaryTable.getValueAt(i, 0).equals(id) || !this.primaryTable.getValueAt(i, 2).equals(data) || !this.primaryTable.getValueAt(i, 3).equals(cityId)) continue;
                        this.primaryTable.removeRow(i);
                        notAdd = true;
                        break;
                    }
                }
                if (notAdd) continue;
                rowData.add(id);
                rowData.add(title);
                rowData.add(data);
                this.secondaryTable.addRow(rowData);
            }
            ps.close();
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                this.closeConnection(maincon, seccon);
                throw throwable;
            }
            this.closeConnection(maincon, seccon);
        }
        this.closeConnection(maincon, seccon);
        this.primaryRecordLabel.setText("\u0417\u0430\u043f\u0438\u0441\u0435\u0439: " + this.primaryTable.getRowCount());
        this.secondaryRecordLabel.setText("\u0417\u0430\u043f\u0438\u0441\u0435\u0439: " + this.secondaryTable.getRowCount());
    }

    private void initTables() {
        int[] w0 = new int[]{70, 70, 70, 70};
        int[] w1 = new int[]{-1, -1, -1, -1};
        int[] w2 = new int[]{0, 0, 0, 0};
        BGTableColumn column = BGTableColumn.getInstance("id", "id", w0, true, null);
        BGTableColumn column2 = BGTableColumn.getInstance("id", "id", w0, true, null);
        column.setEditable(false);
        column2.setEditable(false);
        this.primaryTable.addColumn(column);
        this.secondaryTable.addColumn(column2);
        column = BGTableColumn.getInstance("title", "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", w1, true, null);
        column2 = BGTableColumn.getInstance("title", "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", w1, true, null);
        column.setEditable(false);
        column2.setEditable(false);
        this.primaryTable.addColumn(column);
        this.secondaryTable.addColumn(column2);
        column = BGTableColumn.getInstance("data", "", w2, true, null);
        column2 = BGTableColumn.getInstance("data", "", w2, true, null);
        column.setEditable(false);
        column2.setEditable(false);
        this.primaryTable.addColumn(column);
        this.secondaryTable.addColumn(column2);
        column = BGTableColumn.getInstance("cityid", "", w2, true, null);
        column2 = BGTableColumn.getInstance("cityid", "", w2, true, null);
        column.setEditable(false);
        column2.setEditable(false);
        this.primaryTable.addColumn(column);
        this.secondaryTable.addColumn(column2);
    }

    private void jbInit() {
        JPanel importExportPanel = new JPanel(new GridBagLayout());
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0436\u0438\u043c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 "));
        JPanel mainTablePanel = new JPanel(new GridBagLayout());
        mainTablePanel.setBorder(new BGTitleBorder(" \u0422\u0430\u0431\u043b\u0438\u0446\u0430 A "));
        JPanel secondaryTablePanel = new JPanel(new GridBagLayout());
        secondaryTablePanel.setBorder(new BGTitleBorder(" \u0422\u0430\u0431\u043b\u0438\u0446\u0430 B "));
        buttonsPanel.add((Component)this.addressTable, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        buttonsPanel.add((Component)this.mode, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 1, new Insets(0, 5, 5, 50), 0, 0));
        buttonsPanel.add((Component)this.commit, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        buttonsPanel.add((Component)this.showOnlyAsyncCB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.showOnlyAsyncCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressSynchronizer.this.setData(AddressSynchronizer.this.addressTable.getSelectedCommand());
            }
        });
        mainTablePanel.add((Component)new JScrollPane(this.primaryTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        mainTablePanel.add((Component)this.primaryRecordLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        secondaryTablePanel.add((Component)new JScrollPane(this.secondaryTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        secondaryTablePanel.add((Component)this.secondaryRecordLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)importExportPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)buttonsPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)mainTablePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)secondaryTablePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setDefaultCloseOperation(3);
        this.commit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressSynchronizer.this.synchronize();
            }
        });
    }

    private void synchronize() {
        if (Utils.isBlankString(this.addressTable.getSelectedCommand())) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0436\u0438\u043c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438!");
            return;
        }
        String command = this.mode.getSelectedCommand();
        if ("AtoB".equals(command)) {
            this.synchronize_AtoB();
        } else if ("BtoA".equals(command)) {
            this.synchronize_BtoA();
        } else if ("AB".equals(command)) {
            this.synchronize_AB();
        }
        this.setData(this.addressTable.getSelectedCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronize_AtoB() {
        String command = this.addressTable.getSelectedCommand();
        for (int selectedRow : this.primaryTable.getSelectedRows()) {
            Connection seccon;
            Connection maincon;
            block23: {
                int primaryId = Utils.parseInt(String.valueOf(this.primaryTable.getValueAt(selectedRow, 0)));
                maincon = null;
                seccon = null;
                try {
                    String query = null;
                    ResultSet rs = null;
                    boolean IDisFree = true;
                    PreparedStatement ps = null;
                    maincon = this.getDBConnectionFromMainPool();
                    seccon = this.getDBConnectionFromSecondaryPool();
                    query = "SELECT id FROM address_" + command + " WHERE id=?";
                    ps = seccon.prepareStatement(query);
                    ps.setInt(1, primaryId);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        IDisFree = false;
                    }
                    rs.close();
                    ps.close();
                    if (IDisFree) {
                        if ("country".equals(command)) {
                            this.insertCountryInB(maincon, seccon, primaryId);
                        } else if ("city".equals(command)) {
                            this.insertCityInB(maincon, seccon, primaryId);
                        } else if ("area".equals(command)) {
                            this.insertAreaInB(maincon, seccon, primaryId);
                        } else if ("quarter".equals(command)) {
                            this.insertQuarterInB(maincon, seccon, primaryId);
                        } else if ("street".equals(command)) {
                            this.insertStreetInB(maincon, seccon, primaryId);
                        } else if ("house".equals(command)) {
                            this.insertHouseInB(maincon, seccon, primaryId);
                        }
                        break block23;
                    }
                    if ("country".equals(command)) {
                        this.updateCountryInB(maincon, seccon, primaryId);
                        break block23;
                    }
                    if ("city".equals(command)) {
                        this.updateCityInB(maincon, seccon, primaryId);
                        break block23;
                    }
                    if ("area".equals(command)) {
                        this.updateAreaInB(maincon, seccon, primaryId);
                        break block23;
                    }
                    if ("quarter".equals(command)) {
                        this.updateQuarterInB(maincon, seccon, primaryId);
                        break block23;
                    }
                    if ("street".equals(command)) {
                        this.updateStreetInB(maincon, seccon, primaryId);
                        break block23;
                    }
                    if (!"house".equals(command)) break block23;
                    this.updateHouseInB(maincon, seccon, primaryId);
                }
                catch (Exception ex) {
                    try {
                        ex.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        this.closeConnection(maincon, seccon);
                        throw throwable;
                    }
                    this.closeConnection(maincon, seccon);
                    continue;
                }
            }
            this.closeConnection(maincon, seccon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronize_BtoA() {
        Connection maincon = null;
        Connection seccon = null;
        String command = this.addressTable.getSelectedCommand();
        for (int selectedRow : this.secondaryTable.getSelectedRows()) {
            int primaryId = -1;
            int secondaryId = Utils.parseInt(String.valueOf(this.secondaryTable.getValueAt(selectedRow, 0)));
            String title = String.valueOf(this.secondaryTable.getValueAt(selectedRow, 2));
            try {
                maincon = this.getDBConnectionFromMainPool();
                seccon = this.getDBConnectionFromSecondaryPool();
                if ("country".equals(command)) {
                    String query = "INSERT INTO address_country SET title=?";
                    PreparedStatement ps = maincon.prepareStatement(query, 1);
                    ps.setString(1, title);
                    ps.executeUpdate();
                    primaryId = this.lastInsertId(ps);
                    ps.close();
                    this.exchange("UPDATE address_country SET id=? WHERE id=?", primaryId, secondaryId, 0, seccon);
                } else if ("city".equals(command)) {
                    primaryId = this.updateCityInA(secondaryId, maincon, seccon);
                } else if ("area".equals(command)) {
                    primaryId = this.updateAreaAndQuarter("address_area", secondaryId, maincon, seccon);
                    this.exchange("UPDATE address_house SET areaid=? WHERE areaid=?", primaryId, secondaryId, -2, seccon);
                } else if ("quarter".equals(command)) {
                    primaryId = this.updateAreaAndQuarter("address_quarter", secondaryId, maincon, seccon);
                    this.exchange("UPDATE address_house SET quarterid=? WHERE quarterid=?", primaryId, secondaryId, -2, seccon);
                } else if ("street".equals(command)) {
                    primaryId = this.updateStreet(secondaryId, maincon, seccon);
                } else if ("house".equals(command)) {
                    primaryId = this.updateHouse(secondaryId, maincon, seccon);
                }
                this.updateSecondaryTable(primaryId, secondaryId);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    this.closeConnection(maincon, seccon);
                    throw throwable;
                }
                this.closeConnection(maincon, seccon);
                continue;
            }
            this.closeConnection(maincon, seccon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronize_AB() {
        Connection seccon;
        Connection maincon;
        block12: {
            int sSelectRow;
            maincon = null;
            seccon = null;
            String command = this.addressTable.getSelectedCommand();
            int primaryId = 0;
            int secondaryId = 0;
            int pSelectRow = this.primaryTable.getSelectedRowCount();
            if (pSelectRow != (sSelectRow = this.secondaryTable.getSelectedRowCount()) || pSelectRow != 0) {
                if (pSelectRow == sSelectRow && pSelectRow == 1) {
                    primaryId = Utils.parseInt(String.valueOf(this.primaryTable.getValueAt(this.primaryTable.getSelectedRow(), 0)));
                    secondaryId = Utils.parseInt(String.valueOf(this.secondaryTable.getValueAt(this.secondaryTable.getSelectedRow(), 0)));
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e \u043e\u0434\u043d\u043e\u0439(\u0438\u043b\u0438 \u043d\u0438 \u043e\u0434\u043d\u043e\u0439) \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 A \u0438 B");
                    return;
                }
            }
            try {
                maincon = this.getDBConnectionFromMainPool();
                seccon = this.getDBConnectionFromSecondaryPool();
                if ("country".equals(command)) {
                    this.updateCountryInB(maincon, seccon, primaryId, secondaryId);
                    break block12;
                }
                if ("city".equals(command)) {
                    this.updateCityInB(maincon, seccon, primaryId, secondaryId);
                    break block12;
                }
                if ("area".equals(command)) {
                    this.updateAreaInB(maincon, seccon, primaryId, secondaryId);
                    break block12;
                }
                if ("quarter".equals(command)) {
                    this.updateQuarterInB(maincon, seccon, primaryId, secondaryId);
                    break block12;
                }
                if ("street".equals(command)) {
                    this.updateStreetInB(maincon, seccon, primaryId, secondaryId);
                    break block12;
                }
                if (!"house".equals(command)) break block12;
                this.updateHouseInB(maincon, seccon, primaryId, secondaryId);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    this.closeConnection(maincon, seccon);
                    throw throwable;
                }
                this.closeConnection(maincon, seccon);
            }
        }
        this.closeConnection(maincon, seccon);
    }

    private int lastInsertId(PreparedStatement ps) throws SQLException {
        int id = -1;
        ResultSet rs = ps.getGeneratedKeys();
        if (rs.last()) {
            id = rs.getInt(1);
        }
        return id;
    }

    private void exchange(String query, int primaryID, int secondaryID, int a, Connection con) throws Exception {
        PreparedStatement ps = null;
        ps = con.prepareStatement(query);
        ps.setInt(1, a);
        ps.setInt(2, secondaryID);
        ps.executeUpdate();
        ps.close();
        ps = con.prepareStatement(query);
        ps.setInt(1, secondaryID);
        ps.setInt(2, primaryID);
        ps.executeUpdate();
        ps.close();
        ps = con.prepareStatement(query);
        ps.setInt(1, primaryID);
        ps.setInt(2, a);
        ps.executeUpdate();
        ps.close();
    }

    private void updateConfig(Connection con, String tableName, int primaryId, String key, String value) throws SQLException {
        if (value != null && !value.isEmpty()) {
            PreparedStatement ps = con.prepareStatement("INSERT INTO address_config SET table_id=?, record_id=?, `key`=?, `value`=?");
            ps.setString(1, tableName);
            ps.setInt(2, primaryId);
            ps.setString(3, key);
            ps.setString(4, value);
            ps.executeUpdate();
            ps.close();
        }
    }

    private void init() {
        try {
            this.setup = new Preferences(this.getClass().getResource("data.properties"));
            this.mainConnectionPool = this.initConnectionPool("main");
            this.secondaryConnectionPool = this.initConnectionPool("secondary");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Connection getDBConnectionFromSecondaryPool() {
        Connection con = null;
        if (this.secondaryConnectionPool != null) {
            try {
                con = (Connection)this.secondaryConnectionPool.borrowObject();
                con.setAutoCommit(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return con;
    }

    private GenericObjectPool<Object> initConnectionPool(String prefix) throws Exception {
        String dbDriver = this.setup.get("db.driver", null);
        String dbURL = this.setup.get("db." + prefix + ".url", null);
        String dbUser = this.setup.get("db." + prefix + ".user", null);
        String dbPswd = this.setup.get("db." + prefix + ".pswd", null);
        int maxIdle = 20;
        int maxActive = 20;
        Class.forName(dbDriver).getConstructor(new Class[0]).newInstance(new Object[0]);
        GenericObjectPool connectionPool = new GenericObjectPool(null);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, dbUser, dbPswd);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, "SELECT 1", false, true);
        connectionPool.setMaxIdle(maxIdle);
        connectionPool.setMaxActive(maxActive);
        connectionPool.setTestOnBorrow(true);
        connectionPool.setTestOnReturn(true);
        return connectionPool;
    }

    private Connection getDBConnectionFromMainPool() {
        Connection con = null;
        if (this.mainConnectionPool != null) {
            try {
                con = (Connection)this.mainConnectionPool.borrowObject();
                con.setAutoCommit(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return con;
    }

    private void updateSecondaryTable(int primaryId, int secondaryId) {
        if (primaryId != secondaryId) {
            for (int row : this.secondaryTable.getSelectedRows()) {
                int id = Utils.parseInt(String.valueOf(this.secondaryTable.getValueAt(row, 0)));
                if (id == primaryId) {
                    this.secondaryTable.setValueAt(String.valueOf(secondaryId), row, 0);
                    continue;
                }
                if (id != secondaryId) continue;
                this.secondaryTable.setValueAt(String.valueOf(primaryId), row, 0);
            }
        }
    }

    private void closeConnection(Connection ... con) {
        for (Connection c : con) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void insertCountryInB(Connection maincon, Connection seccon, int id) throws SQLException {
        String title = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT title FROM ");
        query.append("address_country");
        query.append(" WHERE id=?");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            title = rs.getString(1);
        }
        rs.close();
        ps.close();
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append("address_country");
        query.append(" SET id=?, title=?");
        ps = seccon.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setString(2, title);
        ps.executeUpdate();
        ps.close();
    }

    private void updateCountryInB(Connection maincon, Connection seccon, int id) throws Exception {
        String title = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT title FROM ");
        query.append("address_country");
        query.append(" WHERE id=?");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            title = rs.getString(1);
        }
        rs.close();
        ps.close();
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append("address_country");
        query.append(" SET title=?");
        ps = seccon.prepareStatement(query.toString(), 1);
        ps.setString(1, title);
        ps.executeUpdate();
        int newId = this.lastInsertId(ps);
        ps.close();
        this.exchange("UPDATE address_country SET id=? WHERE id=?", id, newId, 0, seccon);
        this.exchange("UPDATE address_city SET country_id=? WHERE country_id=?", id, newId, -1, seccon);
    }

    private void updateCountryInB(Connection maincon, Connection seccon, int primaryId, int secondaryId) throws Exception {
        String title = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT title FROM ");
        query.append("address_country");
        query.append(" WHERE id=?");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setInt(1, primaryId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            title = rs.getString(1);
        }
        rs.close();
        ps.close();
        query = new StringBuilder();
        query.append("UPDATE ");
        query.append("address_country");
        query.append(" SET title=? WHERE id=?");
        ps = seccon.prepareStatement(query.toString());
        ps.setString(1, title);
        ps.setInt(2, secondaryId);
        ps.executeUpdate();
        ps.close();
        if (primaryId != secondaryId) {
            this.exchange("UPDATE address_country SET id=? WHERE id=?", primaryId, secondaryId, 0, seccon);
            this.exchange("UPDATE address_city SET country_id=? WHERE country_id=?", primaryId, secondaryId, -1, seccon);
        }
    }

    private void insertCityInB(Connection maincon, Connection seccon, int id) throws Exception {
        int countryId = -1;
        String title = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT country_id, title FROM ");
        query.append("address_city");
        query.append(" WHERE id=?");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            countryId = rs.getInt(1);
            title = rs.getString(2);
        }
        rs.close();
        ps.close();
        if (countryId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 A \u0441 id=" + id);
        }
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append("address_city");
        query.append(" SET id=?, country_id=?, title=?");
        ps = seccon.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, countryId);
        ps.setString(3, title);
        ps.executeUpdate();
        ps.close();
    }

    private void updateCityInB(Connection maincon, Connection seccon, int id) throws Exception {
        int countryId = -1;
        String title = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT country_id, title FROM ");
        query.append("address_city");
        query.append(" WHERE id=?");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            countryId = rs.getInt(1);
            title = rs.getString(2);
        }
        rs.close();
        ps.close();
        if (countryId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 A \u0441 id=" + id);
        }
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append("address_city");
        query.append(" SET country_id=?, title=?");
        ps = seccon.prepareStatement(query.toString(), 1);
        ps.setInt(1, countryId);
        ps.setString(2, title);
        ps.executeUpdate();
        int newId = this.lastInsertId(ps);
        ps.close();
        this.exchange("UPDATE address_city SET id=? WHERE id=?", id, newId, 0, seccon);
        this.exchange("UPDATE address_area SET cityid=? WHERE cityid=?", id, newId, -1, seccon);
        this.exchange("UPDATE address_quarter SET cityid=? WHERE cityid=?", id, newId, -1, seccon);
        this.exchange("UPDATE address_street SET cityid=? WHERE cityid=?", id, newId, -1, seccon);
        this.exchange("UPDATE address_house SET cityid=? WHERE cityid=?", id, newId, 0, seccon);
    }

    private void updateCityInB(Connection maincon, Connection seccon, int primaryId, int secondaryId) throws Exception {
        int countryId = -1;
        String title = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT country_id, title FROM ");
        query.append("address_city");
        query.append(" WHERE id=?");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setInt(1, primaryId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            countryId = rs.getInt(1);
            title = rs.getString(2);
        }
        rs.close();
        ps.close();
        if (countryId > 0) {
            query = new StringBuilder();
            query.append("UPDATE ");
            query.append("address_city");
            query.append(" SET country_id=?, title=? WHERE id=?");
            ps = seccon.prepareStatement(query.toString());
            ps.setInt(1, countryId);
            ps.setString(2, title);
            ps.setInt(3, secondaryId);
            ps.executeUpdate();
            ps.close();
            if (primaryId != secondaryId) {
                this.exchange("UPDATE address_city SET id=? WHERE id=?", primaryId, secondaryId, 0, seccon);
                this.exchange("UPDATE address_area SET cityid=? WHERE cityid=?", primaryId, secondaryId, -1, seccon);
                this.exchange("UPDATE address_quarter SET cityid=? WHERE cityid=?", primaryId, secondaryId, -1, seccon);
                this.exchange("UPDATE address_street SET cityid=? WHERE cityid=?", primaryId, secondaryId, -1, seccon);
                this.exchange("UPDATE address_house SET cityid=? WHERE cityid=?", primaryId, secondaryId, 0, seccon);
            }
        } else {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 A \u0441 id=" + primaryId);
        }
    }

    private void insertAreaInB(Connection maincon, Connection seccon, int id) throws Exception {
        this.insertAreaOrQuarterInB(maincon, seccon, id, "address_area");
    }

    private void updateAreaInB(Connection maincon, Connection seccon, int id) throws Exception {
        int newId = this.updateAreaOrQuarterInB(maincon, seccon, "address_area", id);
        this.exchange("UPDATE address_house SET areaid=? WHERE areaid=?", id, newId, -2, seccon);
    }

    private void updateAreaInB(Connection maincon, Connection seccon, int primaryId, int secondaryId) throws Exception {
        Map<Integer, Map<String, Integer>> crmMap = this.getCrmMap(maincon, "address_area");
        if (primaryId == 0 && secondaryId == 0) {
            for (Map.Entry<Integer, Map<String, Integer>> recordMap : crmMap.entrySet()) {
                for (Map.Entry<String, Integer> record : recordMap.getValue().entrySet()) {
                    int[] pair = this.getPair(record, seccon, "address_area", recordMap.getKey());
                    if (pair == null) continue;
                    this.updateAreaOrQuarterInB(maincon, seccon, "address_area", pair[0], pair[1]);
                    if (pair[0] == pair[1]) continue;
                    this.exchange("UPDATE address_house SET areaid=? WHERE areaid=?", pair[0], pair[1], -2, seccon);
                }
            }
        } else {
            this.updateAreaOrQuarterInB(maincon, seccon, "address_area", primaryId, secondaryId);
            if (primaryId != secondaryId) {
                this.exchange("UPDATE address_house SET areaid=? WHERE areaid=?", primaryId, secondaryId, -2, seccon);
            }
        }
    }

    private void insertQuarterInB(Connection maincon, Connection seccon, int id) throws Exception {
        this.insertAreaOrQuarterInB(maincon, seccon, id, "address_quarter");
    }

    private void updateQuarterInB(Connection maincon, Connection seccon, int id) throws Exception {
        int newId = this.updateAreaOrQuarterInB(maincon, seccon, "address_quarter", id);
        this.exchange("UPDATE address_house SET quarterid=? WHERE quarterid=?", id, newId, -2, seccon);
    }

    private void updateQuarterInB(Connection maincon, Connection seccon, int primaryId, int secondaryId) throws Exception {
        Map<Integer, Map<String, Integer>> crmMap = this.getCrmMap(maincon, "address_quarter");
        if (primaryId == 0 && secondaryId == 0) {
            for (Map.Entry<Integer, Map<String, Integer>> recordMap : crmMap.entrySet()) {
                for (Map.Entry<String, Integer> record : recordMap.getValue().entrySet()) {
                    int[] pair = this.getPair(record, seccon, "address_quarter", recordMap.getKey());
                    if (pair == null) continue;
                    this.updateAreaOrQuarterInB(maincon, seccon, "address_quarter", pair[0], pair[1]);
                    if (pair[0] == pair[1]) continue;
                    this.exchange("UPDATE address_house SET quarterid=? WHERE quarterid=?", pair[0], pair[1], -2, seccon);
                }
            }
        } else {
            this.updateAreaOrQuarterInB(maincon, seccon, "address_quarter", primaryId, secondaryId);
            if (primaryId != secondaryId) {
                this.exchange("UPDATE address_house SET quarterid=? WHERE quarterid=?", primaryId, secondaryId, -2, seccon);
            }
        }
    }

    private Map<Integer, Map<String, Integer>> getCrmMap(Connection maincon, String tableName) throws SQLException {
        HashMap<Integer, Map<String, Integer>> crmMap = new HashMap<Integer, Map<String, Integer>>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT id, cityid, title FROM ");
        query.append(tableName);
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            HashMap<String, Integer> map = (HashMap<String, Integer>)crmMap.get(rs.getInt(2));
            if (map == null) {
                map = new HashMap<String, Integer>();
                crmMap.put(rs.getInt(2), map);
            }
            map.put(rs.getString(3), rs.getInt(1));
        }
        rs.close();
        ps.close();
        return crmMap;
    }

    private int[] getPair(Map.Entry<String, Integer> record, Connection seccon, String tableName, int cityId) throws SQLException {
        int[] pair = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT id FROM ");
        query.append(tableName);
        query.append(" WHERE title=? AND cityid=?");
        PreparedStatement ps = seccon.prepareStatement(query.toString());
        ps.setString(1, record.getKey());
        ps.setInt(2, cityId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int idP;
            int idS = rs.getInt(1);
            Integer val = record.getValue();
            if (val == null || (idP = val.intValue()) == idS) continue;
            pair = new int[]{idP, idS};
        }
        rs.close();
        ps.close();
        return pair;
    }

    private void insertAreaOrQuarterInB(Connection maincon, Connection seccon, int id, String tableName) throws Exception {
        int cityId = -1;
        String title = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT cityid, title FROM ");
        query.append(tableName);
        query.append(" WHERE id=?");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            cityId = rs.getInt(1);
            title = rs.getString(2);
        }
        rs.close();
        ps.close();
        if (cityId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 A \u0441 id=" + id);
        }
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append(tableName);
        query.append(" SET id=?, cityid=?, title=?");
        ps = seccon.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, cityId);
        ps.setString(3, title);
        ps.executeUpdate();
        ps.close();
    }

    private int updateAreaOrQuarterInB(Connection maincon, Connection seccon, String tableName, int id) throws Exception {
        int cityId = -1;
        String title = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT cityid, title FROM ");
        query.append(tableName);
        query.append(" WHERE id=?");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            cityId = rs.getInt(1);
            title = rs.getString(2);
        }
        rs.close();
        ps.close();
        int newId = -1;
        if (cityId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 A \u0441 id=" + id);
        }
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append(tableName);
        query.append(" SET cityid=?, title=?");
        ps = seccon.prepareStatement(query.toString(), 1);
        ps.setInt(1, cityId);
        ps.setString(2, title);
        ps.executeUpdate();
        newId = this.lastInsertId(ps);
        ps.close();
        this.exchange("UPDATE " + tableName + " SET id=? WHERE id=?", id, newId, 0, seccon);
        return newId;
    }

    private void updateAreaOrQuarterInB(Connection maincon, Connection seccon, String tableName, int primaryId, int secondaryId) throws Exception {
        int cityId = -1;
        String title = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT cityid, title FROM ");
        query.append(tableName);
        query.append(" WHERE id=?");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setInt(1, primaryId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            cityId = rs.getInt(1);
            title = rs.getString(2);
        }
        rs.close();
        ps.close();
        if (cityId > 0) {
            query = new StringBuilder();
            query.append("UPDATE ");
            query.append(tableName);
            query.append(" SET cityid=?, title=? WHERE id=?");
            ps = seccon.prepareStatement(query.toString());
            ps.setInt(1, cityId);
            ps.setString(2, title);
            ps.setInt(3, secondaryId);
            ps.executeUpdate();
            ps.close();
            if (primaryId != secondaryId) {
                this.exchange("UPDATE " + tableName + " SET id=? WHERE id=?", primaryId, secondaryId, 0, seccon);
            }
        } else {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 A \u0441 id=" + primaryId);
        }
    }

    private void insertStreetInB(Connection maincon, Connection seccon, int id) throws Exception {
        int cityId = -1;
        String title = null;
        String boxIndex = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT cityid, title, value FROM ");
        query.append("address_street");
        query.append(" AS street LEFT JOIN ");
        query.append("address_config");
        query.append(" AS config ON ( config.record_id=street.id AND config.table_id=? AND config.key=? )");
        query.append(" WHERE street.id=? ");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setString(1, "address_street");
        ps.setString(2, "s.box.index");
        ps.setInt(3, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            cityId = rs.getInt(1);
            title = rs.getString(2);
            boxIndex = rs.getString(3);
        }
        rs.close();
        ps.close();
        if (cityId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 A \u0441 id=" + id);
        }
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append("address_street");
        query.append(" SET id=?, cityid=?, title=?, p_index=?");
        ps = seccon.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.setInt(2, cityId);
        ps.setString(3, title);
        ps.setString(4, Utils.maskNull(boxIndex));
        ps.executeUpdate();
        ps.close();
    }

    private void updateStreetInB(Connection maincon, Connection seccon, int id) throws Exception {
        int cityId = -1;
        String title = null;
        String boxIndex = null;
        StringBuilder query = new StringBuilder();
        query.append("SELECT cityid, title, value FROM ");
        query.append("address_street");
        query.append(" AS street LEFT JOIN ");
        query.append("address_config");
        query.append(" AS config ON ( config.record_id=street.id AND config.table_id=? AND config.key=? )");
        query.append(" WHERE street.id=?");
        PreparedStatement ps = maincon.prepareStatement(query.toString());
        ps.setString(1, "address_street");
        ps.setString(2, "s.box.index");
        ps.setInt(3, id);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            cityId = rs.getInt(1);
            title = rs.getString(2);
            boxIndex = rs.getString(3);
        }
        rs.close();
        ps.close();
        if (cityId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 A \u0441 id=" + id);
        }
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append("address_street");
        query.append(" SET cityid=?, title=?, p_index=?");
        ps = seccon.prepareStatement(query.toString(), 1);
        ps.setInt(1, cityId);
        ps.setString(2, title);
        ps.setString(3, boxIndex == null ? "" : boxIndex);
        ps.executeUpdate();
        int newId = this.lastInsertId(ps);
        ps.close();
        this.exchange("UPDATE address_street SET id=? WHERE id=?", id, newId, 0, seccon);
        this.exchange("UPDATE address_house SET streetid=? WHERE streetid=?", id, newId, 0, seccon);
    }

    private void updateStreetInB(Connection maincon, Connection seccon, int primaryId, int secondaryId) throws Exception {
        StringBuilder query = new StringBuilder();
        query.append("SELECT id, cityid, title FROM ");
        query.append("address_street");
        if (primaryId > 0) {
            query.append(" WHERE id=");
            query.append(primaryId);
        }
        PreparedStatement psSelectStreet = maincon.prepareStatement(query.toString());
        ResultSet rsStreet = psSelectStreet.executeQuery();
        while (rsStreet.next()) {
            if (secondaryId == 0) {
                primaryId = rsStreet.getInt("id");
                query = new StringBuilder();
                query.append("SELECT id FROM ");
                query.append("address_street");
                query.append(" WHERE cityid=? AND title=?");
                PreparedStatement psSelect = seccon.prepareStatement(query.toString());
                psSelect.setInt(1, rsStreet.getInt("cityid"));
                psSelect.setString(2, rsStreet.getString("title"));
                ResultSet rs = psSelect.executeQuery();
                while (rs.next()) {
                    secondaryId = rs.getInt(1);
                }
                rs.close();
                psSelect.close();
            }
            if (secondaryId <= 0) continue;
            int cityId = -1;
            String title = null;
            String boxIndex = null;
            query = new StringBuilder();
            query.append("SELECT cityid, title, value FROM ");
            query.append("address_street");
            query.append(" AS street LEFT JOIN ");
            query.append("address_config");
            query.append(" AS config ON ( config.record_id=street.id  AND config.table_id=? AND config.key=? )");
            query.append(" WHERE street.id=?");
            PreparedStatement ps = maincon.prepareStatement(query.toString());
            ps.setString(1, "address_street");
            ps.setString(2, "s.box.index");
            ps.setInt(3, primaryId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                cityId = rs.getInt(1);
                title = rs.getString(2);
                boxIndex = rs.getString(3);
            }
            rs.close();
            ps.close();
            if (cityId > 0) {
                query = new StringBuilder();
                query.append("UPDATE ");
                query.append("address_street");
                query.append(" SET cityid=?, title=?, p_index=? WHERE id=?");
                ps = seccon.prepareStatement(query.toString());
                ps.setInt(1, cityId);
                ps.setString(2, title);
                ps.setString(3, boxIndex);
                ps.setInt(4, secondaryId);
                ps.executeUpdate();
                ps.close();
                if (primaryId != secondaryId) {
                    this.exchange("UPDATE address_street SET id=? WHERE id=?", primaryId, secondaryId, 0, seccon);
                    this.exchange("UPDATE address_house SET streetid=? WHERE streetid=?", primaryId, secondaryId, 0, seccon);
                }
            } else {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 A \u0441 id=" + primaryId);
            }
            secondaryId = 0;
        }
    }

    private void insertHouseInB(Connection maincon, Connection seccon, int id) throws Exception {
        int cityId = 0;
        int quarterId = 0;
        int streetId = 0;
        int areaId = 0;
        int house = 0;
        int amount = 0;
        String frac = "";
        String pod_diapazon = "";
        String comment = "";
        String box_index = "";
        java.util.Date dt = null;
        int index = 1;
        ResultSet rs = null;
        PreparedStatement ps = null;
        StringBuilder query = new StringBuilder();
        String dbaseName = this.setup.get("db.secondary.title", "");
        query.append("SELECT house.*, cnf1.value AS dt, cnf2.value AS box_index,");
        query.append(" cnf3.value AS amount, cnf4.value AS pod_diapazon, street.cityid AS cityid FROM ");
        query.append("address_house");
        query.append(" AS house LEFT JOIN ");
        query.append("address_config");
        query.append(" AS cnf1 ON (cnf1.table_id=? AND cnf1.record_id=house.id AND cnf1.key=?) LEFT JOIN ");
        query.append("address_config");
        query.append(" AS cnf2 ON (cnf2.table_id=? AND cnf2.record_id=house.id AND cnf2.key=?) LEFT JOIN ");
        query.append("address_config");
        query.append(" AS cnf3 ON (cnf3.table_id=? AND cnf3.record_id=house.id AND cnf3.key=?) LEFT JOIN ");
        query.append("address_config");
        query.append(" AS cnf4 ON (cnf4.table_id=? AND cnf4.record_id=house.id AND cnf4.key=?) LEFT JOIN ");
        query.append("address_street");
        query.append(" AS street ON (house.streetid=street.id) WHERE house.id=?");
        ps = maincon.prepareStatement(query.toString());
        ps.setString(index++, "address_house");
        ps.setString(index++, "d.date." + dbaseName.toLowerCase());
        ps.setString(index++, "address_house");
        ps.setString(index++, "s.box.index");
        ps.setString(index++, "address_house");
        ps.setString(index++, ".i.flat.amount");
        ps.setString(index++, "address_house");
        ps.setString(index++, ".s.pod.range");
        ps.setInt(index++, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            cityId = rs.getInt("cityid");
            quarterId = rs.getInt("quarterid");
            streetId = rs.getInt("streetid");
            areaId = rs.getInt("areaid");
            house = rs.getInt("house");
            amount = rs.getInt("amount");
            frac = rs.getString("frac");
            pod_diapazon = rs.getString("pod_diapazon");
            comment = rs.getString("comment");
            box_index = rs.getString("box_index");
            String dtS = rs.getString("dt");
            dt = null;
            if (dtS == null) continue;
            dt = TimeUtils.parseDate(dtS, "dd.MM.yyyy");
        }
        rs.close();
        ps.close();
        if (cityId <= 0 && streetId <= 0 && areaId <= 0 && quarterId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c ID \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u043e\u0439 \u0431\u0430\u0437\u044b.");
        }
        index = 1;
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append("address_house");
        query.append(" SET id=?, cityid=?, quarterid=?, streetid=?, areaid=?, house=?, amount=?, frac=?,");
        query.append(" pod_diapazon=?, comment=?, box_index=?, dt=?");
        ps = seccon.prepareStatement(query.toString());
        ps.setInt(index++, id);
        ps.setInt(index++, cityId);
        ps.setInt(index++, quarterId);
        ps.setInt(index++, streetId);
        ps.setInt(index++, areaId);
        ps.setInt(index++, house);
        ps.setInt(index++, amount);
        ps.setString(index++, Utils.maskNull(frac));
        ps.setString(index++, Utils.maskNull(pod_diapazon));
        ps.setString(index++, comment);
        ps.setString(index++, box_index);
        ps.setDate(index++, TimeUtils.convertDateToSqlDate(dt));
        ps.executeUpdate();
        ps.close();
    }

    private void updateHouseInB(Connection maincon, Connection seccon, int id) throws Exception {
        int cityId = 0;
        int quarterId = 0;
        int streetId = 0;
        int areaId = 0;
        int house = 0;
        int amount = 0;
        String frac = "";
        String pod_diapazon = "";
        String comment = "";
        String box_index = "";
        java.util.Date dt = null;
        int index = 1;
        ResultSet rs = null;
        PreparedStatement ps = null;
        StringBuilder query = new StringBuilder();
        String dbaseName = this.setup.get("db.secondary.title", "");
        query.append("SELECT house.*, cnf1.value AS dt, cnf2.value AS box_index,");
        query.append(" cnf3.value AS amount, cnf4.value AS pod_diapazon, street.cityid AS cityid FROM ");
        query.append("address_house");
        query.append(" AS house LEFT JOIN ");
        query.append("address_config");
        query.append(" AS cnf1 ON (cnf1.table_id=? AND cnf1.record_id=house.id AND cnf1.key=?) LEFT JOIN ");
        query.append("address_config");
        query.append(" AS cnf2 ON (cnf2.table_id=? AND cnf2.record_id=house.id AND cnf2.key=?) LEFT JOIN ");
        query.append("address_config");
        query.append(" AS cnf3 ON (cnf3.table_id=? AND cnf3.record_id=house.id AND cnf3.key=?) LEFT JOIN ");
        query.append("address_config");
        query.append(" AS cnf4 ON (cnf4.table_id=? AND cnf4.record_id=house.id AND cnf4.key=?) LEFT JOIN ");
        query.append("address_street");
        query.append(" AS street ON (house.streetid=street.id) WHERE house.id=?");
        ps = maincon.prepareStatement(query.toString());
        ps.setString(index++, "address_house");
        ps.setString(index++, "d.date." + dbaseName.toLowerCase());
        ps.setString(index++, "address_house");
        ps.setString(index++, "s.box.index");
        ps.setString(index++, "address_house");
        ps.setString(index++, ".i.flat.amount");
        ps.setString(index++, "address_house");
        ps.setString(index++, ".s.pod.range");
        ps.setInt(index++, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            cityId = rs.getInt("cityid");
            quarterId = rs.getInt("quarterid");
            streetId = rs.getInt("streetid");
            areaId = rs.getInt("areaid");
            house = rs.getInt("house");
            amount = rs.getInt("amount");
            frac = rs.getString("frac");
            pod_diapazon = rs.getString("pod_diapazon");
            comment = rs.getString("comment");
            box_index = rs.getString("box_index");
            String dtS = rs.getString("dt");
            dt = null;
            if (dtS == null) continue;
            dt = TimeUtils.parseDate(dtS, "dd.MM.yyyy");
        }
        rs.close();
        ps.close();
        if (cityId <= 0 && streetId <= 0 && areaId <= 0 && quarterId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c ID \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u043e\u0439 \u0431\u0430\u0437\u044b.");
        }
        index = 1;
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append("address_house");
        query.append(" SET cityid=?, quarterid=?, streetid=?, areaid=?, house=?, amount=?, frac=?,");
        query.append(" pod_diapazon=?, comment=?, box_index=?, dt=?");
        ps = seccon.prepareStatement(query.toString(), 1);
        ps.setInt(index++, cityId);
        ps.setInt(index++, quarterId);
        ps.setInt(index++, streetId);
        ps.setInt(index++, areaId);
        ps.setInt(index++, house);
        ps.setInt(index++, amount);
        ps.setString(index++, frac);
        ps.setString(index++, Utils.maskNull(pod_diapazon));
        ps.setString(index++, comment);
        ps.setString(index++, box_index);
        ps.setDate(index++, TimeUtils.convertDateToSqlDate(dt));
        ps.executeUpdate();
        int newId = this.lastInsertId(ps);
        ps.close();
        this.exchange("UPDATE address_house SET id=? WHERE id=?", id, newId, 0, seccon);
        this.exchange("UPDATE contract_parameter_type_2 SET hid=? WHERE hid=?", id, newId, -1, seccon);
        this.exchange("UPDATE object_param_value_address SET hid=? WHERE hid=?", id, newId, -1, seccon);
    }

    private void updateHouseInB(Connection maincon, Connection seccon, int primaryId, int secondaryId) throws Exception {
        StringBuilder query = new StringBuilder();
        query.append("SELECT id, areaid, quarterid, streetid, house, frac FROM ");
        query.append("address_house");
        if (primaryId > 0) {
            query.append(" WHERE id=");
            query.append(primaryId);
        }
        PreparedStatement psSelectStreet = maincon.prepareStatement(query.toString());
        ResultSet rsHouse = psSelectStreet.executeQuery();
        while (rsHouse.next()) {
            if (secondaryId == 0) {
                int index = 1;
                primaryId = rsHouse.getInt("id");
                query = new StringBuilder();
                query.append("SELECT id FROM ");
                query.append("address_house");
                query.append(" WHERE ");
                query.append("streetid=? AND house=? AND frac=?");
                PreparedStatement psSelect = seccon.prepareStatement(query.toString());
                psSelect.setInt(index++, rsHouse.getInt("streetid"));
                psSelect.setInt(index++, rsHouse.getInt("house"));
                psSelect.setString(index++, rsHouse.getString("frac"));
                ResultSet rs = psSelect.executeQuery();
                while (rs.next()) {
                    secondaryId = rs.getInt(1);
                }
                rs.close();
                psSelect.close();
            }
            if (secondaryId <= 0) continue;
            int cityId = 0;
            int quarterId = 0;
            int streetId = 0;
            int areaId = 0;
            int house = 0;
            int amount = 0;
            String frac = "";
            String pod_diapazon = "";
            String comment = "";
            String box_index = "";
            java.util.Date dt = null;
            int index = 1;
            ResultSet rs = null;
            PreparedStatement ps = null;
            query = new StringBuilder();
            String dbaseName = this.setup.get("db.secondary.title", "");
            query.append("SELECT house.*, cnf1.value AS dt, cnf2.value AS box_index,");
            query.append(" cnf3.value AS amount, cnf4.value AS pod_diapazon, street.cityid AS cityid FROM ");
            query.append("address_house");
            query.append(" AS house LEFT JOIN ");
            query.append("address_config");
            query.append(" AS cnf1 ON (cnf1.table_id=? AND cnf1.record_id=house.id AND cnf1.key=?) LEFT JOIN ");
            query.append("address_config");
            query.append(" AS cnf2 ON (cnf2.table_id=? AND cnf2.record_id=house.id AND cnf2.key=?) LEFT JOIN ");
            query.append("address_config");
            query.append(" AS cnf3 ON (cnf3.table_id=? AND cnf3.record_id=house.id AND cnf3.key=?) LEFT JOIN ");
            query.append("address_config");
            query.append(" AS cnf4 ON (cnf4.table_id=? AND cnf4.record_id=house.id AND cnf4.key=?) LEFT JOIN ");
            query.append("address_street");
            query.append(" AS street ON (house.streetid=street.id) WHERE house.id=?");
            ps = maincon.prepareStatement(query.toString());
            ps.setString(index++, "address_house");
            ps.setString(index++, "d.date." + dbaseName.toLowerCase());
            ps.setString(index++, "address_house");
            ps.setString(index++, "s.box.index");
            ps.setString(index++, "address_house");
            ps.setString(index++, ".i.flat.amount");
            ps.setString(index++, "address_house");
            ps.setString(index++, ".s.pod.range");
            ps.setInt(index++, primaryId);
            rs = ps.executeQuery();
            while (rs.next()) {
                cityId = rs.getInt("cityid");
                quarterId = rs.getInt("quarterid");
                streetId = rs.getInt("streetid");
                areaId = rs.getInt("areaid");
                house = rs.getInt("house");
                amount = rs.getInt("amount");
                frac = rs.getString("frac");
                pod_diapazon = rs.getString("pod_diapazon");
                comment = rs.getString("comment");
                box_index = rs.getString("box_index");
                String dtS = rs.getString("dt");
                dt = null;
                if (dtS == null) continue;
                dt = TimeUtils.parseDate(dtS, "dd.MM.yyyy");
            }
            rs.close();
            ps.close();
            if (cityId > 0 || streetId > 0 || areaId > 0 || quarterId > 0) {
                index = 1;
                query = new StringBuilder();
                query.append("UPDATE ");
                query.append("address_house");
                query.append(" SET cityid=?, quarterid=?, streetid=?, areaid=?, house=?, amount=?, frac=?,");
                query.append(" pod_diapazon=?, comment=?, box_index=?, dt=? WHERE id=?");
                ps = seccon.prepareStatement(query.toString());
                ps.setInt(index++, cityId);
                ps.setInt(index++, quarterId);
                ps.setInt(index++, streetId);
                ps.setInt(index++, areaId);
                ps.setInt(index++, house);
                ps.setInt(index++, amount);
                ps.setString(index++, frac);
                ps.setString(index++, Utils.maskNull(pod_diapazon));
                ps.setString(index++, comment);
                ps.setString(index++, box_index);
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(dt));
                ps.setInt(index++, secondaryId);
                ps.executeUpdate();
                ps.close();
                if (primaryId != secondaryId) {
                    this.exchange("UPDATE address_house SET id=? WHERE id=?", primaryId, secondaryId, 0, seccon);
                    try {
                        this.exchange("UPDATE contract_parameter_type_2 SET hid=? WHERE hid=?", primaryId, secondaryId, -1, seccon);
                    }
                    catch (Exception e) {
                        System.err.println(e.getLocalizedMessage());
                    }
                    try {
                        this.exchange("UPDATE object_param_value_address SET hid=? WHERE hid=?", primaryId, secondaryId, -1, seccon);
                    }
                    catch (Exception e) {
                        System.err.println(e.getLocalizedMessage());
                    }
                }
            } else {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c ID \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u043e\u0439 \u0431\u0430\u0437\u044b.");
            }
            secondaryId = 0;
        }
    }

    private int updateCityInA(int secondaryId, Connection maincon, Connection seccon) throws Exception {
        int countryId = -1;
        String title = "";
        String query = "SELECT country_id, title FROM address_city WHERE id=?";
        PreparedStatement ps = seccon.prepareStatement(query);
        ps.setInt(1, secondaryId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            countryId = rs.getInt(1);
            title = rs.getString(2);
        }
        rs.close();
        ps.close();
        int primaryId = -1;
        if (countryId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c ID \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u043e\u0439 \u0431\u0430\u0437\u044b.");
        }
        query = "INSERT INTO address_city SET country_id=?, title=?";
        ps = maincon.prepareStatement(query, 1);
        ps.setInt(1, countryId);
        ps.setString(2, title);
        ps.executeUpdate();
        primaryId = this.lastInsertId(ps);
        ps.close();
        this.exchange("UPDATE address_city SET id=? WHERE id=?", primaryId, secondaryId, 0, seccon);
        this.exchange("UPDATE address_area SET cityid=? WHERE cityid=?", primaryId, secondaryId, 0, seccon);
        this.exchange("UPDATE address_street SET cityid=? WHERE cityid=?", primaryId, secondaryId, 0, seccon);
        this.exchange("UPDATE address_quarter SET cityid=? WHERE cityid=?", primaryId, secondaryId, 0, seccon);
        this.exchange("UPDATE address_house SET cityid=? WHERE cityid=?", primaryId, secondaryId, 0, seccon);
        return primaryId;
    }

    private int updateAreaAndQuarter(String tableName, int secondaryId, Connection maincon, Connection seccon) throws Exception {
        int cityId = 0;
        String title = "";
        String query = "SELECT cityid, title FROM " + tableName + " WHERE id=?";
        PreparedStatement ps = seccon.prepareStatement(query);
        ps.setInt(1, secondaryId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            cityId = rs.getInt(1);
            title = rs.getString(2);
        }
        rs.close();
        ps.close();
        int primaryId = -1;
        if (cityId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c ID \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u043e\u0439 \u0431\u0430\u0437\u044b.");
        }
        query = "INSERT INTO " + tableName + " SET cityid=?, title=?";
        ps = maincon.prepareStatement(query, 1);
        ps.setInt(1, cityId);
        ps.setString(2, title);
        ps.executeUpdate();
        primaryId = this.lastInsertId(ps);
        ps.close();
        this.exchange("UPDATE " + tableName + " SET id=? WHERE id=?", primaryId, secondaryId, 0, seccon);
        return primaryId;
    }

    private int updateStreet(int secondaryId, Connection maincon, Connection seccon) throws Exception {
        int cityId = -1;
        String boxIndex = "";
        String title = "";
        String query = "SELECT cityid, p_index, title FROM address_street WHERE id=?";
        PreparedStatement ps = seccon.prepareStatement(query);
        ps.setInt(1, secondaryId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            cityId = rs.getInt(1);
            boxIndex = rs.getString(2);
            title = rs.getString(3);
        }
        ps.close();
        int primaryId = -1;
        if (cityId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c ID \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u043e\u0439 \u0431\u0430\u0437\u044b.");
        }
        query = "INSERT INTO address_street SET cityid=?, title=?";
        ps = maincon.prepareStatement(query, 1);
        ps.setInt(1, cityId);
        ps.setString(2, title);
        ps.executeUpdate();
        primaryId = this.lastInsertId(ps);
        ps.close();
        this.updateConfig(maincon, "address_street", primaryId, "s.box.index", boxIndex);
        this.exchange("UPDATE address_street SET id=? WHERE id=?", primaryId, secondaryId, 0, seccon);
        this.exchange("UPDATE address_house SET streetid=? WHERE streetid=?", primaryId, secondaryId, 0, seccon);
        return primaryId;
    }

    private int updateHouse(int secondaryId, Connection maincon, Connection seccon) throws Exception {
        int quarterId = 0;
        int streetId = 0;
        int areaId = 0;
        int house = 0;
        int amount = 0;
        String frac = "";
        String pod_diapazon = "";
        String comment = "";
        String boxIndex = "";
        Date dt = null;
        String query = "SELECT * FROM address_house WHERE id=?";
        PreparedStatement ps = seccon.prepareStatement(query);
        ps.setInt(1, secondaryId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            quarterId = rs.getInt("quarterid");
            streetId = rs.getInt("streetid");
            areaId = rs.getInt("areaid");
            house = rs.getInt("house");
            amount = rs.getInt("amount");
            frac = rs.getString("frac");
            pod_diapazon = rs.getString("pod_diapazon");
            comment = rs.getString("comment");
            boxIndex = rs.getString("box_index");
            dt = rs.getDate("dt");
        }
        rs.close();
        ps.close();
        int primaryId = -1;
        if (streetId <= 0 && quarterId <= 0 && areaId <= 0) {
            throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u043c ID \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u0443\u0435\u043c\u043e\u0439 \u0431\u0430\u0437\u044b.");
        }
        query = "INSERT INTO address_house SET quarterid=?, streetid=?, areaid=?, house=?, frac=?, comment=?";
        ps = maincon.prepareStatement(query, 1);
        ps.setInt(1, quarterId);
        ps.setInt(2, streetId);
        ps.setInt(3, areaId);
        ps.setInt(4, house);
        ps.setString(5, frac);
        ps.setString(6, comment);
        ps.executeUpdate();
        primaryId = this.lastInsertId(ps);
        ps.close();
        String dbaseName = this.setup.get("db.secondary.title", "");
        this.updateConfig(maincon, "address_house", primaryId, "d.date." + dbaseName.toLowerCase(), TimeUtils.formatDate(dt));
        this.updateConfig(maincon, "address_house", primaryId, "s.box.index", boxIndex);
        this.updateConfig(maincon, "address_house", primaryId, ".s.pod.range", pod_diapazon);
        this.updateConfig(maincon, "address_house", primaryId, ".i.flat.amount", String.valueOf(amount));
        this.exchange("UPDATE address_house SET id=? WHERE id=?", primaryId, secondaryId, 0, seccon);
        this.exchange("UPDATE contract_parameter_type_2 SET hid=? WHERE hid=?", primaryId, secondaryId, 0, seccon);
        this.exchange("UPDATE object_param_value_address SET hid=? WHERE hid=?", primaryId, secondaryId, 0, seccon);
        return primaryId;
    }

    public static void main(String[] args) {
        new AddressSynchronizer();
    }
}

