/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class AbstractSpecAttr
extends IdTitle {
    private int type;
    private boolean history;
    private String comment;

    @XmlAttribute
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static String getTypeName(int type) {
        EntitySpecAttrType entitySpecAttrType = EntitySpecAttrType.getEntitySpecAttrType(type);
        return entitySpecAttrType == null ? "unknown" : entitySpecAttrType.getTypeName();
    }

    public String getTypeName() {
        return AbstractSpecAttr.getTypeName(this.type);
    }

    @XmlAttribute
    public boolean isHistory() {
        return this.history;
    }

    public void setHistory(boolean history) {
        this.history = history;
    }

    @XmlElement
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static <A extends AbstractSpecAttr> Map<Integer, List<A>> toTypeMap(List<A> entitySpecAttrList) {
        HashMap<Integer, List<A>> result = new HashMap<Integer, List<A>>();
        for (AbstractSpecAttr sa : entitySpecAttrList) {
            ArrayList<AbstractSpecAttr> list = (ArrayList<AbstractSpecAttr>)result.get(sa.getType());
            if (list == null) {
                list = new ArrayList<AbstractSpecAttr>();
                result.put(sa.getType(), list);
            }
            list.add(sa);
        }
        return result;
    }

    public static class Builder<T extends AbstractSpecAttr> {
        private T attr;
        final /* synthetic */ AbstractSpecAttr this$0;

        protected Builder(T attr) {
            this.this$0 = this$0;
            this.attr = attr;
        }

        public Builder<T> setId(int value) {
            ((AbstractSpecAttr)this.attr).id = value;
            return this;
        }

        public Builder<T> setTitle(String title) {
            ((AbstractSpecAttr)this.attr).title = title;
            return this;
        }

        public Builder<T> setType(int type) {
            ((AbstractSpecAttr)this.attr).setType(type);
            return this;
        }

        public Builder<T> setComment(String comment) {
            ((AbstractSpecAttr)this.attr).setComment(comment);
            return this;
        }

        public Builder<T> setHistory(boolean history) {
            ((AbstractSpecAttr)this.attr).setHistory(history);
            return this;
        }

        public T build() {
            try {
                T t = this.attr;
                return t;
            }
            finally {
                this.attr = null;
            }
        }
    }
}

