<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<fmt:setLocale value="RU"/>

<div class="tile">
	<bg:blockTitle title="Текущий статус"/>
	<div class="titleFont3 text-center">${statusstr}</div>
	<div>
	<c:choose>
		<%-- если canchange=1 (CANCHANGE_DISABLED) --%>
		<c:when test="${canchange == 1}"><div class="message">Смена статуса запрещена системой</div></c:when>
		<%-- если canchange=2 (CANCHANGE_DISABLED_BADSTATUS) --%>
		<c:when test="${canchange == 2}"><div class="message">Смена статуса невозможна из текущего статуса</div></c:when>		
		<%-- если canchange=3 (CANCHANGE_DO) --%>
		<c:when test="${canchange == 3}">
			<form>
				<div style="margin-top: 15px;">
					<c:choose>
						<%-- CONTRACT_STATUS_ACTIVE --%>
						<c:when test="${statusint == 0}">Приостановить <input type="hidden" name="status" value="4" /></c:when>
						<%-- CONTRACT_STATUS_SUSPENDED --%>
						<c:when test="${statusint == 4}">Активировать <input type="hidden" name="status" value="0" /></c:when>						
					</c:choose>
					договор с
				</div>
				<div style="margin-top: 15px;"><select class="select2" name="dateFrom"><c:forEach var="item" items="${fromDates}"><fmt:formatDate var="d" value="${item}" type="DATE" dateStyle="SHORT"/><option value="${d}">${d}</option></c:forEach></select></div>
				<%-- раскомментировать если требуется возможность указывать дату ДО при смене статуса
				<c:if test="${statusint == 0 and not empty toDates}">
				<div style="margin-top: 15px;">по</div>
				<div style="margin-top: 15px;"><select class="gradbtn" name="dateTo" ><c:forEach var="item" items="${toDates}"><fmt:formatDate var="d" value="${item}" type="DATE" dateStyle="SHORT"/><option value="${d}">${d}</option></c:forEach></select></div>
				</c:if>
				--%>
				<div class="formButtons"><button class="btn btn-primary" onclick="showBlock( 'statusForm', 'status', { ...statusQuery, command: 'Change', status: this.form.status.value, dateFrom: this.form.dateFrom.value } ); return false;">Выполнить</button></div>
			</form>
		</c:when>
		<%-- если canchange=4 (CANCHANGE_CANCEL_ALLOW) --%>
		<c:when test="${canchange == 4}">
			<div style="margin: 10px;">На будущее число запланирована смена статуса. Вы можете отменить её.</div>
			<div class="formButtons"><button class="btn btn-primary" onclick="showBlock( 'statusForm', 'status', { ...statusQuery, command: 'Cancel' } ); return false;">Отменить</button></div>
		</c:when>
		<%-- если canchange=5 (CANCHANGE_CANCEL_DENY) --%> 
		<c:when test="${canchange == 5}"><div class="message">На будущее число было запланирована смена(-ы) статуса, которую отменить нельзя.</div></c:when>
		<%-- если canchange иной --%>
		<c:otherwise><div class="alert alert-danger" role="alert">Ошибка. Статус нельзя изменить. Обратитесь к оператору [canchange=${canchange}].</div></c:otherwise>
	</c:choose>
	</div>
	<c:if test="${not empty error}"><div class="alert alert-danger" role="alert">${error}</div></c:if>		
</div>

<div class="tile comment">
	<div class="textIndent1">Здесь можно приостановить или активировать договор.</div>
	<div class="textIndent1 textMarginTop1">Приостановить договор можно не ранее завтрашнего числа. Активировать можно начиная с сегодняшнего.</div>
	<!-- <div class="textIndent1 textMarginTop1">В таблице серым цветом отмечены неактивные периоды (например, будущие).</div> -->
</div>

<script>showBlock( 'statusLog', 'log', statusQuery );</script>
