/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNContractStatusLogRecord;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNContractStatusManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRuleManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;

public class ActionGateContractInfo
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int cid = this.getIntParameter("cid", -1);
        if (this.mid == -1 || cid == -1) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u0445 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        Element gates = this.createElement(this.rootNode, "gates");
        UserGateRuleManager ugrm = new UserGateRuleManager(this.con, this.mid);
        List<UserGateRule> userRules = ugrm.getUserGateRules(cid);
        GateManager gm = new GateManager(this.con, this.mid);
        int size = userRules.size();
        for (int i = 0; i < size; ++i) {
            UserGateRule ugr = userRules.get(i);
            Gate gate = gm.getGateById(ugr.getGateId());
            if (gate == null) continue;
            Element item = this.createElement(gates, "item");
            item.setAttribute("id", String.valueOf(ugr.getId()));
            item.setAttribute("title", gate.getTitle());
            item.setAttribute("gid", String.valueOf(gate.getId()));
            item.setAttribute("gtid", String.valueOf(gate.getTypeId()));
        }
        Element gate = this.createElement(this.rootNode, "gate");
        IPNContractStatusManager csm = new IPNContractStatusManager(this.con, this.mid, (Preferences)this.moduleSetup);
        gate.setAttribute("status", String.valueOf(csm.getContractStatus(cid)));
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).add(2, -2);
        SearchResult searchResult = new SearchResult();
        searchResult.getPeriod().setDateFrom(now.getTime());
        csm.searchIPNContractStatusLogRecordList((SearchResult<IPNContractStatusLogRecord>)searchResult, cid, true);
        for (IPNContractStatusLogRecord logRecord : searchResult.getList()) {
            Element element = this.createElement(data, "row");
            element.setAttribute("f0", TimeUtils.format((Date)logRecord.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            element.setAttribute("f1", IPNContractStatusManager.statusToString(logRecord.getStatusId()));
            element.setAttribute("f2", UserMap.getUser((Integer)logRecord.getUserId()).getName());
            element.setAttribute("f3", logRecord.getComment());
        }
    }
}

