/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn;

import bitel.billing.server.load.BaseLoader;
import bitel.billing.server.load.LoadOut;
import bitel.billing.server.netflow.ipn.NFUtil;
import bitel.billing.server.netflow.packet.Flow;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.ipn.server.LogRecord;

public class BinaryLogLoadOut
extends LoadOut {
    private static final Logger logger = LogManager.getLogger((String)"collector");
    private File file;
    private final AtomicInteger recordCount = new AtomicInteger();
    private ConcurrentLinkedQueue<Object> recordQueue = new ConcurrentLinkedQueue();
    private final ReentrantLock lock = new ReentrantLock();
    private final int bufferSize;
    private final ByteBuffer byteBuffer;
    private final FileChannel channel;

    public BinaryLogLoadOut(BaseLoader loader) {
        super(loader);
        this.file = NFUtil.getLogFile(this.setup, loader.getSource().getId(), loader.getHour(), true);
        this.bufferSize = this.setup.getInt("netflow.write.buffer.flow.capacity", 5000);
        this.byteBuffer = ByteBuffer.allocateDirect(this.bufferSize * 2 * 20);
        FileChannel channel = null;
        try {
            FileOutputStream outputStream = new FileOutputStream(this.file, true);
            channel = outputStream.getChannel();
            long tail = this.file.length() % 20L;
            if (tail != 0L) {
                channel.position(this.file.length() - tail + 1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.channel = channel;
    }

    private static final void putRecord(ByteBuffer bb, Object rec) {
        if (rec instanceof Flow) {
            Flow flow = (Flow)rec;
            bb.putInt((int)(flow.srcAddress & 0xFFFFFFFFL));
            bb.putInt((int)(flow.dstAddress & 0xFFFFFFFFL));
            bb.putShort((short)(flow.inputInterface & 0xFFFF));
            bb.putShort((short)(flow.outputInterface & 0xFFFF));
            bb.putShort((short)(flow.srcPort & 0xFFFF));
            bb.putShort((short)(flow.dstPort & 0xFFFF));
            bb.putInt((int)(flow.octets & 0xFFFFFFFFL));
        } else {
            LogRecord record = (LogRecord)rec;
            bb.putInt((int)(record.fromIp & 0xFFFFFFFFL));
            bb.putInt((int)(record.toIp & 0xFFFFFFFFL));
            bb.putShort((short)(record.fromIface & 0xFFFF));
            bb.putShort((short)(record.toIface & 0xFFFF));
            bb.putShort((short)(record.fromPort & 0xFFFF));
            bb.putShort((short)(record.toPort & 0xFFFF));
            bb.putInt((int)(record.amount & 0xFFFFFFFFL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(Object value) {
        ReentrantLock lock;
        this.recordQueue.offer(value);
        if (this.recordCount.incrementAndGet() >= this.bufferSize && (lock = this.lock).tryLock()) {
            try {
                this.recordCount.addAndGet(-this.bufferSize);
                this.byteBuffer.clear();
                for (int i = 0; i < this.bufferSize; ++i) {
                    Object rec = this.recordQueue.poll();
                    if (rec == null) continue;
                    BinaryLogLoadOut.putRecord(this.byteBuffer, rec);
                }
                this.byteBuffer.flip();
                this.channel.write(this.byteBuffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishLoad() {
        super.finishLoad();
        if (this.channel != null) {
            logger.info("FLUSH " + this.loader.getSource().getId());
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                Object rec;
                this.byteBuffer.clear();
                ConcurrentLinkedQueue<Object> recordQueue = this.recordQueue;
                this.recordQueue = new ConcurrentLinkedQueue();
                while ((rec = recordQueue.poll()) != null) {
                    this.recordCount.decrementAndGet();
                    try {
                        BinaryLogLoadOut.putRecord(this.byteBuffer, rec);
                    }
                    catch (BufferOverflowException e) {
                        this.byteBuffer.flip();
                        this.channel.write(this.byteBuffer);
                        this.byteBuffer.clear();
                        BinaryLogLoadOut.putRecord(this.byteBuffer, rec);
                    }
                }
                this.byteBuffer.flip();
                this.channel.write(this.byteBuffer);
                this.channel.force(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                lock.unlock();
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.channel.close();
        if (this.recordCount.get() != 0) {
            logger.warn("Netflow recieve queue on LoadOut.finalize=" + this.recordCount.get());
        }
    }

    public long getFileTime() {
        return this.file.lastModified();
    }

    public long getFileSize() {
        return this.file.length();
    }
}

