/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorker;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAuthError;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.DhcpDisableMode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAuthErrorDao;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetAbstractDhcpProcessor;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDevice;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpOfferedAddressMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.ServSearchResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;

@Deprecated
public class InetDhcpProcessorOld
extends InetAbstractDhcpProcessor
implements ExtendedLifecycle {
    private static final Logger log = LogManager.getLogger();
    private InetDhcpOfferedAddressMap offerMap;
    private final Random random = new Random();
    private final byte[] ZERO_ADDR = new byte[]{0, 0, 0, 0};

    @ConstructorProperties(value={"setup", "access"})
    public InetDhcpProcessorOld(Setup setup, Access access) throws BGException {
        super(access, setup, "inet", SetupParam.getModuleId((ParameterMap)setup));
    }

    public void init() throws Exception {
        boolean processRenew;
        boolean useXid;
        this.deviceMap = new InetDhcpDeviceMap(this.access);
        InetDeviceRuntime rootDeviceRuntime = this.access.deviceMap.get(this.access.rootDeviceId);
        if (rootDeviceRuntime != null) {
            useXid = rootDeviceRuntime.config.getInt("dhcp.xid", 1) > 0;
            processRenew = rootDeviceRuntime.config.getInt("dhcp.renew", 0) > 0;
        } else {
            useXid = ((Setup)this.setup).getModuleSetup(Integer.valueOf(this.access.moduleId)).getInt("dhcp.xid", 1) > 0;
            processRenew = this.access.setup.getModuleSetup(Integer.valueOf(this.access.moduleId)).getInt("dhcp.renew", 0) > 0;
        }
        this.offerMap = new InetDhcpOfferedAddressMap(useXid);
        this.processRenew = processRenew;
        if (processRenew) {
            this.addAccountingListeners();
            log.info("Restore connections on DhcpProcessor");
            for (Map.Entry<Integer, ConcurrentMap<Long, InetConnectionRuntime>> me : this.access.connectionManager.deviceConnectionEntrySet()) {
                ConcurrentMap<Long, InetConnectionRuntime> map = me.getValue();
                for (InetConnectionRuntime connectionRuntime : map.values()) {
                    int address;
                    InetConnection connection = connectionRuntime.connection;
                    if (connection.getParentConnectionId() > 0L) {
                        log.debug("Skip service connection");
                    }
                    if ((address = Utils.convertBytesToInt((byte[])connection.getInetAddressBytes())) == 0) continue;
                    this.addressMap.add(address, new InetAbstractDhcpProcessor.Entry(connection.getIpResourceId(), address, connection.getServId(), connection.getId()));
                }
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void destroy() throws Exception {
    }

    @Override
    protected void onAccountingStart(InetConnectionManager.ConnectionAddEvent e, EventListenerContext ctx, int deviceId, InetDhcpDevice dhcpDevice, InetConnection connection) {
        int address = Utils.convertBytesToInt((byte[])connection.getInetAddressBytes());
        if (address != 0) {
            this.addressMap.add(address, new InetAbstractDhcpProcessor.Entry(connection.getIpResourceId(), address, connection.getServId(), connection.getId()));
        }
    }

    @Override
    protected void onAccountingUpdate(InetConnectionManager.ConnectionUpdateEvent e, EventListenerContext ctx, int deviceId, InetDhcpDevice dhcpDevice, InetConnection connection) {
        int address = Utils.convertBytesToInt((byte[])connection.getInetAddressBytes());
        if (address != 0) {
            this.addressMap.add(address, new InetAbstractDhcpProcessor.Entry(connection.getIpResourceId(), address, connection.getServId(), connection.getId()));
        }
    }

    @Override
    protected void onAccountingStop(InetConnectionManager.ConnectionRemoveEvent e, EventListenerContext ctx, int deviceId, InetDhcpDevice dhcpDevice, InetConnection connection) {
        int address = Utils.convertBytesToInt((byte[])connection.getInetAddressBytes());
        if (address != 0) {
            this.addressMap.remove(address, new InetAbstractDhcpProcessor.Entry(connection.getIpResourceId(), address, connection.getServId(), connection.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DhcpPacket processOption82RequestImpl(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice device, DhcpPacket request, boolean renew) throws BGException {
        byte messageType = request.messageType;
        if (messageType == 3) {
            DhcpOption serverIdentifier;
            log.debug("DHCP_REQUEST");
            if (device.filterServerIdentifier != null && (serverIdentifier = request.getOption((byte)54)) != null && !Arrays.equals(serverIdentifier.value, device.filterServerIdentifier)) {
                log.debug("Skip packet by filter.");
                return null;
            }
        } else {
            log.debug("DHCP_DISCOVER");
        }
        if (log.isDebugEnabled()) {
            log.debug("request.giaddr= " + IPUtils.convertIpToString((int)Utils.convertBytesToInt((byte[])request.giaddr)) + ", clientAddress=" + clientAddress);
        }
        DhcpPacket response = request.createResponse();
        ServSearchResult servSearchResult = device.findServRuntime(request, req);
        if (servSearchResult == null) {
            log.info("InetServ not found.");
            return null;
        }
        log.info("InetServ found: " + servSearchResult.parentServRuntime);
        servSearchResult.parentServRuntime.tryLockEx(20L, TimeUnit.SECONDS);
        try {
            DhcpPacket dhcpPacket = this.processOption82RequestImpl0(req, clientAddress, device, servSearchResult, request, response, renew);
            servSearchResult.parentServRuntime.unlock();
            return dhcpPacket;
        }
        catch (Throwable throwable) {
            try {
                servSearchResult.parentServRuntime.unlock();
                throw throwable;
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
    }

    private List<InetConnectionRuntime> getConnectionList(int servId) {
        List<InetConnectionRuntime> allConnectionList = this.access.connectionManager.getByServId(servId);
        if (allConnectionList == null) {
            return Collections.emptyList();
        }
        ArrayList<InetConnectionRuntime> connectionList = new ArrayList<InetConnectionRuntime>(allConnectionList.size());
        int size = allConnectionList.size();
        for (int i = 0; i < size; ++i) {
            InetConnectionRuntime existConnectionRuntime = allConnectionList.get(i);
            InetConnection existConnection = existConnectionRuntime.connection;
            if (!InetUtils.checkAliveAndType(existConnection, false, 1024)) continue;
            connectionList.add(existConnectionRuntime);
        }
        return connectionList;
    }

    private DhcpPacket processOption82RequestImpl0(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice device, ServSearchResult servSearchResult, DhcpPacket request, DhcpPacket response, boolean renew) throws BGException, UnknownHostException {
        InetConnection existConnection;
        InetServRuntime parentServRuntime = servSearchResult.parentServRuntime;
        InetServRuntime servRuntime = servSearchResult.servRuntime != null ? servSearchResult.servRuntime : parentServRuntime;
        InetServ parentServ = parentServRuntime.getInetServ();
        InetServ serv = servRuntime.getInetServ();
        req.interfaceId = parentServ.getInterfaceId();
        List<InetConnectionRuntime> connectionList = this.getConnectionList(serv.getId());
        String macString = Utils.bytesToHexString((byte[])request.chaddr);
        int deviceId = device.deviceRuntime.inetDeviceId;
        InetConnectionRuntime connectionRuntime = null;
        InetConnection connection = null;
        InetConnectionRuntime _connectionRuntime = null;
        InetConnection _connection = null;
        int size = connectionList.size();
        for (int i = 0; i < size; ++i) {
            InetConnectionRuntime existConnectionRuntime = connectionList.get(i);
            existConnection = existConnectionRuntime.connection;
            if (deviceId != existConnection.getDeviceId() || !macString.equals(existConnection.getCallingStationId())) continue;
            if (Utils.isEmptyString((String)existConnection.getUsername())) {
                connectionRuntime = existConnectionRuntime;
                connection = existConnection;
                continue;
            }
            _connectionRuntime = existConnectionRuntime;
            _connection = existConnection;
        }
        if (connection == null) {
            connectionRuntime = _connectionRuntime;
            connection = _connection;
        }
        if (connection != null) {
            req.connectionId = connection.getId();
            boolean needClose = false;
            DhcpDisableMode dhcpDisableMode = device.getDhcpDisableMode(servRuntime.getInetServTypeRuntime());
            if (dhcpDisableMode != DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH) {
                AuthResult authResult;
                if (servSearchResult.servRuntime == null) {
                    log.info("inetServ[id=" + serv.getId() + "] sub serv with MAC-addresses not found.");
                    authResult = new AuthResult(AccessCode.MAC_DENY.getCode());
                } else {
                    ConnectionSet connectionSet;
                    authResult = this.access.authorization(parentServRuntime, servRuntime, true, connection.getDeviceId(), connection.getAgentDeviceId(), null, null, 0, null, 0, 0, false, null, null, true, BigDecimal.ZERO, true);
                    if (authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && Boolean.FALSE.equals(this.access.checkSessionCount(connectionSet = ((DefaultContext)ThreadContext.get(DefaultContext.class)).getConnectionSet(), parentServRuntime, servRuntime, 1024, 0, false, null, null, null, false))) {
                        log.info("Too many sessions.");
                        authResult = new AuthResult(AccessCode.TOO_MANY_SESSIONS_ERROR.getCode());
                    }
                }
                boolean bl = needClose = authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() != (connection.getDeviceState() == InetServState.STATE_ENABLE.getCode());
                if (needClose) {
                    log.info("Stopping session with deviceState= " + connection.getDeviceState() + " and accessCode=" + authResult.accessCode);
                }
            }
            if (needClose) {
                req.setConnectionModified(true);
                this.access.connectionManager.accountingStop(serv, connection, 5000L);
                connection = null;
                if (request.messageType == 3) {
                    response.messageType = (byte)6;
                    return response;
                }
                log.info("Discard offer packet");
                return null;
            }
        }
        if (connection != null) {
            if (request.messageType == 1) {
                this.setOptions(device, connection.getInetAddressBytes(), connection.getIpResourceId(), response, connection.getDeviceOptions(), renew);
                response.messageType = (byte)2;
                return response;
            }
            if (request.messageType == 3) {
                DhcpOption requestedIp = request.getOption((byte)50);
                if (requestedIp != null && !Arrays.equals(requestedIp.value, connection.getInetAddressBytes())) {
                    req.setConnectionModified(true);
                    log.info("RequestedIP=" + InetAddress.getByAddress(requestedIp.value));
                    response.messageType = (byte)6;
                    response.flags = DhcpPacket.FLAG_BROADCAST;
                } else {
                    this.setOptions(device, connection.getInetAddressBytes(), connection.getIpResourceId(), response, connection.getDeviceOptions(), renew);
                    response.messageType = (byte)5;
                    log.info("Updating of existing connection: " + connection);
                    this.access.connectionManager.accountingUpdate(serv, connection);
                    if (req.isConnectionModified()) {
                        connectionRuntime.nextDhcpLog = req.millis + TimeUnit.MINUTES.toMillis(465 + this.random.nextInt(30));
                    } else if (connectionRuntime.nextDhcpLog == 0L) {
                        connectionRuntime.nextDhcpLog = req.millis + TimeUnit.MINUTES.toMillis(45 + this.random.nextInt(30));
                    } else if (connectionRuntime.nextDhcpLog <= req.millis) {
                        connectionRuntime.nextDhcpLog = req.millis + TimeUnit.MINUTES.toMillis(465 + this.random.nextInt(30));
                        req.setConnectionModified(true);
                    }
                }
                return response;
            }
            return null;
        }
        if (request.messageType == 1) {
            AuthResult authResult;
            DhcpOption reqParams;
            boolean infoReq;
            boolean bl = infoReq = request.ciaddr != null && !Arrays.equals(this.ZERO_ADDR, request.ciaddr);
            if (infoReq && (reqParams = request.getOption((byte)55)) != null && reqParams.value != null) {
                for (int i = 0; i < reqParams.value.length; ++i) {
                    if (reqParams.value[i] != 1) continue;
                    infoReq = false;
                    break;
                }
            }
            if (!infoReq && device.getDhcpConnectionCloseOnNew(parentServRuntime.getInetServTypeRuntime())) {
                int size2 = connectionList.size();
                for (int i = 0; i < size2; ++i) {
                    existConnection = connectionList.get((int)i).connection;
                    this.access.connectionManager.accountingStop(serv, existConnection, 5000L);
                }
                connectionList = this.access.connectionManager.getByServId(serv.getId());
                if (connectionList == null) {
                    connectionList = Collections.emptyList();
                }
            }
            if (servSearchResult.servRuntime == null) {
                log.info("inetServ[id=" + serv.getId() + "] sub serv with MAC-addresses not found.");
                authResult = new AuthResult(AccessCode.MAC_DENY.getCode());
            } else {
                ConnectionSet connectionSet;
                authResult = this.access.authorization(parentServRuntime, servRuntime, false, device.deviceRuntime.inetDeviceId, 0, null, null, 0, null, 0, 0, false, null, null, true, BigDecimal.ZERO, true);
                if (authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() && !this.access.checkSessionCount(connectionSet = ((DefaultContext)ThreadContext.get(DefaultContext.class)).getConnectionSet(), parentServRuntime, servRuntime, 1024, 0, false, null, null, null, true).booleanValue()) {
                    log.info("Too many sessions.");
                    authResult = new AuthResult(AccessCode.TOO_MANY_SESSIONS_ERROR.getCode());
                }
            }
            if (infoReq) {
                if (!device.dhcpInfoReq) {
                    log.info("Skip DHCP-packet without IP-address request");
                    return null;
                }
                Set inetOptionIds = authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() ? parentServ.getDeviceOptions() : null;
                this.setOptions(device, request.ciaddr, 0, response, inetOptionIds, renew);
                response.messageType = (byte)2;
                return response;
            }
            req.setConnectionModified(true);
            IpResourceReserve resource = null;
            int sessionCountLimit = InetUtils.getSessionCountLimit(servRuntime.inetServTypeRef.get().inetServType, serv);
            DhcpDisableMode dhcpDisableMode = device.getDhcpDisableMode(servRuntime.getInetServTypeRuntime());
            if (authResult.accessCode == AccessCode.TOO_MANY_SESSIONS_ERROR.getCode() && (dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH || connectionList.size() >= sessionCountLimit + device.additionalUnauthorizedSessionCount)) {
                log.info("Too many sessions.");
                return null;
            }
            InetDhcpOfferedAddressMap.Offered offered = this.offerMap.getOffered(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr);
            if (offered != null) {
                log.info("Duplicate offer. Send same answer");
                resource = offered.resource;
            }
            if (resource == null) {
                if (authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH) {
                    List<InetServRuntime> childrenServRuntimeList = this.access.inetServRuntimeMap.listChildren(serv.getId(), req.millis);
                    ArrayList<InetConnectionRuntime> userAddressConnectionList = new ArrayList<InetConnectionRuntime>(connectionList.size());
                    for (InetConnectionRuntime existConnectionRuntime : connectionList) {
                        if (!InetUtils.checkAliveAndType(existConnectionRuntime.connection, false, 1024) || existConnectionRuntime.connection.getParentConnectionId() > 0L) continue;
                        String username = existConnectionRuntime.connection.getUsername();
                        byte[] address = existConnectionRuntime.connection.getInetAddressBytes();
                        if (Utils.notEmptyString((String)username) && address != null && username.equals(IpAddress.toString((byte[])address))) continue;
                        userAddressConnectionList.add(existConnectionRuntime);
                    }
                    resource = this.offerMap.offer(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr, serv, childrenServRuntimeList, userAddressConnectionList, authResult.accessCode);
                } else {
                    InetAuthError error = new InetAuthError();
                    error.setDeviceId(device.deviceRuntime.inetDevice.getId());
                    error.setDeviceTitle(device.deviceRuntime.inetDevice.getTitle());
                    error.setContractId(serv.getContractId());
                    error.setServId(serv.getId());
                    error.setServTitle(serv.getTitle());
                    error.setErrorCode(authResult.accessCode);
                    try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
                        error.setContractTitle("");
                        InetAuthErrorDao authErrorDao = new InetAuthErrorDao(connectionSet, this.mid, new Date());
                        authErrorDao.addError(error);
                        authErrorDao.recycle();
                    }
                }
            }
            if (resource == null) {
                log.info("IP not found in service. Searching in device...");
                resource = dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL || dhcpDisableMode == DhcpDisableMode.DHCP_DISABLE_MODE_DEFAULT_POOL_AND_AUTH ? device.reserveAddress(AccessCode.AUTHORIZATION_SUCCEEDED.getCode(), null) : device.reserveAddress(authResult.accessCode, null);
                if (resource != null) {
                    this.offerMap.offer(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr, resource, authResult.accessCode);
                }
            }
            if (resource == null) {
                log.info("Free IP-address not found");
                return null;
            }
            Set inetOptionIds = authResult.accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() ? parentServ.getDeviceOptions() : null;
            this.setOptions(device, resource.getAddress(), resource.getIpResourceId(), response, inetOptionIds, renew);
            response.messageType = (byte)2;
            if (device.dhcpOfferRandomDelay > 0) {
                try {
                    Thread.sleep(this.random.nextInt(device.dhcpOfferRandomDelay) * 5);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            return response;
        }
        if (request.messageType == 3) {
            req.setConnectionModified(true);
            InetDhcpOfferedAddressMap.Offered offered = this.offerMap.getOffered(device.deviceRuntime.inetDeviceId, serv.getId(), request.xid, request.chaddr);
            if (offered == null) {
                log.info("Unknown packet (linked offer not found). Discard packet.");
                response.messageType = (byte)6;
                response.flags = DhcpPacket.FLAG_BROADCAST;
                return response;
            }
            DhcpOption requestedIp = request.getOption((byte)50);
            if (requestedIp != null && !Arrays.equals(requestedIp.value, offered.resource.getAddress())) {
                log.info("requestedIP=" + InetAddress.getByAddress(requestedIp.value));
                response.messageType = (byte)6;
                response.flags = DhcpPacket.FLAG_BROADCAST;
            } else {
                IpResourceReserve resource = offered.resource;
                int errorCode = offered.errorCode;
                Set inetOptionIds = errorCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode() ? parentServ.getDeviceOptions() : null;
                this.setOptions(device, resource.getAddress(), resource.getIpResourceId(), response, inetOptionIds, renew);
                response.messageType = (byte)5;
                connection = new InetConnection();
                connection.setDeviceId(device.deviceRuntime.inetDevice.getId());
                connection.setDevicePort(parentServ.getInterfaceId());
                connection.setContractId(parentServ.getContractId());
                connection.setServId(serv.getId());
                connection.setAcctSessionId(Integer.toHexString(request.xid));
                connection.setCallingStationId(macString);
                connection.setIpResourceId(resource.getIpResourceId());
                connection.setInetAddressBytes(resource.getAddress());
                if (errorCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                    InetConnection.setType((InetConnection)connection, (int)32, (boolean)true);
                }
                connection.setAccessCode(errorCode);
                connection.setDeviceState(errorCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode() ? InetServState.STATE_DISABLE.getCode() : InetServState.STATE_ENABLE.getCode());
                connection.setConnectionStart(new Date());
                log.info("Starting connection: " + connection);
                connection = this.access.connectionManager.accountingStart(serv, connection, 4000L);
                req.connectionId = connection.getId();
            }
        }
        return response;
    }

    private void setOptions(InetDhcpDevice device, byte[] address, int ipResourceId, DhcpPacket response, Set<Integer> inetOptionIds, boolean renew) throws BGException {
        response.yiaddr = address;
        device.setOptions(this.access.ipResourceManager, ipResourceId, response, Utils.unsignedIntToLong((int)Utils.convertBytesToInt((byte[])address)), inetOptionIds, renew);
    }
}

