/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.access;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAuthError;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAuthErrorDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.BatchWorker;

public class InetAuthErrorWorker
extends BatchWorker<Object, ServerContext> {
    private final BlockingQueue<Object> queue;
    private final boolean authErrorUpdate;
    private final Random random = new Random();
    private ConnectionSet connectionSet;
    private long nextDayStartMillis = -1L;
    private InetAuthErrorDao authErrorDao;
    private ConnectionLogEntryDao connectionLogEntryDao;

    public InetAuthErrorWorker(Setup setup, int moduleId, int capacity, long defaultTimeout, boolean authErrorUpdate) {
        this.errorPause = 50 + 250 * this.random.nextInt(2);
        this.context = new ServerContext(setup, moduleId, 0);
        this.queue = new LinkedBlockingQueue<Object>(capacity);
        this.authErrorUpdate = authErrorUpdate;
        new Thread((Runnable)((Object)this), "auth-error-worker").start();
    }

    protected Object takeImpl() throws Exception {
        return this.queue.take();
    }

    protected Object pollImpl(long timeout) throws Exception {
        return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    public boolean offer(InetAuthError error) throws InterruptedException {
        return this.queue.offer(error);
    }

    public boolean offer(Object error) throws InterruptedException {
        return this.queue.offer(error);
    }

    private InetAuthErrorDao getAuthErrorDao() {
        if (this.authErrorDao != null && System.currentTimeMillis() < this.nextDayStartMillis) {
            return this.authErrorDao;
        }
        this.init();
        return this.authErrorDao;
    }

    private ConnectionLogEntryDao getConnectionLogEntryDao() {
        if (this.connectionLogEntryDao != null && System.currentTimeMillis() < this.nextDayStartMillis) {
            return this.connectionLogEntryDao;
        }
        this.init();
        return this.connectionLogEntryDao;
    }

    private void init() {
        GregorianCalendar calendar = new GregorianCalendar();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        if (this.authErrorDao != null) {
            this.authErrorDao.recycle();
        }
        if (this.connectionLogEntryDao != null) {
            this.connectionLogEntryDao.recycle();
        }
        this.authErrorDao = new InetAuthErrorDao(this.connectionSet, ((ServerContext)this.context).getModuleId(), calendar.getTime());
        this.connectionLogEntryDao = new ConnectionLogEntryDao(this.connectionSet, ((ServerContext)this.context).getModuleId());
        ((Calendar)calendar).add(5, 1);
        this.nextDayStartMillis = calendar.getTimeInMillis();
    }

    protected boolean runWorker() throws BGException {
        try {
            this.errorPause = 50 + 250 * this.random.nextInt(2);
            this.connectionSet = ((ServerContext)this.context).getConnectionSet();
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            if (this.authErrorDao != null) {
                this.authErrorDao.recycle();
                this.authErrorDao = null;
            }
            if (this.connectionLogEntryDao != null) {
                this.connectionLogEntryDao.recycle();
                this.connectionLogEntryDao = null;
            }
            ((ServerContext)this.context).recycle();
            if (this.connectionSet != null) {
                this.connectionSet = null;
            }
        }
    }

    public Object doTask(Object o) throws BGException {
        if (o instanceof InetAuthErrorTask) {
            InetAuthErrorTask task = (InetAuthErrorTask)o;
            this.getAuthErrorDao().addError(task.error, task.logEntry, this.authErrorUpdate);
        } else if (o instanceof ConnectionLogEntry) {
            ConnectionLogEntry entry = (ConnectionLogEntry)o;
            this.getConnectionLogEntryDao().update(entry, true);
        } else {
            InetAuthError error = (InetAuthError)o;
            this.getAuthErrorDao().addError(error, null, this.authErrorUpdate);
        }
        return null;
    }

    public static final class InetAuthErrorTask {
        final InetAuthError error;
        final ConnectionLogEntry logEntry;

        public InetAuthErrorTask(InetAuthError error, ConnectionLogEntry logEntry) {
            this.error = error;
            this.logEntry = logEntry;
        }
    }
}

