/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.sender.smsc;

import jakarta.activation.DataSource;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.sms.Smsc;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class SmscSender
implements Sender {
    private static final Logger logger = LogManager.getLogger();
    private final Smsc smsc;
    private final String sender;
    private final int translit;

    public SmscSender() throws BGException {
        Preferences pluginPreferences = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch").getSetup();
        String login = pluginPreferences.get("sender.sms.smsc.login");
        String password = pluginPreferences.get("sender.sms.smsc.password");
        this.sender = Utils.maskNull((String)pluginPreferences.get("sender.sms.smsc.sender"));
        this.translit = pluginPreferences.getInt("sender.sms.smsc.translit", 1);
        if (Utils.isBlankString((String)login) && Utils.isBlankString((String)password)) {
            throw new BGException("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043b\u043e\u0433\u0438\u043d \u0438/\u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c.");
        }
        this.smsc = new Smsc(login, password);
    }

    @Override
    public void send(Contact contact, String title, String messageBody, List<DataSource> messageFiles) {
        if (contact != null) {
            String[] result = this.smsc.send_sms(contact.getValueForSend(), messageBody, this.translit, "", "", 0, this.sender, "");
            if (logger.isDebugEnabled()) {
                logger.debug("\t\t\tSms-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 " + contact.getValueForSend() + " \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e. \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + result);
            }
        } else {
            logger.warn("\t\t\t\u0412 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442! \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043c\u0441-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
        }
    }
}

