/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.action.web;

import jakarta.annotation.Resource;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactTypeDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.SubscriptionDao;
import ru.bitel.bgbilling.plugins.dispatch.server.interaction.ModuleDataManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.ScheduleTime;

@WebAction(title="\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0438")
public class ActionDispatch
extends AbstractAction {
    @Resource
    private DispatchService dispatchService;

    public ActionDispatch() {
        super("dispatch");
    }

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
        super.execute();
    }

    @WebOperation(title="\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u044b")
    public void contacts() throws BGException {
        this.setResultParam("contacts", this.dispatchService.getContacts(this.contractId));
        this.setResultParam("contactTypes", this.dispatchService.getContactTypes());
        this.requestDispatcher(this.moduleName, "contact_list");
    }

    @WebOperation(title="\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438")
    public void subscriptions() throws BGException {
        this.setResultParam("subscriptions", this.dispatchService.getSubscriptions(0, this.contractId));
        this.setResultParam("dispatches", this.dispatchService.getDispatchList().stream().filter(a -> a.isActive()).toList());
        this.requestDispatcher(this.moduleName, "subscription_list");
    }

    @WebOperation(title="\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438")
    public void showSubscriptionEditor() throws BGException {
        int step = this.req.getInt("step", 1);
        int subscriptionId = this.req.getInt("subscriptionId", 0);
        try (ContactDao contactDao = new ContactDao(this.con);){
            Subscription subscription = null;
            SubscriptionDao subscriptionDao = new SubscriptionDao(this.con);
            if (subscriptionId > 0 && (subscription = subscriptionDao.get(subscriptionId)) != null && subscription.getContractId() != this.contractId) {
                subscription = null;
            }
            if (subscription == null) {
                subscription = new Subscription();
                subscription.setContractId(this.contractId);
            }
            if (subscription.getId() < 1) {
                subscription.setActive(true);
                subscription.setSubscriptionPeriod(new Period());
                try (DispatchDao dispatchDao = new DispatchDao(this.con);){
                    subscription.setDispatch((Dispatch)dispatchDao.get(this.req.getInt("dispatchId", 0)));
                }
            }
            if (subscription.getId() > 0 && step == 1) {
                step = 2;
            }
            if (step == 1) {
                this.setResultParam("dispatches", this.dispatchService.getDispatchList());
            } else if (step == 2) {
                ArrayList<Contact> contacts = new ArrayList<Contact>();
                for (Contact contact : contactDao.getContactsOfContract(this.contractId)) {
                    if (contact.getContactTypeId() != subscription.getDispatch().getContactTypeId()) continue;
                    contacts.add(contact);
                }
                this.setResultParam("contacts", contacts);
            } else if (step == 3) {
                if (subscription.getDispatch().isPersonal()) {
                    subscription.setRepeatTime(this.convertDaysToScheduleTime(this.context.getRequest().getParameter("days")));
                }
                subscription.setComment(this.req.get("comment", ""));
                String[] contactIds = this.context.getRequest().getParameterValues("contactIds");
                subscription.setContacts(contactDao.getContacts(Utils.toString(contactIds != null ? Arrays.asList(contactIds) : new ArrayList()), this.contractId));
                Preferences prefs = new Preferences();
                for (Map.Entry pref : this.req.sub("prefs.").entrySet()) {
                    prefs.set((String)pref.getKey(), (String)pref.getValue());
                }
                subscription.setPreferences(prefs);
                try {
                    this.dispatchService.updateSubscriptions(subscription);
                }
                catch (BGMessageException e) {
                    this.setResultParam("error", e.getMessage());
                    step = 2;
                }
            }
            this.setResultParam("step", step);
            this.setResultParam("subscription", subscription);
            this.requestDispatcher(this.moduleName, "subscription_editor");
            return;
        }
    }

    @WebOperation(title="\u041e\u0442\u043c\u0435\u043d\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438")
    public void unsubscribeSubscription() throws BGException {
        int id = this.req.getInt("id", 0);
        Subscription subscription = new SubscriptionDao(this.con).get(id);
        if (this.req.getBoolean("remove", false)) {
            if (subscription != null && subscription.getContractId() == this.contractId) {
                this.dispatchService.deleteSubscription(id);
                this.setResultParam("status", "ok");
            }
        } else {
            this.setResultParam("subscription", subscription);
        }
        this.requestDispatcher(this.moduleName, "subscription_remove");
    }

    @WebOperation(title="\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430")
    public void removeContact() throws BGException {
        int id = this.req.getInt("id", 0);
        try (ContactDao contactDao = new ContactDao(this.con);){
            Contact contact = (Contact)contactDao.get(id);
            if (this.req.getBoolean("remove", false)) {
                if (contact != null && contact.getContractId() == this.contractId) {
                    this.dispatchService.deleteContact(id);
                    this.setResultParam("status", "ok");
                }
            } else {
                try (ContactTypeDao contactTypeDao = new ContactTypeDao(this.con);){
                    this.setResultParam("contactType", contactTypeDao.get(contact.getContactTypeId()));
                }
                this.setResultParam("contact", contact);
            }
            this.requestDispatcher(this.moduleName, "contact_remove");
        }
    }

    @WebOperation(title="\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430")
    public void showContactEditor() throws BGException {
        int step = this.req.getInt("step", 1);
        int contactId = this.req.getInt("contactId", 0);
        try (ContactDao contactDao = new ContactDao(this.con);
             ContactTypeDao contactTypeDao = new ContactTypeDao(this.con);){
            Contact contact = null;
            if (contactId > 0 && (contact = (Contact)contactDao.get(contactId)) != null && contact.getContractId() != this.contractId) {
                contact = null;
            }
            if (contact == null) {
                contact = new Contact();
                contact.setContractId(this.contractId);
            }
            if (contact.getId() < 1) {
                contact.setContactTypeId(this.req.getInt("contactTypeId", 0));
            }
            if (contact.getId() > 0 && step == 1) {
                step = 2;
            }
            if (step == 1) {
                this.setResultParam("contactTypes", contactTypeDao.getList());
            } else if (step == 2) {
                ContactType contactType = contactTypeDao.get(contact.getContactTypeId());
                if (contactType != null) {
                    Object text = contactType.getDescription();
                    int pos = 0;
                    int column = 70;
                    while (pos + column < ((String)text).length()) {
                        pos += column;
                        pos = ((String)text).lastIndexOf(32, pos);
                        text = ((String)text).substring(0, pos) + "\n" + ((String)text).substring(pos + 1);
                    }
                    text = (String)text + (((String)text).length() > 0 ? "\n\n" : "") + "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:\n";
                    String defaultValue = contactDao.getDefaultValue(contactType.getId(), this.contractId);
                    text = (String)text + (defaultValue == null ? "\u043d\u0435\u0442" : defaultValue.replaceAll("<", "&lt;"));
                    this.setResultParam("tooltip", text);
                }
                this.setResultParam("contactType", contactType == null ? new ContactType() : contactType);
            }
            if (step == 3) {
                contact.setValue(this.req.get("contactValue", ""));
                try {
                    this.dispatchService.updateContact(contact);
                }
                catch (BGMessageException e) {
                    this.setResultParam("error", e.getMessage());
                    step = 2;
                }
            }
            this.setResultParam("step", step);
            this.setResultParam("contact", contact);
            this.requestDispatcher(this.moduleName, "contact_editor");
        }
    }

    public void getModuleData() throws BGException {
        try {
            int moduleId = this.req.getInt("moduleId", 0);
            String moduleName = this.req.get("class", null);
            if (moduleId == 0) {
                return;
            }
            if (moduleName == null) {
                return;
            }
            String className = "ru.bitel.bgbilling.plugins.dispatch.modules." + moduleName + ".server.ModuleDataManager";
            Constructor<?> constructor = Class.forName(className).getConstructor(Connection.class, Integer.TYPE);
            ModuleDataManager manager = (ModuleDataManager)constructor.newInstance(this.con, moduleId);
            this.setResult(manager.getData(this.contractId));
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private ScheduleTime convertDaysToScheduleTime(String daysOfWeek) {
        ScheduleTime scheduleTime = new ScheduleTime();
        scheduleTime.setMonth(0);
        scheduleTime.setDayOfWeek((int)Utils.packValues((Collection)Utils.toList((String)daysOfWeek), (int)1));
        scheduleTime.setDay(0);
        scheduleTime.setHour((int)Utils.packValues((Collection)Utils.toList((String)"0"), (int)0));
        scheduleTime.setMin((long)((int)Utils.packValues((Collection)Utils.toList((String)"0"), (int)0)));
        return scheduleTime;
    }
}

