/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.crm.common.model.PersonalRegisterTask;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterTask;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterTaskType;
import ru.bitel.bgbilling.plugins.crm.server.model.PhoneParam;
import ru.bitel.bgbilling.plugins.crm.server.model.TaskFilter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class RegisterTaskManager {
    private static final Logger log = LogManager.getLogger();
    private Connection con;

    public RegisterTaskManager(Connection con) {
        this.con = con;
    }

    public RegisterTask getTaskById(int id) {
        RegisterTask result = null;
        String query = "SELECT * FROM register_task WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getTaskFromRS("", rs);
                    this.loadExecutorList(result);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void loadExecutorList(RegisterTask task) {
        ArrayList<Integer> executors = new ArrayList<Integer>();
        String query = "SELECT eid FROM register_task_executor WHERE tid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, task.getId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    executors.add(rs.getInt(1));
                }
            }
            task.setExecutors(executors);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Map<Integer, String> getStatusMap(String values) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        if (values != null) {
            StringTokenizer st = new StringTokenizer(values, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int pos = token.indexOf(58);
                if (pos <= -1) continue;
                try {
                    int id = Integer.parseInt(token.substring(0, pos));
                    map.put(id, token.substring(pos + 1));
                }
                catch (Exception exception) {}
            }
        }
        return map;
    }

    public void updateExecutorList(RegisterTask task) {
        String query = null;
        PreparedStatement ps = null;
        try {
            query = "DELETE FROM register_task_executor WHERE tid=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, task.getId());
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO register_task_executor (tid, eid) VALUES (?, ?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, task.getId());
            for (Integer executor : task.getExecutors()) {
                ps.setInt(2, executor);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public void updateTask(String id, RegisterTask task) {
        if (task != null && id != null) {
            task.setId(Utils.parseInt((String)id, (int)-1));
        }
    }

    public void updateTask(RegisterTask task, int userId) {
        if (task != null) {
            try {
                int index = 1;
                String query = null;
                PreparedStatement ps = null;
                if (task.getId() < 0) {
                    query = "INSERT INTO register_task SET accept_dt=?, accept_uid=?, close_dt=?, close_uid=?, status=?, target_dt=?, comment=?, gr=?, resolution=?, prid=?, execute_dt=?, apid=?, processed=?, lm_dt=?, lm_uid=?, aobject_id=?, type=?, cid=?, open_dt=?, open_uid=?";
                    ps = this.con.prepareStatement(query, 1);
                } else {
                    query = "UPDATE register_task SET accept_dt=?, accept_uid=?, close_dt=?, close_uid=?, status=?, target_dt=?, comment=?, gr=?, resolution=?, prid=?, execute_dt=?, apid=?, processed=?, lm_dt=?, lm_uid=?, aobject_id=?, type=? WHERE id=?";
                    ps = this.con.prepareStatement(query);
                }
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)task.getAcceptTime()));
                ps.setInt(index++, task.getAcceptUserId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)task.getCloseTime()));
                ps.setInt(index++, task.getCloseUserId());
                ps.setInt(index++, task.getStatus());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)task.getTargetDate()));
                ps.setString(index++, task.getComment());
                ps.setInt(index++, task.getGroupId());
                ps.setString(index++, task.getResolution());
                ps.setInt(index++, task.getProblemId());
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)task.getExecuteDate()));
                ps.setInt(index++, task.getAddressParamId());
                ps.setBoolean(index++, task.isProcessed());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)task.getLastmodTime()));
                ps.setInt(index++, task.getLastmodUserId());
                ps.setInt(index++, task.getAddressObjectId());
                ps.setInt(index++, task.getTypeId());
                if (task.getId() < 0) {
                    ps.setInt(index++, task.getContractId());
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)task.getOpenTime()));
                    ps.setInt(index++, task.getOpenUserId());
                } else {
                    ps.setInt(index++, task.getId());
                }
                if (ps.executeUpdate() > 0) {
                    if (task.getId() < 0) {
                        task.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                    }
                    this.updateTaskLog(task, userId);
                }
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateTaskLog(RegisterTask task, int userId) {
        if (task != null) {
            try {
                String query = "INSERT INTO register_task_log SET task_id=?, change_dt=?, change_uid=?, status=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(1, task.getId());
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)new Date()));
                ps.setInt(3, userId);
                ps.setInt(4, task.getStatus());
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public List<RegisterTask> getRegisterTaskLog(int taskId) {
        ArrayList<RegisterTask> result = new ArrayList<RegisterTask>();
        try {
            String query = "SELECT * FROM register_task_log WHERE task_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, taskId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RegisterTask task = new RegisterTask();
                task.setId(rs.getInt("task_id"));
                task.setLastmodTime((Date)rs.getTimestamp("change_dt"));
                task.setLastmodUserId(rs.getInt("change_uid"));
                task.setStatus(rs.getInt("status"));
                result.add(task);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteTask(int id) {
        if (log.isDebugEnabled()) {
            log.debug("DELETE FROM register_task WHERE id=" + id);
        }
        try {
            String query = "DELETE FROM register_task WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM register_task_log WHERE task_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteTasksByContractId(int contractId) {
        if (log.isDebugEnabled()) {
            log.debug("DELETE FROM register_task_log WHERE task_id IN (SELECT id FROM register_task WHERE cid=" + contractId + ")");
            log.debug("DELETE FROM register_task WHERE cid=" + contractId);
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM register_task_log WHERE task_id IN (SELECT id FROM register_task WHERE cid=?)");
            ps.setInt(1, contractId);
            ps.executeUpdate();
            ps.close();
            ps = this.con.prepareStatement("DELETE FROM register_task WHERE cid=?");
            ps.setInt(1, contractId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getTaskCount(TaskFilter filter) {
        int result = 0;
        List fioParamsList = Utils.toList((String)filter.fioParams);
        StringBuffer query = new StringBuffer();
        query.append("SELECT COUNT(DISTINCT task.id) ");
        this.addFromString(filter, query, fioParamsList);
        query.append(" WHERE 1>0 ");
        this.addWhereString(filter, query);
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            this.setFioData(ps, fioParamsList);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<RegisterTask> getAfterDateTaskList(int contractId, Calendar fromDate) {
        ArrayList<RegisterTask> result = new ArrayList<RegisterTask>();
        String query = "SELECT * FROM register_task WHERE cid=? AND TO_DAYS(open_dt)>=TO_DAYS(?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)fromDate));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getTaskFromRS("", rs));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<RegisterTask> getNoClosedTaskList(int contractId) {
        ArrayList<RegisterTask> result = new ArrayList<RegisterTask>();
        String query = "SELECT * FROM register_task WHERE cid=? AND status IN (?, ?) ";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, 0);
            ps.setInt(3, 1);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getTaskFromRS("", rs));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<PersonalRegisterTask> getTaskList(TaskFilter filter, Page page) {
        StringBuffer query = new StringBuffer();
        List fioParamsList = Utils.toList((String)filter.fioParams);
        query.append("SELECT task.*, address.hid, address.flat, address.room, address.pod, address.floor, objecta.flat, objecta.room, objecta.pod, objecta.floor, contract.title, contract.comment, ");
        for (int i = 0; i < fioParamsList.size(); ++i) {
            query.append("fio").append(i).append(".val").append(",");
        }
        List<PhoneParam> phoneParamList = filter.getPhoneParams();
        if (phoneParamList.size() > 1) {
            query.append(" concat( ''");
            for (PhoneParam phoneParam : phoneParamList) {
                query.append(", if ( isNull(phone");
                query.append(phoneParam.paramId);
                query.append(phoneParam.paramType == 9 ? ".value" : ".val");
                query.append("), '', phone");
                query.append(phoneParam.paramId);
                query.append(phoneParam.paramType == 9 ? ".value" : ".val");
                query.append(" ), ' '");
            }
            query.append(" ) ");
        } else if (phoneParamList.size() > 0) {
            PhoneParam phoneParam = phoneParamList.get(0);
            query.append(" phone").append(phoneParam.paramId).append(phoneParam.paramType == 9 ? ".value" : ".val");
        } else {
            query.append(" ''");
        }
        query.append(" AS phone, house.*, quarter.title, street.title, city.title, area.title, object.title");
        this.addFromString(filter, query, fioParamsList);
        query.append(" WHERE 1>0 ");
        this.addWhereString(filter, query);
        query.append(" GROUP BY task.id ");
        StringBuilder order = new StringBuilder();
        for (String orderItem : filter.orders) {
            if (!Utils.notEmptyString((String)orderItem) || orderItem.equals("no")) continue;
            if (order.length() == 0) {
                order.append(" ORDER BY ");
            } else {
                order.append(",");
            }
            order.append(orderItem);
        }
        query.append((CharSequence)order);
        query.append(page.sqlLimit());
        ArrayList<PersonalRegisterTask> arrayList = new ArrayList<PersonalRegisterTask>(1000);
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            this.setFioData(ps, fioParamsList);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String tableName = rs.getString("address.hid") == null ? "objecta" : "address";
                    String fio = null;
                    for (int i = 0; i < fioParamsList.size(); ++i) {
                        String a = rs.getString("fio" + i + ".val");
                        if (a == null || a.length() <= 0) continue;
                        fio = a;
                    }
                    Object flat = rs.getString(tableName + ".flat");
                    String room = rs.getString(tableName + ".room");
                    if (room != null && room.length() > 0) {
                        flat = (String)flat + " (" + room + ")";
                    }
                    if (flat != null && ((String)flat).equals("0")) {
                        flat = "";
                    }
                    PersonalRegisterTask personalTask = PersonalRegisterTask.builder().setContract(rs.getString("contract.title")).setContractComment(rs.getString("contract.comment")).setObjectTitle(rs.getString("object.title")).setFio(fio).setPhone(rs.getString("phone")).setCity(rs.getString("city.title")).setStreet(rs.getString("street.title")).setArea(rs.getString("area.title")).setQuarter(rs.getString("quarter.title")).setStreet(rs.getString("street.title")).setHouse(rs.getString("house.house")).setPod(rs.getInt(tableName + ".pod")).setFloor(rs.getInt(tableName + ".floor")).setFlat((String)flat).build();
                    String frac = rs.getString("house.frac");
                    if (frac != null && frac.length() > 0) {
                        StringBuilder buf = new StringBuilder();
                        buf.append(personalTask.getHouse());
                        if (Character.isDigit(frac.charAt(0))) {
                            buf.append("/");
                        }
                        buf.append(frac);
                        personalTask.setHouse(buf.toString());
                    }
                    personalTask.setTask(this.getTaskFromRS("task.", rs));
                    arrayList.add(personalTask);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return arrayList;
    }

    public List<RegisterTaskType> getRegisterTaskTypeList(Set<Integer> groups) throws BGException {
        ArrayList<RegisterTaskType> list = new ArrayList<RegisterTaskType>();
        try {
            StringBuffer query = new StringBuffer();
            if (groups == null || groups.isEmpty()) {
                query.append("SELECT id, title FROM register_task_type ORDER BY title");
            } else {
                query.append("SELECT DISTINCT type.id, type.title FROM register_task_type AS type ");
                query.append("INNER JOIN register_group_task_type AS group_type ON type.id=group_type.type_id ");
                query.append("INNER JOIN register_group AS gr ON group_type.gid=gr.id ");
                query.append("WHERE gr.id IN ( ");
                query.append(Utils.toString(groups));
                query.append(" ) ORDER BY title");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(new RegisterTaskType(rs.getString(1), rs.getString(2)));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }

    private void addFromString(TaskFilter filter, StringBuffer query, List<String> fioParamsList) {
        query.append(" FROM register_task AS task  ");
        query.append(" LEFT JOIN object ON task.aobject_id=object.id");
        query.append(" LEFT JOIN object_param_value_address as objecta ");
        query.append(" ON object.id=objecta.object_id AND task.apid=param_id");
        query.append(" LEFT JOIN contract_parameter_type_2 AS address ");
        query.append(" ON task.cid=address.cid AND address.pid=task.apid AND task.aobject_id=0");
        query.append(" LEFT JOIN address_house AS house");
        query.append(" ON house.id=IF (address.hid IS NULL, objecta.hid, address.hid ) ");
        query.append(" LEFT JOIN address_quarter AS quarter");
        query.append(" ON house.quarterid=quarter.id ");
        query.append(" LEFT JOIN address_street AS street");
        query.append(" ON house.streetid=street.id");
        query.append(" LEFT JOIN address_area AS area");
        query.append(" ON house.areaid=area.id");
        query.append(" LEFT JOIN address_city AS city");
        query.append(" ON street.cityid=city.id");
        query.append(" LEFT JOIN contract");
        query.append(" ON task.cid=contract.id");
        for (int i = 0; i < fioParamsList.size(); ++i) {
            query.append(" LEFT JOIN contract_parameter_type_1 AS fio");
            query.append(i);
            query.append(" ON task.cid=fio");
            query.append(i);
            query.append(".cid AND fio");
            query.append(i);
            query.append(".pid=?");
        }
        for (PhoneParam param : filter.getPhoneParams()) {
            query.append(" LEFT JOIN contract_parameter_type_");
            if (param.paramType == 9) {
                query.append("phone");
            } else {
                query.append(param.paramType);
            }
            query.append(" AS phone");
            query.append(param.paramId);
            query.append(" ON task.cid=phone");
            query.append(param.paramId);
            query.append(".cid AND phone");
            query.append(param.paramId);
            query.append(".pid=");
            query.append(param.paramId);
        }
        if (Utils.notEmptyString((String)filter.executors)) {
            query.append(" INNER JOIN register_task_executor AS executors");
            query.append(" ON task.id=executors.tid AND executors.eid IN ( ");
            query.append(filter.executors);
            query.append(")");
        }
    }

    private void addWhereString(TaskFilter filter, StringBuffer query) {
        if (filter.id > 0) {
            query.append(" AND task.id=");
            query.append(filter.id);
        }
        if (Utils.notBlankString((String)filter.types)) {
            query.append(" AND task.type IN (");
            query.append(filter.types);
            query.append(") ");
        }
        if (filter.contractId > 0) {
            query.append(" AND task.cid=");
            query.append(filter.contractId);
        }
        if (Utils.notEmptyString((String)filter.statusMask)) {
            query.append(" AND task.status IN ( ");
            query.append(filter.statusMask);
            query.append(" )");
        }
        if (filter.processed >= 0) {
            query.append(" AND task.processed=");
            query.append(filter.processed);
        }
        if (filter.dateFrom != null) {
            query.append(" AND task.");
            query.append(filter.dateType);
            query.append(">='");
            query.append(TimeUtils.format((Calendar)filter.dateFrom, (String)"yyyy-MM-dd"));
            query.append("' ");
        }
        if (filter.dateTo != null) {
            query.append(" AND task.");
            query.append(filter.dateType);
            query.append("<DATE_ADD('");
            query.append(TimeUtils.format((Calendar)filter.dateTo, (String)"yyyy-MM-dd"));
            query.append("', INTERVAL 1 DAY )");
        }
        if (filter.addressFilter != null) {
            if (filter.addressFilter.getCityId() > 0) {
                query.append(" AND street.cityid=");
                query.append(filter.addressFilter.getCityId());
            }
            if (filter.addressFilter.getQuarterId() > 0) {
                query.append(" AND house.quarterid=");
                query.append(filter.addressFilter.getQuarterId());
            }
            if (filter.addressFilter.getStreetId() > 0) {
                query.append(" AND house.streetid=");
                query.append(filter.addressFilter.getStreetId());
            }
            if (filter.addressFilter.getHouseId() > 0) {
                query.append(" AND house.id=");
                query.append(filter.addressFilter.getHouseId());
            }
        }
        if (Utils.notEmptyString((String)filter.groups)) {
            query.append(" AND task.gr IN (");
            query.append(filter.groups);
            query.append(")");
        }
    }

    private void setFioData(PreparedStatement ps, List<String> fioParamsList) throws SQLException {
        for (int i = 0; i < fioParamsList.size(); ++i) {
            ps.setString(i + 1, fioParamsList.get(i).trim());
        }
    }

    private RegisterTask getTaskFromRS(String prefix, ResultSet rs) throws Exception {
        RegisterTask task = new RegisterTask();
        task.setId(rs.getInt(prefix + "id"));
        task.setTypeId(rs.getInt(prefix + "type"));
        task.setContractId(rs.getInt(prefix + "cid"));
        task.setAddressParamId(rs.getInt(prefix + "apid"));
        task.setAddressObjectId(rs.getInt(prefix + "aobject_id"));
        task.setOpenTime((Date)rs.getTimestamp(prefix + "open_dt"));
        task.setOpenUserId(rs.getInt(prefix + "open_uid"));
        task.setAcceptTime((Date)rs.getTimestamp(prefix + "accept_dt"));
        task.setAcceptUserId(rs.getInt(prefix + "accept_uid"));
        task.setCloseTime((Date)rs.getTimestamp(prefix + "close_dt"));
        task.setCloseUserId(rs.getInt(prefix + "close_uid"));
        task.setLastmodTime((Date)rs.getTimestamp(prefix + "lm_dt"));
        task.setLastmodUserId(rs.getInt(prefix + "lm_uid"));
        task.setStatus(rs.getInt(prefix + "status"));
        task.setProcessed(rs.getBoolean("processed"));
        task.setGroupId(rs.getInt(prefix + "gr"));
        task.setTargetDate((Date)rs.getTimestamp(prefix + "target_dt"));
        task.setComment(rs.getString(prefix + "comment"));
        task.setResolution(rs.getString(prefix + "resolution"));
        task.setProblemId(rs.getInt(prefix + "prid"));
        task.setExecuteDate((Date)rs.getDate(prefix + "execute_dt"));
        return task;
    }
}

