/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.services.ActionServiceConfigBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGLoggedEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.LogRequestParameters;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.client.CardSelectComboBox;
import ru.bitel.bgbilling.modules.cerbercrypt.client.ServiceConfigSynclog;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.ActivateEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.CustomEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.DosyncEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.GetSubscribeInfoEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.PairingEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.PasswordEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.PinCodeEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.client.editors.SendMessageEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.common.AvailableEditors;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.UserCardService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.UserDeviceService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;

public class UserCardPanel
extends BGUPanel {
    private BGUTable table;
    private UserCardTableModel model;
    private BGLoggedEditor editor;
    private UserCardService userCardService = null;
    private UserCardEditor userCardEditor = new UserCardEditor();
    private SubscriptionCostChecker subscrCostChecker = new SubscriptionCostChecker();

    public void jbInit() {
        this.model = new UserCardTableModel(UserCardTableModel.class.getName());
        this.table = new BGUTable((TableModel)((Object)this.model));
        this.editor = new BGLoggedEditor(this.subscrCostChecker.getName(), UserCardService.class);
        this.editor.addForm((JComponent)((Object)this.subscrCostChecker), new LogRequestParameters(){

            public Object[] getArgs() {
                return new Object[]{((ClientContext)UserCardPanel.this.getContext()).getContractId()};
            }

            public String getFilter() {
                return "cid";
            }
        });
        this.editor.addForm((JComponent)((Object)this.userCardEditor), new LogRequestParameters(){

            public Object[] getArgs() {
                return new Object[]{UserCardPanel.this.userCardEditor.current.getId()};
            }

            public String getFilter() {
                return "oid";
            }
        });
        this.editor.show(this.subscrCostChecker.getName());
        this.editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this.table, "enabled", "oldValue"));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserCardPanel.this.performAction("edit");
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                UserCard currentRow = (UserCard)UserCardPanel.this.model.getSelectedRow();
                if (currentRow != null && currentRow.getId() >= 0) {
                    UserCardPanel.this.onSelectedTableRow(currentRow);
                }
            }
        });
        this.performAction("sysinfo");
    }

    private UserCardService getUserCardService() {
        if (this.userCardService == null) {
            this.userCardService = (UserCardService)((ClientContext)this.getContext()).getPort(UserCardService.class);
        }
        return this.userCardService;
    }

    protected void onSelectedTableRow(UserCard selectedRow) {
        ActionMap actionMap = this.userCardEditor.getActionMap();
        Action releaseSlaveAction = actionMap.get("userCard.releaseSlave");
        releaseSlaveAction.setEnabled(selectedRow.getBasecardId() > 0);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            List poolList = null;
            poolList = ((ClientContext)this.getContext()).getObjectId() > 0 ? this.getUserCardService().getCardListByObject(((ClientContext)this.getContext()).getObjectId()) : this.getUserCardService().getUserCardList(((ClientContext)this.getContext()).getContractId(), true);
            this.model.setData(poolList);
            List objectList = this.getUserCardService().getContractObjects(((ClientContext)this.getContext()).getContractId());
            objectList.add(0, new IdTitle(-1, " --- "));
            this.userCardEditor.objectBox.setData(objectList);
            List devicesList = ((UserDeviceService)((ClientContext)this.getContext()).getPort(UserDeviceService.class)).getUserDevicesList();
            List idTitles = devicesList.stream().map(f -> new IdTitle(f.getId(), f.getTitle())).collect(Collectors.toList());
            idTitles.add(0, new IdTitle(-1, " --- "));
            this.userCardEditor.devicesBox.setData(idTitles);
            this.userCardEditor.cardNumber.refreshData();
        });
        new AbstractBGUPanel.DefaultAction("sysinfo", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                MapHolder dm = UserCardPanel.this.getUserCardService().getSystemInfo();
                String sa = (String)dm.getMap().get("sa");
                if (AvailableEditors.SendMessageEditor.isEnable(sa)) {
                    UserCardPanel.this.editor.addForm((JComponent)((Object)new SendMessageEditor(UserCardPanel.this.table, true)));
                }
                if (AvailableEditors.PinCodeEditor.isEnable(sa)) {
                    UserCardPanel.this.editor.addForm((JComponent)((Object)new PinCodeEditor(UserCardPanel.this.table)));
                }
                if (AvailableEditors.ActivateEditor.isEnable(sa)) {
                    UserCardPanel.this.editor.addForm((JComponent)((Object)new ActivateEditor(UserCardPanel.this.table)));
                }
                if (AvailableEditors.GetSubscribeInfoEditor.isEnable(sa)) {
                    UserCardPanel.this.editor.addForm((JComponent)((Object)new GetSubscribeInfoEditor(UserCardPanel.this.table)));
                }
                if (AvailableEditors.PairingEditor.isEnable(sa)) {
                    UserCardPanel.this.editor.addForm((JComponent)((Object)new PairingEditor(UserCardPanel.this.table)));
                }
                UserCardPanel.this.editor.addForm((JComponent)((Object)new PasswordEditor(UserCardPanel.this.table)));
                UserCardPanel.this.editor.addForm((JComponent)((Object)new DosyncEditor(UserCardPanel.this.table)));
                for (String ce : AvailableEditors.getCustomEditors((String)sa)) {
                    UserCardPanel.this.editor.addForm((JComponent)((Object)new CustomEditor(UserCardPanel.this.table, ce)));
                }
                BGSwingUtilites.buildPopupMenu((JComponent)UserCardPanel.this.table, (Container)UserCardPanel.this.editor, (String)"");
            }
        };
    }

    protected class UserCardEditor
    extends BGUPanel {
        protected UserCard current;
        private CardSelectComboBox cardNumber;
        private BGControlPanelPeriodNoB periodPanel;
        private JTextArea commentTA;
        private BGControlPanelDateNoB subscrDate;
        private BGUComboBox<IdTitle> baseCards;
        private JLabel thisSlaveBaseCardsLabel;
        private BGUComboBox<IdTitle> objectBox;
        private BGUComboBox<IdTitle> devicesBox;
        private BGTextField snText;

        protected UserCardEditor() {
            this.cardNumber = new CardSelectComboBox((ClientContext)UserCardPanel.this.getContext());
            this.periodPanel = new BGControlPanelPeriodNoB();
            this.commentTA = new JTextArea();
            this.subscrDate = new BGControlPanelDateNoB();
            this.baseCards = new BGUComboBox();
            this.thisSlaveBaseCardsLabel = new JLabel();
            this.objectBox = new BGUComboBox();
            this.devicesBox = new BGUComboBox();
            this.snText = new BGTextField();
        }

        protected void jbInit() {
            this.commentTA.setLineWrap(true);
            this.commentTA.setWrapStyleWord(true);
            JPanel panel1 = new JPanel(new GridBagLayout());
            panel1.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel1.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel1.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel1.add((Component)this.cardNumber, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel1.add((Component)new JLabel("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u0447\u0435\u0440\u0435\u0437 WEB \u0441 : "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel1.add((Component)this.subscrDate, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel1.add((Component)new JLabel("\u0411\u0430\u0437\u043e\u0432\u0430\u044f \u043a\u0430\u0440\u0442\u0430: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel1.add((Component)this.baseCards, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel1.add((Component)this.thisSlaveBaseCardsLabel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel1.add((Component)new JLabel("\u041e\u0431\u044a\u0435\u043a\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: "), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel1.add((Component)this.objectBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel1.add((Component)new JLabel("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e: "), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel1.add((Component)this.devicesBox, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel1.add((Component)new JLabel("S/N: "), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
            panel1.add((Component)this.snText, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            JPanel leftPanel = new JPanel(new GridBagLayout());
            leftPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b "));
            leftPanel.add((Component)panel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            leftPanel.add(Box.createGlue(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            JPanel rightPanel = new JPanel(new GridBagLayout());
            rightPanel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
            rightPanel.add((Component)new JScrollPane(this.commentTA), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add(leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(rightPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void fillMultiroomBasecards() throws BGException {
            List basecards = UserCardPanel.this.getUserCardService().getMultiroomBasecards(((ClientContext)UserCardPanel.this.getContext()).getContractId(), this.current.getId());
            List idTitles = basecards.stream().map(f -> new IdTitle(f.getId(), f.getGuiTitle())).collect(Collectors.toList());
            idTitles.add(0, new IdTitle(-1, " --- "));
            this.baseCards.setData(idTitles);
            this.baseCards.setSelectedItem((Object)this.current.getBasecardId());
        }

        private void enableComboBoxBasecards() {
            this.baseCards.setVisible(true);
            this.thisSlaveBaseCardsLabel.setVisible(false);
        }

        private void disableComboBoxBasecards(String reason) {
            this.baseCards.setVisible(false);
            this.thisSlaveBaseCardsLabel.setText("\u041d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e. " + reason);
            this.thisSlaveBaseCardsLabel.setVisible(true);
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                this.current = new UserCard();
                this.current.setId(-1);
                this.current.setContractId(((ClientContext)UserCardPanel.this.getContext()).getContractId());
                this.cardNumber.setValue(0L);
                this.commentTA.setText("");
                this.periodPanel.setDateString2("");
                this.periodPanel.setDateCalendar1((Calendar)new GregorianCalendar());
                this.subscrDate.setLocalDate(null);
                this.objectBox.setSelectedIndex(0);
                this.devicesBox.setSelectedIndex(0);
                this.snText.setText("");
                this.fillMultiroomBasecards();
                this.enableComboBoxBasecards();
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                this.current = (UserCard)UserCardPanel.this.model.getSelectedRow();
                if (this.current != null) {
                    this.current = UserCardPanel.this.getUserCardService().getUserCard(this.current.getId());
                    this.cardNumber.setValue(this.current.getNumber());
                    this.commentTA.setText(this.current.getComment());
                    this.periodPanel.setDateCalendar1(TimeUtils.convertDateToCalendar((Date)this.current.getDate1()));
                    this.periodPanel.setDateCalendar2(TimeUtils.convertDateToCalendar((Date)this.current.getDate2()));
                    this.subscrDate.setLocalDate(TimeUtils.convertDateToLocalDate((Date)this.current.getSubscrDate()));
                    this.objectBox.setSelectedItem((Object)this.current.getObjectId());
                    this.devicesBox.setSelectedItem((Object)this.current.getUserdeviceId());
                    this.snText.setText(this.current.getUserdeviceSN());
                    if (this.current.getSlavecardsNumber() > 0) {
                        this.disableComboBoxBasecards(this.current.getBasecardTitle());
                    } else if (this.current.getBasecardId() > 0) {
                        this.disableComboBoxBasecards(this.current.getBasecardTitle());
                    } else {
                        this.fillMultiroomBasecards();
                        this.enableComboBoxBasecards();
                    }
                    this.performActionOpen();
                }
            });
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                this.current = (UserCard)UserCardPanel.this.model.getSelectedRow();
                if (this.current != null && this.current.getId() >= 0 && BGSwingUtilites.confirmDelete((String)this.current.getGuiTitle())) {
                    UserCardPanel.this.getUserCardService().deleteUserCard(this.current.getId());
                    UserCardPanel.this.performAction("refresh");
                    this.performActionClose();
                }
            });
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (UserCardEditor.this.current != null) {
                        if (UserCardEditor.this.cardNumber.getValue() <= 0L) {
                            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b!");
                            return;
                        }
                        if (Utils.isEmptyString((String)UserCardEditor.this.periodPanel.getDateString1())) {
                            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                            return;
                        }
                        UserCard uc = new UserCard();
                        uc.setId(UserCardEditor.this.current.getId());
                        uc.setContractId(UserCardEditor.this.current.getContractId());
                        uc.setComment(UserCardEditor.this.commentTA.getText());
                        uc.setDate1(UserCardEditor.this.periodPanel.getDateFrom());
                        uc.setDate2(UserCardEditor.this.periodPanel.getDateTo());
                        uc.setNumber(UserCardEditor.this.cardNumber.getValue());
                        uc.setSubscrDate(TimeUtils.convertCalendarToDate((Calendar)UserCardEditor.this.subscrDate.getDateCalendar()));
                        uc.setObjectId(((IdTitle)UserCardEditor.this.objectBox.getSelectedItem()).getId());
                        uc.setUserdeviceId(((IdTitle)UserCardEditor.this.devicesBox.getSelectedItem()).getId());
                        uc.setUserdeviceSN(UserCardEditor.this.snText.getText());
                        if (UserCardEditor.this.baseCards.isVisible()) {
                            uc.setBasecardId(UserCardEditor.this.baseCards.getSelectedItem() != null ? ((IdTitle)UserCardEditor.this.baseCards.getSelectedItem()).getId() : -1);
                        } else {
                            uc.setBasecardId(UserCardEditor.this.current.getBasecardId());
                        }
                        UserCardPanel.this.getUserCardService().updateUserCard(uc);
                        UserCardPanel.this.performAction("refresh");
                        UserCardEditor.this.performActionClose();
                    }
                }
            };
            new AbstractBGUPanel.MenuAction("userCard.releaseSlave", "\u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u043a\u0430\u0440\u0442\u0443"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    UserCardEditor.this.current = (UserCard)UserCardPanel.this.model.getSelectedRow();
                    if (UserCardEditor.this.current != null && UserCardEditor.this.current.getId() >= 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0431\u0440\u0430\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0443 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0439 \u043a\u0430\u0440\u0442\u044b " + UserCardEditor.this.current.getGuiTitle() + " \u043a \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439?\n\u042d\u0442\u043e \u0437\u0430\u043a\u0440\u043e\u0435\u0442 \u044d\u0442\u0443 \u043a\u0430\u0440\u0442\u0443-\u043a\u043e\u043f\u0438\u044e.", "\u041e\u0442\u0432\u044f\u0437\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0443?", 0) == 0) {
                        UserCardPanel.this.getUserCardService().releaseSlave(((ClientContext)UserCardPanel.this.getContext()).getContractId(), UserCardEditor.this.current.getId());
                        UserCardPanel.this.performAction("refresh");
                    }
                }
            };
            new AbstractBGUPanel.MenuAction("userCard.openSynclog", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043b\u043e\u0433 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0439"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    UserCardEditor.this.current = (UserCard)UserCardPanel.this.model.getSelectedRow();
                    if (UserCardEditor.this.current != null && UserCardEditor.this.current.getId() >= 0) {
                        ActionServiceConfigBase.openServiceConfig((int)((ClientContext)UserCardPanel.this.getContext()).getModuleId(), (String)ServiceConfigSynclog.class.getName(), (Object)UserCardEditor.this.current.getNumber());
                    }
                }
            };
        }
    }

    protected class SubscriptionCostChecker
    extends BGUPanel {
        private BGControlPanelDateNoB costDate = new BGControlPanelDateNoB();
        private JLabel costLabel = new JLabel();

        protected SubscriptionCostChecker() {
        }

        protected void jbInit() {
            this.setLayout(new GridBagLayout());
            this.add(new JLabel("C\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043a\u0430\u0440\u0442 \u043d\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.costDate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            JButton showCostButton = new JButton("\u0434\u043d\u0435\u0432\u043d\u043e\u0439 =");
            this.add(showCostButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            JButton showCostButtonMonth = new JButton("\u043c\u0435\u0441\u044f\u0447\u043d\u043e\u0439 \u2248");
            this.add(showCostButtonMonth, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.costLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.costDate.setLocalDate(LocalDate.now());
            showCostButton.addActionListener(e -> this.performAction("check"));
            showCostButtonMonth.addActionListener(e -> this.performAction("check_month"));
        }

        void check(boolean forMonth) throws BGException {
            int cid = ((ClientContext)UserCardPanel.this.getContext()).getContractId();
            List ucids = UserCardPanel.this.model.getSelectedRows().stream().map(uc -> uc.getId()).collect(Collectors.toList());
            Date date = TimeUtils.convertCalendarToDate((Calendar)this.costDate.getDateCalendar());
            if (!ucids.isEmpty() && date != null) {
                BigDecimal cost = UserCardPanel.this.getUserCardService().checkSubscriptionCost(cid, ucids, date);
                if (forMonth) {
                    int month = this.costDate.getDateCalendar().getActualMaximum(5);
                    cost = cost.multiply(new BigDecimal(month));
                }
                this.costLabel.setText(Utils.formatCost((BigDecimal)cost));
            } else {
                this.costLabel.setText("? \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u043a\u0430\u0440\u0442\u044b \u0438\u043b\u0438 \u0434\u0430\u0442\u0430");
            }
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("check", "="){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    SubscriptionCostChecker.this.check(false);
                }
            };
            new AbstractBGUPanel.DefaultAction("check_month", "check_month"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    SubscriptionCostChecker.this.check(true);
                }
            };
        }
    }

    class UserCardTableModel
    extends BGTableModel<UserCard> {
        public UserCardTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u0430\u0440\u0442\u0430", 150, 150, 150, "number", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u0447\u0435\u0440\u0435\u0437 WEB \u0441", 200, 200, 200, "subscrDate", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438", 150, 150, -1, "basecardTitle", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0440\u0435\u0431.\u0441\u0438\u043d\u0445\u0440", 50, 100, 150, "needSync", true);
            this.addColumn("Pairing", 70, 100, 150, "pairingModule", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(UserCard val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("period".equals(identifier)) {
                return TimeUtils.formatPeriod((Date)val.getDate1(), (Date)val.getDate2());
            }
            if ("number".equals(identifier)) {
                return val.format();
            }
            if ("basecardTitle".equals(identifier)) {
                return val.getBasecardTitle();
            }
            return super.getValue((Object)val, column);
        }
    }
}

