/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogGroup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class BotDialogGroupDao
extends AbstractIdDao<BotDialogGroup> {
    public BotDialogGroupDao(Connection connection, int moduleId) {
        this(connection, moduleId, "bot_dialog_group");
    }

    private BotDialogGroupDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public List<BotDialogGroup> getGroupList() throws BGException {
        return super.list(null, null, new Object[0]);
    }

    protected BotDialogGroup getFromRS(ResultSet rs) throws SQLException, BGException {
        BotDialogGroup group = new BotDialogGroup();
        group.setId(rs.getInt("id"));
        group.setTitle(rs.getString("title"));
        group.setComment(rs.getString("comment"));
        group.setDialogIds(rs.getString("dialog_ids"));
        return group;
    }

    protected void updateImpl(BotDialogGroup group) throws BGException, SQLException {
        Object set = " SET title=?, comment=? ";
        if (Utils.notBlankString((String)group.getDialogIds())) {
            set = (String)set + ", dialog_ids=?";
        }
        String query = group.getId() > 0 ? "UPDATE " + this.tableName + (String)set + " WHERE id=?" : "INSERT INTO " + this.tableName + (String)set;
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, group.getTitle());
            ps.setString(index++, group.getComment());
            if (Utils.notBlankString((String)group.getDialogIds())) {
                ps.setString(index++, group.getDialogIds());
            }
            if (group.getId() > 0) {
                ps.setInt(index, group.getId());
            }
            ps.executeUpdate();
            if (group.getId() <= 0) {
                group.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

