<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

<xsl:output method="html" encoding="UTF-8" indent="yes"/>

<xsl:template match="/">
   <html>
   <head>
   <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
   </head>
    <body>
    <center>
        <xsl:call-template name="head"/><br/>
        <xsl:call-template name="table"/><br/>
        <xsl:call-template name="sums"/>
    </center>
    </body>
    </html>
</xsl:template>

<xsl:template name="head">
    <xsl:for-each select="/data/table">
         <h2><xsl:value-of select="@reportTitle"/><br/>
         Контракт:&#160;<xsl:value-of select="@contractTitle"/>(<xsl:value-of select="@comment"/>)
         </h2><br/>
         Логин:<xsl:value-of select="@login"/>&#160;Период с: <xsl:value-of select="@date1"/> по <xsl:value-of select="@date2"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="table">
<table width="100%" border="1" cellspacing="0" cellpadding="3">
     <tr bgcolor="#f0f0f0">         
         <td>Направление</td>
         <td>Количество сессий</td>
         <td>Время</td>
         <td>Окр. время</td>
         <td>Стоимость</td>
     </tr>
     <xsl:for-each select="/data/table/data/row">
         <tr bgcolor="#ffffff">
             <td><xsl:value-of select="@dest"/></td>
             <td><xsl:value-of select="@count"/></td>
             <td><xsl:value-of select="@time"/></td>
             <td><xsl:value-of select="@round_time"/></td>
             <td><xsl:value-of select="@cost"/></td>
         </tr>
     </xsl:for-each>
</table>
</xsl:template>

<xsl:template name="sums">
    <br/>
	Количество сессий:&#160;<xsl:value-of select="sum(/data/table/data/row/@count)"/>&#160;
    Время [сек.][мин.]:&#160;<xsl:value-of select="/data/table/data/@time_amount"/>&#160;
	Стоимость:&#160;<xsl:value-of select="/data/table/data/@money_amount"/>&#160;
</xsl:template>

</xsl:stylesheet>
