/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.action.web;

import jakarta.annotation.Resource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionDetailOrder;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

@WebAction(title="Voice")
public class ActionVoice
extends AbstractAction {
    @Resource
    VoiceAccountService voiceAccountService;

    public ActionVoice() {
        super("voice");
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432")
    public void accounts() throws BGException {
        LocalDate fromDate = LocalDate.now().minusMonths(1L).withDayOfMonth(1);
        this.setResultParam("accountList", this.voiceAccountService.voiceAccountList(this.contractId, -1, new Period(fromDate, null)));
        this.requestDispatcher(this.moduleName, "accounts");
    }

    @WebOperation(title="\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f")
    public void accountSessionDetail() throws BGException {
        LocalDate date = LocalDate.now();
        ArrayList<String> years = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            years.add(String.valueOf(date.minusYears(i).getYear()));
        }
        this.setResultParam("years", years);
        this.setResultParam("month", (date.getMonthValue() > 9 ? "" : "0") + date.getMonthValue());
        int accountId = this.req.getInt("accountId", 0);
        VoiceAccount voiceAccount = this.voiceAccountService.voiceAccountGet(accountId);
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
            Contract contract = (Contract)contractDao.get(this.contractId);
            if (voiceAccount != null && contract != null && (voiceAccount.getContractId() == this.contractId || voiceAccount.getContractId() == contract.getSuperCid())) {
                this.setResultParam("account", voiceAccount);
                this.setResultParam("orders", this.voiceAccountService.voiceSessionDetailOrderList(voiceAccount.getId(), this.contractId));
            } else {
                this.setResultParam("account", "Account not found [#" + accountId + "]");
            }
        }
        this.setResultParam("accountId", accountId);
        this.requestDispatcher(this.moduleName, "voice_session_detail");
    }

    @WebOperation(title="\u0417\u0430\u043a\u0430\u0437 \u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438")
    public void accountSessionDetailOrder() throws BGException {
        int accountId = this.req.getInt("accountId", 0);
        ActionMessage message = new ActionMessage("voiceRoot", "accountSessionDetail", "voiceQuery", "\u0417\u0430\u043a\u0430\u0437 \u043f\u0440\u0438\u043d\u044f\u0442 \u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u043d\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443");
        message.setQueryParamList(Arrays.asList(new KeyValue("accountId", String.valueOf(accountId))));
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
            int month = this.req.getInt("month", 12);
            int year = this.req.getInt("year", 3000);
            if (LocalDate.of(year, month, 1).isAfter(LocalDate.now().withDayOfMonth(1))) {
                throw new BGException("\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434");
            }
            String email = this.req.get("email");
            String emailSend = this.req.get("emailSend", "none");
            if (Utils.isBlankString((String)email) && !VoiceSessionDetailOrder.EmailSend.NONE.name().equals(emailSend)) {
                throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d e-mail");
            }
            VoiceAccount voiceAccount = this.voiceAccountService.voiceAccountGet(this.req.getInt("accountId", 0));
            Contract contract = (Contract)contractDao.get(voiceAccount.getContractId());
            if (voiceAccount == null || contract == null || voiceAccount.getContractId() != this.contractId && voiceAccount.getContractId() != contract.getSuperCid()) {
                throw new BGException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            VoiceSessionDetailOrder order = VoiceSessionDetailOrder.builder().setCreateDate(new Date()).setStatus(VoiceSessionDetailOrder.Status.WAIT).setContractId(this.contractId).setAccountId(accountId).setFormatType(VoiceSessionDetailOrder.FormatType.valueOf((String)this.req.get("format", VoiceSessionDetailOrder.FormatType.PDF.name()))).setMonth(month).setYear(year).setEmail(email).setEmailSend(VoiceSessionDetailOrder.EmailSend.valueOf((String)emailSend)).build();
            this.voiceAccountService.voiceSessionDetailOrderDelete(order);
            this.voiceAccountService.voiceSessionDetailOrderUpdate(order);
        }
        catch (Exception ex) {
            message.setOnClose("close");
            message.setError(ex.getMessage());
        }
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }
}

