/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.tariff.tree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.smarthouse.client.common.BooleanEditor;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageOption;
import ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHousePackageService;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class SmartHousePackageOptionTariffTreeNode
extends DefaultTariffTreeNode {
    private static final String KEY_NAME = "name";
    private static final String KEY_TITLE = "title";
    private static final String KEY_SELECTED = "selected";
    private static final String KEY_OPTION_NAMES = "optionNames";
    private static Icon icon = ClientUtils.getIcon((String)"filter");
    private Editor editor = new Editor();
    private JLabel view = new JLabel(icon);
    private List<RowData> listOptions = null;

    public Component getView() {
        this.loadData();
        StringBuffer str = new StringBuffer("<html>");
        str.append("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043e\u043f\u0446\u0438\u044f\u043c \u043f\u0430\u043a\u0435\u0442\u0430:");
        for (RowData rowData : this.getOptionList()) {
            if (!rowData.getJson().getBoolean(KEY_SELECTED)) continue;
            str.append("<br>&nbsp;&nbsp;&nbsp;-&nbsp;").append(rowData.getJson().optString(KEY_TITLE));
        }
        str.append("</html>");
        this.view.setHorizontalAlignment(2);
        this.view.setText(str.toString());
        return this.view;
    }

    protected JPanel getEditorPanel() {
        if (this.editor == null) {
            this.editor = new Editor();
        }
        return this.editor;
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        StringBuffer buffer = new StringBuffer();
        this.listOptions.stream().filter(e -> e.getJson().optBoolean(KEY_SELECTED, false)).forEach(e -> buffer.append(e.getJson().optString(KEY_NAME)).append(","));
        data.put(KEY_OPTION_NAMES, buffer.toString());
        this.setDataInHash(data);
    }

    protected void loadData() {
        Map dataMap = this.getDataInHash();
        String optionNames = dataMap.getOrDefault(KEY_OPTION_NAMES, "");
        List<String> names = Arrays.asList(optionNames.split(","));
        for (RowData rowData : this.getOptionList()) {
            rowData.getJson().put(KEY_SELECTED, names.contains(rowData.getJson().getString(KEY_NAME)));
        }
    }

    private List<RowData> getOptionList() {
        if (this.listOptions == null) {
            this.listOptions = new ArrayList<RowData>();
            ClientContext clientContext = new ClientContext("smarthouse", this.getDirManager().getModuleId(), 0, null);
            SmartHousePackageService smartHousePackageService = (SmartHousePackageService)clientContext.getPort(SmartHousePackageService.class);
            try {
                for (SmartHousePackageOption packageOption : smartHousePackageService.packageOptionList()) {
                    JSONObject json = new JSONObject();
                    json.put(KEY_NAME, (Object)packageOption.getName());
                    json.put(KEY_TITLE, (Object)packageOption.getTitle());
                    json.put(KEY_SELECTED, false);
                    this.listOptions.add(new RowData(json));
                }
                this.editor.tableModel.setData(this.listOptions);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
        return this.listOptions;
    }

    class Editor
    extends JPanel {
        private PackageOptionTableModel tableModel;

        public Editor() {
            super(new GridBagLayout());
            this.tableModel = new PackageOptionTableModel(PackageOptionTableModel.class.getName());
            BGUTable table = new BGUTable((TableModel)((Object)this.tableModel)){

                public TableCellEditor getCellEditor(int row, int column) {
                    return new BooleanEditor();
                }
            };
            table.setSelectionMode(0);
            JScrollPane scrollPane = new JScrollPane((Component)table);
            scrollPane.setPreferredSize(new Dimension(500, 200));
            this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        }
    }

    class PackageOptionTableModel
    extends BGTableModel<RowData> {
        public PackageOptionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("", Boolean.class, 50, 50, 50, SmartHousePackageOptionTariffTreeNode.KEY_SELECTED, true);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u043f\u0446\u0438\u0438", 300, 400, -1, SmartHousePackageOptionTariffTreeNode.KEY_TITLE, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if (SmartHousePackageOptionTariffTreeNode.KEY_TITLE.equals(identifier)) {
                return rowData.getJson().optString(identifier);
            }
            if (SmartHousePackageOptionTariffTreeNode.KEY_SELECTED.equals(identifier)) {
                return rowData.getJson().optBoolean(identifier);
            }
            return super.getValue((Object)rowData, column);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return SmartHousePackageOptionTariffTreeNode.KEY_SELECTED.equals(this.getIdentifier(columnIndex));
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ((RowData)this.getRows().get(rowIndex)).getJson().put(SmartHousePackageOptionTariffTreeNode.KEY_SELECTED, ((Boolean)value).booleanValue());
        }
    }
}

