/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sbpilot.server.bean;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.sbpilot.server.bean.SBPilotTerminal;
import ru.bitel.bgbilling.server.util.UserSession;
import ru.bitel.common.ParameterMap;

public class SBPilotTerminalManager {
    private static final String SESSION_CurrentTerminalId = "ru.bitel.bgbilling.plugins.sbpilot.CurrentTerminalId";
    private static final Logger log = LogManager.getLogger();
    private static volatile Map<Integer, SBPilotTerminal> terminalMap = null;

    private static Map<Integer, SBPilotTerminal> getTerminalMap() {
        if (terminalMap == null) {
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.sbpilot");
            SortedMap list = plugin.getSetup().subIndexed("cashserver.");
            terminalMap = new HashMap<Integer, SBPilotTerminal>();
            for (Map.Entry frItem : list.entrySet()) {
                try {
                    SBPilotTerminal p = new SBPilotTerminal();
                    int id = (Integer)frItem.getKey();
                    ParameterMap frConfig = (ParameterMap)frItem.getValue();
                    p.setId(id);
                    p.setTitle(frConfig.get("title"));
                    p.setConnector(frConfig.get("connector"));
                    terminalMap.put(id, p);
                }
                catch (Exception e) {
                    log.error("sbpilot: \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430 cashserver." + frItem.getKey() + " \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b \u0438 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u044e\u0442\u0441\u044f", (Throwable)e);
                }
            }
        }
        return terminalMap;
    }

    public static Collection<SBPilotTerminal> getTerminals() {
        return SBPilotTerminalManager.getTerminalMap().values();
    }

    public static SBPilotTerminal getTerminal(int terminalId) throws BGException {
        Map<Integer, SBPilotTerminal> terminals = SBPilotTerminalManager.getTerminalMap();
        SBPilotTerminal terminal = terminals.get(terminalId);
        if (terminal == null) {
            throw new BGException("\u0422\u0435\u0440\u043c\u0438\u043d\u0430\u043b#" + terminalId + " \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        return terminal;
    }

    public static void setCurrentTerminal(int terminalId) {
        if (terminalId > 0) {
            UserSession.getInstance().setAttribute(SESSION_CurrentTerminalId, (Object)terminalId);
        } else {
            UserSession.getInstance().removeAttribute(SESSION_CurrentTerminalId);
        }
    }

    public static int getCurrentTerminalId() {
        Integer terminalId = (Integer)UserSession.getInstance().getAttribute(SESSION_CurrentTerminalId);
        int id = terminalId != null ? terminalId : 0;
        return id;
    }

    public static void resetCache() {
        terminalMap = null;
    }
}

