/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.qiwi.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.qiwi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatusRest;
import ru.bitel.bgbilling.modules.qiwi.common.service.QiwiService;
import ru.bitel.bgbilling.modules.qiwi.server.bean.QiwiProtocolFactory;
import ru.bitel.bgbilling.modules.qiwi.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.qiwi.common.service.QiwiService")
public class QiwiServiceImpl
extends AbstractService
implements QiwiService {
    private TransactionManager manager;

    @PostConstruct
    private void init() {
        this.manager = new TransactionManager(this.getConnection(), this.moduleId);
    }

    public void checkPayment(int contractId, PeriodWithTime period) throws BGException {
        String status = "soap".equals(this.getModuleSetup().get("qiwi.protocol.version")) ? TransactionStatus.EXPOSED.getCode() : TransactionStatusRest.WAITING.getCode();
        SearchResult<Transaction> searchResult = this.searchTransactionList(contractId <= 0 ? -1 : contractId, null, status, period, null);
        for (Transaction transaction : searchResult.getList()) {
            QiwiProtocolFactory.getInstance().getCurrentProtocol(this.getConnection(), this.moduleId).checkTransaction(transaction);
        }
    }

    public SearchResult<Transaction> searchTransactionList(int contractId, String contractTitle, String status, PeriodWithTime period, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(period, page);
        this.manager.searchTransaction((SearchResult<Transaction>)searchResult, contractId, contractTitle, status);
        return searchResult;
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws BGException {
        String failureUrl;
        if (mode != null) {
            mode.value = "redirect";
        }
        if (paramsHolder == null) {
            throw new BGIllegalArgumentException("params");
        }
        if (paramsHolder.value == null) {
            throw new BGIllegalArgumentException("params.value");
        }
        ModuleSetup moduleSetup = this.getModuleSetup();
        Map params = ((MapHolder)paramsHolder.value).getMap();
        String phone = (String)params.get("phone");
        BigDecimal sumMin = moduleSetup.getBigDecimal("qiwi.sum.min", new BigDecimal(100));
        BigDecimal sumMax = moduleSetup.getBigDecimal("qiwi.sum.max", new BigDecimal(5000));
        if (amount == null || amount.compareTo(BigDecimal.ZERO) <= 0 || amount.compareTo(sumMin) < 0 || amount.compareTo(sumMax) > 0) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
        }
        if (Utils.isBlankString((String)phone)) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430!", "phone.required");
        }
        if (!phone.startsWith("7")) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0435\u043b\u0435\u0444\u043e\u043d!", "phone.incorrect");
        }
        phone.substring(1);
        Pattern pattern = Pattern.compile("\\d{1,15}");
        Matcher matcher = pattern.matcher(phone);
        if (!matcher.find()) {
            throw new BGMessageException("\u041f\u043e\u043b\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043e\u0442 1 \u0434\u043e 15 \u0446\u0438\u0444\u0440!", "phone.incorrect");
        }
        String successUrl = params != null ? (String)params.get("successUrl") : null;
        String string = failureUrl = params != null ? (String)params.get("failureUrl") : null;
        if (Utils.isBlankString((String)successUrl)) {
            successUrl = moduleSetup.get("qiwi.success.url");
        }
        if (Utils.isBlankString((String)failureUrl)) {
            failureUrl = moduleSetup.get("qiwi.fail.url");
        }
        String redirectUrl = QiwiProtocolFactory.getInstance().getCurrentProtocol(this.getConnection(), this.moduleId).beginTransaction(contractId, phone, amount, successUrl, failureUrl);
        url.value = redirectUrl;
        if (paramsHolder != null) {
            paramsHolder.value = null;
        }
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException, BGMessageException, BGIllegalArgumentException, BGIllegalAccessException {
    }

    public void cancelTransaction(int transactionId) throws BGException {
        Transaction transaction = this.manager.getTransaction(transactionId);
        QiwiProtocolFactory.getInstance().getCurrentProtocol(this.getConnection(), this.moduleId).cancelTransaction(transaction);
    }

    public void refundTransaction(int transactionId) throws BGException {
        Transaction transaction = this.manager.getTransaction(transactionId);
        QiwiProtocolFactory.getInstance().getCurrentProtocol(this.getConnection(), this.moduleId).refundTransaction(transaction);
    }

    public void checkRefundStatus(int transactionId) throws BGException {
        Transaction transaction = this.manager.getTransaction(transactionId);
        QiwiProtocolFactory.getInstance().getCurrentProtocol(this.getConnection(), this.moduleId).checkRefundStatus(transaction);
    }
}

