/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.packer.client.kit;

import bitel.billing.module.common.BGTabbedPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGCheckListCellRenderer;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.plugins.packer.client.kit.PackerKitConfiguritonPanel;
import ru.bitel.bgbilling.plugins.packer.common.bean.PackerKit;
import ru.bitel.bgbilling.plugins.packer.common.bean.PackerOptionHandler;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class PackerKitConfiguritonEditorPanel
extends BGUPanel {
    private ParamRowData paramTitle = new ParamRowData("title", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "");
    private ParamRowData paramDependence = new ParamRowData("dependence", "\u0417\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c", "");
    private ParamRowData paramCompatibility = new ParamRowData("compatibility", "\u0421\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c", "");
    private ParamRowData paramHandlerClass = new ParamRowData("class", "\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430", "");
    private List<ParamRowData> params = Arrays.asList(this.paramTitle);
    private PackerKit packerKit;
    private JSONObject data;
    private RowData currentOption;
    private KitOptionTableModel optionTableModel;
    private KitOptionParamTableModel optionParamTableModel;
    private PackerKitConfiguritonPanel parentPanel;
    private BGTabbedPane tabbedPane = new BGTabbedPane();

    public PackerKitConfiguritonEditorPanel(PackerKitConfiguritonPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    protected void jbInit() throws Exception {
        this.tabbedPane.add((Component)this.getEditPanel(), (Object)"\u041e\u043f\u0446\u0438\u0438");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.add(this.getButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    private JPanel getButtonPanel() {
        BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.GLUE, BGButtonPanel.SAVE, BGButtonPanel.CLOSE});
        buttonPanel.addActionListener(e -> this.parentPanel.getActionMap().get("close").actionPerformed(e));
        return buttonPanel;
    }

    private JPanel getEditPanel() {
        this.optionTableModel = new KitOptionTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)this.optionTableModel)){

            public TableCellRenderer getCellRenderer(int row, int column) {
                if ("group".equals(((RowData)PackerKitConfiguritonEditorPanel.this.optionTableModel.getRows().get(this.convertRowIndexToModel(row))).getJson().opt("type"))) {
                    return new OptionTableCellRenderer();
                }
                return HorizontalAlignmentTableCellRenderer.LEFT();
            }
        };
        table.setAutoRowHeight(true);
        table.setDragEnabled(true);
        table.setDropMode(DropMode.INSERT_ROWS);
        table.setTransferHandler((TransferHandler)new TableRowTransferHandler());
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PackerKitConfiguritonEditorPanel.this.setParamData();
            }
        });
        Dimension dimension = new Dimension(200, 300);
        JScrollPane scrollPane = new JScrollPane((Component)table);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.getOptionButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.getOptionParamPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getOptionParamPanel() {
        FontUIResource font = (FontUIResource)UIManager.get("Table.font");
        font = new FontUIResource(new Font(font.getName(), font.getStyle(), font.getSize() + 2));
        int fontHeight = this.getFontMetrics(font).getHeight() + 3;
        this.optionParamTableModel = new KitOptionParamTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)this.optionParamTableModel));
        table.setFont((Font)font);
        table.setRowHeight(fontHeight);
        table.setSelectionMode(0);
        table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                ParamRowData paramRowData;
                if (keyEvent.getKeyChar() == '\u007f' && (paramRowData = (ParamRowData)PackerKitConfiguritonEditorPanel.this.optionParamTableModel.getSelectedRow()) != null) {
                    paramRowData.value = "";
                    if (PackerKitConfiguritonEditorPanel.this.currentOption != null) {
                        PackerKitConfiguritonEditorPanel.this.currentOption.getJson().put(paramRowData.key, (Object)"");
                        int rowIndex = PackerKitConfiguritonEditorPanel.this.optionParamTableModel.getSelectedRowIndex();
                        PackerKitConfiguritonEditorPanel.this.optionTableModel.fireTableRowsUpdated(0, PackerKitConfiguritonEditorPanel.this.optionTableModel.getRowCount());
                        PackerKitConfiguritonEditorPanel.this.optionParamTableModel.fireTableRowsUpdated(rowIndex, rowIndex);
                    }
                }
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ParamRowData paramRowData = (ParamRowData)PackerKitConfiguritonEditorPanel.this.optionParamTableModel.getSelectedRow();
                    if (PackerKitConfiguritonEditorPanel.this.paramHandlerClass.equals(paramRowData)) {
                        new HandlerClassEditor("\u0412\u044b\u0431\u043e\u0440 \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430", paramRowData).open();
                        if (PackerKitConfiguritonEditorPanel.this.currentOption != null) {
                            PackerKitConfiguritonEditorPanel.this.currentOption.getJson().put(paramRowData.key, (Object)paramRowData.value);
                        }
                    } else if (PackerKitConfiguritonEditorPanel.this.paramDependence.equals(paramRowData)) {
                        new DependenceEditor("\u0412\u044b\u0431\u043e\u0440 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0445 \u043e\u043f\u0446\u0438\u0439", paramRowData).open();
                    }
                    PackerKitConfiguritonEditorPanel.this.optionParamTableModel.fireTableDataChanged();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getOptionButtonPanel() {
        BGButton newOptionButton = new BGButton(this.getActionMap().get("new"));
        BGButton addOptionGroupButton = new BGButton(this.getActionMap().get("newGroup"));
        BGButton addLibraryOptionButton = new BGButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043e\u043f\u0446\u0438\u044e \u0438\u0437 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438");
        BGButton deleteButton = new BGButton(this.getActionMap().get("delete"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)addOptionGroupButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 0, 3), 0, 0));
        panel.add((Component)newOptionButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 3), 0, 0));
        panel.add((Component)addLibraryOptionButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 0, 0), 0, 0));
        panel.add((Component)deleteButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 0, 3), 0, 0));
        return panel;
    }

    public void setPackerKit(PackerKit packerKit) {
        this.packerKit = packerKit;
        if (Utils.isBlankString((String)packerKit.getData())) {
            packerKit.setData("{}");
        }
        this.data = new JSONObject(packerKit.getData());
        JSONArray options = this.data.optJSONArray("options");
        if (options == null) {
            options = new JSONArray();
            this.data.put("options", (Object)options);
        }
        this.setData();
    }

    public PackerKit getPackerKit() {
        this.packerKit.setData(this.data.toString());
        return this.packerKit;
    }

    private void setData() {
        ArrayList<RowData> optionsData = new ArrayList<RowData>();
        JSONArray array = this.data.optJSONArray("options");
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            Object a = array.get(i);
            if (a == JSONObject.NULL) {
                JSONObject json = new JSONObject();
                json.put("type", (Object)"option");
                json.put("title", (Object)"null");
                a = json;
            }
            optionsData.add(new RowData((JSONObject)a));
        }
        this.optionTableModel.setData(optionsData, true);
        this.optionParamTableModel.setData(Collections.emptyList());
    }

    private void setParamData() {
        this.currentOption = (RowData)this.optionTableModel.getSelectedRow();
        if (this.currentOption == null) {
            this.optionParamTableModel.deleteRows();
            return;
        }
        ArrayList<ParamRowData> list = new ArrayList<ParamRowData>();
        JSONObject json = this.currentOption.getJson();
        String type = json.optString("type");
        if ("group".equals(type)) {
            this.paramTitle.setValue(json.optString("title"));
            list.add(this.paramTitle);
        } else if ("option".equals(type)) {
            this.paramTitle.setValue(json.optString(this.paramTitle.key));
            list.add(this.paramTitle);
            this.paramHandlerClass.setValue(json.optString(this.paramHandlerClass.key));
            list.add(this.paramHandlerClass);
            this.paramDependence.setValue(json.optString(this.paramDependence.key));
            list.add(this.paramDependence);
            this.paramCompatibility.setValue(json.optString(this.paramCompatibility.key));
            list.add(this.paramCompatibility);
        }
        this.optionParamTableModel.setData(list, false);
    }

    private void addItem(JSONObject newOption, int step) {
        int index = -1;
        RowData rowData = (RowData)this.optionTableModel.getSelectedRow();
        if (rowData != null) {
            index = this.optionTableModel.getRows().indexOf(rowData);
        }
        if (index == -1) {
            this.data.optJSONArray("options").put((Object)newOption);
            this.optionTableModel.addRow(new RowData(newOption));
        } else {
            this.data.optJSONArray("options").put(index + step, (Object)newOption);
            this.optionTableModel.insertRow(index + step, new RowData(newOption));
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            JSONObject newOption = new JSONObject();
            newOption.put("type", (Object)"option");
            newOption.put("title", (Object)"\u041d\u043e\u0432\u0430\u044f \u043e\u043f\u0446\u0438\u044f");
            newOption.put("uuid", (Object)UUID.randomUUID().toString());
            this.addItem(newOption, 1);
        });
        new AbstractBGUPanel.DefaultAction("newGroup", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 \u043e\u043f\u0446\u0438\u0439"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                JSONObject newOptionGroup = new JSONObject();
                newOptionGroup.put("type", (Object)"group");
                newOptionGroup.put("title", (Object)"\u041d\u043e\u0432\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430 \u043e\u043f\u0446\u0438\u0439");
                newOptionGroup.put("uuid", (Object)UUID.randomUUID().toString());
                PackerKitConfiguritonEditorPanel.this.addItem(newOptionGroup, 0);
            }
        };
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            RowData rowData = (RowData)this.optionTableModel.getSelectedRow();
            if (rowData == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            this.data.optJSONArray("options").remove(this.optionTableModel.getRows().indexOf(rowData));
            this.optionTableModel.deleteRow(rowData);
            this.optionParamTableModel.setData(Collections.emptyList());
        });
    }

    public class ParamRowData {
        String key;
        String title;
        String value;

        public ParamRowData(String key, String title, String value) {
            this.key = key;
            this.title = title;
            this.value = value;
        }

        public String getTitle() {
            return this.title;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void reset() {
            this.value = "";
        }
    }

    class KitOptionTableModel
    extends BGTableModel<RowData> {
        public KitOptionTableModel() {
            super(KitOptionTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u043f\u0446\u0438\u0438", 100, 300, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RowData rowData, int column) throws BGException {
            String i;
            switch (i = this.getIdentifier(column)) {
                case "title": {
                    return rowData.getJson().optString(i);
                }
            }
            return super.getValue((Object)rowData, column);
        }

        public TableCellRenderer getTableCellRenderer(int columnIndex) {
            return super.getTableCellRenderer(columnIndex);
        }
    }

    class TableRowTransferHandler
    extends TransferHandler {
        private final DataFlavor localObjectFlavor = new DataFlavor(RowData.class, "RowData");

        TableRowTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent component) {
            BGUTable table = (BGUTable)component;
            final KitOptionTableModel tableModel = (KitOptionTableModel)((Object)table.getModel());
            return new Transferable(){

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return true;
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{TableRowTransferHandler.this.localObjectFlavor};
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    return tableModel.getSelectedRow();
                }
            };
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            JTable target = (JTable)info.getComponent();
            JTable.DropLocation dropLocation = (JTable.DropLocation)info.getDropLocation();
            target.setCursor(Cursor.getPredefinedCursor(0));
            try {
                int index = dropLocation.getRow();
                RowData rowFrom = (RowData)info.getTransferable().getTransferData(this.localObjectFlavor);
                PackerKitConfiguritonEditorPanel.this.optionTableModel.getRows().add(index, new RowData(rowFrom.getData()));
                PackerKitConfiguritonEditorPanel.this.optionTableModel.deleteRow(rowFrom);
                PackerKitConfiguritonEditorPanel.this.optionTableModel.fireTableRowsUpdated(0, PackerKitConfiguritonEditorPanel.this.optionTableModel.getRowCount());
                JSONArray options = new JSONArray();
                PackerKitConfiguritonEditorPanel.this.optionTableModel.getRows().forEach(a -> options.put((Object)a.getJson()));
                PackerKitConfiguritonEditorPanel.this.data.put("options", (Object)options);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    class KitOptionParamTableModel
    extends BGTableModel<ParamRowData> {
        public KitOptionParamTableModel() {
            super(KitOptionParamTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 400, 600, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, 400, -1, "value", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e)", 100, 400, -1, "defaultValue", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(ParamRowData paramRowData, int column) throws BGException {
            return super.getValue((Object)paramRowData, column);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ParamRowData paramRowData = (ParamRowData)this.getRows().get(this.table.convertRowIndexToModel(rowIndex));
            if ("value".equals(this.getIdentifier(columnIndex))) {
                paramRowData.setValue(String.valueOf(value));
                if (PackerKitConfiguritonEditorPanel.this.currentOption != null) {
                    PackerKitConfiguritonEditorPanel.this.currentOption.getJson().put(paramRowData.key, value);
                    PackerKitConfiguritonEditorPanel.this.optionTableModel.fireTableRowsUpdated(0, PackerKitConfiguritonEditorPanel.this.optionTableModel.getRowCount());
                }
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && PackerKitConfiguritonEditorPanel.this.params.contains(this.getRows().get(rowIndex));
        }
    }

    class DependenceEditor
    extends BGEditorDialog<ParamRowData> {
        private BGControlPanelListSelect listSelect;

        public DependenceEditor(String title, ParamRowData data) {
            super(title, (Object)data);
            this.listSelect = new BGControlPanelListSelect();
        }

        public void doDialogPanel() {
            Dimension dimension = new Dimension(500, 400);
            this.listSelect.setMinimumSize(dimension);
            this.listSelect.setPreferredSize(dimension);
            this.panel.add((Component)this.listSelect, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            HashSet uuids = new HashSet();
            String value = ((ParamRowData)this.data).getValue();
            new JSONArray(Utils.notBlankString((String)value) ? value : "[]").forEach(a -> uuids.add(a.toString()));
            ArrayList listItems = new ArrayList();
            PackerKitConfiguritonEditorPanel.this.optionTableModel.getRows().forEach(a -> {
                JSONObject json = a.getJson();
                if ("option".equals(json.optString("type"))) {
                    BGUListItem listItem = new BGUListItem(-1, json.optString("title"));
                    String uuid = json.optString("uuid");
                    listItem.setAttribute("uuid", (Object)uuid);
                    listItem.setSelected(uuids.contains(uuid));
                    listItems.add(listItem);
                }
            });
            this.listSelect.getListModel().addAll(listItems);
            this.listSelect.getList().setCellRenderer((ListCellRenderer)new BGCheckListCellRenderer());
        }

        public boolean doApply() throws Exception {
            JSONArray jsonArray = new JSONArray();
            this.listSelect.getSelectedElements().forEach(a -> jsonArray.put(a.getAttribute("uuid")));
            PackerKitConfiguritonEditorPanel.this.currentOption.getJson().put("dependence", (Object)jsonArray.toString());
            return true;
        }
    }

    class HandlerClassEditor
    extends BGEditorDialog<ParamRowData> {
        private DynamicClassChooser dynamicClassChooser;

        public HandlerClassEditor(String title, ParamRowData data) {
            super(title, (Object)data);
            this.dynamicClassChooser = new DynamicClassChooser(true, 2);
        }

        public void doDialogPanel() {
            Dimension dimension = new Dimension(600, 300);
            this.dynamicClassChooser.setMinimumSize(dimension);
            this.dynamicClassChooser.setPreferredSize(dimension);
            this.dynamicClassChooser.setNewClass(false);
            this.dynamicClassChooser.setIfaceName(PackerOptionHandler.class.getName());
            this.panel.add((Component)this.dynamicClassChooser, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.dynamicClassChooser.performAction("refresh");
        }

        public boolean doApply() throws Exception {
            ((ParamRowData)this.data).setValue(this.dynamicClassChooser.getSelectedClass());
            return super.doApply();
        }
    }

    public class OptionTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Font font = ((JLabel)component).getFont();
            ((JLabel)component).setFont(font.deriveFont(1).deriveFont(((JLabel)component).getFont().getSize2D() * 1.2f));
            ((JLabel)component).setBorder(BorderFactory.createEmptyBorder(3, 15, 2, 5));
            return component;
        }
    }
}

