/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileToken;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class MobileTokenDao
extends AbstractIdDao<MobileToken> {
    public MobileTokenDao(Connection con, int moduleId) {
        super(con, moduleId, "mobile_tokens");
    }

    public int getCountTokenActive(int contractId) throws BGException {
        int result = 0;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT COUNT(*) FROM " + this.tableName + " WHERE contractId=? AND expiredDate>NOW()");){
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<MobileToken> listTokens(int contractId) throws BGException {
        return this.list("contractId=?", null, new Object[]{contractId});
    }

    public void deleteExpiredTokens(int contractId) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE contractId=? AND expiredDate<NOW()");){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteTokens(int contractId) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE contractId=?");){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    protected MobileToken getFromRS(ResultSet rs) throws SQLException, BGException {
        MobileToken token = new MobileToken();
        token.setId(rs.getInt("id"));
        token.setContractId(rs.getInt("contractId"));
        token.setExpiredDate(rs.getTimestamp("expiredDate"));
        token.setCreatedDate(rs.getTimestamp("createdDate"));
        token.setUpdatedDate(rs.getTimestamp("updatedDate"));
        return token;
    }

    protected void updateImpl(MobileToken token) throws BGException, SQLException {
        if (token.getId() <= 0) {
            if (token.getContractId() < 0) {
                throw new BGIllegalArgumentException();
            }
            String query = "INSERT INTO " + this.tableName + " SET contractId=?, expiredDate=?, createdDate=NOW()";
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                ps.setInt(1, token.getContractId());
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)token.getExpiredDate()));
                ps.executeUpdate();
                token.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

