/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractCredentials;
import ru.bitel.common.dao.AbstractDao;

public class MegogoContractCredentialsDao
extends AbstractDao<MegogoContractCredentials> {
    public MegogoContractCredentialsDao(Connection con, int moduleId) {
        super(con, moduleId, "megogo_contract_credentials");
    }

    public MegogoContractCredentials getByContractId(int contractId) throws BGException {
        return (MegogoContractCredentials)this.get("contractId=?", new Object[]{contractId});
    }

    public MegogoContractCredentials getByLogin(String login) throws BGException {
        if (login == null) {
            throw new BGMessageException("Login \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        return (MegogoContractCredentials)this.get("login=?", new Object[]{login});
    }

    protected void updateImpl(MegogoContractCredentials contractLogin) throws BGException, SQLException {
        PreparedStatement ps = null;
        String query = "INSERT INTO " + this.tableName + "( contractId, uid, login, pwd ) VALUES ( ?, ?, ?, ? ) ON DUPLICATE KEY UPDATE login=?, pwd=? ";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, contractLogin.getContractId());
        ps.setInt(2, contractLogin.getUid());
        ps.setString(3, contractLogin.getLogin());
        ps.setString(4, contractLogin.getPwd());
        ps.setString(5, contractLogin.getLogin());
        ps.setString(6, contractLogin.getPwd());
        ps.executeUpdate();
    }

    protected MegogoContractCredentials getFromRS(ResultSet rs) throws SQLException, BGException {
        MegogoContractCredentials contractLogin = new MegogoContractCredentials();
        contractLogin.setContractId(rs.getInt("contractId"));
        contractLogin.setLogin(rs.getString("login"));
        contractLogin.setPwd(rs.getString("pwd"));
        contractLogin.setLm((Date)rs.getTimestamp("lm"));
        contractLogin.setUid(rs.getInt("uid"));
        return contractLogin;
    }
}

