/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.task.common.bean.TaskStatus;
import ru.bitel.common.Utils;

public class DependentTask
implements Serializable {
    private static final long serialVersionUID = -6267878664713910978L;
    public static final String CLASS_NAME = "className";
    public static final String IS_PLUGIN = "isPlugin";
    public static final String MODULE_ID = "moduleId";
    public static final String MODULE_NAME = "moduleName";
    public static final String PARAMS = "params";
    public static final String PRIORITY = "priority";
    public static final String STATUS = "status";
    public static final String COMMENT = "comment";
    private String title;
    private String className;
    private String comment;
    private boolean isPlugin;
    private int moduleId = -2;
    private String moduleName;
    private int priority = 0;
    private String params;
    private TaskStatus taskStatus = TaskStatus.ENABLE;

    @XmlAttribute
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlAttribute
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @XmlAttribute
    public boolean isPlugin() {
        return this.isPlugin;
    }

    public void setPlugin(boolean plugin) {
        this.isPlugin = plugin;
    }

    @XmlAttribute
    public int getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    @XmlAttribute
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @XmlAttribute
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @XmlElement
    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    @XmlAttribute
    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    @XmlAttribute
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put(CLASS_NAME, (Object)this.getClassName());
        json.put(IS_PLUGIN, this.isPlugin());
        json.put(MODULE_ID, this.getModuleId());
        json.put(MODULE_NAME, (Object)this.getModuleName());
        json.put(PARAMS, (Object)this.getParams());
        json.put(PRIORITY, this.getPriority());
        json.put(STATUS, this.getTaskStatus().getStatus());
        json.put(COMMENT, (Object)this.getComment());
        return json;
    }

    public static DependentTask fromJson(JSONObject json) {
        DependentTask task = new DependentTask();
        task.setClassName(json.optString(CLASS_NAME, ""));
        task.setPlugin(json.optBoolean(IS_PLUGIN, false));
        task.setModuleId(json.optInt(MODULE_ID, -1));
        task.setModuleName(json.optString(MODULE_NAME, ""));
        task.setParams(json.optString(PARAMS, ""));
        task.setPriority(json.optInt(PRIORITY, 2));
        task.setTaskStatus(json.optInt(STATUS, 0) == 1 ? TaskStatus.ENABLE : TaskStatus.DISABLE);
        task.setComment(json.optString(COMMENT, ""));
        return task;
    }

    public static JSONArray toJSONArray(List<DependentTask> taskList) {
        JSONArray array = new JSONArray();
        if (Utils.isEmptyCollection(taskList)) {
            return array;
        }
        taskList.forEach(t -> array.put((Object)t.toJson()));
        return array;
    }

    public static List<DependentTask> fromJSONArray(JSONArray array) {
        LinkedList<DependentTask> result = new LinkedList<DependentTask>();
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                result.add(DependentTask.fromJson(array.optJSONObject(i)));
            }
        }
        return result;
    }
}

