/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;

public class TariffVariablePanel
extends BGUPanel {
    private ButtonGroup filter\u0410ccessories = new ButtonGroup();
    private JCheckBox onlyReset = new JCheckBox("\u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
    private TariffVariableTableModel variableTableModel = new TariffVariableTableModel();
    private List<ContractTariffVar> contractTariffVars = new ArrayList<ContractTariffVar>();

    @Override
    protected void jbInit() throws Exception {
        FontUIResource font = (FontUIResource)UIManager.get("Table.font");
        BGUTable table = new BGUTable(this.variableTableModel);
        table.setSelectionMode(0);
        table.setAutoRowHeight(true);
        table.setFont(new FontUIResource(new Font(font.getName(), font.getStyle(), font.getSize() + 2)));
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    TariffVariablePanel.this.variableTableModel.optSelectedRow().ifPresentOrElse(contractTariffVar -> {
                        new ContractTariffVarDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", (ContractTariffVar)contractTariffVar).open();
                        TariffVariablePanel.this.showTariffVariables(contractTariffVar.getContractTarifffId());
                    }, () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443"));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTariffVariableTopPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
    }

    private JPanel getTariffVariableTopPanel() {
        ActionListener actionListener = e -> this.doFilterTariffVariables();
        JToggleButton allButton = new JToggleButton("\u0432\u0441\u0435", true);
        allButton.setActionCommand("all");
        allButton.addActionListener(actionListener);
        this.filter\u0410ccessories.add(allButton);
        JToggleButton globalButton = new JToggleButton("\u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0435");
        globalButton.setActionCommand("global");
        globalButton.addActionListener(actionListener);
        this.filter\u0410ccessories.add(globalButton);
        JToggleButton tariffButton = new JToggleButton("\u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0435");
        tariffButton.setActionCommand("tariff");
        tariffButton.addActionListener(actionListener);
        this.filter\u0410ccessories.add(tariffButton);
        this.onlyReset.addChangeListener(e -> this.doFilterTariffVariables());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)allButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)globalButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)tariffButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.onlyReset, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 0), 0, 0));
        return panel;
    }

    public void doFilterTariffVariables() {
        ArrayList<ContractTariffVar> data = new ArrayList<ContractTariffVar>();
        String access = this.filter\u0410ccessories.getSelection().getActionCommand();
        for (ContractTariffVar contractTariffVar : this.contractTariffVars) {
            boolean add = "all".equals(access) || "global".equals(access) && contractTariffVar.getTariffPlanId() == 0 || "tariff".equals(access) && contractTariffVar.getTariffPlanId() > 0;
            if (!(add = add && (!this.onlyReset.isSelected() || this.onlyReset.isSelected() && contractTariffVar.getValue() != null))) continue;
            data.add(contractTariffVar);
        }
        this.variableTableModel.setData(data);
    }

    public void showTariffVariables(int contractTariffId) {
        if (contractTariffId > 0) {
            Async.ofWithTry(() -> {
                this.contractTariffVars = ((ClientContext)this.getContext()).getWebService(ContractTariffService.class, 0).contractTariffVars(contractTariffId);
                this.doFilterTariffVariables();
            });
        } else {
            this.contractTariffVars.clear();
            this.doFilterTariffVariables();
        }
    }

    public void clearContractTariffVars() {
        this.contractTariffVars.clear();
    }

    public void reset() {
        this.variableTableModel.setData(new ArrayList());
    }

    class TariffVariableTableModel
    extends BGTableModel<ContractTariffVar> {
        public TariffVariableTableModel() {
            super(TariffVariableTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0422\u0438\u043f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", 200, 200, 300, "type", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0430\u044f", Boolean.class, 100, 100, 100, "global", true);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 300, 400, 500, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 200, 250, -1, "value", true, new ValueTableCellRenderer());
        }

        @Override
        public Object getValue(ContractTariffVar val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("type".equals(identifier)) {
                return val.getType().getTitle();
            }
            if ("global".equals(identifier)) {
                return val.getTariffPlanId() == 0;
            }
            if ("value".equals(identifier)) {
                String value;
                String string = value = val.getValue() == null ? val.getDefaultValue() : val.getValue();
                if ("list".equals(val.getType().getType())) {
                    return value.replaceFirst("^(\\d+):(.*)", "$2 [#$1]");
                }
                return value;
            }
            return super.getValue(val, column);
        }
    }

    class ContractTariffVarDialog
    extends BGEditorDialog<ContractTariffVar> {
        private BGButton defaultValue;
        private BGTextField type;
        private BGTextField title;
        private BGTextField value;
        private BGUComboBox<IdTitle> listValue;
        private List<IdTitle> listItems;
        private final String tariffVarEditorType;

        public ContractTariffVarDialog(String title, ContractTariffVar data) {
            super(title, data);
            this.defaultValue = new BGButton();
            this.type = new BGTextField(15);
            this.title = new BGTextField(30);
            this.value = new BGTextField(30);
            this.listValue = new BGUComboBox();
            this.listItems = new ArrayList<IdTitle>();
            this.tariffVarEditorType = data.getType().getType();
            if ("list".equals(this.tariffVarEditorType)) {
                try {
                    this.listItems = ((ClientContext)TariffVariablePanel.this.getContext()).getWebService(TariffService.class, 0).tariffVarListItems(data.getModuleId(), data.getType().getCode());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        }

        @Override
        public void doDialogPanel() {
            Font font = this.title.getFont();
            Color bgColor = this.title.getBackground();
            this.title.setHorizontalAlignment(0);
            this.title.setFont(font.deriveFont(1).deriveFont(font.getSize2D() * 1.5f));
            this.title.setEditable(false);
            this.title.setBackground(bgColor);
            this.type.setHorizontalAlignment(0);
            this.type.setFont(font.deriveFont(1).deriveFont(font.getSize2D() * 1.2f));
            this.type.setEditable(false);
            this.type.setBackground(bgColor);
            this.defaultValue.setHorizontalAlignment(0);
            this.defaultValue.setFont(font.deriveFont(1).deriveFont(font.getSize2D() * 1.2f));
            this.defaultValue.addActionListener(e -> {
                if ("list".equals(this.tariffVarEditorType)) {
                    this.settListItem(Utils.parseInt(((ContractTariffVar)this.data).getDefaultValue().replaceAll("^(\\d+):.*", "$1")));
                } else {
                    this.value.setText(((ContractTariffVar)this.data).getDefaultValue());
                }
            });
            this.value.setHorizontalAlignment(0);
            this.value.setFont(font.deriveFont(1).deriveFont(font.getSize2D() * 1.7f));
            this.listValue.setFont(font.deriveFont(1).deriveFont(font.getSize2D() * 1.5f));
            this.listValue.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    IdTitle idTitle = (IdTitle)value;
                    JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (idTitle != null) {
                        label.setText(idTitle.getTitle() + " [#" + idTitle.getId() + "]");
                    }
                    label.setHorizontalAlignment(0);
                    return label;
                }
            });
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getDefaultValueAndTypePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add("list".equals(this.tariffVarEditorType) ? this.listValue : this.value, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
            String text = ((ContractTariffVar)this.data).getDefaultValue();
            this.type.setText(((ContractTariffVar)this.data).getType().getTitle());
            this.title.setText(((ContractTariffVar)this.data).getTitle());
            if ("list".equals(this.tariffVarEditorType)) {
                this.listValue.setData(this.listItems);
                this.settListItem(Utils.parseInt(((ContractTariffVar)this.data).getValue() != null ? ((ContractTariffVar)this.data).getValue().replaceAll("^(\\d+):.*", "$1") : "0"));
                text = text.replaceAll("^(\\d+):(.*)", "$2 [#$1]");
            }
            this.defaultValue.setText(text);
            this.value.setText(((ContractTariffVar)this.data).getValue());
        }

        private void settListItem(int listVarId) {
            this.listValue.setSelectedItem(this.listItems.stream().filter(a -> a.getId() == listVarId).findFirst().orElse(null));
        }

        private JPanel getDefaultValueAndTypePanel() {
            JPanel panel = new JPanel(new GridLayout(1, 2, 10, 0));
            panel.add(this.getDefaultValuePanel());
            panel.add(this.getTypePanel());
            return panel;
        }

        private JPanel getDefaultValuePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)this.defaultValue, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getTypePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)this.type, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            Object text;
            if (((ContractTariffVar)this.data).getType().equals(TariffVarType.COST)) {
                try {
                    text = this.value.getText();
                    BigDecimal bigDecimal = new BigDecimal((String)text);
                    if (!bigDecimal.setScale(2, RoundingMode.HALF_UP).toString().equals(text) && !bigDecimal.setScale(0, RoundingMode.HALF_UP).toString().equals(text)) {
                        throw new BGException("");
                    }
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0432\u043e\u0434\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
                    return false;
                }
            }
            text = this.value.getText().trim();
            if ("list".equals(((ContractTariffVar)this.data).getType().getType())) {
                IdTitle idTitle = (IdTitle)this.listValue.getSelectedItem();
                if (idTitle == null) {
                    ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0432\u043e\u0434\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
                    return false;
                }
                text = idTitle.getId() + ":" + idTitle.getTitle();
            }
            ((ContractTariffVar)this.data).setValue((String)text);
            if (((ContractTariffVar)this.data).getValue().isEmpty() || ((ContractTariffVar)this.data).getValue().equals(((ContractTariffVar)this.data).getDefaultValue())) {
                ((ClientContext)TariffVariablePanel.this.getContext()).getWebService(ContractTariffService.class, 0).contractTariffVarDelete((ContractTariffVar)this.data);
            } else {
                ((ClientContext)TariffVariablePanel.this.getContext()).getWebService(ContractTariffService.class, 0).contractTariffVarUpdate((ContractTariffVar)this.data);
            }
            return super.doApply();
        }
    }

    class ValueTableCellRenderer
    extends DefaultTableCellRenderer {
        ValueTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ContractTariffVar contractTariffVar = (ContractTariffVar)TariffVariablePanel.this.variableTableModel.getRows().get(row);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.setFont(contractTariffVar.getValue() == null ? table.getFont() : table.getFont().deriveFont(1));
            return this;
        }
    }
}

