/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.datalog.hourly.RadiusHourlyDataLogger;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.io.DatagramChannelListener;
import ru.bitel.common.model.Idable;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class RadiusClient {
    private static Logger logger = LogManager.getLogger();
    private final String sourceHost;
    private final int sourcePort;
    private final InetAddress host;
    private final int port;
    private final byte[] secret;
    private final long timeout = 5L;
    private boolean reuseAddress = false;
    private volatile boolean working = true;
    static final Callable<Boolean> nullCallable = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            throw new UnsupportedOperationException();
        }
    };
    private final ConcurrentMap<Integer, WeakReference<ResponseFuture<Boolean>>> accessQueue = new ConcurrentHashMap<Integer, WeakReference<ResponseFuture<Boolean>>>(8, 0.75f, 8);
    private final ConcurrentMap<Integer, WeakReference<ResponseFuture<Boolean>>> accountingQueue = new ConcurrentHashMap<Integer, WeakReference<ResponseFuture<Boolean>>>(8, 0.75f, 8);
    private final ConcurrentMap<Integer, WeakReference<ResponseFuture<Boolean>>> modifyQueue = new ConcurrentHashMap<Integer, WeakReference<ResponseFuture<Boolean>>>(8, 0.75f, 8);
    private final ConcurrentMap<Integer, WeakReference<ResponseFuture<Boolean>>> disconnectQueue = new ConcurrentHashMap<Integer, WeakReference<ResponseFuture<Boolean>>>(8, 0.75f, 8);
    private volatile RadiusDatagramChannelListener listener;
    private final AtomicInteger identifier = new AtomicInteger();
    private final boolean logCoA;
    private final boolean logPoD;
    private final RadiusHourlyDataLogger dataLogger;
    private final int applicationId;
    private final int moduleId;
    private volatile Idable nas;
    private volatile long connectionId;

    public RadiusClient(InetAddress host, int port, byte[] secret) {
        this(null, -1, host, port, secret);
    }

    @Deprecated
    public RadiusClient(int sourcePort, InetAddress host, int port, byte[] secret) {
        this(null, sourcePort, host, port, secret);
    }

    public RadiusClient(String sourceHost, int sourcePort, InetAddress host, int port, byte[] secret) {
        this.sourceHost = sourceHost;
        this.sourcePort = sourcePort;
        this.host = host;
        this.port = port;
        this.secret = secret;
        this.dataLogger = null;
        this.applicationId = 0;
        this.moduleId = 0;
        this.logCoA = false;
        this.logPoD = false;
    }

    public RadiusClient(InetAddress host, int port, byte[] secret, Setup setup, RadiusHourlyDataLogger dataLogger, boolean logCoA, boolean logPoD) {
        this(null, -1, host, port, secret, setup, dataLogger, logCoA, logPoD);
    }

    @Deprecated
    public RadiusClient(int sourcePort, InetAddress host, int port, byte[] secret, Setup setup, RadiusHourlyDataLogger dataLogger, boolean logCoA, boolean logPoD) {
        this(null, sourcePort, host, port, secret, setup, dataLogger, logCoA, logPoD);
    }

    public RadiusClient(String sourceHost, int sourcePort, InetAddress host, int port, byte[] secret, Setup setup, RadiusHourlyDataLogger dataLogger, boolean logCoA, boolean logPoD) {
        this.sourceHost = sourceHost;
        this.sourcePort = sourcePort;
        this.host = host;
        this.port = port;
        this.secret = secret;
        this.dataLogger = dataLogger;
        this.applicationId = SetupParam.getApplicationId((ParameterMap)setup);
        this.moduleId = SetupParam.getModuleId((ParameterMap)setup);
        this.logCoA = logCoA;
        this.logPoD = logPoD;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    private int newIdentifier() {
        int next;
        int current;
        while (!this.identifier.compareAndSet(current = this.identifier.get(), next = (current + 1) % 256)) {
        }
        return next;
    }

    public RadiusPacket createRequest(byte code) {
        return new RadiusPacket(code, (byte)this.newIdentifier());
    }

    public RadiusPacket createAccountingRequest() {
        return this.createRequest((byte)4);
    }

    public RadiusPacket createModifyRequest() {
        return this.createRequest((byte)43);
    }

    public RadiusPacket createDisconnectRequest() {
        return this.createRequest((byte)40);
    }

    public boolean send(RadiusPacket packet) throws InvalidKeyException, SocketException, NoSuchAlgorithmException, InterruptedException, ExecutionException, TimeoutException {
        Boolean result = this.sendAsync(packet).get(5L, TimeUnit.SECONDS);
        return result != null ? result : true;
    }

    public boolean send(RadiusPacket packet, long timeout, TimeUnit unit) throws InvalidKeyException, SocketException, NoSuchAlgorithmException, InterruptedException, ExecutionException, TimeoutException {
        Boolean result = this.sendAsync(packet).get(timeout, unit);
        return result != null ? result : true;
    }

    public Future<Boolean> sendAsync(RadiusPacket packet) throws InvalidKeyException, SocketException, NoSuchAlgorithmException {
        return this.sendAsync0(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseFuture<Boolean> sendAsync0(RadiusPacket packet) throws InvalidKeyException, SocketException, NoSuchAlgorithmException {
        logger.debug("Sending to " + this.host + ":" + this.port);
        logger.trace("\n" + packet);
        ByteBuffer bb = ByteBuffer.wrap(new byte[4096]);
        packet.write(bb, this.secret);
        bb.flip();
        try {
            ResponseFuture<Boolean> result;
            if (this.listener == null) {
                RadiusClient radiusClient = this;
                synchronized (radiusClient) {
                    if (this.listener == null) {
                        RadiusDatagramChannelListener listener = new RadiusDatagramChannelListener(this.sourceHost, this.sourcePort, 262144, 0);
                        listener.setReuseAddress(this.reuseAddress);
                        listener.init();
                        this.listener = listener;
                        Thread thread = new Thread((Runnable)listener, "rds-clnt-" + this.host + "-" + this.port);
                        thread.start();
                    }
                }
            }
            Date time = new Date();
            int connectionLogEntryId = this.writeRequestLog(packet, bb, time);
            bb.rewind();
            int deviceId = this.nas != null ? this.nas.getId() : 0;
            byte code = packet.getCode();
            switch (code) {
                case 43: {
                    result = new ResponseFuture<Boolean>(nullCallable, time, deviceId, this.connectionId, connectionLogEntryId);
                    this.modifyQueue.put(Integer.valueOf(packet.identifier), new WeakReference<ResponseFuture<Boolean>>(result));
                    break;
                }
                case 40: {
                    result = new ResponseFuture<Boolean>(nullCallable, time, deviceId, this.connectionId, connectionLogEntryId);
                    this.disconnectQueue.put(Integer.valueOf(packet.identifier), new WeakReference<ResponseFuture<Boolean>>(result));
                    break;
                }
                case 4: {
                    result = new ResponseFuture<Boolean>(nullCallable, time, deviceId, this.connectionId, connectionLogEntryId);
                    this.accountingQueue.put(Integer.valueOf(packet.identifier), new WeakReference<ResponseFuture<Boolean>>(result));
                    break;
                }
                case 1: {
                    result = new ResponseFuture<Boolean>(nullCallable, time, deviceId, this.connectionId, connectionLogEntryId);
                    this.accessQueue.put(Integer.valueOf(packet.identifier), new WeakReference<ResponseFuture<Boolean>>(result));
                    break;
                }
                default: {
                    result = null;
                }
            }
            this.listener.send(new InetSocketAddress(this.host, this.port), bb);
            return result;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public RadiusPacket request(RadiusPacket packet) throws InvalidKeyException, SocketException, NoSuchAlgorithmException, InterruptedException, ExecutionException, TimeoutException {
        RadiusPacket result = this.sendAsync0(packet).getResponse(5L, TimeUnit.SECONDS);
        return result;
    }

    public RadiusPacket request(RadiusPacket packet, long timeout, TimeUnit unit) throws InvalidKeyException, SocketException, NoSuchAlgorithmException, InterruptedException, ExecutionException, TimeoutException {
        RadiusPacket result = this.sendAsync0(packet).getResponse(timeout, unit);
        return result;
    }

    public void setNas(Idable nas) {
        this.nas = nas;
    }

    public void setConnectionId(long connectionId) {
        this.connectionId = connectionId;
    }

    protected int writeRequestLog(RadiusPacket packet, ByteBuffer data, Date time) {
        int logType;
        if (this.dataLogger == null || this.nas == null) {
            return 0;
        }
        if (this.logCoA && packet.getCode() == 43) {
            logType = 3;
        } else if (this.logPoD && packet.getCode() == 40) {
            logType = 4;
        } else {
            return 0;
        }
        try {
            DefaultContext context = (DefaultContext)ThreadContext.get();
            ConnectionSet connectionSet = context.getConnectionSet();
            int[] coords = new int[3];
            this.dataLogger.writeRecord(this.nas, coords, data, time.getTime());
            ConnectionLogEntry entry = new ConnectionLogEntry();
            entry.setApplicationId(this.applicationId);
            entry.setDeviceId(this.nas.getId());
            entry.setDevicePort(RadiusUtils.getNasPort(packet));
            entry.setTime(time);
            entry.setAcctSessId(packet.getStringAttribute(-1, 44, ""));
            entry.setConnectionId(this.connectionId);
            entry.setLogType(logType);
            entry.setRequestDataLogId(coords[0]);
            entry.setRequestChunkId(coords[1]);
            entry.setRequestPosition(coords[2]);
            ConnectionLogEntryDao connectionLogEntryDao = new ConnectionLogEntryDao(connectionSet, this.moduleId);
            connectionLogEntryDao.update(entry);
            connectionLogEntryDao.recycle();
            connectionSet.commit();
            return entry.getId();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    protected void writeResponseLog(ServerContext context, RadiusPacket packet, ByteBuffer data, Date time, int deviceId, int connectionLogEntryId) {
        if (this.dataLogger == null || this.nas == null) {
            return;
        }
        try {
            ConnectionSet connectionSet = context.getConnectionSet();
            int[] coords = new int[3];
            this.dataLogger.writeRecord(this.nas, coords, data, time.getTime());
            ConnectionLogEntryDao connectionLogEntryDao = new ConnectionLogEntryDao(connectionSet, this.moduleId);
            connectionLogEntryDao.updateResponseCoords(time, deviceId, connectionLogEntryId, coords);
            connectionLogEntryDao.recycle();
            connectionSet.commit();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void beforeReceive(ByteBuffer bb) {
    }

    public synchronized void destroy() {
        if (this.working) {
            this.working = false;
            if (this.listener != null) {
                this.listener.shutdown();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public static final class ResponseFuture<V>
    extends FutureTask<V> {
        final Date time;
        final int deviceId;
        final long connectionId;
        final int connectionLogEntryId;
        volatile RadiusPacket response;

        public ResponseFuture(Callable<V> callable, Date time, int deviceId, long connectionId, int connectionLogEntryId) {
            super(callable);
            this.time = time;
            this.deviceId = deviceId;
            this.connectionId = connectionId;
            this.connectionLogEntryId = connectionLogEntryId;
        }

        @Override
        protected void done() {
            super.done();
        }

        @Override
        public void set(V v) {
            super.set(v);
        }

        public RadiusPacket getResponse() throws InterruptedException, ExecutionException {
            this.get();
            return this.response;
        }

        public RadiusPacket getResponse(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.get(timeout, unit);
            return this.response;
        }
    }

    class RadiusDatagramChannelListener
    extends DatagramChannelListener {
        private final ServerContext context;

        public RadiusDatagramChannelListener(String host, int port, int byteBufferCapacity, int socketRCVBUF) {
            super(host, port, byteBufferCapacity, socketRCVBUF);
            this.context = new ServerContext(Setup.getSetup(), RadiusClient.this.moduleId, 0);
        }

        @Override
        public void run() {
            ThreadContext parentContext = ThreadContext.push(this.context);
            try {
                super.run();
            }
            finally {
                ThreadContext.pop(this.context, parentContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPacket(SocketAddress clientAddress, ByteBuffer data) {
            try {
                RadiusPacket response = RadiusPacket.parse(data);
                logger.debug("Recieved from " + clientAddress);
                logger.trace("\n" + response);
                byte code = response.getCode();
                switch (code) {
                    case 41: 
                    case 42: {
                        ResponseFuture future;
                        WeakReference futureRef = (WeakReference)RadiusClient.this.disconnectQueue.remove(response.identifier);
                        ResponseFuture responseFuture = future = futureRef != null ? (ResponseFuture)futureRef.get() : null;
                        if (future == null) break;
                        data.rewind();
                        RadiusClient.this.writeResponseLog(this.context, response, data, future.time, future.deviceId, future.connectionLogEntryId);
                        future.response = response;
                        if (code == 41) {
                            future.set(Boolean.TRUE);
                            break;
                        }
                        future.set(Boolean.FALSE);
                        break;
                    }
                    case 44: 
                    case 45: {
                        ResponseFuture future;
                        WeakReference futureRef = (WeakReference)RadiusClient.this.modifyQueue.remove(response.identifier);
                        ResponseFuture responseFuture = future = futureRef != null ? (ResponseFuture)futureRef.get() : null;
                        if (future == null) break;
                        data.rewind();
                        RadiusClient.this.writeResponseLog(this.context, response, data, future.time, future.deviceId, future.connectionLogEntryId);
                        future.response = response;
                        if (code == 44) {
                            future.set(Boolean.TRUE);
                            break;
                        }
                        future.set(Boolean.FALSE);
                        break;
                    }
                    case 5: {
                        ResponseFuture future;
                        WeakReference futureRef = (WeakReference)RadiusClient.this.accountingQueue.remove(response.identifier);
                        ResponseFuture responseFuture = future = futureRef != null ? (ResponseFuture)futureRef.get() : null;
                        if (future == null) break;
                        data.rewind();
                        RadiusClient.this.writeResponseLog(this.context, response, data, future.time, future.deviceId, future.connectionLogEntryId);
                        future.response = response;
                        future.set(Boolean.TRUE);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 11: {
                        ResponseFuture future;
                        WeakReference futureRef = (WeakReference)RadiusClient.this.accessQueue.remove(response.identifier);
                        ResponseFuture responseFuture = future = futureRef != null ? (ResponseFuture)futureRef.get() : null;
                        if (future == null) break;
                        data.rewind();
                        RadiusClient.this.writeResponseLog(this.context, response, data, future.time, future.deviceId, future.connectionLogEntryId);
                        future.response = response;
                        future.set(Boolean.TRUE);
                        break;
                    }
                }
                this.context.commit();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.context.recycle();
            }
        }
    }
}

