/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import bitel.billing.server.contract.object.bean.ListValueManager;
import bitel.billing.server.contract.object.bean.ObjectManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParameterGroupAttr;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.AbstractSpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;

public class ContractObjectDao
extends AbstractEntityAttrDao<ContractObject> {
    public ContractObjectDao(Connection con, int userId) {
        super(con, 0, userId, "object", "object", CONTRACT_OBJECT_SUPPORT);
    }

    public EntityAttr getObjectParameter(int objectId, int parameterId) throws BGException {
        return super.getEntityAttribute(objectId, parameterId);
    }

    public boolean updateObjectParameter(int objectId, EntityAttr entityAttr) throws BGException {
        try {
            boolean result = super.updateEntityAttribute(objectId, entityAttr);
            ObjectManager objectManager = new ObjectManager(this.con);
            ContractObject object = objectManager.getObject(entityAttr.getEntityId());
            objectManager.saveTitleByMacros(object);
            return result;
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public Optional<EntityAttrText> optObjectParameterText(int objectId, int parameterId) throws BGException {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrText).map(a -> (EntityAttrText)a);
    }

    public Optional<String> optObjectParameterTextAsString(int objectId, int parameterId) throws BGException {
        return this.optObjectParameterText(objectId, parameterId).map(EntityAttrText::getValue);
    }

    public Optional<EntityAttrBoolean> optObjectParameterBoolean(int objectId, int parameterId) throws BGException {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrBoolean).map(a -> (EntityAttrBoolean)a);
    }

    public Optional<Boolean> optObjectParameterBooleanAsBoolean(int objectId, int parameterId) throws BGException {
        return this.optObjectParameterBoolean(objectId, parameterId).map(EntityAttrBoolean::getValue);
    }

    public Optional<EntityAttrDate> optObjectParameterDate(int objectId, int parameterId) throws BGException {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrDate).map(a -> (EntityAttrDate)a);
    }

    public Optional<Date> optObjectParameterDateAsDate(int objectId, int parameterId) throws BGException {
        return this.optObjectParameterDate(objectId, parameterId).map(EntityAttrDate::getValue);
    }

    public Optional<EntityAttrList> optObjectParameterList(int objectId, int parameterId) throws BGException {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrList).map(a -> (EntityAttrList)a);
    }

    public Optional<String> optObjectParameterListAsString(int objectId, int parameterId) throws Exception {
        EntityAttrList attrList = this.optObjectParameterList(objectId, parameterId).orElse(null);
        if (attrList == null) {
            return Optional.empty();
        }
        if (attrList.getValue() > 0) {
            return new ListValueManager(this.con).getValues(parameterId).stream().filter(a -> a.getId() == attrList.getValue()).findFirst().map(IdTitle::getTitle);
        }
        return Optional.ofNullable(attrList.getTitle());
    }

    public Optional<EntityAttrAddress> optObjectParameterAddress(int objectId, int parameterId) throws BGException {
        return super.optEntityAttribute(objectId, parameterId).filter(a -> a instanceof EntityAttrAddress).map(a -> (EntityAttrAddress)a);
    }

    public Optional<String> getObjectParameterAddressAsString(int contractId, int parameterId) throws BGException {
        return this.optObjectParameterAddress(contractId, parameterId).map(EntityAttrAddress::getTitle);
    }

    public Directory<? extends EntitySpec> getEntitySpecDirectory() throws BGException {
        if (this.entitySpecDirectory == null) {
            this.entitySpecDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ContractObjectType.class, this.con, 0, true);
        }
        return this.entitySpecDirectory;
    }

    protected Directory<? extends AbstractSpecAttr> getEntitySpecAttrDirectory() throws BGException {
        if (this.entitySpecAttrDirectory == null) {
            this.entitySpecAttrDirectory = ServerDirectoryFactory.newUnmodifiableDirectory(ObjectParameterGroupAttr.class, this.con, 0, true);
        }
        return this.entitySpecAttrDirectory;
    }

    public void contractObjectTable(SearchResult<ContractObject> searchResult, int contractId, String titleFilter, int typeId) throws BGException {
        List<ContractObject> list = searchResult.getList();
        Page page = searchResult.getPage();
        StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS * FROM ").append(this.tableName).append(" WHERE cid=").append(contractId);
        if (typeId > 0) {
            query.append(" AND type_id=").append(typeId);
        }
        if (Utils.notBlankString(titleFilter)) {
            query.append(" AND title REGEXP ?");
        }
        query.append(" ORDER BY pos").append(page.sqlLimit());
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (Utils.notBlankString(titleFilter)) {
                ps.setString(1, titleFilter);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add((ContractObject)((Object)this.getFromRS(rs)));
                }
            }
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    protected ContractObject getFromRS(ResultSet rs, boolean loadAttributes) throws SQLException {
        return ContractObject.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setStatus(rs.getInt("status")).setTitle(rs.getString("title")).setTypeId(rs.getInt("type_id")).setDateFrom(rs.getDate("date1")).setDateTo(rs.getDate("date2")).setPosition(rs.getInt("pos")).build();
    }

    protected void updateImpl(ContractObject contractObject) throws BGException, SQLException {
        boolean update = contractObject.getId() > 0;
        String set = " SET title=?, date1=?, date2=?, cid=?, type_id=?";
        String prefix = update ? "UPDATE " + this.tableName : "INSERT INTO " + this.tableName;
        String query = prefix + set;
        if (update) {
            query = query + " WHERE id=?";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, contractObject.getTitle() != null ? contractObject.getTitle().trim() : "");
            ps.setDate(2, TimeUtils.convertDateToSqlDate(contractObject.getDateFrom()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate(contractObject.getDateTo()));
            ps.setInt(4, contractObject.getContractId());
            ps.setInt(5, contractObject.getTypeId());
            if (update) {
                ps.setInt(6, contractObject.getId());
            }
            ps.executeUpdate();
            if (!update) {
                contractObject.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        if (!update) {
            this.updateSortPosition(contractObject);
        }
    }

    private void updateSortPosition(ContractObject contractObject) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET pos=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractObject.getId());
            ps.setInt(2, contractObject.getId());
            ps.executeUpdate();
        }
    }

    public List<ContractObject> list(int contractId) throws BGException {
        return super.list("cid=?", "pos", new Object[]{contractId});
    }

    public void orderObject(int id, boolean up) throws BGException {
        String query = up ? "SELECT id, pos FROM " + this.tableName + " WHERE cid=? AND pos<? AND id!=? ORDER BY pos DESC LIMIT 1" : "SELECT id, pos FROM " + this.tableName + " WHERE cid=? AND pos>? AND id!=? ORDER BY pos ASC LIMIT 1";
        try {
            ContractObject contractObject = (ContractObject)((Object)this.get(id));
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractObject.getContractId());
            ps.setInt(2, contractObject.getPosition());
            ps.setInt(3, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int contrObjectId = rs.getInt(1);
                int contrObjectPos = rs.getInt(2);
                ps.close();
                ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET pos=? WHERE id=?");
                ps.setInt(1, contractObject.getPosition());
                ps.setInt(2, contrObjectId);
                ps.executeUpdate();
                ps.setInt(1, contrObjectPos);
                ps.setInt(2, id);
                ps.executeUpdate();
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }
}

