/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.managed;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.resource.ResourceManager;

public class ManagedBeanInfo<B> {
    protected final Class<? extends B> clazz;
    protected final Constructor<? extends B> constructor;
    private final ConcurrentMap<String, Method> methodMap = new ConcurrentHashMap<String, Method>(8);
    private final ConcurrentMap<String, Method> getterMap = new ConcurrentHashMap<String, Method>(8);
    private final ConcurrentMap<String, Method> setterMap = new ConcurrentHashMap<String, Method>(8);
    private static final Class<?>[] nilClassArray = new Class[0];
    private Method postConstruct = null;
    private Method preDestroy = null;

    public ManagedBeanInfo(Class<? extends B> clazz) {
        this.clazz = clazz;
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getAnnotation(PostConstruct.class) == null) continue;
            this.postConstruct = m;
            if (this.postConstruct.isAccessible() || (this.postConstruct.getModifiers() & 1) != 0) break;
            this.postConstruct.setAccessible(true);
            break;
        }
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getAnnotation(PreDestroy.class) == null) continue;
            this.preDestroy = m;
            if (this.preDestroy.isAccessible() || (this.preDestroy.getModifiers() & 1) != 0) break;
            this.preDestroy.setAccessible(true);
            break;
        }
        Constructor<B> constructor = null;
        try {
            constructor = clazz.getConstructor(nilClassArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.constructor = constructor;
    }

    public void postConstruct(ServerContext context, int moduleId, Object t) throws Exception {
        ResourceManager resourceManager = context.getResourceManager();
        resourceManager.inject(context, t, moduleId);
        if (this.postConstruct != null) {
            this.postConstruct.invoke(t, new Object[0]);
        }
    }

    public B newInstance() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (NullPointerException e) {
            throw new InstantiationException(this.clazz.getName());
        }
    }

    public void preDestroy(Object action) throws Exception {
        if (this.preDestroy != null) {
            this.preDestroy.invoke(action, new Object[0]);
        }
    }

    public Method getMethod(String operation) throws SecurityException, NoSuchMethodException {
        Method method = (Method)this.methodMap.get(operation);
        if (method == null) {
            Method newMethod;
            block5: {
                try {
                    newMethod = this.clazz.getMethod(operation, new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    newMethod = null;
                    for (Method m : this.clazz.getMethods()) {
                        if (!m.getName().equals(operation)) continue;
                        newMethod = m;
                        break;
                    }
                    if (newMethod != null) break block5;
                    throw ex;
                }
            }
            method = this.methodMap.putIfAbsent(operation, newMethod);
            if (method == null) {
                method = newMethod;
            }
        }
        return method;
    }

    public Method getGetter(B b, String name) throws NoSuchMethodException {
        Method method = (Method)this.getterMap.get(name);
        if (method == null) {
            Method newMethod = null;
            try {
                newMethod = this.clazz.getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                try {
                    newMethod = this.clazz.getMethod("is" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
                }
                catch (NoSuchMethodException ex2) {
                    newMethod = this.clazz.getMethod(name, new Class[0]);
                }
            }
            method = this.getterMap.putIfAbsent(name, newMethod);
            if (method == null) {
                method = newMethod;
            }
        }
        return method;
    }

    public Method getSetter(B b, String name) throws NoSuchMethodException {
        Method method = (Method)this.setterMap.get(name);
        if (method == null) {
            Method newMethod = null;
            String name1 = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
            for (Method m : this.clazz.getMethods()) {
                if (!m.getName().equals(name1) && !m.getName().equals(name)) continue;
                newMethod = m;
                break;
            }
            if (newMethod == null) {
                return null;
            }
            method = this.setterMap.putIfAbsent(name, newMethod);
            if (method == null) {
                method = newMethod;
            }
        }
        return method;
    }

    protected static String inferName(Class<?> clazz) {
        return Introspector.decapitalize(clazz.getSimpleName());
    }
}

