/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.reports.client.modules.inet.DeviceSelectDialog;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;

public class BGSelectedDevicePanel
extends BGUPanel {
    private BGControlPanelListSelect selectedDeviceListPanel;
    private String description;
    private DefaultListModel<BGUListItem> deviceListModel;
    private boolean isVoice = false;
    int mid;

    public BGSelectedDevicePanel(String description, int mid) {
        this.description = description;
        this.mid = mid;
    }

    public BGSelectedDevicePanel(int mid, boolean isVoice) {
        this.mid = mid;
        this.isVoice = isVoice;
    }

    public BGSelectedDevicePanel(int mid) {
        this.mid = mid;
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JButton selectDevicesButton = new JButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
        this.selectedDeviceListPanel = new BGControlPanelListSelect();
        if (this.description != null && this.description.length() > 0) {
            this.setBorder(new BGTitleBorder(" " + this.description + " "));
        }
        this.add((Component)selectDevicesButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.selectedDeviceListPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        selectDevicesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGSelectedDevicePanel.this.deviceListModel = DeviceSelectDialog.showDeviceDialog((int)BGSelectedDevicePanel.this.mid, (boolean)BGSelectedDevicePanel.this.isVoice);
                BGSelectedDevicePanel.this.selectedDeviceListPanel.getList().setModel(BGSelectedDevicePanel.this.deviceListModel);
            }
        });
    }

    public List<Integer> getSelectedDeviceItem() {
        return this.selectedDeviceListPanel.getListIds();
    }

    public void setSelectedDeviceItem(String values, int mid, boolean isVoice) throws BGException {
        DefaultListModel<BGUListItem> listModel = new DefaultListModel<BGUListItem>();
        ClientContext ctx = new ClientContext("kernel", 0, mid, null);
        ArrayList<Object> devices = new ArrayList<Object>();
        if (isVoice) {
            VoiceDeviceService voiceService = ctx.getPort(VoiceDeviceService.class, mid);
            for (String id : Utils.toList(values)) {
                Device device = voiceService.deviceGet(Integer.parseInt(id));
                if (device == null) continue;
                devices.add(device);
            }
        } else {
            InetDeviceService inetService = ctx.getPort(InetDeviceService.class, mid);
            for (String id : Utils.toList(values)) {
                InetDevice device = inetService.inetDeviceGet(Integer.parseInt(id));
                if (device == null) continue;
                devices.add(device);
            }
        }
        listModel.addAll(devices.stream().map(d -> new BGUListItem(d.getId(), d.getTitle(), true)).toList());
        this.selectedDeviceListPanel.getList().setModel(listModel);
        this.selectedDeviceListPanel.setListValues(values);
    }
}

