/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGClientBaseResultPopup;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.search.client.ContracHistoryTableModel;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractHistoryRecord;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;

public class BGClientHistoryResultPopup
extends BGClientBaseResultPopup {
    private JPanel filterPanel;
    private List<ContractHistoryRecord> contracts;
    private ContracHistoryTableModel tableModel = new ContracHistoryTableModel();

    public BGClientHistoryResultPopup(ClientContext clientContext) {
        super(clientContext);
        this.add("Center", this.getTablePanel());
        this.add("South", this.getFilterPeriodPanel());
    }

    private JPanel getTablePanel() {
        BGUTable table = new BGUTable(this.tableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BGClientHistoryResultPopup.this.tableModel.optSelectedRow().ifPresent(contractHistoryRecord -> {
                        BGClientBase.getFrame().getTabbedPane().addContractEditorTab(contractHistoryRecord.getContractId());
                        BGClientHistoryResultPopup.this.setVisible(false);
                    });
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setOpaque(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getFilterPeriodPanel() {
        if (this.filterPanel == null) {
            ActionListener actionListener = e -> this.applyFilter(e.getActionCommand());
            this.filterPanel = new JPanel(new GridBagLayout());
            this.filterPanel.setOpaque(false);
            this.filterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5), new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0443")));
            this.filterPanel.add((Component)new PeriodFilterButton("\u0417\u0430 \u0432\u0435\u0441\u044c \u043f\u0435\u0440\u0438\u043e\u0434", "all", actionListener), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)new PeriodFilterButton("\u0421\u0435\u0433\u043e\u0434\u043d\u044f", "now", actionListener), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)new PeriodFilterButton("\u0412\u0447\u0435\u0440\u0430", "yesterday", actionListener), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)new PeriodFilterButton("\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u043d\u0435\u0434\u0435\u043b\u044f", "currWeek", actionListener), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)new PeriodFilterButton("\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u043d\u0435\u0434\u0435\u043b\u044f", "prevWeek", actionListener), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)new PeriodFilterButton("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446", "currMonth", actionListener), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)new PeriodFilterButton("\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u043c\u0435\u0441\u044f\u0446", "prevMonth", actionListener), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add(Box.createGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.filterPanel;
    }

    public void applyFilter(String periodMode) {
        if (periodMode == null) {
            try {
                this.contracts = this.getContractService().searchContractHistoryRecord(new Page(1, 50)).getList();
            }
            catch (BGException e2) {
                ClientUtils.showErrorMessageDialog(e2);
            }
        }
        periodMode = periodMode == null ? "all" : periodMode;
        LocalDate now = LocalDate.now();
        ArrayList<ContractHistoryRecord> list = new ArrayList<ContractHistoryRecord>();
        switch (periodMode) {
            case "now": {
                this.contracts.stream().filter(e -> TimeUtils.convertDateToLocalDate(e.getLastOpen()).isEqual(now)).forEach(e -> list.add((ContractHistoryRecord)e));
                break;
            }
            case "yesterday": {
                LocalDate dateFrom = now.minusDays(1L);
                this.contracts.stream().filter(e -> TimeUtils.convertDateToLocalDate(e.getLastOpen()).isEqual(dateFrom)).forEach(e -> list.add((ContractHistoryRecord)e));
                break;
            }
            case "currWeek": {
                LocalDate dateFrom = now.minusDays(now.get(ChronoField.DAY_OF_WEEK)).minusDays(1L);
                this.contracts.stream().filter(e -> TimeUtils.convertDateToLocalDate(e.getLastOpen()).isAfter(dateFrom)).forEach(e -> list.add((ContractHistoryRecord)e));
                break;
            }
            case "prevWeek": {
                LocalDate dateFrom = now.minusDays(now.get(ChronoField.DAY_OF_WEEK)).minusDays(8L);
                LocalDate dateTo = now.minusDays(now.get(ChronoField.DAY_OF_WEEK));
                this.contracts.stream().filter(e -> TimeUtils.convertDateToLocalDate(e.getLastOpen()).isAfter(dateFrom) && TimeUtils.convertDateToLocalDate(e.getLastOpen()).isBefore(dateTo)).forEach(e -> list.add((ContractHistoryRecord)e));
                break;
            }
            case "currMonth": {
                LocalDate dateFrom = now.minusDays(now.get(ChronoField.DAY_OF_MONTH)).minusDays(1L);
                this.contracts.stream().filter(e -> TimeUtils.convertDateToLocalDate(e.getLastOpen()).isAfter(dateFrom)).forEach(e -> list.add((ContractHistoryRecord)e));
                break;
            }
            case "prevMonth": {
                LocalDate dateFrom = now.minusDays(now.get(ChronoField.DAY_OF_MONTH)).minusMonths(1L).minusDays(1L);
                LocalDate dateTo = now.minusDays(now.get(ChronoField.DAY_OF_MONTH));
                this.contracts.stream().filter(e -> TimeUtils.convertDateToLocalDate(e.getLastOpen()).isAfter(dateFrom) && TimeUtils.convertDateToLocalDate(e.getLastOpen()).isBefore(dateTo)).forEach(e -> list.add((ContractHistoryRecord)e));
                break;
            }
            default: {
                list.addAll(this.contracts);
            }
        }
        this.tableModel.setData(list);
    }

    class PeriodFilterButton
    extends JButton {
        public PeriodFilterButton(String text, String actionCommand, ActionListener actionListener) {
            super(text);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
        }
    }
}

