/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.voice;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.tariff.voice.table.ZoneModel;
import bitel.billing.module.tariff.voice.table.ZoneNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.table.tree.JTreeTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ServiceConfigZone
extends BGPanel {
    private final boolean load = true;
    private String title;
    private ZoneModel model = new ZoneModel();
    private JTreeTable table = new JTreeTable(this.model);
    private List<ZoneNode> currentNodes = new LinkedList<ZoneNode>();
    private JPanel edit = new JPanel(new GridBagLayout());
    private BGComboBox<ComboBoxItem> zone = new BGComboBox();
    private JComboBox<Object> menuList = new BGComboBox<Object>();
    private BasicComboPopup menu;
    private JPopupMenu menuLevelStart = new JPopupMenu();
    private JPopupMenu menuLevelEnd = new JPopupMenu();
    private BGSelectFilePanel file = new BGSelectFilePanel(false);

    public ServiceConfigZone() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.edit.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 "));
        this.edit.add((Component)new JLabel("\u0417\u043e\u043d\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.edit.add(this.zone, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.edit.setVisible(false);
        JPanel panel = new JPanel(new GridBagLayout());
        final BGTextField find = new BGTextField(20);
        BGButton findButton = new BGButton("\u041d\u0430\u0439\u0442\u0438");
        panel.add((Component)find, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)findButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 5), 0, 0));
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = find.getText();
                ZoneNode root = (ZoneNode)ServiceConfigZone.this.model.getRoot();
                ZoneNode node = root.findParentNode(text);
                while (node != null && !node.code.equals(text)) {
                    String findedPrefix = node.code;
                    ServiceConfigZone.this.table.getTree().expandPath(new TreePath(node.getPath()));
                    node = root.findParentNode(text);
                    if (!findedPrefix.equals(node.code)) continue;
                    break;
                }
                if (node != null) {
                    ServiceConfigZone.this.table.getTree().scrollPathToVisible(new TreePath(node.getPath()));
                    node = root.findParentNode(text);
                    TreePath path = new TreePath(node.getPath());
                    ServiceConfigZone.this.table.getTree().expandPath(path);
                    ServiceConfigZone.this.table.getTree().setSelectionPath(path);
                    ServiceConfigZone.this.table.getTree().scrollPathToVisible(path);
                }
            }
        };
        findButton.addActionListener(l);
        find.addActionListener(l);
        this.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.edit, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.menuList.setMaximumRowCount(20);
        this.menu = new BasicComboPopup(this.menuList){

            @Override
            protected void configureList() {
                super.configureList();
                this.list.setVisibleRowCount(20);
            }
        };
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.evaluatePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int c = ServiceConfigZone.this.table.getColumnModel().getColumnIndexAtX(e.getX());
                    switch (c) {
                        case 0: 
                        case 1: {
                            ServiceConfigZone.this.menu.show(e.getComponent(), e.getX(), e.getY());
                            break;
                        }
                        case 2: {
                            ServiceConfigZone.this.menuLevelStart.show(e.getComponent(), e.getX(), e.getY());
                            break;
                        }
                        case 3: {
                            ServiceConfigZone.this.menuLevelEnd.show(e.getComponent(), e.getX(), e.getY());
                            break;
                        }
                    }
                }
            }
        });
        this.menuList.addActionListener(e -> {
            Object item = this.menuList.getSelectedItem();
            if (item instanceof ComboBoxItem) {
                ComboBoxItem comboBoxItem = (ComboBoxItem)item;
                this.set((String)comboBoxItem.getObject());
            }
            this.menuList.setSelectedIndex(-1);
            this.menu.hide();
        });
        BGButton save = new BGButton();
        save.setText("\u042d\u043a\u0441\u043f\u043e\u0440\u0442");
        save.addActionListener(e -> this.saveToFile());
        BGButton load = new BGButton();
        load.setText("\u0418\u043c\u043f\u043e\u0440\u0442");
        load.addActionListener(e -> this.loadFromFile());
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.setBorder(new BGTitleBorder(" \u0418\u043c\u043f\u043e\u0440\u0442/\u042d\u043a\u0441\u043f\u043e\u0440\u0442 "));
        bottomPanel.add((Component)this.file, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        bottomPanel.add((Component)save, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        bottomPanel.add((Component)load, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)bottomPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        JPanel closePanel = new JPanel(new GridBagLayout());
        BGButton button = new BGButton();
        button.setText("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        button.addActionListener(e -> this.setVisible(false));
        closePanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        closePanel.add((Component)button, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)closePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        ActionListener lStart = e -> this.setLevel(e.getActionCommand(), true);
        ActionListener lEnd = e -> this.setLevel(e.getActionCommand(), false);
        JMenuItem item = new JMenuItem("\u0411\u0435\u0437 \u0443\u0440\u043e\u0432\u043d\u044f");
        item.setActionCommand("0");
        item.addActionListener(lStart);
        this.menuLevelStart.add(item);
        item = new JMenuItem("\u0411\u0435\u0437 \u0443\u0440\u043e\u0432\u043d\u044f");
        item.setActionCommand("0");
        item.addActionListener(lEnd);
        this.menuLevelEnd.add(item);
        for (int i = 1; i < 13; ++i) {
            String c = String.valueOf(i).intern();
            item = new JMenuItem(c);
            item.setActionCommand(c);
            item.addActionListener(lStart);
            this.menuLevelStart.add(item);
            item = new JMenuItem(c);
            item.setActionCommand(c);
            item.addActionListener(lEnd);
            this.menuLevelEnd.add(item);
        }
        Objects.requireNonNull(this);
        TreeWillExpandListener tweListener = new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                ZoneNode node = (ZoneNode)event.getPath().getLastPathComponent();
                if (!node.loaded) {
                    node.loaded = true;
                    ServiceConfigZone.this.model.fireTreeStructureChanged(node);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        };
        this.table.addTreeWillExpandListener(tweListener);
        this.table.setRowHeight(20);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
    }

    @Override
    public void setData() {
        Request req = new Request();
        req.setModule("tariff.voice");
        req.setModuleId(this.getModuleId());
        req.setAction("Zone");
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            DefaultComboBoxModel<ComboBoxItem> comboBoxModel = ClientUtils.buildComboBox(XMLUtils.getNode(doc, "zones"), null);
            DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
            for (int index = 0; index < comboBoxModel.getSize(); ++index) {
                model.addElement(comboBoxModel.getElementAt(index));
            }
            this.menuList.setModel(model);
            this.menuList.setSelectedIndex(-1);
        }
        req = new Request();
        req.setModule("tariff.voice");
        req.setModuleId(this.getModuleId());
        req.setAction("GeographicCodeTree");
        req.setAttribute("map_id", this.id);
        req.setAttribute("find", "");
        InputStream docum = this.getInputStream(req);
        this.model.load(docum);
        Object root = this.model.getChild(this.model.getRoot(), 0);
        if (root != null) {
            ZoneNode r = (ZoneNode)root;
            r.title = this.title;
            this.table.getTree().expandPath(new TreePath(this.model.getPathToRoot(r)));
        }
        this.table.updateUI();
    }

    private void set(String id) {
        for (TreePath path : this.table.getTree().getSelectionPaths()) {
            ZoneNode node = (ZoneNode)path.getLastPathComponent();
            if (node.code == null || node.code.length() <= 0) continue;
            this.currentNodes.add((ZoneNode)path.getLastPathComponent());
        }
        StringBuilder builder = new StringBuilder();
        for (ZoneNode node : this.currentNodes) {
            builder.append(node.code);
            builder.append(",");
        }
        Request req = new Request();
        req.setModule("tariff.voice");
        req.setModuleId(this.getModuleId());
        req.setAction("ZoneMapItemUpdate");
        req.setAttribute("map_id", this.id);
        req.setAttribute("codes", builder.toString());
        req.setAttribute("zone_id", id);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            Element el = XMLUtils.getElement(doc, "zone");
            int zoneId = Utils.parseInt(el.getAttribute("id"), 0);
            String title = el.getAttribute("title");
            for (ZoneNode node : this.currentNodes) {
                node.zoneId = zoneId;
                node.zone = title;
            }
            this.table.updateUI();
        }
        this.currentNodes.clear();
    }

    private void setLevel(String id, boolean start) {
        for (TreePath path : this.table.getTree().getSelectionPaths()) {
            ZoneNode node = (ZoneNode)path.getLastPathComponent();
            if (node.code == null || node.code.length() <= 0) continue;
            this.currentNodes.add((ZoneNode)path.getLastPathComponent());
        }
        StringBuilder builder = new StringBuilder();
        for (ZoneNode node : this.currentNodes) {
            builder.append(node.code);
            builder.append(",");
        }
        Request req = new Request();
        req.setModule("tariff.voice");
        req.setModuleId(this.getModuleId());
        req.setAction("ZoneMapItemUpdate");
        req.setAttribute("map_id", this.id);
        req.setAttribute("codes", builder.toString());
        if (start) {
            req.setAttribute("level_start", id);
        } else {
            req.setAttribute("level_end", id);
        }
        this.getDocument(req);
        if ("0".equals(id)) {
            id = "";
        }
        this.table.updateUI();
        this.currentNodes.clear();
    }

    private void saveToFile() {
        File file = this.file.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
            return;
        }
        Request request = new Request();
        request.setModule("tariff.voice");
        request.setModuleId(this.getModuleId());
        request.setAction("ZoneMapItemExport");
        request.setAttribute("map_id", this.id);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            try {
                FileOutputStream out = new FileOutputStream(file);
                XMLUtils.serialize(XMLUtils.getElement(doc, "zones"), new StreamResult(out), "UTF-8", true);
                out.close();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private void loadFromFile() {
        File file = this.file.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
            return;
        }
        Request request = new Request();
        request.setModule("tariff.voice");
        request.setModuleId(this.getModuleId());
        request.setAction("ZoneMapItemImport");
        request.setAttribute("map_id", this.id);
        try {
            request.setAttribute("data", new String(Utils.readByBlock(new FileInputStream(file)), "UTF-8"));
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.setData();
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public Element getNode(String code) {
        Request request = new Request();
        request.setModule("tariff.voice");
        request.setModuleId(this.getModuleId());
        request.setAction("GeographicCodeTreeNode");
        request.setAttribute("map_id", this.id);
        request.setAttribute("code", code);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Node node;
            for (node = doc.getDocumentElement(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
            }
            return node;
        }
        return null;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

