/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.call;

import bitel.billing.module.common.BSHEditor;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGRadio;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModelXML;

public class CallServiceConfigNAS
extends ServiceConfigTabbedPanel {
    private boolean newConfig = false;
    private String config_id = null;
    private BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();
    private BGButtonPanelRestoreOkCancelHelp bGControlPanel_02 = new BGButtonPanelRestoreOkCancelHelp();
    private JPasswordField secret = new JPasswordField();
    private CardLayout cardLayout1 = new CardLayout();
    private JTextField ipaddr = new JTextField();
    private BGButton saveConfigButton = new BGButton();
    private BGButton newConfigButton = new BGButton();
    private BGButton openConfigButton = new BGButton();
    private BGButton setConfigButton = new BGButton();
    private BGButton deleteConfigButton = new BGButton();
    private BGButton cancelConfigButton = new BGButton();
    private JTextField title = new JTextField();
    private JTextArea comment = new JTextArea();
    private BGUTable nasTable;
    private BGTable configTable = new BGTable();
    private BGTable commonConfigTable = new BGTable();
    private BGConfigEditorPane configData = new BGConfigEditorPane();
    private BGTextField configTitle = new BGTextField();
    private JComboBox<ComboBoxItem> vendorList = new JComboBox();
    private JPanel editor = new JPanel();
    private JPanel configViewAndEditPanel = new JPanel();
    private BSHEditor scriptTA = new BSHEditor();
    private BGTableModelXML nasTableModel;

    public CallServiceConfigNAS() {
        this.rb_name = "bitel.billing.module.services.call.setup";
        this.getModuleDoc(CallServiceConfigNAS.class);
        this.nasTableModel = new BGTableModelXML((Node)this.moduleDoc, ResourceBundle.getBundle(this.rb_name), "naslist");
        this.nasTable = new BGUTable(this.nasTableModel);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.configTable.setHeader(this.rb_name, this.moduleDoc, "nasconfig");
        this.commonConfigTable.setHeader(this.rb_name, this.moduleDoc, "nasconfig_common");
        this.editor.setVisible(false);
    }

    private JPanel getCommonConfigPanel() {
        JPanel commonConfigPanel = new JPanel(new GridBagLayout());
        final JScrollPane tablePane = new JScrollPane(this.commonConfigTable);
        commonConfigPanel.add((Component)tablePane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
        JPanel commonConfigButtons = new JPanel(new GridBagLayout());
        final BGButton saveCConfigButton = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        saveCConfigButton.setActionCommand("save");
        saveCConfigButton.setMargin(new Insets(2, 4, 2, 4));
        final BGButton newCConfigButton = new BGButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        newCConfigButton.setActionCommand("new");
        newCConfigButton.setMargin(new Insets(2, 4, 2, 4));
        final BGButton openCConfigButton = new BGButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c");
        openCConfigButton.setActionCommand("open");
        openCConfigButton.setMargin(new Insets(2, 4, 2, 4));
        final BGButton setCConfigButton = new BGButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        setCConfigButton.setActionCommand("set");
        setCConfigButton.setMargin(new Insets(2, 4, 2, 4));
        final BGButton deleteCConfigButton = new BGButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        deleteCConfigButton.setActionCommand("delete");
        deleteCConfigButton.setMargin(new Insets(2, 4, 2, 4));
        final BGButton cancelCConfigButton = new BGButton("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c");
        cancelCConfigButton.setActionCommand("cancel");
        cancelCConfigButton.setMargin(new Insets(2, 4, 2, 4));
        commonConfigButtons.add((Component)newCConfigButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 5), 0, 0));
        commonConfigButtons.add((Component)openCConfigButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        commonConfigButtons.add((Component)deleteCConfigButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 10), 0, 0));
        commonConfigButtons.add((Component)saveCConfigButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 5), 0, 0));
        commonConfigButtons.add((Component)cancelCConfigButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 10), 0, 0));
        commonConfigButtons.add((Component)setCConfigButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        final JPanel commonConfigEditorPanel = new JPanel(new GridBagLayout());
        final BGTextField configTitle = new BGTextField();
        final BGConfigEditorPane configData = new BGConfigEditorPane();
        commonConfigEditorPanel.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        commonConfigEditorPanel.add((Component)configTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        commonConfigEditorPanel.add((Component)new JScrollPane(configData), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        ActionListener al = new ActionListener(){
            private boolean newConfig = false;
            private String config_id = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if ("new".equals(command)) {
                    this.newConfig = true;
                    newCConfigButton.setEnabled(false);
                    openCConfigButton.setEnabled(false);
                    deleteCConfigButton.setEnabled(false);
                    saveCConfigButton.setEnabled(true);
                    cancelCConfigButton.setEnabled(true);
                    setCConfigButton.setEnabled(false);
                    this.config_id = null;
                    configTitle.setText("");
                    configData.setText("");
                    commonConfigEditorPanel.setVisible(true);
                    tablePane.setVisible(false);
                } else if ("open".equals(command)) {
                    this.config_id = ClientUtils.getRowId(CallServiceConfigNAS.this.commonConfigTable, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e", null);
                    if (this.config_id != null) {
                        this.newConfig = false;
                        Request request = new Request();
                        request.setModule("call");
                        request.setAction("GetNasConfig");
                        request.setModuleId(CallServiceConfigNAS.this.getModuleId());
                        request.setAttribute("config_id", this.config_id);
                        Document doc = CallServiceConfigNAS.this.getDocument(request);
                        if (ClientUtils.checkStatus(doc)) {
                            Element config = XMLUtils.selectElement(doc, "//config");
                            String title = config.getAttribute("title");
                            configTitle.setText(title);
                            configData.setText(ClientUtils.linesToString(config));
                            newCConfigButton.setEnabled(false);
                            openCConfigButton.setEnabled(false);
                            deleteCConfigButton.setEnabled(false);
                            saveCConfigButton.setEnabled(true);
                            cancelCConfigButton.setEnabled(true);
                            setCConfigButton.setEnabled(false);
                            commonConfigEditorPanel.setVisible(true);
                            tablePane.setVisible(false);
                        }
                    }
                } else if ("save".equals(command)) {
                    if (configTitle.getText().trim().length() == 0) {
                        ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u043d\u0430\u043d\u0438\u0435");
                        return;
                    }
                    Request request = new Request();
                    request.setModule("call");
                    request.setAction("UpdateNasConfig");
                    request.setModuleId(CallServiceConfigNAS.this.getModuleId());
                    request.setAttribute("id", 0);
                    if (this.config_id != null) {
                        request.setAttribute("config_id", this.config_id);
                    }
                    request.setAttribute("title", configTitle.getText().trim());
                    request.setAttribute("config", configData.getText().trim());
                    Document doc = CallServiceConfigNAS.this.getDocument(request);
                    if (ClientUtils.checkStatus(doc)) {
                        Element config = XMLUtils.selectElement(doc, "//config");
                        this.config_id = config.getAttribute("id");
                        String userName = config.getAttribute("user");
                        String dt = config.getAttribute("dt");
                        String title = config.getAttribute("title");
                        if (Utils.notBlankString(this.config_id) && Utils.notBlankString(userName) && Utils.notBlankString(dt) && Utils.notBlankString(title)) {
                            boolean s = false;
                            int rowIndex = CallServiceConfigNAS.this.commonConfigTable.getSelectedRow();
                            if (rowIndex > -1) {
                                Object value = CallServiceConfigNAS.this.commonConfigTable.getValueAt(rowIndex, 1);
                                s = !this.newConfig && value instanceof Boolean && (Boolean)value != false;
                            }
                            Vector<Object> rowData = new Vector<Object>();
                            rowData.addElement(this.config_id);
                            rowData.addElement(s);
                            rowData.addElement(dt);
                            rowData.addElement(title);
                            rowData.addElement(userName);
                            if (this.newConfig) {
                                if (CallServiceConfigNAS.this.commonConfigTable.getRowCount() > 0) {
                                    CallServiceConfigNAS.this.commonConfigTable.insertRow(0, rowData);
                                } else {
                                    CallServiceConfigNAS.this.commonConfigTable.addRow(rowData);
                                }
                            } else {
                                CallServiceConfigNAS.this.commonConfigTable.removeRow(rowIndex);
                                if (rowIndex > -1 && rowIndex < CallServiceConfigNAS.this.commonConfigTable.getRowCount()) {
                                    CallServiceConfigNAS.this.commonConfigTable.insertRow(rowIndex, rowData);
                                } else {
                                    CallServiceConfigNAS.this.commonConfigTable.addRow(rowData);
                                }
                            }
                            newCConfigButton.setEnabled(true);
                            openCConfigButton.setEnabled(true);
                            deleteCConfigButton.setEnabled(true);
                            saveCConfigButton.setEnabled(false);
                            cancelCConfigButton.setEnabled(false);
                            setCConfigButton.setEnabled(true);
                        } else {
                            ClientUtils.showErrorMessageDialog("config_id = null!!!");
                        }
                    }
                    commonConfigEditorPanel.setVisible(false);
                    tablePane.setVisible(true);
                } else if ("delete".equals(command)) {
                    this.config_id = ClientUtils.getRowId(CallServiceConfigNAS.this.commonConfigTable, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e", null);
                    if (this.config_id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                        Request request = new Request();
                        request.setModule("call");
                        request.setAction("DeleteNasConfig");
                        request.setModuleId(CallServiceConfigNAS.this.getModuleId());
                        request.setAttribute("config_id", this.config_id);
                        if (ClientUtils.checkStatus(CallServiceConfigNAS.this.getDocument(request))) {
                            CallServiceConfigNAS.this.commonConfigTable.removeRow(CallServiceConfigNAS.this.commonConfigTable.getSelectedRow());
                        }
                    }
                } else if ("set".equals(command)) {
                    int index = CallServiceConfigNAS.this.commonConfigTable.getSelectedRow();
                    if (index == -1) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
                        return;
                    }
                    Boolean selected = (Boolean)CallServiceConfigNAS.this.commonConfigTable.getValueAt(index, 1);
                    CallServiceConfigNAS.this.commonConfigTable.setValueAt(selected == false, index, 1);
                    CallServiceConfigNAS.this.commonConfigTable.repaint();
                } else if ("cancel".equals(command)) {
                    newCConfigButton.setEnabled(true);
                    openCConfigButton.setEnabled(true);
                    deleteCConfigButton.setEnabled(true);
                    saveCConfigButton.setEnabled(false);
                    cancelCConfigButton.setEnabled(false);
                    setCConfigButton.setEnabled(true);
                    commonConfigEditorPanel.setVisible(false);
                    tablePane.setVisible(true);
                }
            }
        };
        saveCConfigButton.addActionListener(al);
        cancelCConfigButton.addActionListener(al);
        newCConfigButton.addActionListener(al);
        openCConfigButton.addActionListener(al);
        setCConfigButton.addActionListener(al);
        deleteCConfigButton.addActionListener(al);
        commonConfigPanel.add((Component)commonConfigEditorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        commonConfigPanel.add((Component)commonConfigButtons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        commonConfigEditorPanel.setVisible(false);
        newCConfigButton.setEnabled(true);
        openCConfigButton.setEnabled(true);
        deleteCConfigButton.setEnabled(true);
        saveCConfigButton.setEnabled(false);
        cancelCConfigButton.setEnabled(false);
        setCConfigButton.setEnabled(true);
        return commonConfigPanel;
    }

    private void jbInit() throws Exception {
        JLabel jLabel1 = new JLabel();
        JPanel topEditorPanel = new JPanel();
        JPanel nasParamsPanel = new JPanel();
        JPanel ipaddrPanel = new JPanel();
        JPanel commentPanel = new JPanel();
        JPanel titlePanel = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel configPanel = new JPanel(new GridBagLayout());
        JPanel secretPanel = new JPanel();
        JPanel configButtonsPanel = new JPanel();
        JPanel jPanel12 = new JPanel();
        JScrollPane nasTableScroll = new JScrollPane();
        JScrollPane commentScroll = new JScrollPane();
        JScrollPane configTableScroll = new JScrollPane();
        JScrollPane configScroll = new JScrollPane();
        JPanel vendorsPanel = new JPanel();
        JPanel commonConfigPanel = this.getCommonConfigPanel();
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(600, 400));
        JTabbedPane configAndScriptPanel = new JTabbedPane();
        configAndScriptPanel.add((Component)configPanel, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
        configAndScriptPanel.add((Component)commonConfigPanel, "\u041e\u0431\u0449\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
        JPanel scriptPanel = new JPanel(new GridBagLayout());
        scriptPanel.add((Component)this.scriptTA, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        configAndScriptPanel.add((Component)scriptPanel, "\u0421\u043a\u0440\u0438\u043f\u0442 \u043f\u0440\u0435\u0434\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438");
        this.editor.setLayout(new GridBagLayout());
        topEditorPanel.setLayout(new GridBagLayout());
        topEditorPanel.setVisible(true);
        topEditorPanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 NAS "));
        this.bGControlPanel_02.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallServiceConfigNAS.this.bGControlPanel_02_actionPerformed(e);
            }
        });
        this.nasTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CallServiceConfigNAS.this.bGTable0_mouseClicked(e);
            }
        });
        secretPanel.setBorder(new BGTitleBorder(" \u0421\u0435\u043a\u0440\u0435\u0442 "));
        secretPanel.setLayout(new GridBagLayout());
        nasParamsPanel.setLayout(new GridBagLayout());
        this.title.setMinimumSize(new Dimension(4, 24));
        this.title.setPreferredSize(new Dimension(275, 24));
        this.title.setRequestFocusEnabled(true);
        this.title.setColumns(25);
        this.title.setHorizontalAlignment(0);
        ipaddrPanel.setLayout(new GridBagLayout());
        ipaddrPanel.setBorder(new BGTitleBorder(" \u0410\u0434\u0440\u0435\u0441 ( X.X.X.X ) "));
        commentPanel.setLayout(new GridBagLayout());
        commentPanel.setBorder(new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
        this.comment.setPreferredSize(new Dimension(220, 51));
        this.comment.setColumns(20);
        this.comment.setRows(2);
        commentScroll.setMinimumSize(new Dimension(223, 51));
        titlePanel.setLayout(new GridBagLayout());
        titlePanel.setBorder(new BGTitleBorder(" \u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 "));
        this.secret.setMinimumSize(new Dimension(110, 24));
        this.secret.setPreferredSize(new Dimension(110, 24));
        this.secret.setColumns(10);
        this.secret.setHorizontalAlignment(0);
        jPanel6.setLayout(new GridBagLayout());
        this.ipaddr.setMinimumSize(new Dimension(114, 24));
        this.ipaddr.setPreferredSize(new Dimension(4, 24));
        this.ipaddr.setColumns(10);
        this.ipaddr.setHorizontalAlignment(0);
        this.editor.setVerifyInputWhenFocusTarget(true);
        this.openConfigButton.setMargin(new Insets(2, 4, 2, 4));
        this.openConfigButton.setText("\u041e\u0442\u043a\u0440\u044b\u0442\u044c");
        this.openConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallServiceConfigNAS.this.openConfigButton_actionPerformed(e);
            }
        });
        this.configTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CallServiceConfigNAS.this.openConfigButton_actionPerformed(null);
                }
            }
        });
        this.setConfigButton.setMargin(new Insets(2, 4, 2, 4));
        this.setConfigButton.setText("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        this.setConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallServiceConfigNAS.this.setConfigButton_actionPerformed(e);
            }
        });
        this.deleteConfigButton.setMargin(new Insets(2, 4, 2, 4));
        this.deleteConfigButton.setText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        this.deleteConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallServiceConfigNAS.this.deleteConfigButton_actionPerformed(e);
            }
        });
        this.cancelConfigButton.setEnabled(false);
        this.cancelConfigButton.setMargin(new Insets(2, 4, 2, 4));
        this.cancelConfigButton.setText("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c");
        this.cancelConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallServiceConfigNAS.this.cancelConfigButton_actionPerformed(e);
            }
        });
        this.configViewAndEditPanel.setLayout(this.cardLayout1);
        jPanel12.setLayout(new GridBagLayout());
        this.saveConfigButton.setEnabled(false);
        this.saveConfigButton.setMargin(new Insets(2, 4, 2, 4));
        this.saveConfigButton.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        this.saveConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallServiceConfigNAS.this.saveConfigButton_actionPerformed(e);
            }
        });
        this.newConfigButton.setMargin(new Insets(2, 4, 2, 4));
        this.newConfigButton.setText("\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        this.newConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallServiceConfigNAS.this.newConfigButton_actionPerformed(e);
            }
        });
        configButtonsPanel.setLocale(Locale.getDefault());
        configButtonsPanel.setLayout(new GridBagLayout());
        jLabel1.setText("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435: ");
        vendorsPanel.setLayout(new GridBagLayout());
        vendorsPanel.setBorder(new BGTitleBorder(" \u0412\u0435\u043d\u0434\u043e\u0440 "));
        this.add((Component)nasTableScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)topEditorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topEditorPanel.add((Component)nasParamsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        nasParamsPanel.add((Component)ipaddrPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ipaddrPanel.add((Component)this.ipaddr, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        nasParamsPanel.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        titlePanel.add((Component)this.title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        nasParamsPanel.add((Component)this.periodPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        nasParamsPanel.add((Component)commentPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        commentPanel.add((Component)commentScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        nasParamsPanel.add((Component)secretPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        secretPanel.add((Component)this.secret, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        nasParamsPanel.add((Component)vendorsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        vendorsPanel.add(this.vendorList, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        commentScroll.setViewportView(this.comment);
        jPanel6.add((Component)configScroll, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel6.add((Component)jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel6.add((Component)this.configTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        topEditorPanel.add((Component)configAndScriptPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        configPanel.add((Component)this.configViewAndEditPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.configViewAndEditPanel.add((Component)jPanel12, "table");
        jPanel12.add((Component)configTableScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        configTableScroll.setViewportView(this.configTable);
        this.configViewAndEditPanel.add((Component)jPanel6, "editor");
        configPanel.add((Component)configButtonsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        configButtonsPanel.add((Component)this.newConfigButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 5), 0, 0));
        configButtonsPanel.add((Component)this.openConfigButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        configButtonsPanel.add((Component)this.deleteConfigButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 10), 0, 0));
        configButtonsPanel.add((Component)this.saveConfigButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 5), 0, 0));
        configButtonsPanel.add((Component)this.cancelConfigButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 10), 0, 0));
        configButtonsPanel.add((Component)this.setConfigButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
        configScroll.setViewportView(this.configData);
        this.editor.add((Component)this.bGControlPanel_02, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        nasTableScroll.setViewportView(this.nasTable);
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule("call");
        request.setModuleId(this.getModuleId());
        request.setAction("NASList");
        this.setDocument(this.getDocument(request));
        this.buildVendorsList();
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            this.nasTableModel.setData(doc);
        }
    }

    protected void editRow() {
        int row = this.nasTable.getSelectedRow();
        if (row < 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return;
        }
        this.id = (String)this.nasTable.getValueAt(row, 0);
        if (this.id == null) {
            return;
        }
        Request request = new Request();
        request.setModule("call");
        request.setAction("NasInfo");
        request.setAttribute("id", this.id);
        request.setModuleId(this.getModuleId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.configTable.updateData(XMLUtils.selectNode(doc, "//table"));
            this.commonConfigTable.updateData(XMLUtils.selectNode(doc, "//commonTable"));
            Element nas = XMLUtils.selectElement(doc, "//nas");
            this.title.setText(XMLUtils.getAttribute(nas, "title", "\u0431\u0435\u0437 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f"));
            this.ipaddr.setText(XMLUtils.getAttribute(nas, "addr", ""));
            this.secret.setText(XMLUtils.getAttribute(nas, "secret", "***********"));
            this.periodPanel.setDateString1(XMLUtils.getAttribute(nas, "date1", null));
            this.periodPanel.setDateString2(XMLUtils.getAttribute(nas, "date2", null));
            this.comment.setText(XMLUtils.getAttribute(nas, "comment", ""));
            String config = XMLUtils.getAttribute(nas, "config_id", null);
            this.configTable.setRadioValue(1, Utils.parseInt(config, 0));
            String vendor = XMLUtils.getAttribute(nas, "vendor", "0");
            int size = this.vendorList.getItemCount();
            for (int i = 0; i < size; ++i) {
                ComboBoxItem item = this.vendorList.getItemAt(i);
                if (!item.getObject().equals(vendor)) continue;
                this.vendorList.setSelectedIndex(i);
                break;
            }
            this.newConfigButton.setEnabled(true);
            this.editor.setVisible(true);
            Element script = XMLUtils.selectElement(doc, "//script");
            this.scriptTA.setText(ClientUtils.linesToString(script));
            this.cancelConfig();
        }
    }

    public void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.setData();
        } else if ("ok".equals(actionCommand)) {
            Request request = new Request();
            request.setModule("call");
            request.setAction("UpdateNasInfo");
            request.setModuleId(this.getModuleId());
            if (this.id != null) {
                request.setAttribute("id", this.id);
            }
            request.setAttribute("title", this.title.getText());
            request.setAttribute("secret", new String(this.secret.getPassword()));
            request.setAttribute("addr", this.ipaddr.getText());
            request.setAttribute("date1", this.periodPanel.getDateString1());
            request.setAttribute("date2", this.periodPanel.getDateString2());
            request.setAttribute("comment", this.comment.getText().trim());
            request.setAttribute("config", this.configTable.getRadioValue(0, 1));
            Object commonConfigs = "";
            for (int i = 0; i < this.commonConfigTable.getRowCount(); ++i) {
                if (!((Boolean)this.commonConfigTable.getValueAt(i, 1)).booleanValue()) continue;
                if (Utils.notBlankString((String)commonConfigs)) {
                    commonConfigs = (String)commonConfigs + ",";
                }
                commonConfigs = (String)commonConfigs + (String)this.commonConfigTable.getValueAt(i, 0);
            }
            request.setAttribute("common_config", (String)commonConfigs);
            request.setAttribute("script", this.scriptTA.getText());
            String vendor = "0";
            ComboBoxItem item = (ComboBoxItem)this.vendorList.getSelectedItem();
            if (item != null) {
                vendor = (String)item.getObject();
            }
            request.setAttribute("vendor", vendor);
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.editor.setVisible(false);
                this.setData();
            }
            this.cancelConfigButton_actionPerformed(null);
        } else if ("cancel".equals(actionCommand)) {
            this.editor.setVisible(false);
            this.cancelConfigButton_actionPerformed(null);
        } else if ("help".equals(actionCommand)) {
            this.openHelp(CallServiceConfigNAS.class.getName());
        }
    }

    private void bGTable0_mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.editRow();
        }
    }

    @Override
    public void editItem() {
        this.editRow();
    }

    @Override
    public void newItem() {
        this.id = null;
        this.title.setText("New NAS");
        this.secret.setText("");
        this.comment.setText("");
        this.ipaddr.setText("");
        this.scriptTA.setText("");
        this.periodPanel.setDateString1(null);
        this.periodPanel.setDateString2(null);
        this.configTable.removeRows();
        this.newConfigButton.setEnabled(false);
        this.editor.setVisible(true);
    }

    @Override
    public void deleteItem() {
        int row = this.nasTable.getSelectedRow();
        if (row < 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
            return;
        }
        this.id = (String)this.nasTableModel.getValueAt(row, 0);
        if (this.id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c NAS?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule("call");
            request.setAction("DeleteNas");
            request.setAttribute("id", this.id);
            request.setModuleId(this.getModuleId());
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.setData();
            }
        }
    }

    private void newConfigButton_actionPerformed(ActionEvent e) {
        this.newConfig = true;
        this.newConfigButton.setEnabled(false);
        this.openConfigButton.setEnabled(false);
        this.deleteConfigButton.setEnabled(false);
        this.saveConfigButton.setEnabled(true);
        this.cancelConfigButton.setEnabled(true);
        this.setConfigButton.setEnabled(false);
        this.config_id = null;
        this.configTitle.setText("");
        this.configData.setText("");
        this.cardLayout1.show(this.configViewAndEditPanel, "editor");
    }

    private void openConfigButton_actionPerformed(ActionEvent e) {
        this.config_id = ClientUtils.getRowId(this.configTable, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e", null);
        if (this.config_id != null) {
            this.newConfig = false;
            Request request = new Request();
            request.setModule("call");
            request.setAction("GetNasConfig");
            request.setModuleId(this.getModuleId());
            request.setAttribute("config_id", this.config_id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                Element config = XMLUtils.selectElement(doc, "//config");
                this.configTitle.setText(XMLUtils.getAttribute(config, "title", "-"));
                this.configData.setText(ClientUtils.linesToString(config));
                this.newConfigButton.setEnabled(false);
                this.openConfigButton.setEnabled(false);
                this.deleteConfigButton.setEnabled(false);
                this.saveConfigButton.setEnabled(true);
                this.cancelConfigButton.setEnabled(true);
                this.setConfigButton.setEnabled(false);
                this.cardLayout1.show(this.configViewAndEditPanel, "editor");
            }
        }
    }

    private void deleteConfigButton_actionPerformed(ActionEvent e) {
        this.config_id = ClientUtils.getRowId(this.configTable, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e", null);
        if (this.config_id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule("call");
            request.setAction("DeleteNasConfig");
            request.setModuleId(this.getModuleId());
            request.setAttribute("config_id", this.config_id);
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.configTable.removeRow(this.configTable.getSelectedRow());
            }
        }
    }

    private void saveConfigButton_actionPerformed(ActionEvent e) {
        if (this.configTitle.getText().trim().length() == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u043d\u0430\u043d\u0438\u0435");
            return;
        }
        Request request = new Request();
        request.setModule("call");
        request.setAction("UpdateNasConfig");
        request.setModuleId(this.getModuleId());
        request.setAttribute("id", this.id);
        if (this.config_id != null) {
            request.setAttribute("config_id", this.config_id);
        }
        request.setAttribute("title", this.configTitle.getText().trim());
        request.setAttribute("config", this.configData.getText().trim());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element config = XMLUtils.selectElement(doc, "//config");
            this.config_id = XMLUtils.getAttribute(config, "id", null);
            String userName = XMLUtils.getAttribute(config, "user", null);
            String dt = XMLUtils.getAttribute(config, "dt", null);
            String title = XMLUtils.getAttribute(config, "title", null);
            if (this.config_id != null && userName != null && dt != null && title != null) {
                boolean s = false;
                int rowIndex = this.configTable.getSelectedRow();
                if (rowIndex > -1) {
                    Object value = this.configTable.getValueAt(rowIndex, 1);
                    s = !this.newConfig && value instanceof BGRadio && ((BGRadio)value).isSelected();
                }
                Vector<Object> rowData = new Vector<Object>();
                rowData.addElement(this.config_id);
                rowData.addElement(new BGRadio(s));
                rowData.addElement(dt);
                rowData.addElement(title);
                rowData.addElement(userName);
                if (this.newConfig) {
                    if (this.configTable.getRowCount() > 0) {
                        this.configTable.insertRow(0, rowData);
                    } else {
                        this.configTable.addRow(rowData);
                    }
                } else {
                    this.configTable.removeRow(rowIndex);
                    if (rowIndex > -1 && rowIndex < this.configTable.getRowCount()) {
                        this.configTable.insertRow(rowIndex, rowData);
                    } else {
                        this.configTable.addRow(rowData);
                    }
                }
                this.newConfigButton.setEnabled(true);
                this.openConfigButton.setEnabled(true);
                this.deleteConfigButton.setEnabled(true);
                this.saveConfigButton.setEnabled(false);
                this.cancelConfigButton.setEnabled(false);
                this.setConfigButton.setEnabled(true);
                this.cardLayout1.show(this.configViewAndEditPanel, "table");
            } else {
                ClientUtils.showErrorMessageDialog("config_id = null!!!");
            }
        }
    }

    private void cancelConfigButton_actionPerformed(ActionEvent e) {
        this.cancelConfig();
    }

    private void cancelConfig() {
        this.newConfigButton.setEnabled(true);
        this.openConfigButton.setEnabled(true);
        this.deleteConfigButton.setEnabled(true);
        this.saveConfigButton.setEnabled(false);
        this.cancelConfigButton.setEnabled(false);
        this.setConfigButton.setEnabled(true);
        this.cardLayout1.show(this.configViewAndEditPanel, "table");
    }

    private void setConfigButton_actionPerformed(ActionEvent e) {
        int index = this.configTable.getSelectedRow();
        if (index == -1) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
            return;
        }
        for (int i = 0; i < this.configTable.getRowCount(); ++i) {
            Object value = this.configTable.getValueAt(i, 1);
            if (!(value instanceof BGRadio)) continue;
            ((BGRadio)value).setSelected(i == index);
        }
        this.configTable.repaint();
    }

    protected void buildVendorsList() {
        Request req = new Request();
        req.setModule("call");
        req.setModuleId(this.getModuleId());
        req.setAction("VendorsList");
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            Element vendors = XMLUtils.selectElement(doc, "//vendors");
            this.vendorList.setModel(ClientUtils.buildComboBox(vendors, ""));
        }
    }
}

