/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateMenuTolbarEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

class EditorModuleAndService
extends BGUPanel {
    private ModuleService moduleService = null;
    private ModuleTableModel modulesModel = new ModuleTableModel(ModuleTableModel.class.getName());
    private ServicesTableModel servicesModel = new ServicesTableModel(ServicesTableModel.class.getName());

    public EditorModuleAndService() {
        this.build();
    }

    @Override
    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)BGSwingUtilites.wrapBorder(this.getModulePanel(), "\u041c\u043e\u0434\u0443\u043b\u0438"), new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)BGSwingUtilites.wrapBorder(this.getServicePanel(), "\u0423\u0441\u043b\u0443\u0433\u0438"), new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setFocusCycleRoot(true);
    }

    private JPanel getModulePanel() {
        BGUTable modulesTable = new BGUTable(this.modulesModel);
        modulesTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.performAction("service.refresh", "async");
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(modulesTable), "Center");
        return panel;
    }

    private JPanel getServicePanel() {
        BGUTable servicesTable = new BGUTable(this.servicesModel);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setFloatable(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
        panel.add((Component)new JScrollPane(servicesTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit(servicesTable, this, "service.edit");
        BGSwingUtilites.buildToolBar(toolBar, (JComponent)this, "service.new", "service.edit", "service.delete", "separator", "service.copy", "service.refresh");
        toolBar.compact();
        return panel;
    }

    private ModuleService getModuleService() {
        if (this.moduleService == null) {
            this.moduleService = ((ClientContext)this.getContext()).getPort(ModuleService.class, 0);
        }
        return this.moduleService;
    }

    @Override
    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
    }

    public void setData() {
        this.performAction("refresh");
    }

    public void newItem() {
        this.performAction("new");
    }

    public void editItem() {
        this.performAction("edit");
    }

    public void deleteItem() {
        this.performAction("delete");
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> this.modulesModel.setData(this.getModuleService().moduleList()));
        new AbstractBGUPanel.BGActionNew(e -> new ModuleEditor("\u041d\u043e\u0432\u044b\u0439 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 \u043c\u043e\u0434\u0443\u043b\u044f", new BGModule()).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.modulesModel.optSelectedRow().ifPresentOrElse(a -> new ModuleEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f", (BGModule)a).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u043e\u0434\u0443\u043b\u044c \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
        new AbstractBGUPanel.BGActionDelete(e -> {
            BGModule module = (BGModule)this.modulesModel.getSelectedRow();
            if (module != null && BGSwingUtilites.confirmDelete("\u043c\u043e\u0434\u0443\u043b\u044c", module)) {
                this.getModuleService().moduleDelete(module.getId());
                this.performAction("refresh");
                EventBus.publish((Object)new UpdateMenuTolbarEvent());
            }
        });
        new AbstractBGUPanel.DefaultAction("service.refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", (Icon)ClientUtils.getIcon("refresh")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                final BGModule module = (BGModule)EditorModuleAndService.this.modulesModel.getSelectedRow();
                if (module != null) {
                    if (!"async".equals(e.getActionCommand())) {
                        try {
                            EditorModuleAndService.this.servicesModel.setData(((ClientContext)EditorModuleAndService.this.getContext()).getWebService(ModuleService.class, 0).serviceList(module.getId()));
                        }
                        catch (BGException ex) {
                            ClientUtils.showErrorMessageDialog(ex);
                        }
                    } else {
                        new SwingWorker<List<Service>, Void>(){

                            @Override
                            protected List<Service> doInBackground() throws Exception {
                                return ((ClientContext)EditorModuleAndService.this.getContext()).getWebService(ModuleService.class, 0).serviceList(module.getId());
                            }

                            @Override
                            protected void done() {
                                try {
                                    EditorModuleAndService.this.servicesModel.setData((List)this.get());
                                }
                                catch (Exception ex) {
                                    ClientUtils.showErrorMessageDialog(ex);
                                }
                            }
                        }.execute();
                    }
                } else {
                    EditorModuleAndService.this.servicesModel.setData(Collections.emptyList());
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("service.new", "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", (Icon)ClientUtils.getIcon("item_add")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                EditorModuleAndService.this.modulesModel.optSelectedRow().ifPresent(module -> new ServiceEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443", new Service(module.getId())).open());
            }
        };
        new AbstractBGUPanel.DefaultAction("service.edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", (Icon)ClientUtils.getIcon("item_edit")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                EditorModuleAndService.this.servicesModel.optSelectedRow().ifPresentOrElse(a -> new ServiceEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0443\u0441\u043b\u0443\u0433\u0438", (Service)a).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0443\u0441\u043b\u0443\u0433!"));
            }
        };
        new AbstractBGUPanel.DefaultAction("service.copy", "\u041a\u043b\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438 ", (Icon)ClientUtils.getIcon("copy")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                EditorModuleAndService.this.servicesModel.optSelectedRow().ifPresentOrElse(service -> {
                    try {
                        int id = ((ClientContext)EditorModuleAndService.this.getContext()).getWebService(ModuleService.class, 0).serviceUpdate(Service.builder().setModuleId(service.getModuleId()).setTitle(service.getTitle() + "(\u043a\u043e\u043f\u0438\u044f)").setUnit(service.getUnit()).setUsing(service.isUsing()).build());
                        EditorModuleAndService.this.performAction("refresh");
                        EditorModuleAndService.this.servicesModel.setSelectedRow(id);
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }, () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0443\u0441\u043b\u0443\u0433!"));
            }
        };
        new AbstractBGUPanel.DefaultAction("service.delete", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", (Icon)ClientUtils.getIcon("item_delete")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                EditorModuleAndService.this.servicesModel.optSelectedRow().ifPresentOrElse(service -> {
                    if (BGSwingUtilites.confirmDelete("\u0443\u0441\u043b\u0443\u0433\u0443", service)) {
                        try {
                            ((ClientContext)EditorModuleAndService.this.getContext()).getWebService(ModuleService.class, 0).serviceDelete(service.getId());
                            EditorModuleAndService.this.performAction("refresh");
                        }
                        catch (BGException ex) {
                            ClientUtils.showErrorMessageDialog(ex);
                        }
                    }
                }, () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0443\u0441\u043b\u0443\u0433!"));
            }
        };
    }

    class ModuleTableModel
    extends BGTableModel<BGModule> {
        private static final String COLUMN_MODULE = "module";

        public ModuleTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c", COLUMN_MODULE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }

        @Override
        public Object getValue(BGModule val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if (COLUMN_MODULE.equals(identifier)) {
                BGInstalledModule module = val.getInstalledModule();
                return module != null ? module.getTitle() : "???";
            }
            return super.getValue(val, column);
        }
    }

    class ServicesTableModel
    extends BGTableModel<Service> {
        private static final String COLUMN_UNIT = "unit";

        public ServicesTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("ID", -1, 50, 50, "id", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434", 170, 170, 170, "activePeriod", true);
            this.addColumn("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f", -1, 100, 100, "using", true);
            this.addColumn("\u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f", -1, 120, 140, COLUMN_UNIT, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
        }

        @Override
        public Object getValue(Service val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if (COLUMN_UNIT.equals(identifier)) {
                switch (val.getUnit()) {
                    case 10000: {
                        return "\u0448\u0442\u0443\u043a\u0430";
                    }
                    case 20000: {
                        return "\u0441\u0435\u043a\u0443\u043d\u0434\u0430";
                    }
                    case 30000: {
                        return "\u0431\u0430\u0439\u0442";
                    }
                }
                return "";
            }
            return super.getValue(val, column);
        }
    }

    class ModuleEditor
    extends BGEditorDialog<BGModule> {
        private BGTextField title;
        private BGUComboBox<BGInstalledModule> modules;

        public ModuleEditor(String title, BGModule data) {
            super(title, data);
            this.title = new BGTextField();
            this.modules = new BGUComboBox();
        }

        @Override
        public void doDialogPanel() {
            this.title.setColumns(30);
            int gridy = 0;
            this.panel.setLayout(new GridBagLayout());
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0411\u0430\u0437\u043e\u0432\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 3, 5), 0, 0));
            this.panel.add(this.modules, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 3, 0), 0, 0));
            try {
                this.modules.setData(EditorModuleAndService.this.getModuleService().installedModuleList());
                if (((BGModule)this.data).getInstalledModule() != null) {
                    this.modules.setSelectedItem(((BGModule)this.data).getInstalledModule());
                }
                this.modules.setEnabled(((BGModule)this.data).getId() == 0);
                this.title.setText(((BGModule)this.data).getTitle());
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }

        @Override
        public boolean doApply() throws Exception {
            if (Utils.isBlankString(this.title.getText())) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            int id = ((BGModule)this.data).getId();
            if (id > 0) {
                ((BGModule)this.data).setTitle(this.title.getText());
                EditorModuleAndService.this.modulesModel.fireTableDataChanged();
                EditorModuleAndService.this.getModuleService().moduleUpdate((BGModule)this.data);
            } else {
                BGInstalledModule installedModule = (BGInstalledModule)this.modules.getSelectedItem();
                if (installedModule != null) {
                    id = EditorModuleAndService.this.getModuleService().moduleAdd(installedModule.getName(), this.title.getText());
                    EditorModuleAndService.this.performAction("refresh");
                }
            }
            EditorModuleAndService.this.modulesModel.setSelectedRow(id);
            EventBus.publish((Object)new UpdateMenuTolbarEvent());
            return true;
        }
    }

    class ServiceEditor
    extends BGEditorDialog<Service> {
        private BGTextField title;
        private JCheckBox used;
        private BGUComboBox<IdTitle> unit;
        private BGConfigEditorPane config;
        private BGControlPanelPeriodNoB period;

        public ServiceEditor(String title, Service data) {
            super(title, data);
            this.title = new BGTextField(40);
            this.used = new JCheckBox("");
            this.unit = new BGUComboBox();
            this.config = new BGConfigEditorPane();
            this.period = new BGControlPanelPeriodNoB(false);
        }

        @Override
        public void doDialogPanel() {
            ArrayList<IdTitle> unitData = new ArrayList<IdTitle>();
            unitData.add(new IdTitle(0, "---"));
            unitData.add(new IdTitle(10000, "\u0448\u0442\u0443\u043a\u0430"));
            unitData.add(new IdTitle(20000, "\u0441\u0435\u043a\u0443\u043d\u0434\u0430"));
            unitData.add(new IdTitle(30000, "\u0431\u0430\u0439\u0442"));
            this.unit.setData(unitData);
            this.config.setMargin(new Insets(3, 3, 3, 3));
            Dimension dimension = new Dimension(300, 100);
            JScrollPane scrollPane = new JScrollPane(this.config);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 3, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 3, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 0), 0, 0));
            this.panel.add(this.unit, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 3, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 0), 0, 0));
            this.panel.add((Component)this.period, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 3, 0), 0, 0));
            this.panel.add((Component)this.used, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043d\u0444\u0438\u0433:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 12, 0, new Insets(0, 0, 3, 0), 0, 0));
            this.panel.add((Component)scrollPane, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 3, 0), 0, 0));
            this.title.setText(((Service)this.data).getTitle());
            this.unit.setSelectedItem(((Service)this.data).getUnit());
            this.period.setPeriod(((Service)this.data).getActivePeriod());
            this.used.setSelected(((Service)this.data).isUsing());
            this.config.setText(((Service)this.data).getConfig());
        }

        @Override
        public boolean doApply() throws Exception {
            ((Service)this.data).setTitle(this.title.getText());
            ((Service)this.data).setUnit(((IdTitle)this.unit.getSelectedItem()).getId());
            ((Service)this.data).setActivePeriod(this.period.getPeriod());
            ((Service)this.data).setUsing(this.used.isSelected());
            ((Service)this.data).setConfig(this.config.getText());
            int id = ((ClientContext)EditorModuleAndService.this.getContext()).getWebService(ModuleService.class, 0).serviceUpdate((Service)this.data);
            EditorModuleAndService.this.performAction("refresh", "async");
            if (((Service)this.data).getId() < 1) {
                EditorModuleAndService.this.servicesModel.setSelectedRow(id);
            }
            return true;
        }
    }
}

