/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;

public class TimeUtils {
    public static final String[] monthNames = new String[]{"\u044f\u043d\u0432\u0430\u0440\u044c", "\u0444\u0435\u0432\u0440\u0430\u043b\u044c", "\u043c\u0430\u0440\u0442", "\u0430\u043f\u0440\u0435\u043b\u044c", "\u043c\u0430\u0439", "\u0438\u044e\u043d\u044c", "\u0438\u044e\u043b\u044c", "\u0430\u0432\u0433\u0443\u0441\u0442", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u043e\u043a\u0442\u044f\u0431\u0440\u044c", "\u043d\u043e\u044f\u0431\u0440\u044c", "\u0434\u0435\u043a\u0430\u0431\u0440\u044c"};
    public static final String[] monthNamesRod = new String[]{"\u044f\u043d\u0432\u0430\u0440\u044f", "\u0444\u0435\u0432\u0440\u0430\u043b\u044f", "\u043c\u0430\u0440\u0442\u0430", "\u0430\u043f\u0440\u0435\u043b\u044f", "\u043c\u0430\u044f", "\u0438\u044e\u043d\u044f", "\u0438\u044e\u043b\u044f", "\u0430\u0432\u0433\u0443\u0441\u0442\u0430", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f", "\u043e\u043a\u0442\u044f\u0431\u0440\u044f", "\u043d\u043e\u044f\u0431\u0440\u044f", "\u0434\u0435\u043a\u0430\u0431\u0440\u044f"};
    public static final String[] weekDayName = new String[]{"\u041f\u043d.", "\u0412\u0442.", "\u0421\u0440.", "\u0427\u0442.", "\u041f\u0442.", "\u0421\u0431.", "\u0412\u0441."};
    public static final String DATE_FORMAT_PATTERN_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DATE_FORMAT_PATTERN_YYYY_MM_DD_HHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_PATTERN_DDMMYYYY = "dd.MM.yyyy";
    public static final String DATE_FORMAT_PATTERN_DDMMYYYY_HHMMSS = "dd.MM.yyyy HH:mm:ss";
    public static final String DATE_FORMAT_PATTERN_DDMMYYYY_HHMM = "dd.MM.yyyy HH:mm";

    public static final int getDayOfWeekMask(Calendar date) {
        return 1 << (date.get(7) - 2 + 7) % 7;
    }

    public static final int getDayOfMonthMask(Calendar date) {
        return 1 << date.get(5) - 1;
    }

    public static final int getHourOfDayMask(Calendar date) {
        return 1 << date.get(11);
    }

    public static final int getMonthOfYearMask(Calendar date) {
        return 1 << date.get(2);
    }

    public static final long getMinuteMask(Calendar date) {
        return 1L << date.get(12);
    }

    public static final boolean checkMasks(Calendar date, int hourOfDay, int dayOfWeek, int monthOfYear, int dayOfMonth) {
        if (hourOfDay > 0 && (hourOfDay & TimeUtils.getHourOfDayMask(date)) == 0) {
            return false;
        }
        if (dayOfWeek > 0 && (dayOfWeek & TimeUtils.getDayOfWeekMask(date)) == 0) {
            return false;
        }
        if (dayOfMonth > 0 && (dayOfMonth & TimeUtils.getDayOfMonthMask(date)) == 0) {
            return false;
        }
        if (monthOfYear > 0 && (monthOfYear & TimeUtils.getMonthOfYearMask(date)) == 0) {
            return false;
        }
        return dayOfWeek <= 0 || (dayOfWeek & TimeUtils.getDayOfWeekMask(date)) != 0;
    }

    public static final boolean checkMasks(Calendar date, int hourOfDay, int dayOfWeek, int monthOfYear, int dayOfMonth, long minute) {
        boolean result = TimeUtils.checkMasks(date, hourOfDay, dayOfWeek, monthOfYear, dayOfMonth);
        if (result && minute > 0L) {
            result = (minute & TimeUtils.getMinuteMask(date)) > 0L;
        }
        return result;
    }

    public static final String convertCalendarToDateString(Calendar calendar) {
        String stringDate = TimeUtils.format(calendar, DATE_FORMAT_PATTERN_YYYY_MM_DD);
        if (stringDate == null) {
            stringDate = "0000-00-00";
        }
        return stringDate;
    }

    public static final String convertCalendarToDateTimeString(Calendar calendar) {
        String stringDate = TimeUtils.format(calendar, "yyyy-MM-dd HH:00:00");
        if (stringDate == null) {
            stringDate = "0000-00-00 00:00:00";
        }
        return stringDate;
    }

    public static String format(LocalDateTime localDateTime, String pattern) {
        return localDateTime == null ? "" : localDateTime.format(TimeUtils.getDateTimeFormatter(pattern));
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter formatter) {
        return localDateTime == null ? "" : localDateTime.format(formatter);
    }

    public static final String format(java.util.Date date, String pattern) {
        return date == null ? "" : TimeUtils.getDateFormat(pattern).format(date);
    }

    public static final String format(LocalDate date, String pattern) {
        return date == null ? "" : DateTimeFormatter.ofPattern(pattern).format(date);
    }

    public static final String format(java.util.Date date, String pattern, TimeZone zone) {
        return date == null ? "" : TimeUtils.getDateFormat(pattern, zone).format(date);
    }

    public static final String format(java.util.Date date, DateFormat format) {
        return date == null ? "" : format.format(date);
    }

    public static final String format(Calendar date, String pattern) {
        return date == null ? "" : TimeUtils.getDateFormat(pattern).format(date.getTime());
    }

    public static final String format(Calendar date, DateFormat format) {
        return date == null ? "" : format.format(date.getTime());
    }

    public static final String formatTimestamp(Timestamp time, String format) {
        String result = "";
        if (time != null && format != null) {
            result = TimeUtils.getDateFormat(format).format(new Date(time.getTime()));
        }
        return result;
    }

    public static final String formatDate(Calendar date) {
        return TimeUtils.format(date, DATE_FORMAT_PATTERN_DDMMYYYY);
    }

    public static final String formatDate(java.util.Date date) {
        return TimeUtils.format(date, DATE_FORMAT_PATTERN_DDMMYYYY);
    }

    public static final String formatSQLDate(java.util.Date date) {
        return TimeUtils.format(date, DATE_FORMAT_PATTERN_YYYY_MM_DD);
    }

    public static final String formatSQLDate(Calendar date) {
        return TimeUtils.format(date, DATE_FORMAT_PATTERN_YYYY_MM_DD);
    }

    public static final String formatPeriod(Calendar date1, Calendar date2) {
        return TimeUtils.formatPeriod(date1 != null ? date1.getTime() : null, date2 != null ? date2.getTime() : null);
    }

    public static final String formatPeriod(java.util.Date date1, java.util.Date date2) {
        return (date1 != null ? TimeUtils.formatDate(date1) : "\u2026") + "-" + (date2 != null ? TimeUtils.formatDate(date2) : "\u2026");
    }

    public static final String formatPeriod(Period period) {
        return TimeUtils.formatPeriod(period.getDateFrom(), period.getDateTo());
    }

    public static final String formatPeriodWithTime(java.util.Date date1, java.util.Date date2) {
        return (date1 != null ? TimeUtils.formatFullDate(date1) : "\u2026") + " - " + (date2 != null ? TimeUtils.formatFullDate(date2) : "\u2026");
    }

    public static final String formatPeriodWithTime(Period period) {
        return TimeUtils.formatPeriodWithTime(period.getDateFrom(), period.getDateTo());
    }

    public static final String formatPeriodWithTime(PeriodWithTime period) {
        return TimeUtils.formatPeriodWithTime(period.getDateFrom(), period.getDateTo());
    }

    public static String formatFullDate(java.util.Date inDate) {
        String outDate = "";
        if (inDate != null) {
            try {
                outDate = TimeUtils.getDateFormat(DATE_FORMAT_PATTERN_DDMMYYYY_HHMMSS).format(inDate);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return outDate;
    }

    public static final String formatDeltaTime(long delta) {
        int days = (int)(delta / 86400L);
        int hours = (int)((delta -= (long)(days * 86400)) / 3600L);
        int min = (int)((delta -= (long)(hours * 3600)) / 60L);
        int sec = (int)(delta -= (long)(min * 60));
        StringBuffer result = new StringBuffer(30);
        DecimalFormat dfTime = new DecimalFormat("00");
        result.append(days);
        result.append(" d ");
        result.append(dfTime.format(hours));
        result.append(":");
        result.append(dfTime.format(min));
        result.append(":");
        result.append(dfTime.format(sec));
        return result.toString();
    }

    public static final java.util.Date convertCalendarToDate(Calendar calendar) {
        return calendar != null ? calendar.getTime() : null;
    }

    public static final java.util.Date convertSqlDateToDate(Date date) {
        java.util.Date outDate = null;
        if (date != null) {
            outDate = new java.util.Date(date.getTime());
        }
        return outDate;
    }

    public static java.util.Date parseDate(String str, String format) {
        return TimeUtils.parseDate(str, TimeUtils.getDateFormat(format));
    }

    public static java.util.Date parseDate(String str, String format, TimeZone zone) {
        return TimeUtils.parseDate(str, TimeUtils.getDateFormat(format, zone));
    }

    public static LocalDate parseLocalDate(String str) {
        return TimeUtils.parseLocalDate(str, DATE_FORMAT_PATTERN_DDMMYYYY);
    }

    public static LocalDate parseLocalDate(String str, String format) {
        return LocalDate.parse(str, TimeUtils.getDateTimeFormatter(format));
    }

    public static LocalDateTime parseLocalDateTime(String str, String format) {
        return LocalDateTime.parse(str, TimeUtils.getDateTimeFormatter(format));
    }

    public static DateTimeFormatter getDateTimeFormatter(String format) {
        return DateTimeFormatter.ofPattern(format);
    }

    public static java.util.Date parseDate(String str, DateFormat format) {
        java.util.Date date = null;
        if (str != null && format != null) {
            try {
                date = format.parse(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    public static final Calendar convertDateToCalendar(java.util.Date date) {
        GregorianCalendar result = null;
        if (date != null) {
            result = new GregorianCalendar();
            result.setTime(date);
        }
        return result;
    }

    public static final Calendar convertStringToCalendar(String param) {
        Calendar result = null;
        if (param != null && param.length() > 0 && !"00.00.0000".equals(param) && (result = TimeUtils.convertStringToCalendar(param, DATE_FORMAT_PATTERN_DDMMYYYY)) == null) {
            result = TimeUtils.convertStringToCalendar(param, DATE_FORMAT_PATTERN_YYYY_MM_DD);
        }
        return result;
    }

    public static final java.util.Date convertStringToDate(String param) {
        java.util.Date result = TimeUtils.convertStringToDate(param, DATE_FORMAT_PATTERN_DDMMYYYY);
        if (result == null) {
            result = TimeUtils.convertStringToDate(param, DATE_FORMAT_PATTERN_YYYY_MM_DD);
        }
        return result;
    }

    public static final Calendar convertStringToCalendar(String param, String pattern) {
        GregorianCalendar calendar = null;
        if (param != null && pattern != null) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(pattern);
                calendar = new GregorianCalendar();
                calendar.setTime(formatter.parse(param));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return calendar;
    }

    public static final java.util.Date convertStringToDate(String param, String pattern) {
        java.util.Date date = null;
        if (param != null && pattern != null) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(pattern);
                date = formatter.parse(param);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    public static final Calendar convertFullStringToCalendar(String param) {
        return TimeUtils.convertStringToCalendar(param, "dd.MM.yyyy HH':00:00'");
    }

    public static final Calendar convertTimestampToCalendar(Timestamp time) {
        GregorianCalendar result = null;
        if (time != null) {
            result = new GregorianCalendar();
            result.setTimeInMillis(time.getTime());
        }
        return result;
    }

    public static final java.util.Date convertTimestampToDate(Timestamp time) {
        java.util.Date result = null;
        if (time != null) {
            result = new java.util.Date(time.getTime());
        }
        return result;
    }

    public static final LocalDateTime convertTimestampToLocalDateTime(Timestamp time) {
        return time == null ? null : LocalDateTime.from(Instant.ofEpochMilli(time.getTime()).atZone(ZoneId.systemDefault()));
    }

    public static Calendar parseCalendar(String str, String format) {
        java.util.Date date = TimeUtils.parseDate(str, format);
        if (date != null) {
            GregorianCalendar result = new GregorianCalendar();
            result.setTime(date);
            return result;
        }
        return null;
    }

    public static Calendar parseCalendar(String str, DateFormat format) {
        GregorianCalendar result = null;
        java.util.Date date = TimeUtils.parseDate(str, format);
        if (date != null) {
            result = new GregorianCalendar();
            result.setTime(date);
        }
        return result;
    }

    public static final Calendar clear_MIN_MIL_SEC(Calendar time) {
        time.set(14, 0);
        time.set(13, 0);
        time.set(12, 0);
        return time;
    }

    public static final java.util.Date clear_MIN_MIL_SEC(java.util.Date time) {
        time = TimeUtils.convertCalendarToDate(TimeUtils.clear_MIN_MIL_SEC(TimeUtils.convertDateToCalendar(time)));
        return time;
    }

    public static final Calendar clear_HOUR_MIN_MIL_SEC(Calendar time) {
        TimeUtils.clear_MIN_MIL_SEC(time);
        time.set(11, 0);
        return time;
    }

    public static final java.util.Date clear_HOUR_MIN_MIL_SEC(java.util.Date time) {
        Calendar cal = TimeUtils.convertDateToCalendar(time);
        TimeUtils.clear_MIN_MIL_SEC(cal);
        cal.set(11, 0);
        return TimeUtils.convertCalendarToDate(cal);
    }

    public static final java.util.Date clear_MILLISECOND(java.util.Date time) {
        Calendar cal = TimeUtils.convertDateToCalendar(time);
        cal.set(14, 0);
        return TimeUtils.convertCalendarToDate(cal);
    }

    public static final Calendar getEndDay(Calendar date) {
        Calendar result = (Calendar)date.clone();
        result.set(11, 23);
        result.set(12, 59);
        result.set(13, 59);
        result.set(14, 0);
        return result;
    }

    public static final java.util.Date getEndDay(java.util.Date date) {
        return TimeUtils.getEndDay(TimeUtils.convertDateToCalendar(date)).getTime();
    }

    public static final Calendar getStartMonth(Calendar date) {
        Calendar result = (Calendar)date.clone();
        result.set(5, 1);
        return result;
    }

    public static final java.util.Date getStartMonth(java.util.Date date) {
        return TimeUtils.getStartMonth(TimeUtils.convertDateToCalendar(date)).getTime();
    }

    public static final java.util.Date getEndMonth(java.util.Date date) {
        return TimeUtils.getEndMonth(TimeUtils.convertDateToCalendar(date)).getTime();
    }

    public static final Calendar getEndMonth(Calendar date) {
        Calendar result = (Calendar)date.clone();
        result.set(5, date.getActualMaximum(5));
        result.set(11, 23);
        result.set(12, 59);
        result.set(13, 59);
        result.set(14, 999);
        return result;
    }

    public static final Calendar convertSqlDateToCalendar(Date date) {
        return TimeUtils.convertDateToCalendar(TimeUtils.convertSqlDateToDate(date));
    }

    public static final Calendar getNextDay(Calendar date) {
        date = (Calendar)date.clone();
        TimeUtils.moveToStartNextDay(date);
        return date;
    }

    public static final Calendar getNextMonth(Calendar date) {
        Calendar result = null;
        if (date != null) {
            result = (Calendar)date.clone();
            result.add(2, 1);
            result.set(11, 0);
            result.set(12, 0);
            result.set(13, 0);
            result.set(14, 0);
        }
        return result;
    }

    public static final java.util.Date getNextMonth(java.util.Date date) {
        return TimeUtils.convertCalendarToDate(TimeUtils.getNextMonth(TimeUtils.convertDateToCalendar(date)));
    }

    public static final Calendar getPrevDay(Calendar date) {
        date = (Calendar)date.clone();
        date.add(6, -1);
        return date;
    }

    public static final java.util.Date getPrevDay(java.util.Date date) {
        return TimeUtils.convertCalendarToDate(TimeUtils.getPrevDay(TimeUtils.convertDateToCalendar(date)));
    }

    public static final java.util.Date getNextDay(java.util.Date date) {
        return TimeUtils.convertCalendarToDate(TimeUtils.getNextDay(TimeUtils.convertDateToCalendar(date)));
    }

    public static final Date convertCalendarToSqlDate(Calendar calendar) {
        Date result = null;
        if (calendar != null) {
            result = new Date(calendar.getTimeInMillis());
        }
        return result;
    }

    public static final Date convertLocalDateToSqlDate(LocalDate localDate) {
        Date result = null;
        if (localDate != null) {
            result = Date.valueOf(localDate);
        }
        return result;
    }

    public static final Date convertDateToSqlDate(java.util.Date date) {
        return date != null ? new Date(date.getTime()) : null;
    }

    public static final Date convertSQLDate(String inDate) {
        Date outDate = null;
        if (inDate != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_PATTERN_DDMMYYYY);
                outDate = new Date(sdf.parse(inDate).getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return outDate;
    }

    public static final Timestamp convertCalendarToTimestamp(Calendar calendar) {
        Timestamp result = null;
        if (calendar != null) {
            result = new Timestamp(calendar.getTimeInMillis());
        }
        return result;
    }

    public static final Timestamp convertDateToTimestamp(java.util.Date date) {
        Timestamp result = null;
        if (date != null) {
            result = new Timestamp(date.getTime());
        }
        return result;
    }

    public static final Timestamp convertDateToTimestampSeconds(java.util.Date date) {
        if (date != null) {
            return new Timestamp(date.getTime() / 1000L * 1000L);
        }
        return null;
    }

    public static final Timestamp convertLongToTimestamp(long millis) {
        return new Timestamp(millis);
    }

    public static final Timestamp convertLongToTimestamp(Long millis) {
        Timestamp result = null;
        if (millis != null) {
            result = new Timestamp(millis);
        }
        return result;
    }

    public static final DateFormat getDateFormat(String pattern, TimeZone zone) {
        SimpleDateFormat dateFormat = null;
        try {
            dateFormat = new SimpleDateFormat(pattern);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN_DDMMYYYY);
        }
        if (zone != null) {
            dateFormat.setTimeZone(zone);
        }
        return dateFormat;
    }

    public static final DateFormat getDateFormat(String pattern) {
        return TimeUtils.getDateFormat(pattern, null);
    }

    public static final int daysDelta(Calendar dayFrom, Calendar dayTo) {
        dayFrom = (Calendar)dayFrom.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC(dayFrom);
        dayTo = (Calendar)dayTo.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC(dayTo);
        long time1 = dayFrom.getTimeInMillis();
        long time2 = dayTo.getTimeInMillis();
        int days1 = (int)(time1 / 86400000L);
        int days2 = (int)(time2 / 86400000L);
        return days2 - days1;
    }

    public static final int daysDelta(java.util.Date dateFrom, java.util.Date dateTo) {
        return TimeUtils.daysDelta(TimeUtils.convertDateToCalendar(dateFrom), TimeUtils.convertDateToCalendar(dateTo));
    }

    public static final int hourDelta(Calendar hourFrom, Calendar hourTo) {
        long delta = (hourTo.getTimeInMillis() - hourFrom.getTimeInMillis()) / 1000L;
        return (int)(delta / 3600L);
    }

    public static final int monthsDelta(java.util.Date dateFrom, java.util.Date dateTo) {
        return TimeUtils.monthsDelta(TimeUtils.convertDateToCalendar(dateFrom), TimeUtils.convertDateToCalendar(dateTo));
    }

    public static final int monthsDelta(Calendar dateFrom, Calendar dateTo) {
        return (dateTo.get(1) - dateFrom.get(1)) * 12 + (dateTo.get(2) - dateFrom.get(2));
    }

    public static final float getPart(long fromDate, long toDate, long periodFrom, long periodTo) {
        float part = 1.0f;
        if (fromDate == 0L || fromDate < periodFrom) {
            fromDate = periodFrom;
        }
        if (toDate == 0L || periodTo < toDate) {
            toDate = periodTo;
        }
        GregorianCalendar fromCalendar = new GregorianCalendar();
        GregorianCalendar toCalendar = new GregorianCalendar();
        fromCalendar.setTimeInMillis(fromDate);
        toCalendar.setTimeInMillis(toDate);
        int days = TimeUtils.daysDelta(fromCalendar, toCalendar) + 1;
        fromCalendar.setTimeInMillis(periodFrom);
        toCalendar.setTimeInMillis(periodTo);
        part = (float)days / (float)(TimeUtils.daysDelta(fromCalendar, toCalendar) + 1);
        return part;
    }

    public static final float getPart(Calendar fromDate, Calendar toDate, Calendar periodFrom, Calendar periodTo) {
        float part = 1.0f;
        if (fromDate == null || TimeUtils.dateBefore(fromDate, periodFrom)) {
            fromDate = periodFrom;
        }
        if (toDate == null || TimeUtils.dateBefore(periodTo, toDate)) {
            toDate = periodTo;
        }
        int days = TimeUtils.daysDelta(fromDate, toDate) + 1;
        part = (float)days / (float)(TimeUtils.daysDelta(periodFrom, periodTo) + 1);
        return part;
    }

    public static boolean dateBefore(Calendar date1, Calendar date2) {
        if (date1 != null && date2 != null) {
            if (date1.get(1) == date2.get(1)) {
                return date1.get(6) < date2.get(6);
            }
            return date1.get(1) < date2.get(1);
        }
        return false;
    }

    public static boolean dateBefore(java.util.Date date1, java.util.Date date2) {
        return TimeUtils.dateBefore(TimeUtils.convertDateToCalendar(date1), TimeUtils.convertDateToCalendar(date2));
    }

    public static boolean dateEqual(Calendar date1, Calendar date2) {
        return date1 == date2 || date1 != null && date2 != null && date1.get(6) == date2.get(6) && date1.get(1) == date2.get(1);
    }

    public static boolean dateEqual(java.util.Date date1, java.util.Date date2) {
        return TimeUtils.dateEqual(TimeUtils.convertDateToCalendar(date1), TimeUtils.convertDateToCalendar(date2));
    }

    public static boolean dateHourEqual(Calendar dtime1, Calendar dtime2) {
        return TimeUtils.dateEqual(dtime1, dtime2) && dtime1.get(11) == dtime2.get(11);
    }

    public static boolean dateBeforeOrEq(Calendar date1, Calendar date2) {
        return TimeUtils.dateBefore(date1, date2) || TimeUtils.dateEqual(date1, date2);
    }

    public static boolean dateBeforeOrEq(java.util.Date date1, java.util.Date date2) {
        return TimeUtils.dateBeforeOrEq(TimeUtils.convertDateToCalendar(date1), TimeUtils.convertDateToCalendar(date2));
    }

    public static final boolean dateInRange(Calendar checking, Calendar date1, Calendar date2) {
        return !(checking == null || date1 != null && !TimeUtils.dateBeforeOrEq(date1, checking) || date2 != null && !TimeUtils.dateBeforeOrEq(checking, date2));
    }

    public static final boolean dateInRange(java.util.Date checking, java.util.Date date1, java.util.Date date2) {
        return !(checking == null || date1 != null && !TimeUtils.dateBeforeOrEq(date1, checking) || date2 != null && !TimeUtils.dateBeforeOrEq(checking, date2));
    }

    public static final boolean dateInRangeWithTime(java.util.Date checking, java.util.Date date1, java.util.Date date2) {
        boolean result = false;
        if (checking != null) {
            result = true;
            if (date1 != null) {
                boolean bl = result = date1.getTime() <= checking.getTime();
            }
            if (result && date2 != null) {
                result = checking.getTime() <= date2.getTime();
            }
        }
        return result;
    }

    public static final boolean dateInPeriod(java.util.Date checking, Period period) {
        return !(checking == null || period == null || period.getDateFrom() != null && period.getDateFrom().getTime() > checking.getTime() || period.getDateTo() != null && checking.getTime() > period.getDateTo().getTime());
    }

    public static final boolean dateInPeriod(LocalDate checking, Period period) {
        return !(checking == null || period == null || period.getLocalDateFrom() != null && period.getLocalDateFrom().compareTo(checking) >= 1 || period.getLocalDateTo() != null && checking.compareTo(period.getLocalDateTo()) >= 1);
    }

    public static final boolean dateInPeriod(LocalDateTime checking, PeriodWithTime period) {
        return !(checking == null || period == null || period.getLocalDateTimeFrom() != null && period.getLocalDateTimeFrom().compareTo(checking) >= 1 || period.getLocalDateTimeTo() != null && checking.compareTo(period.getLocalDateTimeTo()) >= 1);
    }

    public static final LocalDateTime convertDateToLocalDateTime(java.util.Date date) {
        return date == null ? null : LocalDateTime.from(date.toInstant().atZone(ZoneId.systemDefault()));
    }

    public static final LocalDate convertDateToLocalDate(java.util.Date date) {
        LocalDate localDate = null;
        if (date != null) {
            localDate = date instanceof Date ? ((Date)date).toLocalDate() : LocalDate.from(date.toInstant().atZone(ZoneId.systemDefault()));
        }
        return localDate;
    }

    public static final Calendar convertLocalDateToCalendar(LocalDate localDate) {
        return localDate == null ? null : TimeUtils.convertDateToCalendar(java.util.Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
    }

    public static final java.util.Date convertLocalDateToDate(LocalDate localDate) {
        return localDate == null ? null : java.util.Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static final java.util.Date convertLocalDateTimeToDate(LocalDateTime localDateTime) {
        return localDateTime == null ? null : java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static final Calendar convertLocalDateTimeToCalendar(LocalDateTime localDateTime) {
        return localDateTime == null ? null : TimeUtils.convertDateToCalendar(java.util.Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
    }

    public static final Timestamp convertLocalDateTimeToTimestamp(LocalDateTime localDateTime) {
        return localDateTime == null ? null : new Timestamp(localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static final Timestamp convertLocalDateToTimestamp(LocalDate localDate) {
        return localDate == null ? null : new Timestamp(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static final LocalDateTime convertSecEpochToLocalDateTime(long secEpoch) {
        return LocalDateTime.from(Instant.ofEpochSecond(secEpoch).atZone(ZoneId.systemDefault()));
    }

    public static final boolean periodInRange(Calendar checkingDate1, Calendar checkingDate2, Calendar date1, Calendar date2) {
        boolean result;
        boolean bl = result = date1 == null || checkingDate1 != null && TimeUtils.dateBeforeOrEq(date1, checkingDate1);
        if (result) {
            result = date2 == null || checkingDate2 != null && TimeUtils.dateBeforeOrEq(checkingDate2, date2);
        }
        return result;
    }

    public static final boolean periodInRange(java.util.Date checkingDate1, java.util.Date checkingDate2, java.util.Date date1, java.util.Date date2) {
        boolean result;
        boolean bl = result = date1 == null || checkingDate1 != null && TimeUtils.dateBeforeOrEq(date1, checkingDate1);
        if (result) {
            result = date2 == null || checkingDate2 != null && TimeUtils.dateBeforeOrEq(checkingDate2, date2);
        }
        return result;
    }

    public static final void moveToEndOfMonth(Calendar date) {
        if (date != null) {
            date.set(5, date.getActualMaximum(5));
        }
    }

    public static final void moveToStartNextDay(Calendar date) {
        if (date != null) {
            date.add(6, 1);
            date.set(11, 0);
            date.set(12, 0);
            date.set(13, 0);
            date.set(14, 0);
        }
    }

    public static final java.util.Date moveToEndDay(java.util.Date date) {
        if (date != null) {
            Calendar dt = Calendar.getInstance();
            dt.setTime(date);
            TimeUtils.moveToEndDay(dt);
            return dt.getTime();
        }
        return null;
    }

    public static final void moveToEndDay(Calendar date) {
        if (date != null) {
            date.set(11, 23);
            date.set(12, 59);
            date.set(13, 59);
            date.set(14, 999);
        }
    }

    public static void clearCalendarHour(Calendar cal) {
        if (cal != null) {
            cal.clear(14);
            cal.clear(13);
            cal.clear(12);
            cal.set(11, 0);
        }
    }

    public static java.util.Date nowPlusPeriod(int period, int value) {
        Calendar c = Calendar.getInstance();
        c.add(period, value);
        return c.getTime();
    }

    public static Calendar plusPeriod(Calendar date, int period, int value) {
        Calendar result = (Calendar)date.clone();
        result.add(period, value);
        return result;
    }

    public static java.util.Date plusPeriod(java.util.Date date, int period, int value) {
        return TimeUtils.convertCalendarToDate(TimeUtils.plusPeriod(TimeUtils.convertDateToCalendar(date), period, value));
    }

    public static boolean checkDateIntervalsIntersection(java.util.Date date1, java.util.Date date2, java.util.Date dateFrom, java.util.Date dateTo) {
        java.util.Date dateTwo2;
        if (date1 == null && date2 == null || dateFrom == null && dateTo == null) {
            return true;
        }
        java.util.Date dateOne1 = date1 == null ? TimeUtils.convertStringToDate("01.01.0001") : date1;
        java.util.Date dateTwo1 = date2 == null ? TimeUtils.convertStringToDate("31.12.9999") : date2;
        java.util.Date dateOne2 = dateFrom == null ? TimeUtils.convertStringToDate("01.01.0001") : dateFrom;
        java.util.Date date = dateTwo2 = dateTo == null ? TimeUtils.convertStringToDate("31.12.9999") : dateTo;
        return TimeUtils.dateInRange(dateOne1, dateOne2, dateTwo2) || TimeUtils.dateInRange(dateTwo1, dateOne2, dateTwo2) || TimeUtils.dateInRange(dateOne2, dateOne1, dateTwo1) || TimeUtils.dateInRange(dateTwo2, dateOne1, dateTwo1);
    }

    public static void checkPeriod(java.util.Date date1, java.util.Date date2) throws BGException {
        boolean result;
        boolean bl = result = date1 == null || date2 == null || TimeUtils.dateBeforeOrEq(date1, date2);
        if (!result) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434!");
        }
    }

    public static int compare(Calendar value, Calendar compare, int field) {
        int result = TimeUtils.compareResult(value, compare, 1);
        if (result != 0 || field == 1) {
            return result;
        }
        if (field == 3) {
            return TimeUtils.compareResult(value, compare, 3);
        }
        if (field == 6) {
            return TimeUtils.compareResult(value, compare, 6);
        }
        result = TimeUtils.compareResult(value, compare, 2);
        if (result != 0 || field == 2) {
            return result;
        }
        if (field == 4) {
            return TimeUtils.compareResult(value, compare, 4);
        }
        result = TimeUtils.compareResult(value, compare, 5);
        if (result != 0 || field == 5 || field == 5 || field == 7 || field == 8) {
            return result;
        }
        return TimeUtils.compareTime(value, compare, field);
    }

    private static int compareTime(Calendar value, Calendar compare, int field) {
        int result = 0;
        result = TimeUtils.compareResult(value, compare, 11);
        if (result != 0 || field == 10 || field == 11) {
            return result;
        }
        result = TimeUtils.compareResult(value, compare, 12);
        if (result != 0 || field == 12) {
            return result;
        }
        result = TimeUtils.compareResult(value, compare, 13);
        if (result != 0 || field == 13) {
            return result;
        }
        if (field == 14) {
            return TimeUtils.compareResult(value, compare, 14);
        }
        throw new IllegalArgumentException("Invalid field: " + field);
    }

    private static int compareResult(Calendar value, Calendar compare, int field) {
        int difference = value.get(field) - compare.get(field);
        if (difference < 0) {
            return -1;
        }
        if (difference > 0) {
            return 1;
        }
        return 0;
    }

    public static long clearToBeginDay(Calendar date) {
        Calendar newcal = Calendar.getInstance();
        newcal.clear();
        newcal.set(date.get(1), date.get(2), date.get(5));
        return newcal.getTimeInMillis();
    }

    public static void floor(Calendar calendar, int field) {
        switch (field) {
            case 12: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                break;
            }
            case 10: 
            case 11: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                break;
            }
            case 5: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                break;
            }
            case 3: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(7, calendar.getFirstDayOfWeek());
                break;
            }
            case 2: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                break;
            }
            case 1: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                calendar.set(2, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static String formatCount(int field, int count) {
        switch (field) {
            case 5: {
                return MessageFormat.format("{0} {0, choice, 0#\u0434\u043d\u0435\u0439| 1#\u0434\u0435\u043d\u044c| 2#\u0434\u043d\u044f| 3#\u0434\u043d\u044f| 4#\u0434\u043d\u044f| 4<\u0434\u043d\u0435\u0439| 20<{1}}", count, MessageFormat.format("{0, choice, 0#\u0434\u043d\u0435\u0439| 1#\u0434\u0435\u043d\u044c| 2#\u0434\u043d\u044f| 3#\u0434\u043d\u044f| 4#\u0434\u043d\u044f| 4<\u0434\u043d\u0435\u0439}", count % 10));
            }
            case 2: {
                return MessageFormat.format("{0} {0, choice, 0#\u043c\u0435\u0441\u044f\u0446\u0435\u0432| 1#\u043c\u0435\u0441\u044f\u0446| 2#\u043c\u0435\u0441\u044f\u0446\u0430| 3#\u043c\u0435\u0441\u044f\u0446\u0430| 4#\u043c\u0435\u0441\u044f\u0446\u0430| 4<\u043c\u0435\u0441\u044f\u0446\u0435\u0432| 20<{1}}", count, MessageFormat.format("{0, choice, 0#\u043c\u0435\u0441\u044f\u0446\u0435\u0432| 1#\u043c\u0435\u0441\u044f\u0446| 2#\u043c\u0435\u0441\u044f\u0446\u0430| 3#\u043c\u0435\u0441\u044f\u0446\u0430| 4#\u043c\u0435\u0441\u044f\u0446\u0430| 4<\u043c\u0435\u0441\u044f\u0446\u0435\u0432}", count % 10));
            }
            case 10: 
            case 11: {
                return MessageFormat.format("{0} {0, choice, 0#\u0447\u0430\u0441\u043e\u0432| 1#\u0447\u0430\u0441| 2#\u0447\u0430\u0441\u0430| 3#\u0447\u0430\u0441\u0430| 4#\u0447\u0430\u0441\u0430| 4<\u0447\u0430\u0441\u043e\u0432| 20<{1}}", count, MessageFormat.format("{0, choice, 0#\u0447\u0430\u0441\u043e\u0432| 1#\u0447\u0430\u0441| 2#\u0447\u0430\u0441\u0430| 3#\u0447\u0430\u0441\u0430| 4#\u0447\u0430\u0441\u0430| 4<\u0447\u0430\u0441\u043e\u0432}", count % 10));
            }
            case 12: {
                return MessageFormat.format("{0} {0, choice, 0#\u043c\u0438\u043d\u0443\u0442| 1#\u043c\u0438\u043d\u0443\u0442\u0430| 2#\u043c\u0438\u043d\u0443\u0442\u044b| 3#\u043c\u0438\u043d\u0443\u0442\u044b| 4#\u043c\u0438\u043d\u0443\u0442\u044b| 4<\u043c\u0438\u043d\u0443\u0442| 20<{1}}", count, MessageFormat.format("{0, choice, 0#\u043c\u0438\u043d\u0443\u0442| 1#\u043c\u0438\u043d\u0443\u0442\u0430| 2#\u043c\u0438\u043d\u0443\u0442\u044b| 3#\u043c\u0438\u043d\u0443\u0442\u044b| 4#\u043c\u0438\u043d\u0443\u0442\u044b| 4<\u043c\u0438\u043d\u0443\u0442}", count % 10));
            }
            case 3: 
            case 4: {
                return MessageFormat.format("{0} {0, choice, 0#\u043d\u0435\u0434\u0435\u043b\u044c| 1#\u043d\u0435\u0434\u0435\u043b\u044f| 2#\u043d\u0435\u0434\u0435\u043b\u0438| 3#\u043d\u0435\u0434\u0435\u043b\u0438| 4#\u043d\u0435\u0434\u0435\u043b\u0438| 4<\u043d\u0435\u0434\u0435\u043b\u044c| 20<{1}}", count, MessageFormat.format("{0, choice, 0#\u043d\u0435\u0434\u0435\u043b\u044c| 1#\u043d\u0435\u0434\u0435\u043b\u044f| 2#\u043d\u0435\u0434\u0435\u043b\u0438| 3#\u043d\u0435\u0434\u0435\u043b\u0438| 4#\u043d\u0435\u0434\u0435\u043b\u0438| 4<\u043d\u0435\u0434\u0435\u043b\u044c}", count % 10));
            }
            case 1: {
                return MessageFormat.format("{0} {0, choice, 0#\u043b\u0435\u0442| 1#\u0433\u043e\u0434| 2#\u0433\u043e\u0434\u0430| 3#\u0433\u043e\u0434\u0430| 4#\u0433\u043e\u0434\u0430| 4<\u043b\u0435\u0442| 20<{1}}", count, MessageFormat.format("{0, choice, 0#\u043b\u0435\u0442| 1#\u0433\u043e\u0434| 2#\u0433\u043e\u0434\u0430| 3#\u0433\u043e\u0434\u0430| 4#\u0433\u043e\u0434\u0430| 4<\u043b\u0435\u0442}", count % 10));
            }
        }
        throw new IllegalArgumentException();
    }

    public static java.util.Date subtractHoursFromNow(int hours) {
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).add(11, -hours);
        return now.getTime();
    }

    public static final boolean timeInRange(java.util.Date checking, java.util.Date date1, java.util.Date date2) {
        return !(checking == null || date1 != null && date1.compareTo(checking) > 0 || date2 != null && date2.compareTo(checking) < 0);
    }

    public static long rountToSeconds(long millis) {
        return millis / 1000L * 1000L;
    }

    public static final long convertDateToMillisFrom(Calendar utilCalendar, java.util.Date dateFrom) {
        if (dateFrom != null) {
            utilCalendar.setTime(dateFrom);
            TimeUtils.clear_HOUR_MIN_MIL_SEC(utilCalendar);
            return utilCalendar.getTimeInMillis();
        }
        return 0L;
    }

    public static final long convertDateToMillisTo(Calendar utilCalendar, java.util.Date dateTo) {
        if (dateTo != null) {
            utilCalendar.setTime(dateTo);
            TimeUtils.clear_HOUR_MIN_MIL_SEC(utilCalendar);
            utilCalendar.add(5, 1);
            return utilCalendar.getTimeInMillis() - 1L;
        }
        return 0L;
    }

    public static final java.util.Date convertMillisToDate(long millis) {
        if (millis == 0L) {
            return null;
        }
        return new java.util.Date(millis);
    }

    public static final Calendar convertMillisToCalendar(long millis) {
        return TimeUtils.convertDateToCalendar(TimeUtils.convertMillisToDate(millis));
    }

    public static long hourToMillis(long millis) {
        return millis / 3600000L * 3600000L;
    }

    public static String formatSecondsToDayHourMinute(long seconds) {
        StringBuilder buf = new StringBuilder();
        buf.append(seconds / 60L / 60L / 24L);
        buf.append(":");
        long hour = seconds % 86400L / 60L / 60L;
        if (hour < 10L) {
            buf.append("0");
        }
        buf.append(hour);
        buf.append(":");
        long minute = seconds % 3600L / 60L;
        if (minute < 10L) {
            buf.append("0");
        }
        buf.append(minute);
        return buf.toString();
    }

    public static boolean checkMonthAndYearDates(java.util.Date date1, java.util.Date date2) {
        boolean result = false;
        if (date1 != null && date2 != null) {
            Calendar calendar1 = TimeUtils.convertDateToCalendar(date1);
            Calendar calendar2 = TimeUtils.convertDateToCalendar(date2);
            if (calendar1.get(1) == calendar2.get(1) && calendar1.get(2) == calendar2.get(2)) {
                result = true;
            }
        }
        return result;
    }

    public static boolean checkMonthAndYearAndDaysDates(java.util.Date date1, java.util.Date date2) {
        boolean result = false;
        if (date1 != null && date2 != null) {
            Calendar calendar1 = TimeUtils.convertDateToCalendar(date1);
            Calendar calendar2 = TimeUtils.convertDateToCalendar(date2);
            if (calendar1.get(1) == calendar2.get(1) && calendar1.get(2) == calendar2.get(2) && calendar1.get(5) == calendar2.get(5)) {
                result = true;
            }
        }
        return result;
    }

    public static LocalDate getPeriodFrom(LocalDate date, String mode, int value) {
        if (mode == null) {
            return date;
        }
        return switch (mode) {
            case "currentDate" -> date;
            case "nextDate" -> date.plusDays(1L);
            case "nextWeek" -> date.plusWeeks(1L).with(DayOfWeek.MONDAY);
            case "nextMonth" -> date.plusMonths(1L).withDayOfMonth(1);
            case "nextYear" -> date.plusYears(1L).withDayOfYear(1);
            case "plusDay" -> date.plusDays(value);
            case "plusMonth" -> date.plusMonths(value);
            case "plusMonth1" -> date.plusMonths(value).withDayOfMonth(1);
            case "plusYear" -> date.plusYears(value);
            case "plusYear1" -> date.plusYears(value).withDayOfYear(1);
            default -> date;
        };
    }

    public static LocalDate getPeriodTo(LocalDate date, String mode, int value) {
        if (mode == null) {
            return null;
        }
        return switch (mode) {
            case "unlim" -> null;
            case "currentDate" -> date;
            case "nextDate" -> date.plusDays(1L);
            case "endWeek" -> date.with(DayOfWeek.SUNDAY);
            case "endMonth" -> YearMonth.from(date).atEndOfMonth();
            case "endYear" -> YearMonth.from(date).withMonth(12).atEndOfMonth();
            case "plusDay" -> date.plusDays(value - 1);
            case "plusMonth" -> date.plusMonths(value).minusDays(1L);
            case "plusMonth31" -> YearMonth.from(date.plusMonths(value)).atEndOfMonth();
            case "plusYear" -> date.plusYears(value).minusDays(1L);
            case "plusYear31" -> YearMonth.from(date.plusYears(value).withMonth(12)).atEndOfMonth();
            default -> null;
        };
    }
}

