/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.common;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.CommonTransferManager;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiPacket;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;

public class WiFiUtil {
    public static String getIp(byte[] data, int from) {
        byte[] ip = new byte[4];
        System.arraycopy(data, from, ip, 0, 4);
        String ipString = WiFiUtil.getIp(ip);
        return ipString;
    }

    public static String getIp(byte[] ip) {
        Object ipString = "";
        for (int i = 0; i < 4; ++i) {
            ipString = (String)ipString + Utils.unsignedByteToInt(ip[i]);
            if (i == 3) continue;
            ipString = (String)ipString + ".";
        }
        return ipString;
    }

    public static String getIp(int ip) {
        Object ipString = "";
        int shift = 24;
        for (int i = 0; i < 4; ++i) {
            ipString = (String)ipString + (ip >> shift & 0xFF);
            if (i != 3) {
                ipString = (String)ipString + ".";
            }
            shift -= 8;
        }
        return ipString;
    }

    public static int getIp(String ip) {
        String[] ips = ip.split("\\.");
        long result = 0L;
        int shift = 24;
        for (String str : ips) {
            result += (long)(Integer.valueOf(str) << shift);
            shift -= 8;
        }
        return (int)result;
    }

    public static int byteToInt(byte[] buf) {
        int result = 0;
        int shift = (buf.length - 1) * 8;
        for (int i = 0; i < buf.length; ++i) {
            result += Utils.unsignedByteToInt(buf[i]) << shift;
            shift -= 8;
        }
        return result;
    }

    public static void sendPacket(DatagramSocket socket, WiFiPacket packet) throws IOException {
        byte[] data = packet.serialize();
        DatagramPacket dataPack = new DatagramPacket(data, data.length);
        socket.send(dataPack);
    }

    public static void sendPacket(DatagramSocket socket, WiFiPacket packet, String host, int port) throws IOException {
        byte[] data = packet.serialize();
        DatagramPacket dataPack = new DatagramPacket(data, data.length, InetAddress.getByName(host), port);
        socket.send(dataPack);
    }

    public static WiFiPacket recievePacket(DatagramSocket socket, String secret) throws IOException {
        byte[] buf = new byte[4096];
        DatagramPacket dataPacketIn = new DatagramPacket(buf, buf.length);
        socket.receive(dataPacketIn);
        WiFiPacket packetIn = new WiFiPacket();
        packetIn.setSecret(secret);
        if (!packetIn.parse(dataPacketIn.getData())) {
            packetIn = null;
        }
        return packetIn;
    }

    public static String checkStatus(Document doc) {
        String status;
        String result = null;
        if (doc == null) {
            return "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430";
        }
        Element data = doc.getDocumentElement();
        if ("data".equals(data.getNodeName())) {
            data = (Element)XMLUtils.getNode(doc, "data");
        }
        if ((status = data.getAttribute("status")).equals("error") || status.equals("message")) {
            result = Utils.getMessage(doc);
        }
        return result;
    }

    public static Document getDocument(Map<String, String> request, String host, String login, String password) {
        Document doc = null;
        try {
            String randomBytes = Utils.randomAlphanumeric(24);
            request.put(Utils.swapWords("GBiBllniSgceert"), randomBytes);
            boolean doOutput = request != null && !request.isEmpty();
            URL url = new URL(host + "/executer");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setConnectTimeout(3000);
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            urlConnection.setRequestProperty("Authorization", "Basic " + Base64.encode(login + ":" + password));
            urlConnection.setDoOutput(doOutput);
            urlConnection.setDoInput(true);
            if (doOutput) {
                try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream()));){
                    for (Map.Entry<String, String> entry : request.entrySet()) {
                        bw.write(URLEncoder.encode(entry.getKey(), "UTF-8"));
                        bw.write("=");
                        bw.write(URLEncoder.encode(entry.getValue(), "UTF-8"));
                        bw.write("&");
                    }
                }
            }
            String result = null;
            urlConnection.connect();
            if (urlConnection.getResponseCode() == 200) {
                result = new String(Utils.readByBlock(new BufferedInputStream(urlConnection.getInputStream())), "UTF-8");
            }
            urlConnection.disconnect();
            doc = XMLUtils.parseDocument(new InputSource(new StringReader(result.toString())));
            if (!CommonTransferManager.checkAnswer((Document)doc, (String)randomBytes)) {
                doc = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return doc;
    }
}

