/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractParameterListItemDao
extends AbstractIdDao<ContractParameterListItem>
implements Directory<ContractParameterListItem> {
    private int parameterTypeId;

    public ContractParameterListItemDao(Connection con, int parameterTypeId) {
        super(con, 0, "contract_parameter_type_7_values");
        this.parameterTypeId = parameterTypeId;
    }

    protected ContractParameterListItem getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractParameterListItem result = new ContractParameterListItem();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setParameterId(rs.getInt("pid"));
        result.setInUse(rs.getBoolean("inUse"));
        return result;
    }

    protected void updateImpl(ContractParameterListItem contractParameterListItem) throws BGException, SQLException {
        boolean update = contractParameterListItem.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, pid=?, inUse=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, contractParameterListItem.getTitle());
            ps.setInt(index++, contractParameterListItem.getParameterId());
            ps.setBoolean(index++, contractParameterListItem.isInUse());
            if (update) {
                ps.setInt(index++, contractParameterListItem.getId());
            }
            ps.executeUpdate();
            if (!update) {
                contractParameterListItem.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("SELECT cid FROM contract_parameter_type_7 WHERE pid=? LIMIT 1");){
            boolean isUsed = false;
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                isUsed = rs.next();
            }
            if (isUsed) {
                throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435, \u0442.\u043a. \u043e\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.", "list.value.deleteError.isUsed");
            }
        }
        return super.deleteImpl(id);
    }

    public void recycle() throws BGException {
        super.recycle();
    }

    @Override
    public ContractParameterListItem get(String title) throws BGException {
        return (ContractParameterListItem)((Object)super.get("title=?", new Object[]{title}));
    }

    @Override
    public List<ContractParameterListItem> list() throws BGException {
        return this.parameterTypeId > 0 ? super.list("pid=?", null, new Object[]{this.parameterTypeId}) : super.list(null, null, new Object[0]);
    }
}

