/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.ws.server;

import bitel.billing.server.admin.bgsecure.bean.UserLoginModule;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import jakarta.jws.WebParam;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.ws.Holder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.security.server.FindAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceInfo;
import ru.bitel.bgbilling.kernel.container.ws.server.JaxWsHandler;
import ru.bitel.bgbilling.kernel.container.ws.server.ModuleKey;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class JsonWsHandler
extends JaxWsHandler {
    private static final Logger log = LogManager.getLogger();
    public static final String URL_PREFIX = "/json";
    private static final int URL_PREFIX_LENGTH = "/json".length();
    protected static final ObjectMapper MAPPER = new ObjectMapper();

    public JsonWsHandler(ServletContext context) throws BGException {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response) {
        ModuleKey moduleKey = ModuleKey.getModuleKey(request.getPathInfo().substring(URL_PREFIX_LENGTH));
        if (moduleKey != null) {
            try {
                String requestBody = new String(Utils.readByBlock((InputStream)request.getInputStream()), "UTF-8");
                JsonNode root = MAPPER.readTree(requestBody);
                JsonResponse jsonResponse = new JsonResponse();
                try {
                    String method;
                    Integer userId;
                    long time = System.currentTimeMillis();
                    HttpSession httpSession = request.getSession(false);
                    Subject subject = httpSession != null ? (Subject)httpSession.getAttribute("subject") : null;
                    Integer n = userId = httpSession != null ? (Integer)httpSession.getAttribute("user_id") : null;
                    if (subject == null) {
                        String user = "";
                        String pswd = "";
                        JsonNode userNode = root.get("user");
                        if (userNode == null) {
                            throw new LoginException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 user");
                        }
                        user = (String)MAPPER.convertValue((Object)userNode.get("user"), String.class);
                        pswd = (String)MAPPER.convertValue((Object)userNode.get("pswd"), String.class);
                        ((ObjectNode)userNode).put("pswd", "********");
                        if (Utils.isBlankString((String)user) || Utils.isBlankString((String)pswd)) {
                            throw new LoginException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b 'user' \u043b\u0438\u0431\u043e 'pswd'");
                        }
                        subject = this.login(user, pswd, httpSession);
                        userId = UserLoginModule.getUser(subject).getId();
                    }
                    if (Utils.isBlankString((String)(method = root.get("method").asText()))) {
                        throw new BGException("\u041f\u043e\u043b\u0435 'method' \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e");
                    }
                    Class<?> implementorClass = this.findEndpointClass(moduleKey);
                    if (implementorClass == null) {
                        throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0441\u0435\u0440\u0432\u0438\u0441: " + moduleKey.module + ":" + moduleKey.service);
                    }
                    Method mIface = null;
                    Method mImpl = null;
                    try {
                        mIface = this.getMethodByName(this.findInterfaceClass(moduleKey.service, implementorClass), method);
                        mImpl = this.getMethodImpl(implementorClass, mIface);
                    }
                    catch (Exception e) {
                        throw new BGException("unknown error process method " + method + " from json-ws-impl " + implementorClass, (Throwable)e);
                    }
                    JsonNode params = root.get("params");
                    Args args = this.fillArgs(params, root, mIface, mImpl);
                    Integer contractId = null;
                    try {
                        contractId = (Integer)MAPPER.convertValue((Object)params.get("cid"), Integer.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (contractId == null) {
                            contractId = (Integer)MAPPER.convertValue((Object)params.get("contractId"), Integer.class);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (contractId == null) {
                        contractId = 0;
                    }
                    String[] midRef = new String[]{String.valueOf(moduleKey.moduleId)};
                    ModuleAction moduleAction = FindAction.find(midRef, moduleKey.service, method, args.namedArgs);
                    if (this.requestCheckAuthorization && userId != 1) {
                        this.permissionChecker.checkActionAllow(userId, String.valueOf(moduleKey.moduleId), moduleAction, moduleKey.service, method, contractId, args.namedArgs);
                    }
                    this.logRequest(request, userId, contractId, midRef, moduleAction, moduleKey.service, method, root);
                    ServiceInfo<?> helper = ServiceInfo.getServiceHelper(implementorClass);
                    ThreadContext parent = ThreadContext.get();
                    ServerContext ctx = null;
                    try {
                        ctx = new ServerContext(this.setup, moduleKey.moduleId, userId);
                        ctx.init();
                        ThreadContext.set((ThreadContext)ctx);
                        Object result = helper.invoke(ctx, this.setup, implementorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), mImpl, args.args, moduleKey.moduleId, userId);
                        jsonResponse.setDataReturn(result);
                        for (Map.Entry<String, Holder<Object>> me : args.returnArgs.entrySet()) {
                            jsonResponse.setData(me.getKey(), me.getValue().value);
                        }
                        log.debug("executing {}.{}; time => {} ms.", (Object)implementorClass.getName(), (Object)mImpl.getName(), (Object)(System.currentTimeMillis() - time));
                    }
                    finally {
                        if (ctx != null) {
                            ctx.destroy();
                        }
                        ThreadContext.set((ThreadContext)parent);
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof BGException) {
                        jsonResponse.setError(cause.getClass().getName(), cause.getMessage(), ((BGException)cause).getTag());
                    } else {
                        jsonResponse.setError(cause.getClass().getName(), cause.getMessage());
                    }
                    if (!(cause instanceof BGMessageException)) {
                        log.error("error executing", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    jsonResponse.setError(e.getClass().getName(), e.getMessage());
                    log.error("error executing", e);
                }
                finally {
                    MAPPER.writeValue((OutputStream)response.getOutputStream(), (Object)jsonResponse);
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private Subject login(String userName, String userPswd, HttpSession session) throws LoginException {
        Subject subject = UserLoginModule.auth(this.loginContextName, userName, userPswd);
        User user = UserLoginModule.getUser(subject);
        if (session != null) {
            session.setAttribute("user_id", (Object)user.getId());
            session.setAttribute("subject", (Object)subject);
        }
        return subject;
    }

    protected Args fillArgs(JsonNode params, JsonNode root, Method mIface, Method mImpl) {
        Type[] parameterTypes = mImpl.getGenericParameterTypes();
        int paramListLength = parameterTypes.length;
        Object[] args = new Object[paramListLength];
        HashMap<String, Object> map = new HashMap<String, Object>(paramListLength);
        HashMap<String, Holder<Object>> returnMap = new HashMap<String, Holder<Object>>();
        Parameter[] parameters = mIface.getParameters();
        Annotation[][] paramsAnnotations = mIface.getParameterAnnotations();
        for (int i = 0; i < paramListLength; ++i) {
            WebParam wp = null;
            Type type = parameterTypes[i];
            String paramName = null;
            Annotation[] paramAnnotations = paramsAnnotations[i];
            if (paramAnnotations.length == 1) {
                wp = (WebParam)paramAnnotations[0];
                paramName = wp.name();
            } else {
                paramName = parameters[i].getName();
            }
            try {
                JsonNode paramValue = params.get(paramName);
                if (wp != null && (wp.mode() == WebParam.Mode.INOUT || wp.mode() == WebParam.Mode.OUT)) {
                    Type t = ((ParameterizedType)type).getActualTypeArguments()[0];
                    Class clazz = t instanceof ParameterizedType ? (Class)((ParameterizedType)t).getRawType() : (Class)t;
                    Object value = MAPPER.convertValue((Object)paramValue, clazz);
                    Holder holder = new Holder(value);
                    args[i] = holder;
                    returnMap.put(paramName, (Holder<Object>)holder);
                    continue;
                }
                if (paramValue == null) continue;
                Object javaType = null;
                if (type instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)type;
                    Class rawType = (Class)pType.getRawType();
                    if ("java.lang.Class".equals(rawType.getName())) {
                        args[i] = Class.forName(paramValue.asText());
                    } else {
                        Type[] genericTypes = pType.getActualTypeArguments();
                        int size = genericTypes.length;
                        Class[] genericTypeArgClasses = new Class[size];
                        for (int c = 0; c < size; ++c) {
                            genericTypeArgClasses[c] = (Class)genericTypes[c];
                        }
                        javaType = MAPPER.getTypeFactory().constructParametricType(rawType, genericTypeArgClasses);
                    }
                } else {
                    Class clazz = (Class)type;
                    javaType = clazz.isArray() ? MAPPER.getTypeFactory().constructArrayType(clazz.getComponentType()) : MAPPER.getTypeFactory().constructType((Type)clazz);
                }
                if (args[i] == null) {
                    args[i] = MAPPER.convertValue((Object)paramValue, javaType);
                }
                map.put(paramName, args[i]);
                log.debug("{} ({}) => {} : {}", (Object)paramName, (Object)i, javaType, args[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error on parsing param: " + paramName, e);
            }
        }
        return new Args(args, map, returnMap);
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.findAndRegisterModules();
        MAPPER.setDateFormat((DateFormat)((Object)new BitelJsonDateFormat()));
        MAPPER.registerModule((Module)JSONObjectSerializer.toModule());
        MAPPER.registerModule((Module)DataHandlerSerializer.module());
        MAPPER.registerModule((Module)LocalDateTimeSerializer.toModule());
        MAPPER.registerModule((Module)LocalDateTimeDeserializer.toModule());
        MAPPER.registerModule((Module)LocalDateSerializer.toModule());
        MAPPER.registerModule((Module)LocalDateDeserializer.toModule());
        AnnotationIntrospector introspector = new AnnotationIntrospector(){

            public Version version() {
                return VersionUtil.parseVersion((String)"2.4.1", (String)"com.fasterxml.jackson.module", (String)"jackson-module-bitel-jaxb-annotations");
            }

            public boolean hasIgnoreMarker(AnnotatedMember m) {
                return m.getAnnotation(XmlTransient.class) != null;
            }

            public PropertyName findNameForSerialization(Annotated a) {
                XmlAttribute pann = (XmlAttribute)a.getAnnotation(XmlAttribute.class);
                if (pann != null) {
                    if (Utils.notBlankString((String)pann.name()) && !"##default".equals(pann.name())) {
                        return new PropertyName(pann.name());
                    }
                    return PropertyName.USE_DEFAULT;
                }
                XmlElement el = (XmlElement)a.getAnnotation(XmlElement.class);
                XmlElements els = (XmlElements)a.getAnnotation(XmlElements.class);
                if (el != null || els != null) {
                    return PropertyName.USE_DEFAULT;
                }
                return null;
            }

            public PropertyName findNameForDeserialization(Annotated a) {
                return this.findNameForSerialization(a);
            }
        };
        MAPPER.setAnnotationIntrospector(AnnotationIntrospector.pair((AnnotationIntrospector)new JacksonAnnotationIntrospector(), (AnnotationIntrospector)introspector));
    }

    public static class JsonResponse {
        public static final String STATUS_OK = "ok";
        public static final String STATUS_ERROR = "error";
        private String status = "ok";
        private String exception;
        private String message = "";
        private String tag = null;
        private Map<String, Object> data = new HashMap<String, Object>();

        public String getStatus() {
            return this.status;
        }

        public void setError(String exception, String error) {
            this.status = STATUS_ERROR;
            this.exception = exception;
            this.message = error;
        }

        public void setError(String exception, String error, String tag) {
            this.status = STATUS_ERROR;
            this.exception = exception;
            this.message = error;
            this.tag = tag;
        }

        public String getMessage() {
            return this.message;
        }

        public String getTag() {
            return this.tag;
        }

        public String getException() {
            return this.exception;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public void setDataReturn(Object data) {
            this.data.put("return", data);
        }

        public void setData(String key, Object data) {
            this.data.put(key, data);
        }
    }

    protected static final class Args {
        private final Object[] args;
        private final Map<String, Object> namedArgs;
        private final Map<String, Holder<Object>> returnArgs;

        private Args(Object[] args, Map<String, Object> namedArgs, Map<String, Holder<Object>> returnArgs) {
            this.args = args;
            this.namedArgs = namedArgs;
            this.returnArgs = returnArgs;
        }
    }

    private static class BitelJsonDateFormat
    extends StdDateFormat {
        private static final String BITEL_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";

        public BitelJsonDateFormat() {
            this.setTimeZone(TimeZone.getDefault());
        }

        protected Date parseAsISO8601(String dateStr, ParsePosition pos) throws ParseException {
            Date result = new SimpleDateFormat(BITEL_FORMAT).parse(dateStr, pos);
            if (result == null) {
                try {
                    return super.parseAsISO8601(dateStr, pos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return result;
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return new SimpleDateFormat(BITEL_FORMAT).format(date, toAppendTo, fieldPosition);
        }
    }

    private static class JSONObjectSerializer
    extends StdSerializer<JSONObject> {
        JSONObjectSerializer() {
            this(null);
        }

        JSONObjectSerializer(Class<JSONObject> t) {
            super(t);
        }

        public void serialize(JSONObject value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("json", value.toString());
            gen.writeEndObject();
        }

        private static SimpleModule toModule() {
            return new SimpleModule().addSerializer(JSONObject.class, (JsonSerializer)new JSONObjectSerializer());
        }
    }

    private static class DataHandlerSerializer
    extends StdSerializer<DataHandler> {
        DataHandlerSerializer() {
            super((Class)null);
        }

        public void serialize(DataHandler value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(Base64.getEncoder().encodeToString(IOUtils.toByteArray((InputStream)value.getInputStream())));
        }

        private static SimpleModule module() {
            return new SimpleModule().addSerializer(DataHandler.class, (JsonSerializer)new DataHandlerSerializer());
        }
    }

    private static class LocalDateTimeSerializer
    extends StdSerializer<LocalDateTime> {
        private static final String BITEL_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";

        LocalDateTimeSerializer() {
            this(null);
        }

        LocalDateTimeSerializer(Class<LocalDateTime> t) {
            super(t);
        }

        public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            Date date = Date.from(value.atZone(ZoneId.systemDefault()).toInstant());
            gen.writeString(new SimpleDateFormat(BITEL_FORMAT).format(date));
        }

        private static SimpleModule toModule() {
            return new SimpleModule().addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer());
        }
    }

    private static class LocalDateTimeDeserializer
    extends StdDeserializer<LocalDateTime> {
        private static final String BITEL_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";

        LocalDateTimeDeserializer() {
            this(null);
        }

        LocalDateTimeDeserializer(Class<LocalDateTime> t) {
            super(t);
        }

        private static SimpleModule toModule() {
            return new SimpleModule().addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        }

        public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Date date;
            ObjectCodec oc = p.getCodec();
            TextNode node = (TextNode)oc.readTree(p);
            String dateString = node.textValue();
            try {
                date = new SimpleDateFormat(BITEL_FORMAT).parse(dateString);
            }
            catch (ParseException e) {
                date = new Date();
            }
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
    }

    private static class LocalDateSerializer
    extends StdSerializer<LocalDate> {
        private static final String BITEL_FORMAT = "yyyy-MM-dd";

        LocalDateSerializer() {
            this(null);
        }

        LocalDateSerializer(Class<LocalDate> t) {
            super(t);
        }

        public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            Date date = Date.from(value.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            gen.writeString(new SimpleDateFormat(BITEL_FORMAT).format(date));
        }

        private static SimpleModule toModule() {
            return new SimpleModule().addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer());
        }
    }

    private static class LocalDateDeserializer
    extends StdDeserializer<LocalDate> {
        private static final String BITEL_FORMAT = "yyyy-MM-dd";

        LocalDateDeserializer() {
            this(null);
        }

        LocalDateDeserializer(Class<LocalDate> t) {
            super(t);
        }

        public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Date date;
            ObjectCodec oc = p.getCodec();
            TextNode node = (TextNode)oc.readTree(p);
            String dateString = node.textValue();
            try {
                date = new SimpleDateFormat(BITEL_FORMAT).parse(dateString);
            }
            catch (ParseException e) {
                date = new Date();
            }
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }

        private static SimpleModule toModule() {
            return new SimpleModule().addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
        }
    }

    public static class StringToIntegerSetDeserializer
    extends JsonDeserializer<Set<Integer>> {
        public Set<Integer> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String value = (String)p.readValueAs(String.class);
            String[] values = value.split("\\s");
            HashSet<Integer> result = new HashSet<Integer>(values.length);
            for (String val : values) {
                result.add(Utils.parseInt((String)val));
            }
            return result;
        }
    }
}

