/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.server.api.CustomApiWsHandler;
import ru.bitel.bgbilling.server.api.rest.CustomRestApiHandler;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.Utils;

@WebServlet(name="customApiExecuter", urlPatterns={"/api/*"})
public class CustomApiExecutor
extends CommonExecutor {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(CustomApiExecutor.class);
    private CustomApiWsHandler wsHandler = null;
    private CustomRestApiHandler restApiHandler = null;

    @Override
    public void init() throws ServletException {
        try {
            this.wsHandler = new CustomApiWsHandler(this.getServletContext());
            this.restApiHandler = new CustomRestApiHandler(this.getServletContext());
        }
        catch (BGException e) {
            logger.error(e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (Utils.notBlankString((String)req.getPathInfo())) {
            String[] path = req.getPathInfo().split("/");
            if (path.length >= 2 && "rest".equals(path[1])) {
                this.restApiHandler.handle(req, resp);
            } else {
                this.wsHandler.handle(req, resp);
            }
        }
    }
}

