/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.application.server;

import bitel.billing.server.tariff.TariffTreesCache;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.application.server.CommandPortListener;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.application.server.MethodProperties;
import ru.bitel.bgbilling.kernel.application.server.event.ApplicationRunningEvent;
import ru.bitel.bgbilling.kernel.application.server.event.CheckApplicationRunEvent;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.script.server.bean.GlobalScriptInvoker;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.bootstrap.Shutdown;
import ru.bitel.common.jmx.AnnotatedMBean;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.jmx.MBeanUtils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.logging.Log4j2;
import ru.bitel.common.server.benchmark.DiskBenchmark;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThreadFactory;

public class Application
implements CommandListener {
    public static AtomicInteger shutdownHookCount = new AtomicInteger();
    private static Application instance;
    private static Logger log;
    private final CommandPortListener commandPortListener;
    private final ScriptEngine scriptEngine;
    private final Context env;
    private final Setup setup;
    private final List<Object[]> lifecycleList = new ArrayList<Object[]>();
    private Date startTime = new Date();
    private Set<Object> annotatedMBeans = new HashSet<Object>();

    public static Application getInstance() {
        return instance;
    }

    public Application(String fileName, CommandPortListener commandPortListener) throws Throwable {
        Log4j2.init((String)"conf");
        log = LogManager.getLogger();
        this.commandPortListener = commandPortListener;
        this.scriptEngine = new ScriptEngineManager().getEngineByName("groovy");
        Setup.setSetup(new Setup("conf." + fileName));
        this.setup = Setup.getSetup();
        instance = this;
        final int appId = SetupParam.getApplicationId((ParameterMap)this.setup);
        if (appId <= 0) {
            throw new BGException("Parameter app.id not defined in application XML!");
        }
        EventProcessor.getInstance().addListener(new EventListener<ApplicationRunningEvent>(){

            @Override
            public void notify(ApplicationRunningEvent e, EventListenerContext ctx) {
                if (appId == e.getApplicationId()) {
                    log.error("Already running application with app.id=" + appId + "!!!");
                    new Thread(){

                        @Override
                        public void run() {
                            System.exit(1);
                        }
                    }.start();
                }
            }
        }, ApplicationRunningEvent.class);
        EventProcessor.getInstance().publish(new CheckApplicationRunEvent(appId));
        EventProcessor.getInstance().addListener(new EventListener<CheckApplicationRunEvent>(){

            @Override
            public void notify(CheckApplicationRunEvent e, EventListenerContext ctx) {
                if (appId == e.getApplicationId()) {
                    try {
                        EventProcessor.getInstance().publish(new ApplicationRunningEvent(appId));
                    }
                    catch (Throwable ex) {
                        log.error(ex.getMessage(), ex);
                    }
                }
            }
        }, CheckApplicationRunEvent.class);
        AlarmSender.initSender(this.setup);
        this.env = Setup.getEnvironment();
        Document document = XMLUtils.parseDocument((InputSource)new InputSource(new FileInputStream("conf" + File.separatorChar + fileName + ".xml")), (XMLUtils.ErrorShowType)XMLUtils.ErrorShowType.EXCEPTION);
        this.application(document.getDocumentElement());
        commandPortListener.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void application(Element element) throws Throwable {
        String context = null;
        if ("application".equals(element.getNodeName())) {
            Shutdown.addShutdownHook((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String ctx;
                        Lifecycle lifecycle;
                        ArrayList<Object[]> lifecycleList = new ArrayList<Object[]>(Application.this.lifecycleList);
                        Collections.reverse(lifecycleList);
                        for (Object[] o : lifecycleList) {
                            lifecycle = (Lifecycle)o[0];
                            ctx = (String)o[1];
                            if (ctx != null && ctx.trim().length() > 0) {
                                try {
                                    BGNestedContext.push((String)ctx);
                                    log.info("Stopping " + lifecycle);
                                    lifecycle.stop();
                                    continue;
                                }
                                finally {
                                    BGNestedContext.pop();
                                    continue;
                                }
                            }
                            log.info("Stopping " + lifecycle);
                            lifecycle.stop();
                        }
                        for (Object[] o : lifecycleList) {
                            if (!(o[0] instanceof ExtendedLifecycle)) continue;
                            lifecycle = (ExtendedLifecycle)o[0];
                            ctx = (String)o[1];
                            if (ctx != null && ctx.trim().length() > 0) {
                                try {
                                    BGNestedContext.push((String)ctx);
                                    log.info("Destroying " + (ExtendedLifecycle)lifecycle);
                                    lifecycle.destroy();
                                    continue;
                                }
                                finally {
                                    BGNestedContext.pop();
                                    continue;
                                }
                            }
                            log.info("Destroying " + (ExtendedLifecycle)lifecycle);
                            lifecycle.destroy();
                        }
                    }
                    catch (Throwable e) {
                        log.error(e.getMessage(), e);
                    }
                }
            });
            this.env.bind("application", (Object)this);
            this.scriptEngine.put("setup", (Object)this.setup);
            context = element.getAttribute("context");
            if (context != null && context.length() > 0) {
                BGNestedContext.push((String)context);
            }
            this.processChildren(element, context);
            if (this.lifecycleList.size() > 0) {
                ServerContext serverContext = new ServerContext(this.setup, ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true), SetupParam.getModuleId((ParameterMap)this.setup), 0);
                ThreadContext parent = ThreadContext.get();
                serverContext.init();
                ThreadContext.set((ThreadContext)serverContext);
                try {
                    String ctx;
                    Lifecycle lifecycle;
                    for (Object[] o : this.lifecycleList) {
                        if (!(o[0] instanceof ExtendedLifecycle)) continue;
                        lifecycle = (ExtendedLifecycle)o[0];
                        ctx = (String)o[1];
                        if (ctx != null && ctx.trim().length() > 0) {
                            try {
                                BGNestedContext.push((String)ctx);
                                log.info("Init " + (ExtendedLifecycle)lifecycle);
                                lifecycle.init();
                                log.info("Inited " + (ExtendedLifecycle)lifecycle);
                                this.findMBeans(lifecycle, true);
                                continue;
                            }
                            finally {
                                BGNestedContext.pop();
                                continue;
                            }
                        }
                        log.info("Init " + (ExtendedLifecycle)lifecycle);
                        lifecycle.init();
                        log.info("Inited " + (ExtendedLifecycle)lifecycle);
                    }
                    try {
                        serverContext.getConnectionSet().commit();
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                    try {
                        serverContext.commit();
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                    for (Object[] o : this.lifecycleList) {
                        lifecycle = (Lifecycle)o[0];
                        ctx = (String)o[1];
                        if (ctx != null && ctx.trim().length() > 0) {
                            try {
                                BGNestedContext.push((String)ctx);
                                log.info("Starting " + lifecycle);
                                lifecycle.start();
                                log.info("Started " + lifecycle);
                                this.findMBeans(lifecycle, true);
                                continue;
                            }
                            finally {
                                BGNestedContext.pop();
                                continue;
                            }
                        }
                        log.info("Starting " + lifecycle);
                        lifecycle.start();
                        log.info("Started " + lifecycle);
                    }
                    try {
                        serverContext.getConnectionSet().commit();
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                    try {
                        serverContext.commit();
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                finally {
                    serverContext.destroy();
                    ThreadContext.set((ThreadContext)parent);
                }
            }
            this.annotatedMBeans.clear();
        }
    }

    private void process(Element element, String context) throws Throwable {
        block11: {
            try {
                String threadContextFactoryName;
                if ("context".equals(element.getNodeName())) {
                    context = element.getAttribute("name");
                    BGNestedContext.push((String)context);
                    try {
                        this.processChildren(element, context);
                        break block11;
                    }
                    finally {
                        BGNestedContext.pop();
                    }
                }
                if ("bean".equals(element.getNodeName())) {
                    this.processBean(element);
                    break block11;
                }
                if (!"scheduledExecutorService".equals(element.getNodeName())) break block11;
                String name = element.getAttribute("name");
                String nestedContext = element.getAttribute("context");
                int corePoolSize = Utils.parseInt((String)element.getAttribute("corePoolSize"), (int)1);
                if (nestedContext != null && nestedContext.length() > 0) {
                    context = nestedContext;
                }
                if (Utils.isBlankString((String)(threadContextFactoryName = element.getAttribute("threadContextFactory")))) {
                    threadContextFactoryName = "threadContextFactory";
                }
                ThreadContextFactory threadContextFactory = null;
                try {
                    threadContextFactory = (ThreadContextFactory)this.env.lookup(threadContextFactoryName);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(corePoolSize, (ThreadFactory)new WorkerThreadFactory(name, context, threadContextFactory));
                this.scriptEngine.put(name, threadPool);
            }
            catch (Throwable e) {
                System.err.println("Error on node " + element.getAttribute("name"));
                throw e;
            }
        }
    }

    private void findMBeans(Object o, boolean deep) {
    }

    private void processBean(Element element) throws Throwable {
        ArrayList old;
        Object text;
        String factoryMethod;
        Element constructorEl;
        Class<?> clazz = null;
        String className = element.getAttribute("class");
        if (Utils.isBlankString((String)className)) {
            className = String.class.getCanonicalName();
        }
        clazz = Class.forName(className);
        this.scriptEngine.eval("import " + clazz.getPackage().getName() + ".*;");
        if (clazz.getSuperclass() != null && !Object.class.equals(clazz.getSuperclass())) {
            this.scriptEngine.eval("import " + clazz.getSuperclass().getPackage().getName() + ".*;");
        }
        String name = element.getAttribute("name");
        Object bean = null;
        String stringValue = element.getAttribute("value");
        if (stringValue != null && stringValue.trim().length() > 0) {
            bean = stringValue;
        }
        Map<String, Object> properties = this.params((constructorEl = XMLUtils.selectElement((Node)element, (String)"constructor")) != null ? constructorEl : element);
        if (constructorEl != null && (factoryMethod = constructorEl.getAttribute("factoryMethod")) != null && (factoryMethod = factoryMethod.trim()).length() > 0) {
            ArrayList<Object> params = new ArrayList<Object>();
            for (Method constructor : clazz.getMethods()) {
                MethodProperties constructorProperties = constructor.getAnnotation(MethodProperties.class);
                if (constructorProperties == null) continue;
                for (String p : constructorProperties.value()) {
                    Object o = properties.get(p);
                    if (o == null) {
                        try {
                            o = this.env.lookup(p);
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                    }
                    params.add(o);
                }
                if (constructor.getParameterTypes().length != params.size() || !this.checkConstructor(constructor.getParameterTypes(), params)) continue;
                bean = constructor.invoke(null, params.toArray());
            }
            if (bean == null) {
                params.clear();
                for (Method constructor : clazz.getMethods()) {
                    if (!Modifier.isStatic(constructor.getModifiers()) || constructor.getParameterTypes().length != params.size() || !this.checkConstructor(constructor.getParameterTypes(), params)) continue;
                    bean = constructor.invoke(null, params.toArray());
                }
            }
        }
        if (bean == null) {
            bean = this.tryCreateBean(clazz, properties, c -> Optional.ofNullable(c.getAnnotation(ConstructorProperties.class)).map(a -> a.value()).orElse(null));
        }
        if (bean == null) {
            bean = this.tryCreateBean(clazz, properties, c -> Optional.ofNullable(c.getAnnotation(MethodProperties.class)).map(a -> a.value()).orElse(null));
        }
        if ((text = XMLUtils.selectText((Node)element, (String)"text()")) != null) {
            text = ((String)text).trim();
        }
        if (bean == null && constructorEl != null || text != null && ((String)text).length() > 0) {
            ArrayList params = new ArrayList();
            if (constructorEl != null) {
                Map<String, Object> paramMap = this.params(constructorEl);
                for (Object o : paramMap.values()) {
                    params.add(o);
                }
            } else if (((String)text).startsWith("setup#")) {
                text = ((String)text).substring(6);
                text = "setup.get( \"" + (String)text + "\", null )";
                params.add(this.scriptEngine.eval((String)text));
            } else {
                params.add(this.scriptEngine.eval((String)text));
            }
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (constructor.getParameterTypes().length != params.size() || !this.checkConstructor(constructor.getParameterTypes(), params)) continue;
                bean = constructor.newInstance(params.toArray());
            }
        }
        if (bean == null) {
            bean = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (bean != null) {
            for (Element invoke : XMLUtils.selectElements((Node)element, (String)"invoke")) {
                String method = invoke.getAttribute("method");
                if (method == null || method.length() <= 0) continue;
                this.scriptEngine.put("bean", bean);
                this.scriptEngine.eval("bean." + method + "();");
                this.scriptEngine.put("bean", null);
            }
            if (bean instanceof CommandListener && this.commandPortListener != null) {
                this.commandPortListener.addListener((CommandListener)bean);
            }
            if (bean instanceof Lifecycle) {
                String context = BGNestedContext.peek();
                this.lifecycleList.add(new Object[]{(Lifecycle)bean, context});
            } else {
                this.findMBeans(bean, true);
            }
        }
        if ((old = this.scriptEngine.get(name)) != null) {
            if (!(old instanceof List)) {
                ArrayList params = new ArrayList();
                params.add(old);
                old = params;
                this.env.unbind(name);
                this.scriptEngine.put(name, old);
                this.env.bind(name, old);
            }
            ((List)old).add(bean);
        } else {
            this.scriptEngine.put(name, bean);
            this.env.bind(name, bean);
        }
        if (!this.annotatedMBeans.contains(bean)) {
            this.annotatedMBeans.add(bean);
            AnnotatedMBean.register((Object)bean);
        }
    }

    private Object tryCreateBean(Class<?> clazz, Map<String, Object> properties, Function<Constructor<?>, String[]> argsNamesProducer) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object bean = null;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            String[] argsNames = argsNamesProducer.apply(constructor);
            if (argsNames == null) continue;
            if (constructor.getParameterTypes().length != argsNames.length) {
                log.warn("Constructor annotation is invalid: " + constructor);
                continue;
            }
            List<Object> params = this.getMethodParams(properties, argsNames);
            assert (constructor.getParameterTypes().length == params.size());
            if (!this.checkConstructor(constructor.getParameterTypes(), params)) continue;
            bean = constructor.newInstance(params.toArray());
        }
        return bean;
    }

    private List<Object> getMethodParams(Map<String, Object> properties, String[] argsNames) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (String p : argsNames) {
            Object o = properties.get(p);
            if (o == null) {
                try {
                    o = this.env.lookup(p);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            params.add(o);
        }
        return params;
    }

    private boolean checkConstructor(Class<?>[] parameterTypes, List<Object> params) {
        int i;
        int size = parameterTypes.length;
        for (i = 0; i < size && i < params.size(); ++i) {
            if (params.get(i) == null || parameterTypes[i].isAssignableFrom(params.get(i).getClass()) || params.get(i) instanceof Number && (Integer.TYPE.equals(parameterTypes[i]) || Long.TYPE.equals(parameterTypes[i])) || params.get(i) instanceof Boolean && Boolean.TYPE.equals(parameterTypes[i]) || params.get(i).getClass().equals(String.class)) continue;
            System.err.println("Incorrect parameter: " + i);
            return false;
        }
        size = parameterTypes.length;
        for (i = 0; i < size; ++i) {
            if (params.get(i) != null && (!(params.get(i) instanceof String) && !(params.get(i) instanceof Number) || parameterTypes[i].isAssignableFrom(params.get(i).getClass()))) continue;
            params.set(i, Utils.convert((Object)params.get(i), parameterTypes[i]));
        }
        return true;
    }

    private Map<String, Object> params(Element element) throws ScriptException, XPathExpressionException, DOMException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (element != null) {
            for (Element param : XMLUtils.selectElements((Node)element, (String)"param")) {
                String beanName = param.getAttribute("name");
                String value = param.getAttribute("value");
                Object text = param.getTextContent().trim();
                if (value != null && value.length() > 0) {
                    params.put(beanName, value);
                    continue;
                }
                if (((String)text).startsWith("setup#")) {
                    text = ((String)text).substring(6);
                    text = "setup.get( \"" + (String)text + "\", null )";
                    params.put(beanName, this.scriptEngine.eval((String)text));
                    continue;
                }
                params.put(beanName, this.scriptEngine.eval((String)text));
            }
        }
        return params;
    }

    private void processChildren(Element element, String context) throws Throwable {
        NodeList children = element.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            this.process((Element)node, context);
        }
    }

    public CommandPortListener getCommandPortListener() {
        return this.commandPortListener;
    }

    public static void exit() {
        System.exit(0);
    }

    public static void main(String[] args) throws FileNotFoundException, XPathExpressionException, IllegalArgumentException, ScriptException, InstantiationException, IllegalAccessException, InvocationTargetException, NamingException {
        block10: {
            Log4j2.init((String)"conf");
            log = LogManager.getLogger();
            String appConfig = System.getProperty("app.config", "application");
            Preferences confPreferences = new Preferences("conf." + appConfig);
            int adminPort = confPreferences.getInt("admin.port", Utils.parseInt((String)System.getProperty("admin.port"), (int)-1));
            if (adminPort <= 0) {
                System.err.println("Error: incorrect admin.port. Exit...");
                System.exit(-2);
            }
            try {
                if (args.length > 0) {
                    String[] cmd = Arrays.copyOfRange(args, 0, args.length);
                    CommandPortListener.sendCommand("127.0.0.1", adminPort, cmd);
                    break block10;
                }
                String commandPortListenerClassName = confPreferences.get("command.port.listener");
                CommandPortListener commandPortListener = null;
                if (Utils.isBlankString((String)commandPortListenerClassName)) {
                    commandPortListener = new CommandPortListener(null, adminPort);
                } else {
                    try {
                        commandPortListener = (CommandPortListener)Class.forName(commandPortListenerClassName).getConstructor(String.class, Integer.TYPE).newInstance(null, adminPort);
                    }
                    catch (Exception e) {
                        System.err.println("Error create app's CommandPortListener (" + commandPortListenerClassName + "): " + e.toString());
                        commandPortListener = new CommandPortListener(null, adminPort);
                    }
                }
                new Application(appConfig, commandPortListener);
            }
            catch (Throwable e) {
                try {
                    log.fatal("Fatal error, exit", e);
                    log.fatal("Shutdown with error");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    @Override
    @MBeanAttribute
    public String getCommandsHelp() {
        return "status - show Application status\ngc - call garbage collector\n";
    }

    @Override
    public String executeCommand(String cmd, String param) {
        StringBuilder result = new StringBuilder();
        if ("status".equals(cmd)) {
            result.append(ServerUtils.uptimeStatus(this.startTime)).append("\n");
            result.append(Utils.memoryStatus()).append("\n");
            result.append("Trees in cache: ").append(TariffTreesCache.getCache().getCacheStatus()).append("\n");
            result.append(this.setup.getPoolStatus());
        } else if ("gc".equals(cmd)) {
            log.info("GC called");
            System.gc();
            result.append("GC called");
        }
        return result.toString();
    }

    public static String executeCommonCommand(String command) {
        String params = "";
        int pos = command.indexOf(" ");
        if (pos > 0) {
            params = command.substring(pos + 1, command.length());
            command = command.substring(0, pos);
        }
        return Application.executeCommonCommand(command, params);
    }

    public static String executeCommonCommand(String cmd, final String param) {
        try {
            if ("diskBenchmark".equals(cmd)) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream((OutputStream)out, true, StandardCharsets.UTF_8);
                        DiskBenchmark.execute((String[])param.split("\\s*"), (PrintStream)ps);
                        ps.flush();
                        String result = out.toString(StandardCharsets.UTF_8);
                        log.info("Disk benchmark:\n" + result);
                    }
                }).start();
                return "Disk benchmark started. Look result in log.";
            }
            if ("diskBenchmarkSync".equals(cmd)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream((OutputStream)out, true, StandardCharsets.UTF_8);
                DiskBenchmark.execute((String[])param.split("\\s*"), (PrintStream)ps);
                ps.flush();
                String result = out.toString(StandardCharsets.UTF_8);
                log.info("Disk benchmark:\n" + result);
                return result;
            }
            if ("mbeanGet".equals(cmd)) {
                String[] params = param.split("\\s+");
                return MBeanUtils.mbeanGet((String)params[0], (String)params[1]);
            }
            if ("mbeanSet".equals(cmd)) {
                String[] params = param.split("\\s+");
                return MBeanUtils.mbeanSet((String)params[0], (String)params[1], (String)params[2]);
            }
            if ("mbeanQuery".equals(cmd)) {
                return MBeanUtils.mbeanQuery((String)param);
            }
            if ("mbeanInvoke".equals(cmd)) {
                String[] params = param.split("\\s+");
                return MBeanUtils.mbeanInvoke((String)params[0], (String)params[1]);
            }
            if ("stackTrace".equals(cmd)) {
                StringBuilder sb = new StringBuilder();
                AlarmSender.dumpStack(sb);
                String result = sb.toString();
                log.info("stackTrace");
                log.info(result);
                return result;
            }
            if ("sysvar".equals(cmd)) {
                return Utils.getSystemVariables();
            }
            if ("javavar".equals(cmd)) {
                return Utils.getJavaProperties();
            }
            if ("dynClassRun".equals(cmd)) {
                GlobalScriptInvoker.invoke(param);
                return "Ok";
            }
        }
        catch (Exception e) {
            return BGException.printStackTraceToString((Throwable)e);
        }
        return null;
    }
}

